/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FragmentInputStream
extends FilterInputStream {
    public static final int STAY_ON_CLOSE = 0;
    public static final int CLOSE_ON_CLOSE = 1;
    public static final int ADVANCE_ON_CLOSE = 2;
    long remaining;
    final int closingPolicy;
    long marked = -1L;

    public FragmentInputStream(InputStream in, long len) {
        this(in, len, 0);
    }

    public FragmentInputStream(InputStream in, long len, int closingPolicy) {
        super(in);
        this.remaining = len;
        if (closingPolicy < 0 || closingPolicy > 2) {
            throw new IllegalArgumentException("Unrecognized closing policy");
        }
        this.closingPolicy = closingPolicy;
    }

    public synchronized int read() throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int b = super.read();
        if (b >= 0) {
            --this.remaining;
        }
        return b;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        int read;
        if (this.remaining <= 0L) {
            return -1;
        }
        if ((long)len > this.remaining) {
            len = (int)this.remaining;
        }
        if ((read = super.read(buf, off, len)) >= 0) {
            this.remaining -= (long)read;
        }
        return read;
    }

    public int available() throws IOException {
        if (this.remaining <= 0L) {
            return 0;
        }
        int available = super.available();
        if ((long)available > this.remaining) {
            available = (int)this.remaining;
        }
        return available;
    }

    public long skip(long n) throws IOException {
        if (this.remaining <= 0L) {
            return 0L;
        }
        if (n > this.remaining) {
            n = this.remaining;
        }
        return super.skip(n);
    }

    public void mark(int readlimit) {
        super.mark(readlimit);
        this.marked = this.remaining;
    }

    public void reset(int readlimit) throws IOException {
        if (this.marked < 0L) {
            throw new IllegalStateException("Not marked");
        }
        super.reset();
        this.remaining = this.marked;
    }

    public void close() throws IOException {
        switch (this.closingPolicy) {
            case 1: {
                super.close();
                break;
            }
            case 0: {
                return;
            }
            case 2: {
                while (this.remaining > 0L) {
                    long skipped = super.skip(this.remaining);
                    if (skipped > 0L) {
                        this.remaining -= skipped;
                        continue;
                    }
                    this.read();
                }
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }
}

