/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io;

import edu.emory.mathcs.util.io.RedirectibleReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class RedirectingReader
extends FilterReader
implements RedirectibleReader {
    final char[] buf;
    final boolean autoFlush;
    final boolean autoClose;

    public RedirectingReader(Reader in) {
        this(in, 2048);
    }

    public RedirectingReader(Reader in, int len) {
        this(in, true, false, len);
    }

    public RedirectingReader(Reader in, boolean autoFlush, boolean autoClose) {
        this(in, autoFlush, autoClose, 2048);
    }

    public RedirectingReader(Reader in, boolean autoFlush, boolean autoClose, int len) {
        super(in);
        this.autoFlush = autoFlush;
        this.autoClose = autoClose;
        this.buf = new char[len];
    }

    public int redirect(Writer out, int len) throws IOException {
        int read = this.read(this.buf);
        if (read < 0) {
            if (this.autoClose) {
                out.close();
            }
        } else {
            out.write(this.buf, 0, read);
            if (this.autoFlush) {
                out.flush();
            }
        }
        return read;
    }

    public int redirectAll(Writer out) throws IOException {
        int total = 0;
        while (true) {
            int read;
            if ((read = this.read(this.buf)) < 0) {
                if (this.autoClose) {
                    out.close();
                }
                return total;
            }
            out.write(this.buf, 0, read);
            if (this.autoFlush) {
                out.flush();
            }
            total += read;
        }
    }
}

