/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io.test;

import edu.emory.mathcs.util.io.BufferedDataInputStream;
import edu.emory.mathcs.util.io.BufferedDataOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BufferedDataStreamTest {
    static final boolean o = true;
    static final byte b = 12;
    static final char c = 'a';
    static final short s = 2453;
    static final int i = 88989;
    static final long l = 10000L;
    static final double d = 3.1415;
    static final float f = 0.33333334f;
    static final String str = "Ala ma kota \u0081\ucff5";
    static final boolean[] ao = new boolean[]{true, true, false};
    static byte[] ab;
    static final char[] ac;
    static final short[] as;
    static final int[] ai;
    static final long[] al;
    static final double[] ad;
    static final float[] af;

    public static void main(String[] args) {
        InputStream is;
        ab = new byte[1019];
        for (int i = 0; i < ab.length; ++i) {
            BufferedDataStreamTest.ab[i] = (byte)(i % 256);
        }
        System.out.println("TEST 1: write: DataOutputStream, read: BufferedDataInputStream");
        try {
            DataOutputStream os = new DataOutputStream(new FileOutputStream("testFile.bts"));
            BufferedDataStreamTest.write(os, false);
            ((OutputStream)os).close();
            is = new BufferedDataInputStream(new FileInputStream("testFile.bts"));
            BufferedDataStreamTest.read((DataInput)((Object)is), false);
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        System.out.println("\nTEST 2: write: BufferedDataOutputStream, read: DataInputStream");
        try {
            BufferedDataOutputStream os = new BufferedDataOutputStream(new FileOutputStream("testFile.bts"));
            BufferedDataStreamTest.write(os, false);
            ((OutputStream)os).close();
            is = new DataInputStream(new FileInputStream("testFile.bts"));
            BufferedDataStreamTest.read((DataInput)((Object)is), false);
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        System.out.println("\nTEST 3: write: BufferedDataOutputStream, read: BufferedDataInputStream");
        try {
            BufferedDataOutputStream os = new BufferedDataOutputStream(new FileOutputStream("testFile.bts"));
            BufferedDataStreamTest.write(os, true);
            ((OutputStream)os).close();
            is = new BufferedDataInputStream(new FileInputStream("testFile.bts"));
            BufferedDataStreamTest.read((DataInput)((Object)is), true);
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void write(DataOutput os, boolean buff) throws IOException {
        os.writeBoolean(true);
        os.writeByte(12);
        os.writeChar(97);
        os.writeShort(2453);
        os.writeInt(88989);
        os.writeLong(10000L);
        os.writeDouble(3.1415);
        os.writeFloat(0.33333334f);
        os.writeUTF(str);
        if (buff) {
            BufferedDataOutputStream bos = (BufferedDataOutputStream)os;
            bos.writeInt(ab.length);
            bos.writeBytes(ab, 0, ab.length);
            bos.writeInt(ao.length);
            bos.writeBooleans(ao, 0, ao.length);
            bos.writeInt(ac.length);
            bos.writeChars(ac, 0, ac.length);
            bos.writeInt(as.length);
            bos.writeShorts(as, 0, as.length);
            bos.writeInt(ai.length);
            bos.writeInts(ai, 0, ai.length);
            bos.writeInt(al.length);
            bos.writeLongs(al, 0, al.length);
            bos.writeInt(af.length);
            bos.writeFloats(af, 0, af.length);
            bos.writeInt(ad.length);
            bos.writeDoubles(ad, 0, ad.length);
        }
        os.writeLong(10000L);
        os.writeBoolean(true);
        os.writeByte(12);
        os.writeChar(97);
        os.writeShort(2453);
        os.writeInt(88989);
        os.writeDouble(3.1415);
        os.writeFloat(0.33333334f);
        os.writeUTF(str);
    }

    private static void read(DataInput is, boolean buff) throws IOException {
        System.out.println("orig: true read: " + is.readBoolean());
        System.out.println("orig: 12 read: " + is.readByte());
        System.out.println("orig: a read: " + is.readChar());
        System.out.println("orig: 2453 read: " + is.readShort());
        System.out.println("orig: 88989 read: " + is.readInt());
        System.out.println("orig: 10000 read: " + is.readLong());
        System.out.println("orig: 3.1415 read: " + is.readDouble());
        System.out.println("orig: 0.33333334 read: " + is.readFloat());
        System.out.println("orig: Ala ma kota \u0081\ucff5 read: " + is.readUTF());
        if (buff) {
            BufferedDataInputStream bis = (BufferedDataInputStream)is;
            System.out.print("array orig: ");
            BufferedDataStreamTest.printArray(ab);
            System.out.print("array read: ");
            int lng = bis.readInt();
            Object[] ob = bis.readBytes(new byte[lng], 0, lng);
            BufferedDataStreamTest.printArray(ob);
            System.out.print("array orig: ");
            BufferedDataStreamTest.printArray(ao);
            System.out.print("array read: ");
            lng = bis.readInt();
            ob = bis.readBooleans(new boolean[lng], 0, lng);
            BufferedDataStreamTest.printArray(ob);
            System.out.print("array orig: ");
            BufferedDataStreamTest.printArray(ac);
            System.out.print("array read: ");
            lng = bis.readInt();
            ob = bis.readChars(new char[lng], 0, lng);
            BufferedDataStreamTest.printArray(ob);
            System.out.print("array orig: ");
            BufferedDataStreamTest.printArray(as);
            System.out.print("array read: ");
            lng = bis.readInt();
            ob = bis.readShorts(new short[lng], 0, lng);
            BufferedDataStreamTest.printArray(ob);
            System.out.print("array orig: ");
            BufferedDataStreamTest.printArray(ai);
            System.out.print("array read: ");
            lng = bis.readInt();
            ob = bis.readInts(new int[lng], 0, lng);
            BufferedDataStreamTest.printArray(ob);
            System.out.print("array orig: ");
            BufferedDataStreamTest.printArray(al);
            System.out.print("array read: ");
            lng = bis.readInt();
            ob = bis.readLongs(new long[lng], 0, lng);
            BufferedDataStreamTest.printArray(ob);
            System.out.print("array orig: ");
            BufferedDataStreamTest.printArray(af);
            System.out.print("array read: ");
            lng = bis.readInt();
            ob = bis.readFloats(new float[lng], 0, lng);
            BufferedDataStreamTest.printArray(ob);
            System.out.print("array orig: ");
            BufferedDataStreamTest.printArray(ad);
            System.out.print("array read: ");
            lng = bis.readInt();
            ob = bis.readDoubles(new double[lng], 0, lng);
            BufferedDataStreamTest.printArray(ob);
        }
        System.out.println("orig: 10000 read: " + is.readLong());
        System.out.println("orig: true read: " + is.readBoolean());
        System.out.println("orig: 12 read: " + is.readByte());
        System.out.println("orig: a read: " + is.readChar());
        System.out.println("orig: 2453 read: " + is.readShort());
        System.out.println("orig: 88989 read: " + is.readInt());
        System.out.println("orig: 3.1415 read: " + is.readDouble());
        System.out.println("orig: 0.33333334 read: " + is.readFloat());
        System.out.println("orig: Ala ma kota \u0081\ucff5 read: " + is.readUTF());
    }

    static void printArray(Object obj) {
        if (!obj.getClass().isArray()) {
            System.out.print("NOT AN ARRAY");
            return;
        }
        Class<?> komp = obj.getClass().getComponentType();
        if (Byte.TYPE == komp) {
            BufferedDataStreamTest.printBytes((byte[])obj);
        } else if (Boolean.TYPE == komp) {
            BufferedDataStreamTest.printBooleans((boolean[])obj);
        } else if (Character.TYPE == komp) {
            BufferedDataStreamTest.printChars((char[])obj);
        } else if (Short.TYPE == komp) {
            BufferedDataStreamTest.printShorts((short[])obj);
        } else if (Integer.TYPE == komp) {
            BufferedDataStreamTest.printInts((int[])obj);
        } else if (Long.TYPE == komp) {
            BufferedDataStreamTest.printLongs((long[])obj);
        } else if (Float.TYPE == komp) {
            BufferedDataStreamTest.printFloats((float[])obj);
        } else if (Double.TYPE == komp) {
            BufferedDataStreamTest.printDoubles((double[])obj);
        }
    }

    private static void printBooleans(boolean[] arr) {
        System.out.print("Array of booleans. Length: " + arr.length + ". Elements ");
        int maxToPrint = Math.min(5, arr.length);
        for (int i = 0; i < maxToPrint; ++i) {
            System.out.print(arr[i] + ",");
        }
        System.out.println("...");
    }

    private static void printBytes(byte[] arr) {
        System.out.print("Array of bytes. Length: " + arr.length + ". Elements ");
        int maxToPrint = Math.min(5, arr.length);
        for (int i = 0; i < maxToPrint; ++i) {
            System.out.print(arr[i] + ",");
        }
        System.out.println("...");
    }

    private static void printChars(char[] arr) {
        System.out.print("Array of chars. Length: " + arr.length + ". Elements ");
        int maxToPrint = Math.min(5, arr.length);
        for (int i = 0; i < maxToPrint; ++i) {
            System.out.print(arr[i] + ",");
        }
        System.out.println("...");
    }

    private static void printShorts(short[] arr) {
        System.out.print("Array of shorts. Length: " + arr.length + ". Elements ");
        int maxToPrint = Math.min(5, arr.length);
        for (int i = 0; i < maxToPrint; ++i) {
            System.out.print(arr[i] + ",");
        }
        System.out.println("...");
    }

    private static void printInts(int[] arr) {
        System.out.print("Array of ints. Length: " + arr.length + ". Elements ");
        int maxToPrint = Math.min(5, arr.length);
        for (int i = 0; i < maxToPrint; ++i) {
            System.out.print(arr[i] + ",");
        }
        System.out.println("...");
    }

    private static void printLongs(long[] arr) {
        System.out.print("Array of longs. Length: " + arr.length + ". Elements ");
        int maxToPrint = Math.min(5, arr.length);
        for (int i = 0; i < maxToPrint; ++i) {
            System.out.print(arr[i] + ",");
        }
        System.out.println("...");
    }

    private static void printFloats(float[] arr) {
        System.out.print("Array of floats. Length: " + arr.length + ". Elements ");
        int maxToPrint = Math.min(5, arr.length);
        for (int i = 0; i < maxToPrint; ++i) {
            System.out.print(arr[i] + ",");
        }
        System.out.println("...");
    }

    private static void printDoubles(double[] arr) {
        System.out.print("Array of doubles. Length: " + arr.length + ". Elements ");
        int maxToPrint = Math.min(5, arr.length);
        for (int i = 0; i < maxToPrint; ++i) {
            System.out.print(arr[i] + ",");
        }
        System.out.println("...");
    }

    static {
        ac = new char[]{'a', 'c', 'z', '!', '\"', 'A'};
        as = new short[]{2453, -231};
        ai = new int[]{-192, 1982, 99822, 2337, 3, 254};
        al = new long[]{10000L, -2434L, 876712127727327L};
        ad = new double[]{3.1415, -1.0E-99, 2.3452};
        af = new float[]{0.33333334f, -7.112938E-4f, 7622.385f};
    }
}

