/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.natives;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class FilesystemUtils {
    private static final String[] chmodCandidates = new String[]{"/bin/chmod", "/usr/bin/chmod", "/bin/chmod.exe", "/usr/bin/chmod.exe"};

    private FilesystemUtils() {
    }

    public static boolean setExecutable(final File file, final boolean executable) {
        FilesystemUtils.checkWrite(file);
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FilesystemUtils.setExecutablePrivileged(file, executable);
            }
        });
    }

    private static boolean setExecutablePrivileged(File file, boolean executable) {
        File chmod = FilesystemUtils.findFile(chmodCandidates);
        if (chmod == null) {
            return false;
        }
        String[] cmdarr = new String[]{chmod.getAbsolutePath(), "a" + (executable ? "+" : "-") + "x", file.getPath()};
        return FilesystemUtils.cmdexec(cmdarr);
    }

    public static boolean setPrivate(final File file) {
        FilesystemUtils.checkWrite(file);
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FilesystemUtils.setPrivatePrivileged(file);
            }
        });
    }

    private static boolean setPrivatePrivileged(File file) {
        File chmod = FilesystemUtils.findFile(chmodCandidates);
        if (chmod == null) {
            return false;
        }
        String[] cmdarr = new String[]{chmod.getAbsolutePath(), "og=", file.getPath()};
        return FilesystemUtils.cmdexec(cmdarr);
    }

    private static boolean cmdexec(String[] cmdarr) {
        try {
            Process p = Runtime.getRuntime().exec(cmdarr);
            p.waitFor();
            return p.exitValue() != 0;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static File findFile(String[] candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            File f = new File(candidates[i]);
            if (!f.isFile()) continue;
            return f;
        }
        return null;
    }

    private static void checkWrite(File file) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(file.getPath());
        }
    }
}

