/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.net;

import edu.emory.mathcs.util.net.Connection;
import java.io.IOException;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.HashSet;
import java.util.Iterator;

public class ConnectionPool {
    static final long DEFAULT_EXPIRATION_TIMEOUT = 15000L;
    static final int DEFAULT_CAPACITY = 10;
    private final HashSet connections = new HashSet();
    private final String hostName;
    private final int port;
    private final RMIClientSocketFactory socketFactory;
    final long expirationTimeout;
    private final int capacity;

    public ConnectionPool(String hostName, int port) {
        this(hostName, port, null);
    }

    public ConnectionPool(String hostName, int port, RMIClientSocketFactory socketFactory) {
        this(hostName, port, socketFactory, 15000L, 10);
    }

    public ConnectionPool(String hostName, int port, long expirationTimeout, int capacity) {
        this(hostName, port, null, expirationTimeout, capacity);
    }

    public ConnectionPool(String hostName, int port, RMIClientSocketFactory socketFactory, long expirationTimeout, int capacity) {
        if (capacity <= 0 || expirationTimeout < 0L) {
            throw new IllegalArgumentException();
        }
        this.hostName = hostName;
        this.port = port;
        this.socketFactory = socketFactory;
        this.expirationTimeout = expirationTimeout;
        this.capacity = capacity;
    }

    private Connection findConnection() {
        Connection result = null;
        Iterator iter = this.connections.iterator();
        while (iter.hasNext()) {
            Connection conn = (Connection)iter.next();
            byte connStatus = conn.acquire();
            if (connStatus == 1) {
                result = conn;
                break;
            }
            if (connStatus != 0) continue;
            iter.remove();
        }
        return result;
    }

    synchronized void notifyConnectionStateChanged() {
        this.notify();
    }

    public synchronized Connection getConnection() throws IOException, InterruptedException {
        this.checkConnectPermission();
        Connection conn = this.findConnection();
        while (conn == null) {
            if (this.connections.size() == this.capacity) {
                this.wait();
                conn = this.findConnection();
                continue;
            }
            Socket socket = this.socketFactory != null ? this.socketFactory.createSocket(this.hostName, this.port) : new Socket(this.hostName, this.port);
            conn = new Connection(socket, this);
            this.connections.add(conn);
        }
        return conn;
    }

    private void checkConnectPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkConnect(this.hostName, this.port);
        }
    }
}

