/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;

public abstract class ServerSocketWrapper
extends ServerSocket {
    protected final ServerSocket delegate;

    protected ServerSocketWrapper(ServerSocket delegate) throws IOException {
        if (delegate == null) {
            throw new NullPointerException();
        }
        if (delegate.isClosed()) {
            throw new SocketException("Delegate server socket is closed");
        }
        if (!delegate.isBound()) {
            throw new SocketException("Delegate server socket is not bound");
        }
        this.delegate = delegate;
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public InetAddress getInetAddress() {
        return this.delegate.getInetAddress();
    }

    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    public Socket accept() throws IOException {
        Socket socket = this.delegate.accept();
        return this.wrapAcceptedSocket(socket);
    }

    protected abstract Socket wrapAcceptedSocket(Socket var1) throws IOException;

    public void close() throws IOException {
        this.delegate.close();
    }

    public ServerSocketChannel getChannel() {
        return this.delegate.getChannel();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.delegate.setSoTimeout(timeout);
    }

    public int getSoTimeout() throws IOException {
        return this.delegate.getSoTimeout();
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.delegate.setReuseAddress(on);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.delegate.getReuseAddress();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.delegate.setReceiveBufferSize(size);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.delegate.getReceiveBufferSize();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServerSocketWrapper)) {
            return false;
        }
        ServerSocketWrapper that = (ServerSocketWrapper)obj;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode() ^ 0x1010101;
    }
}

