/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.net.tunnel;

import edu.emory.mathcs.backport.java.util.concurrent.ArrayBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.util.collections.ints.IntIntervalSet;
import edu.emory.mathcs.util.collections.ints.IntMap;
import edu.emory.mathcs.util.collections.ints.IntRadkeHashMap;
import edu.emory.mathcs.util.collections.ints.IntSortedSet;
import edu.emory.mathcs.util.concurrent.AsyncTask;
import edu.emory.mathcs.util.io.IOUtils;
import edu.emory.mathcs.util.net.tunnel.TunnelServerSocket;
import edu.emory.mathcs.util.net.tunnel.TunnelSocketAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class TunnelServerSocket
extends ServerSocket {
    static int PROTOCOL_MAGIC = 341495962;
    static int PROTOCOL_VERSION_1 = 1;
    static final int ACK = 1;
    static final int NACK_UNSUPPORTED_PROTOCOL = -1;
    static final int NACK_NO_SERVER = -2;
    static final int NACK_SERVER_CLOSED = -3;
    static final int NACK_QUEUE_FULL = -4;
    static final int DEFAULT_DISPATCHER_BACKLOG = 200;
    static final Map dispatchers = new HashMap();
    volatile boolean isBinding;
    volatile boolean closed;
    boolean bound;
    Dispatcher dispatcher;
    int localPort;
    int soTimeout = 0;
    int receiveBufferSize = -1;
    volatile BlockingQueue connectionQueue;
    final TunnelFactory tunnelFactory;
    ServerSocket tunnel;
    private static final TunnelFactory plainTunnelFactory = new PlainTunnelFactory();
    private static final Socket TERMINATOR = new Socket();

    public TunnelServerSocket(TunnelFactory tunnelFactory) throws IOException {
        this.tunnelFactory = tunnelFactory;
    }

    public TunnelServerSocket(TunnelFactory tunnelFactory, TunnelSocketAddress addr) throws IOException {
        this(tunnelFactory, addr, 50);
    }

    public TunnelServerSocket(TunnelFactory tunnelFactory, TunnelSocketAddress addr, int backlog) throws IOException {
        this(tunnelFactory);
        this.bind(addr, backlog);
    }

    public TunnelServerSocket() throws IOException {
        this(plainTunnelFactory);
    }

    public TunnelServerSocket(InetSocketAddress tunnelAddr, int port) throws IOException {
        this(plainTunnelFactory, new TunnelSocketAddress(tunnelAddr, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        TunnelServerSocket tunnelServerSocket = this;
        synchronized (tunnelServerSocket) {
            this.ensureNotClosed();
            if (this.isBound()) {
                throw new SocketException("Already bound");
            }
            if (this.isBinding) {
                throw new SocketException("Already binding");
            }
            if (endpoint == null) {
                endpoint = new TunnelSocketAddress(new InetSocketAddress(0), 0);
            }
            if (backlog <= 0) {
                throw new IllegalArgumentException("Backlog must be positive");
            }
            if (!(endpoint instanceof TunnelSocketAddress)) {
                throw new IllegalArgumentException("Unsupported address type");
            }
            this.isBinding = true;
        }
        try {
            TunnelSocketAddress tep = (TunnelSocketAddress)endpoint;
            TunnelServerSocket.bind(this, this.tunnelFactory, tep, backlog);
        }
        finally {
            this.isBinding = false;
        }
    }

    protected ServerSocket getTunnel() {
        return this.tunnel;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean isBound() {
        return this.bound;
    }

    public synchronized void setBound(Dispatcher dispatcher, int localPort, int backlog) {
        this.dispatcher = dispatcher;
        this.tunnel = dispatcher.ssock;
        this.localPort = localPort;
        this.connectionQueue = new ArrayBlockingQueue(backlog);
        this.bound = true;
    }

    boolean connect(Socket s) {
        return this.connectionQueue.offer((Object)s);
    }

    public synchronized int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        return this.localPort;
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new TunnelSocketAddress(this.tunnel.getLocalSocketAddress(), this.getLocalPort());
    }

    public Socket accept() throws IOException {
        this.ensureNotClosed();
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        int soTimeout = this.soTimeout;
        while (true) {
            Socket req;
            try {
                req = soTimeout > 0 ? (Socket)this.connectionQueue.poll((long)soTimeout, TimeUnit.MILLISECONDS) : (Socket)this.connectionQueue.take();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.toString());
            }
            if (req == null) {
                throw new SocketTimeoutException("Timeout on TunnelServerSocket.accept");
            }
            if (req == TERMINATOR) {
                this.close();
                throw new SocketException("Socket closed");
            }
            try {
                TunnelServerSocket.ack(req);
                if (this.receiveBufferSize > 0) {
                    req.setReceiveBufferSize(this.receiveBufferSize);
                }
                return req;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Socket req;
        TunnelServerSocket tunnelServerSocket = this;
        synchronized (tunnelServerSocket) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (!this.isBound()) {
                return;
            }
        }
        while ((req = (Socket)this.connectionQueue.poll()) != null) {
            IOUtils.closeQuietly(req);
        }
        try {
            this.connectionQueue.put((Object)TERMINATOR);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("FATAL: Blocked when putting into empty queue");
        }
        TunnelServerSocket.unbind(this);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be non-negative");
        }
        this.ensureNotClosed();
        this.soTimeout = timeout;
    }

    public int getSoTimeout() throws IOException {
        this.ensureNotClosed();
        return this.soTimeout;
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.ensureNotClosed();
    }

    public boolean getReuseAddress() throws SocketException {
        this.ensureNotClosed();
        return true;
    }

    public String toString() {
        if (!this.isBound()) {
            return "TunnelServerSocket[unbound]";
        }
        return "TunnelServerSocket[tunnel=" + this.tunnel.getLocalSocketAddress() + "; port=" + this.localPort + "]";
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        this.receiveBufferSize = size;
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.receiveBufferSize > 0 ? this.receiveBufferSize : (this.dispatcher != null ? this.dispatcher.ssock.getReceiveBufferSize() : -1);
    }

    private void ensureNotClosed() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void nack(Socket s, DataOutputStream out, int code) {
        try {
            out.writeInt(-4);
            out.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly(s);
        }
    }

    private static void ack(Socket s) throws IOException {
        DataOutputStream out = new DataOutputStream(s.getOutputStream());
        try {
            out.writeInt(1);
            out.flush();
        }
        catch (IOException e) {
            IOUtils.closeQuietly(s);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static void bind(TunnelServerSocket s, TunnelFactory tunnelFactory, TunnelSocketAddress addr, int backlog) throws IOException {
        d = null;
        p = null;
        goahead = false;
        tunnelAddr = addr.getTunnelAddress();
        port = addr.getPort();
        key = new TunnelKey(tunnelFactory, tunnelAddr);
        do lbl-1000:
        // 3 sources

        {
            block16: {
                var10_10 = TunnelServerSocket.dispatchers;
                synchronized (var10_10) {
                    obj = TunnelServerSocket.dispatchers.get(key);
                    if (obj == null) {
                        p = new Promise();
                        goahead = true;
                        TunnelServerSocket.dispatchers.put(key, p);
                    } else if (obj instanceof Dispatcher) {
                        d = (Dispatcher)obj;
                        if (d.isClosed()) {
                            d = null;
                            p = new Promise();
                            goahead = true;
                            TunnelServerSocket.dispatchers.put(key, p);
                        }
                    } else {
                        p = (Promise)obj;
                        goahead = false;
                    }
                }
                if (d == null) break block16;
                if (!d.bindSocket(s, port, backlog)) ** GOTO lbl-1000
                return;
            }
            if (goahead) {
                d = new Dispatcher(tunnelFactory, tunnelAddr);
                d.bindSocket(s, port, backlog);
                var10_10 = TunnelServerSocket.dispatchers;
                synchronized (var10_10) {
                    TunnelServerSocket.dispatchers.put(key, d);
                }
                d.start();
                p.set(d);
                return;
            }
            try {
                d = (Dispatcher)p.get();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Cannot happen");
            }
        } while (!d.bindSocket(s, port, backlog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unbind(TunnelServerSocket s) {
        Dispatcher d = s.dispatcher;
        if (d.tryUnbindSocket(s)) {
            TunnelKey key = new TunnelKey(d.tunnelFactory, d.requestedAddr);
            Map map = dispatchers;
            synchronized (map) {
                Dispatcher curr = (Dispatcher)dispatchers.get(key);
                if (curr == d) {
                    dispatchers.remove(key);
                }
            }
        }
    }

    private static class TunnelKey {
        final TunnelFactory factory;
        final SocketAddress addr;

        TunnelKey(TunnelFactory factory, SocketAddress addr) {
            this.factory = factory;
            this.addr = addr;
        }

        public int hashCode() {
            return this.factory.hashCode() ^ (this.addr == null ? 0 : this.addr.hashCode());
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof TunnelKey)) {
                return false;
            }
            TunnelKey that = (TunnelKey)other;
            return this.factory.equals(that.factory) && (this.addr == null ? that.addr == null : this.addr.equals(that.addr));
        }

        public String toString() {
            return "[" + this.factory + ": " + this.addr + "]";
        }
    }

    public static final class PlainTunnelFactory
    implements TunnelFactory {
        final int defaultTunnelPort;
        final int dispatcherBacklog;

        PlainTunnelFactory() {
            this(0);
        }

        PlainTunnelFactory(int defaultTunnelPort) {
            this(defaultTunnelPort, 200);
        }

        PlainTunnelFactory(int defaultTunnelPort, int dispatcherBacklog) {
            this.defaultTunnelPort = defaultTunnelPort;
            this.dispatcherBacklog = dispatcherBacklog;
        }

        public ServerSocket createTunnel(SocketAddress addr) throws IOException {
            if (addr == null) {
                addr = new InetSocketAddress((InetAddress)null, this.defaultTunnelPort);
            } else if (!(addr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Unsupported address type");
            }
            InetSocketAddress iaddr = (InetSocketAddress)addr;
            return new ServerSocket(iaddr.getPort(), this.dispatcherBacklog, iaddr.getAddress());
        }

        public int hashCode() {
            return this.defaultTunnelPort ^ this.dispatcherBacklog;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof PlainTunnelFactory)) {
                return false;
            }
            PlainTunnelFactory that = (PlainTunnelFactory)other;
            return this.defaultTunnelPort == that.defaultTunnelPort && this.dispatcherBacklog == that.dispatcherBacklog;
        }

        public String toString() {
            return "PlainTunnelFactory(" + this.defaultTunnelPort + ")";
        }
    }

    private static class Promise
    extends AsyncTask {
        Promise() {
        }

        void set(Object result) {
            super.setCompleted(result);
        }
    }

    private static class Dispatcher {
        final TunnelFactory tunnelFactory;
        final SocketAddress requestedAddr;
        final ServerSocket ssock;
        final IntMap sockets = new IntRadkeHashMap();
        final IntSortedSet addresses = new IntIntervalSet(0, Integer.MAX_VALUE);
        volatile boolean closed = false;
        int lastDefaultPort = 32768;

        Dispatcher(TunnelFactory tunnelFactory, SocketAddress requestedAddr) throws IOException {
            this.tunnelFactory = tunnelFactory;
            this.requestedAddr = requestedAddr;
            this.ssock = tunnelFactory.createTunnel(requestedAddr);
        }

        synchronized void start() {
            AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ Dispatcher this$0;
                {
                    this.this$0 = this$0;
                }

                public Object run() {
                    ThreadGroup tg = Thread.currentThread().getThreadGroup();
                    while (tg.getParent() != null) {
                        tg = tg.getParent();
                    }
                    Runnable runLoop = new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            Dispatcher.access$100(1.access$000(this.this$1));
                        }
                    };
                    Thread t = new Thread(tg, runLoop, "tunnel at " + this.this$0.ssock.getLocalSocketAddress());
                    t.start();
                    return null;
                }

                static /* synthetic */ Dispatcher access$000(1 x0) {
                    return x0.this$0;
                }
            });
        }

        synchronized void stop() {
            this.closed = true;
            IOUtils.closeQuietly(this.ssock);
        }

        boolean isClosed() {
            return this.closed;
        }

        synchronized boolean bindSocket(TunnelServerSocket s, int port, int backlog) throws IOException {
            if (this.closed) {
                return false;
            }
            if (port != 0) {
                TunnelServerSocket other = (TunnelServerSocket)this.sockets.get(port);
                if (other != null) {
                    throw new BindException("Address in use: " + this.ssock + ":" + port);
                }
            } else {
                IntSortedSet unusedPorts = (IntSortedSet)this.addresses.complementSet();
                try {
                    port = unusedPorts.higher(this.lastDefaultPort);
                }
                catch (NoSuchElementException e) {
                    port = unusedPorts.first();
                }
                this.lastDefaultPort = port;
            }
            this.addresses.add(port);
            s.setBound(this, port, backlog);
            this.sockets.put(port, s);
            return true;
        }

        synchronized boolean tryUnbindSocket(TunnelServerSocket s) {
            int port = s.getLocalPort();
            TunnelServerSocket current = (TunnelServerSocket)this.sockets.get(port);
            if (current == s) {
                this.sockets.remove(port);
                this.addresses.remove(port);
                if (this.addresses.isEmpty()) {
                    this.stop();
                    return true;
                }
            }
            return false;
        }

        private void acceptLoop() {
            while (!this.ssock.isClosed()) {
                try {
                    Socket s = this.ssock.accept();
                    this.dispatch(s);
                }
                catch (IOException iOException) {}
            }
            this.closed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatch(Socket s) {
            try {
                TunnelServerSocket tss;
                DataInputStream in = new DataInputStream(s.getInputStream());
                DataOutputStream out = new DataOutputStream(s.getOutputStream());
                int magic = in.readInt();
                if (magic != PROTOCOL_MAGIC) {
                    TunnelServerSocket.nack(s, out, -1);
                    return;
                }
                int pver = in.readInt();
                if (pver != PROTOCOL_VERSION_1) {
                    TunnelServerSocket.nack(s, out, -1);
                    return;
                }
                int port = in.readInt();
                Dispatcher dispatcher = this;
                synchronized (dispatcher) {
                    tss = (TunnelServerSocket)this.sockets.get(port);
                }
                if (tss == null) {
                    TunnelServerSocket.nack(s, out, -2);
                    return;
                }
                boolean enqueued = tss.connect(s);
                if (!enqueued) {
                    TunnelServerSocket.nack(s, out, -4);
                    return;
                }
            }
            catch (IOException e) {
                IOUtils.closeQuietly(s);
                return;
            }
        }

        static /* synthetic */ void access$100(Dispatcher x0) {
            x0.acceptLoop();
        }
    }

    public static interface TunnelFactory {
        public ServerSocket createTunnel(SocketAddress var1) throws IOException;
    }
}

