/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.remote.io;

import edu.emory.mathcs.util.remote.io.server.RemoteInputStreamSrv;
import edu.emory.mathcs.util.remote.io.server.impl.RemoteInputStreamSrvImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RemoteInputStream
extends InputStream
implements Externalizable {
    RemoteInputStreamSrv server;

    public RemoteInputStream() {
    }

    public RemoteInputStream(InputStream in) {
        this(new RemoteInputStreamSrvImpl(in));
    }

    public RemoteInputStream(RemoteInputStreamSrv server) {
        if (server == null) {
            throw new NullPointerException("server");
        }
        this.server = server;
    }

    public int read() throws IOException {
        byte[] buf = this.server.read(1);
        if (buf == null) {
            return -1;
        }
        return buf[0];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        byte[] buf = this.server.read(len);
        if (buf == null) {
            return -1;
        }
        System.arraycopy(buf, 0, b, off, buf.length);
        return buf.length;
    }

    public long skip(long n) throws IOException {
        return this.server.skip(n);
    }

    public int available() throws IOException {
        return this.server.available();
    }

    public void close() throws IOException {
        this.server.close();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.server);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.server = (RemoteInputStreamSrv)in.readObject();
    }
}

