/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.remote.io;

import edu.emory.mathcs.util.remote.io.server.RemoteOutputStreamSrv;
import edu.emory.mathcs.util.remote.io.server.impl.RemoteOutputStreamSrvImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class RemoteOutputStream
extends OutputStream
implements Externalizable {
    RemoteOutputStreamSrv server;

    public RemoteOutputStream() {
    }

    public RemoteOutputStream(OutputStream out) {
        this(new RemoteOutputStreamSrvImpl(out));
    }

    public RemoteOutputStream(RemoteOutputStreamSrv server) {
        if (server == null) {
            throw new NullPointerException("server");
        }
        this.server = server;
    }

    public void write(int b) throws IOException {
        this.server.write(new byte[]{(byte)b});
    }

    public void write(byte[] buf) throws IOException {
        this.server.write(buf);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        byte[] data = new byte[len];
        System.arraycopy(buf, off, data, 0, len);
        this.server.write(data);
    }

    public void flush() throws IOException {
        this.server.flush();
    }

    public void close() throws IOException {
        this.server.close();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.server);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.server = (RemoteOutputStreamSrv)in.readObject();
    }
}

