/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.remote.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.util.remote.locks.RemoteCondition;
import edu.emory.mathcs.util.remote.locks.RemoteLock;
import edu.emory.mathcs.util.remote.locks.SharingProtocolException;
import java.rmi.RemoteException;

public class RemoteEisMcGLock
implements RemoteLock {
    final Backend backend;

    public RemoteEisMcGLock(Backend backend) {
        if (backend == null) {
            throw new NullPointerException();
        }
        this.backend = backend;
    }

    public void lock() throws RemoteException {
        boolean wasInterrupted = false;
        while (true) {
            try {
                this.lockInterruptibly();
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
    }

    public void lockInterruptibly() throws InterruptedException, RemoteException {
        this.tryLockImpl(false, 0L);
    }

    public boolean tryLock() throws RemoteException {
        try {
            return this.tryLockImpl(true, 0L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException, RemoteException {
        return this.tryLockImpl(true, unit.toNanos(timeout));
    }

    public RemoteCondition newCondition() throws RemoteException {
        throw new UnsupportedOperationException("Not implemented");
    }

    boolean tryLockImpl(boolean timed, long nanos) throws InterruptedException, RemoteException {
        Comparable turn;
        Comparable myID = this.backend.getMyID();
        long deadline = timed ? Utils.nanoTime() + nanos : 0L;
        block0: while (true) {
            Participant p;
            this.backend.setMyState(Participant.State.WAITING);
            turn = this.backend.getTurnID();
            block1: while (true) {
                this.backend.resetCursor(turn);
                do {
                    if ((p = this.backend.fetchNext()) == null) {
                        throw new SharingProtocolException("The WAITING flag that we've set has disappeared");
                    }
                    if (p.getID().equals(myID)) break block1;
                } while (p.getState() == Participant.State.IDLE);
                if (nanos <= 0L) {
                    this.backend.setMyState(Participant.State.IDLE);
                    return false;
                }
                this.backend.waitForEvent(nanos);
                nanos = timed ? deadline - Utils.nanoTime() : 0L;
            }
            this.backend.setMyState(Participant.State.ACTIVE);
            turn = this.backend.getTurnID();
            this.backend.resetCursor(null);
            while ((p = this.backend.fetchNext()) != null) {
                if (p.getID().equals(myID) || p.getState() != Participant.State.ACTIVE && (!p.getID().equals(turn) || p.getState() == Participant.State.IDLE)) continue;
                if (nanos <= 0L) {
                    this.backend.setMyState(Participant.State.IDLE);
                    return false;
                }
                this.backend.waitForEvent(nanos);
                nanos = timed ? deadline - Utils.nanoTime() : 0L;
                continue block0;
            }
            break;
        }
        this.backend.setTurnID(myID);
        turn = myID;
        return true;
    }

    public void unlock() throws RemoteException {
        Participant p;
        Comparable turn;
        Comparable myID = this.backend.getMyID();
        if (!myID.equals(turn = this.backend.getTurnID())) {
            throw new SharingProtocolException("We are no longer holding a turn");
        }
        this.backend.resetCursor(myID);
        do {
            if ((p = this.backend.fetchNext()) != null) continue;
            this.backend.setTurnID(null);
            return;
        } while (p.getState() == Participant.State.IDLE || p.equals(myID));
        this.backend.setTurnID(p.getID());
        this.backend.setMyState(Participant.State.IDLE);
    }

    public int hashCode() {
        return this.backend.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof RemoteEisMcGLock)) {
            return false;
        }
        RemoteEisMcGLock that = (RemoteEisMcGLock)other;
        return this.backend.equals(that.backend);
    }

    public static class Participant
    implements Comparable {
        final Comparable id;
        final State state;

        public Participant(Comparable id, State state) {
            this.id = id;
            this.state = state;
        }

        public Comparable getID() {
            return this.id;
        }

        public State getState() {
            return this.state;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Participant)) {
                return false;
            }
            Participant that = (Participant)other;
            return this.id.equals(that.id);
        }

        public int compareTo(Object other) {
            if (other == this) {
                return 0;
            }
            Participant that = (Participant)other;
            return this.id.compareTo(that.id);
        }

        public static final class State {
            public static final State IDLE = new State(0, "IDLE");
            public static final State WAITING = new State(1, "WAITING");
            public static final State ACTIVE = new State(2, "ACTIVE");
            public final int id;
            public final String name;

            private State(int id, String name) {
                this.id = id;
                this.name = name;
            }

            public static final State forID(int id) {
                switch (id) {
                    case 0: {
                        return IDLE;
                    }
                    case 1: {
                        return WAITING;
                    }
                    case 2: {
                        return ACTIVE;
                    }
                }
                throw new IllegalArgumentException();
            }

            public static final State forName(String name) {
                if ("IDLE".equalsIgnoreCase(name)) {
                    return IDLE;
                }
                if ("WAITING".equalsIgnoreCase(name)) {
                    return WAITING;
                }
                if ("ACTIVE".equalsIgnoreCase(name)) {
                    return ACTIVE;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    public static interface Backend {
        public Comparable getMyID();

        public Comparable getTurnID() throws RemoteException;

        public void setTurnID(Comparable var1) throws RemoteException;

        public void setMyState(Participant.State var1) throws RemoteException;

        public void resetCursor(Comparable var1);

        public Participant fetchNext() throws RemoteException;

        public void waitForEvent(long var1) throws InterruptedException;
    }
}

