/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.remote.server.impl;

import edu.emory.mathcs.util.remote.io.server.RemoteInputStreamSrv;
import edu.emory.mathcs.util.remote.io.server.RemoteOutputStreamSrv;
import edu.emory.mathcs.util.remote.io.server.impl.RemoteInputStreamSrvImpl;
import edu.emory.mathcs.util.remote.io.server.impl.RemoteOutputStreamSrvImpl;
import edu.emory.mathcs.util.remote.server.RemoteProcessSrv;
import java.io.IOException;

public class RemoteProcessSrvImpl
implements RemoteProcessSrv {
    final Process process;
    final RemoteInputStreamSrv srvin;
    final RemoteOutputStreamSrv srvout;
    final RemoteInputStreamSrv srverr;

    public RemoteProcessSrvImpl(Process process) {
        if (process == null) {
            throw new NullPointerException("process");
        }
        this.process = process;
        this.srvin = new RemoteInputStreamSrvImpl(process.getInputStream());
        this.srverr = new RemoteInputStreamSrvImpl(process.getErrorStream());
        this.srvout = new RemoteOutputStreamSrvImpl(process.getOutputStream());
    }

    public void destroy() {
        this.process.destroy();
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public byte[] readFromIn(int maxbytes) throws IOException {
        return this.srvin.read(maxbytes);
    }

    public int availableInIn() throws IOException {
        return this.srvin.available();
    }

    public long skipInIn(long n) throws IOException {
        return this.srvin.skip(n);
    }

    public void closeIn() throws IOException {
        this.srvin.close();
    }

    public byte[] readFromErr(int maxbytes) throws IOException {
        return this.srverr.read(maxbytes);
    }

    public int availableInErr() throws IOException {
        return this.srverr.available();
    }

    public long skipInErr(long n) throws IOException {
        return this.srverr.skip(n);
    }

    public void closeErr() throws IOException {
        this.srverr.close();
    }

    public void writeToOut(byte[] buf) throws IOException {
        this.srvout.write(buf);
    }

    public void flushOut() throws IOException {
        this.srvout.flush();
    }

    public void closeOut() throws IOException {
        this.srvout.close();
    }
}

