/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.security;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.Arrays;

public class CharStrings {
    private CharStrings() {
    }

    public static char[] concat(char[] s1, char[] s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        char[] s3 = new char[s1.length + s2.length];
        System.arraycopy(s1, 0, s3, 0, s1.length);
        System.arraycopy(s2, 0, s3, s1.length, s2.length);
        return s3;
    }

    public static boolean equals(char[] s1, char[] s2) {
        return Arrays.equals(s1, s2);
    }

    public static void clear(char[] s) {
        if (s != null) {
            Arrays.fill(s, '\u0000');
        }
    }

    public static int writeUTF(OutputStream out, char[] s) throws IOException {
        return CharStrings.writeUTF(out, s, 0, s.length);
    }

    public static int writeUTF(OutputStream out, char[] s, int off, int len) throws IOException {
        int utflen = CharStrings.getUTFLen(s, off, len);
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] dest = new byte[utflen + 2];
        dest[0] = (byte)(utflen >>> 8 & 0xFF);
        dest[1] = (byte)(utflen >>> 0 & 0xFF);
        CharStrings.toUTF(s, off, len, dest, 2);
        out.write(dest);
        Arrays.fill(dest, (byte)0);
        return dest.length;
    }

    public static byte[] toUTF(char[] s) {
        return CharStrings.toUTF(s, 0, s.length);
    }

    public static byte[] toUTF(char[] s, int off, int len) {
        byte[] dest = new byte[CharStrings.getUTFLen(s, off, len)];
        CharStrings.toUTF(s, off, len, dest, 0);
        return dest;
    }

    public static int getUTFLen(char[] s, int off, int len) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > s.length || len < 0 || off + len > s.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int utflen = 0;
        for (int i = 0; i < len; ++i) {
            char c = s[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    private static void toUTF(char[] s, int off, int len, byte[] dest, int destoff) {
        int count = destoff;
        for (int i = 0; i < len; ++i) {
            char c = s[i];
            if (c >= '\u0001' && c <= '\u007f') {
                dest[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                dest[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                dest[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                dest[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            dest[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            dest[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    public static final char[] readUTF(InputStream in) throws IOException {
        DataInput din = in instanceof DataInput ? (DataInput)((Object)in) : new DataInputStream(in);
        return CharStrings.readUTF(din);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final char[] readUTF(DataInput in) throws IOException {
        int utflen = in.readUnsignedShort();
        byte[] bytearr = new byte[utflen];
        try {
            in.readFully(bytearr, 0, utflen);
            char[] cArray = CharStrings.fromUTF(bytearr);
            return cArray;
        }
        finally {
            Arrays.fill(bytearr, (byte)0);
        }
    }

    public static final char[] fromUTF(byte[] utfString) throws IOException {
        return CharStrings.fromUTF(utfString, 0, utfString.length);
    }

    public static final char[] fromUTF(byte[] utfString, int off, int len) throws IOException {
        char[] arr = new char[len];
        int idx = 0;
        try {
            block7: while (off < len) {
                int c = utfString[off] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++off;
                        arr[idx++] = (char)c;
                        continue block7;
                    }
                    case 12: 
                    case 13: {
                        if ((off += 2) > len) {
                            throw new UTFDataFormatException();
                        }
                        byte char2 = utfString[off - 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        arr[idx++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        continue block7;
                    }
                    case 14: {
                        if ((off += 3) > len) {
                            throw new UTFDataFormatException();
                        }
                        byte char2 = utfString[off - 2];
                        byte char3 = utfString[off - 1];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        arr[idx++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        continue block7;
                    }
                }
                throw new UTFDataFormatException();
            }
            if (idx < len) {
                char[] newarr = new char[idx];
                System.arraycopy(arr, 0, newarr, 0, idx);
                Arrays.fill(arr, '\u0000');
                arr = newarr;
            }
            return arr;
        }
        catch (IOException e) {
            Arrays.fill(arr, '\u0000');
            throw e;
        }
    }
}

