/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.security;

import edu.emory.mathcs.util.io.NullOutputStream;
import edu.emory.mathcs.util.io.RedirectingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    private DigestUtils() {
    }

    public static MessageDigest getSHADigest() {
        try {
            return MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA not supported");
        }
    }

    public static MessageDigest getMD5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 not supported");
        }
    }

    public static DigestInputStream getSHADigestInputStream(InputStream is) {
        return new DigestInputStream(is, DigestUtils.getSHADigest());
    }

    public static DigestInputStream getMD5DigestInputStream(InputStream is) {
        return new DigestInputStream(is, DigestUtils.getMD5Digest());
    }

    public static DigestOutputStream getSHADigestOutputStream(OutputStream os) {
        return new DigestOutputStream(os, DigestUtils.getSHADigest());
    }

    public static DigestOutputStream getMD5DigestOutputStream(OutputStream os) {
        return new DigestOutputStream(os, DigestUtils.getMD5Digest());
    }

    public static byte[] calculateDigest(InputStream in, MessageDigest digest) throws IOException {
        new RedirectingInputStream(new DigestInputStream(in, digest), false, true).redirectAll(new NullOutputStream());
        return digest.digest();
    }

    public static byte[] calculateSHADigest(InputStream in) throws IOException {
        return DigestUtils.calculateDigest(in, DigestUtils.getSHADigest());
    }

    public static byte[] calculateMD5Digest(InputStream in) throws IOException {
        return DigestUtils.calculateDigest(in, DigestUtils.getMD5Digest());
    }
}

