/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.security.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public final class SecureByteArrayOutputStream
extends ByteArrayOutputStream {
    public SecureByteArrayOutputStream() {
    }

    public SecureByteArrayOutputStream(int size) {
        super(size);
    }

    public synchronized void write(int b) {
        byte[] buf = this.buf;
        super.write(b);
        if (buf != this.buf) {
            Arrays.fill(buf, (byte)0);
        }
    }

    public synchronized void write(byte[] b, int off, int len) {
        byte[] buf = this.buf;
        super.write(b, off, len);
        if (buf != this.buf) {
            Arrays.fill(buf, (byte)0);
        }
    }

    public synchronized void reset() {
        this.count = 0;
        Arrays.fill(this.buf, (byte)0);
    }

    public void close() throws IOException {
        this.reset();
    }
}

