/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import org.apache.commons.httpclient.Header;

public class HeaderGroup {
    private List headers = new ArrayList();

    public void clear() {
        this.headers.clear();
    }

    public void addHeader(Header header) {
        this.headers.add((Object)header);
    }

    public void removeHeader(Header header) {
        this.headers.remove((Object)header);
    }

    public void setHeaders(Header[] headers) {
        this.clear();
        int i = 0;
        while (i < headers.length) {
            this.addHeader(headers[i]);
            ++i;
        }
    }

    public Header getCondensedHeader(String name) {
        Header[] headers = this.getHeaders(name);
        if (headers.length == 0) {
            return null;
        }
        if (headers.length == 1) {
            return new Header(headers[0].getName(), headers[0].getValue());
        }
        StringBuffer valueBuffer = new StringBuffer(headers[0].getValue());
        int i = 1;
        while (i < headers.length) {
            valueBuffer.append(", ");
            valueBuffer.append(headers[i].getValue());
            ++i;
        }
        return new Header(name.toLowerCase(), valueBuffer.toString());
    }

    public Header[] getHeaders(String name) {
        ArrayList headersFound = new ArrayList();
        Iterator headerIter = this.headers.iterator();
        while (headerIter.hasNext()) {
            Header header = (Header)headerIter.next();
            if (!header.getName().equalsIgnoreCase(name)) continue;
            headersFound.add((Object)header);
        }
        return (Header[])headersFound.toArray((Object[])new Header[headersFound.size()]);
    }

    public Header getFirstHeader(String name) {
        Iterator headerIter = this.headers.iterator();
        while (headerIter.hasNext()) {
            Header header = (Header)headerIter.next();
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    public Header getLastHeader(String name) {
        int i = this.headers.size() - 1;
        while (i >= 0) {
            Header header = (Header)this.headers.get(i);
            if (header.getName().equalsIgnoreCase(name)) {
                return header;
            }
            --i;
        }
        return null;
    }

    public Header[] getAllHeaders() {
        return (Header[])this.headers.toArray((Object[])new Header[this.headers.size()]);
    }

    public boolean containsHeader(String name) {
        Iterator headerIter = this.headers.iterator();
        while (headerIter.hasNext()) {
            Header header = (Header)headerIter.next();
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

