/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util;

public class ArgvUtils {
    private ArgvUtils() {
    }

    public static String[] shift(String[] args) {
        return ArgvUtils.shift(args, 1);
    }

    public static String[] shift(String[] args, int n) {
        if (args.length == 0) {
            return args;
        }
        if (args.length <= n) {
            return new String[0];
        }
        String[] newArgs = new String[args.length - n];
        System.arraycopy(args, n, newArgs, 0, newArgs.length);
        return newArgs;
    }

    public static boolean isOption(String arg) {
        return arg.startsWith("-");
    }

    public static class OptionEntry {
        final String name;
        final String value;

        OptionEntry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            if (this.value == null) {
                throw new IllegalArgumentException("Missing value for option \"" + this.name + "\"");
            }
            return this.value;
        }

        public String getValue(String defaultVal) {
            return this.value != null ? this.value : defaultVal;
        }

        public void ensureNoValue() {
            if (this.value != null) {
                throw new IllegalArgumentException("Superfluous value for option \"" + this.name + "\"");
            }
        }

        public void unrecognized() {
            throw new IllegalArgumentException("Unrecognized option \"" + this.name + "\"");
        }

        public String toString() {
            return "option [name: \"" + this.name + "\", val: \"" + this.value + "\"]";
        }
    }

    public static class OptionIterator {
        final String[] args;
        int idx;
        int lookaheadIdx;
        OptionEntry lookahead;

        public OptionIterator(String[] args) {
            this.args = args;
            this.idx = 0;
            this.lookaheadIdx = 0;
            this.lookahead = this.lookahead();
        }

        public boolean hasNext() {
            return this.lookahead != null;
        }

        public OptionEntry next() {
            OptionEntry next = this.lookahead;
            this.idx = this.lookaheadIdx;
            this.lookahead = this.lookahead();
            return next;
        }

        public int getOffset() {
            return this.idx;
        }

        public String[] getRemainingArgs() {
            String[] remaining = new String[this.args.length - this.idx];
            System.arraycopy(this.args, this.idx, remaining, 0, this.args.length - this.idx);
            return remaining;
        }

        private OptionEntry lookahead() {
            int pos;
            String option;
            if (this.lookaheadIdx >= this.args.length || !ArgvUtils.isOption(this.args[this.lookaheadIdx])) {
                return null;
            }
            if ((option = this.args[this.lookaheadIdx++]).length() > 0 && option.charAt(0) == '-') {
                option = option.substring(1);
            }
            if (option.length() > 0 && option.charAt(0) == '-') {
                option = option.substring(1);
            }
            if ((pos = option.indexOf(61)) >= 0) {
                String name = option.substring(0, pos);
                String val = option.substring(pos + 1);
                return new OptionEntry(name, val);
            }
            String name = option;
            if (this.idx >= this.args.length || this.lookaheadIdx >= this.args.length || ArgvUtils.isOption(this.args[this.lookaheadIdx])) {
                return new OptionEntry(name, null);
            }
            return new OptionEntry(name, this.args[this.lookaheadIdx++]);
        }
    }
}

