/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.keys;

import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import org.logi.crypto.Crypto;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.keys.Key;
import org.logi.crypto.keys.KeyRecord;
import org.logi.crypto.keys.KeySource;

public class KeyRing
extends Crypto
implements KeySource {
    Hashtable keys = new Hashtable();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyRing parseCDS(String string) throws InvalidCDSException {
        KeyRing keyRing = new KeyRing();
        try {
            Object object;
            int n;
            StringReader stringReader = new StringReader(string);
            do {
                if ((object = Crypto.fromString(stringReader)) instanceof Key) {
                    keyRing.insert((Key)object);
                } else {
                    if (!(object instanceof KeyRecord)) throw new InvalidCDSException("Only descendants of Key or KeyRecord expected");
                    keyRing.insert((KeyRecord)object);
                }
                n = stringReader.read();
                while (Character.isWhitespace((char)n)) {
                    n = stringReader.read();
                }
                if (n == -1) return keyRing;
            } while (n == 44);
            throw new InvalidCDSException(", expected after " + object);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return keyRing;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("KeyRing(");
        Enumeration enumeration = this.keys.elements();
        if (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString());
        }
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(",");
            stringBuffer.append(enumeration.nextElement().toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void insert(Key key) {
        this.insert(new KeyRecord(key, "", "", ""));
    }

    public void insert(KeyRecord keyRecord) {
        this.keys.put(keyRecord.getKey().getFingerprint(), keyRecord);
    }

    public KeyRecord byFingerprint(Fingerprint fingerprint) {
        return (KeyRecord)this.keys.get(fingerprint);
    }
}

