/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Header;
import org.tritonus.sampled.file.MpegEncoding;
import org.tritonus.sampled.file.MpegFileFormatType;
import org.tritonus.sampled.file.TAudioFileFormat;
import org.tritonus.sampled.file.TAudioFileReader;

public class MpegAudioFileReader
extends TAudioFileReader {
    private static final boolean DEBUG = false;
    private static final int SYNC = -2097152;
    private static final AudioFormat.Encoding[][] sm_aEncodings = new AudioFormat.Encoding[][]{{MpegEncoding.MPEG2L1, MpegEncoding.MPEG2L2, MpegEncoding.MPEG2L3}, {MpegEncoding.MPEG1L1, MpegEncoding.MPEG1L2, MpegEncoding.MPEG1L3}, {MpegEncoding.MPEG2DOT5L1, MpegEncoding.MPEG2DOT5L2, MpegEncoding.MPEG2DOT5L3}};

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        int n = (int)file.length();
        return this.getAudioFileFormat(new BufferedInputStream(new FileInputStream(file)), null, n);
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(inputStream, null, -1);
    }

    private AudioFileFormat getAudioFileFormat(InputStream inputStream, byte[] byArray, int n) throws UnsupportedAudioFileException, IOException {
        int n2;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 4096);
        byte[] byArray2 = new byte[4];
        pushbackInputStream.read(byArray2);
        if (!(byArray2[0] == 73 | byArray2[0] == 105 && byArray2[1] == 67 | byArray2[1] == 99 && byArray2[2] == 89 | byArray2[2] == 121)) {
            if (byArray2[0] == 79 | byArray2[0] == 111 && byArray2[1] == 71 | byArray2[1] == 103 && byArray2[2] == 71 | byArray2[2] == 103) {
                throw new UnsupportedAudioFileException("Ogg stream found");
            }
            pushbackInputStream.unread(byArray2);
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        float f = -1.0f;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        AudioFormat.Encoding encoding = null;
        try {
            Bitstream bitstream = new Bitstream((InputStream)pushbackInputStream);
            Header header = bitstream.readFrame();
            n3 = header.version();
            n4 = header.layer();
            n5 = header.sample_frequency();
            n6 = header.mode();
            n12 = n6 == 3 ? 1 : 2;
            n7 = header.calculate_framesize();
            n9 = header.frequency();
            f = (float)(1.0 / (double)header.ms_per_frame() * 1000.0);
            if (n != -1) {
                n10 = header.max_number_of_frames(n);
            }
            n11 = Header.bitrates[n3][n4 - 1][header.bitrate_index()];
            n13 = header.getSyncHeader();
            encoding = sm_aEncodings[n3][n4 - 1];
            if (n != -1) {
                n14 = Math.round(header.total_ms(n));
            }
        }
        catch (Exception exception) {
            throw new UnsupportedAudioFileException("not a MPEG stream");
        }
        if (byArray != null) {
            byArray[3] = (byte)(n13 & 0xFF);
            byArray[2] = (byte)(n13 >> 8 & 0xFF);
            byArray[1] = (byte)(n13 >> 16 & 0xFF);
            byArray[0] = (byte)(n13 >> 24 & 0xFF);
        }
        if ((n2 = n13 >> 19 & 3) == 1) {
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong version");
        }
        int n15 = n13 >> 10 & 3;
        if (n15 == 3) {
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong sampling rate");
        }
        AudioFormat audioFormat = new AudioFormat(encoding, n9, -1, n12, -1, -1.0f, true);
        return new TAudioFileFormat((AudioFileFormat.Type)new MpegFileFormatType(MpegFileFormatType.MP3 + "x" + n11 + "x" + n14, "mp3"), audioFormat, n10, n);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(4096);
        byte[] byArray = new byte[4];
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(bufferedInputStream, byArray, -1);
        try {
            bufferedInputStream.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new AudioInputStream(bufferedInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }
}

