/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import java.util.Timer;
import java.util.TimerTask;

public class AlarmClock {
    final Timer engine;
    final Runnable task;
    TimerTask timerTask;

    public AlarmClock(Timer engine, Runnable task) {
        this.engine = engine;
        this.task = task;
    }

    public synchronized void setAlarmDelayIfSooner(long delay) {
        long oldDelay;
        if (delay < 0L) {
            return;
        }
        if (this.timerTask != null && delay >= (oldDelay = this.timerTask.scheduledExecutionTime() - System.currentTimeMillis())) {
            return;
        }
        this.setAlarmDelay(delay);
    }

    public synchronized boolean setAlarmDelay(long delay) {
        if (this.timerTask != null && !this.cancel()) {
            return false;
        }
        this.timerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AlarmClock.this.task.run();
                AlarmClock alarmClock = AlarmClock.this;
                synchronized (alarmClock) {
                    AlarmClock.this.timerTask = null;
                }
            }
        };
        this.engine.schedule(this.timerTask, delay);
        return true;
    }

    public synchronized boolean cancel() {
        if (this.timerTask != null) {
            boolean result = this.timerTask.cancel();
            this.timerTask = null;
            return result;
        }
        return false;
    }
}

