/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Collection;
import java.util.Iterator;

public class DynamicArrayBlockingQueue
extends AbstractQueue
implements BlockingQueue {
    Object[] buf;
    int beg;
    int end;
    int length;
    int maxcap;

    public DynamicArrayBlockingQueue() {
        this(16);
    }

    public DynamicArrayBlockingQueue(int initcap) {
        this(initcap, 0);
    }

    public DynamicArrayBlockingQueue(int initcap, int maxcap) {
        if (initcap <= 0) {
            throw new IllegalArgumentException("Invalid initial capacity: " + initcap);
        }
        if (maxcap > 0 && maxcap < initcap) {
            throw new IllegalArgumentException("Invalid max capacity: " + maxcap);
        }
        this.buf = new Object[initcap];
        this.length = 0;
        this.end = 0;
        this.beg = 0;
        this.maxcap = maxcap;
    }

    public synchronized int size() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remainingCapacity() {
        if (this.maxcap <= 0) {
            return Integer.MAX_VALUE;
        }
        DynamicArrayBlockingQueue dynamicArrayBlockingQueue = this;
        synchronized (dynamicArrayBlockingQueue) {
            return this.maxcap - this.length;
        }
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean offer(Object o) {
        if (this.beg == this.end && this.length > 0 && !this.enlargeForPut()) {
            return false;
        }
        this.put0(o);
        return true;
    }

    public synchronized boolean offer(Object o, long timeout, TimeUnit granularity) throws InterruptedException {
        if (this.full() && !this.enlargeForPut()) {
            if (timeout == 0L) {
                return false;
            }
            long msecs = granularity.convert(timeout, TimeUnit.MILLISECONDS);
            long startTime = msecs >= 0L ? System.currentTimeMillis() : 0L;
            long waitTime = msecs;
            while (this.length >= this.maxcap) {
                if (startTime > 0L) {
                    if (waitTime <= 0L) {
                        return false;
                    }
                    this.wait(waitTime);
                    waitTime = msecs - (System.currentTimeMillis() - startTime);
                    continue;
                }
                this.wait();
            }
        }
        this.put0(o);
        return true;
    }

    public synchronized void put(Object o) throws InterruptedException {
        if (this.full() && !this.enlargeForPut()) {
            while (this.length >= this.maxcap) {
                this.wait();
            }
        }
        this.put0(o);
    }

    public synchronized boolean offerAtHead(Object o) {
        if (this.full() && !this.enlargeForPutAtHead()) {
            return false;
        }
        this.putAtHead0(o);
        return true;
    }

    public synchronized void putAtHead(Object o) throws InterruptedException {
        if (this.full() && !this.enlargeForPutAtHead()) {
            while (this.length >= this.maxcap) {
                this.wait();
            }
        }
        this.putAtHead0(o);
    }

    public synchronized boolean offerAtHead(Object o, int timeout, TimeUnit granularity) throws InterruptedException {
        if (this.full() && !this.enlargeForPutAtHead()) {
            if (timeout == 0) {
                return false;
            }
            long msecs = granularity.convert(timeout, TimeUnit.MILLISECONDS);
            long startTime = msecs >= 0L ? System.currentTimeMillis() : 0L;
            long waitTime = msecs;
            while (this.length >= this.maxcap) {
                if (startTime > 0L) {
                    if (waitTime <= 0L) {
                        return false;
                    }
                    this.wait(waitTime);
                    waitTime = msecs - (System.currentTimeMillis() - startTime);
                    continue;
                }
                this.wait();
            }
        }
        this.putAtHead0(o);
        return true;
    }

    public synchronized Object take() throws InterruptedException {
        while (this.length <= 0) {
            this.wait();
        }
        return this.take0();
    }

    public synchronized Object poll(long timeout, TimeUnit granularity) throws InterruptedException {
        if (this.length <= 0) {
            if (timeout == 0L) {
                return null;
            }
            long msecs = granularity.convert(timeout, TimeUnit.MILLISECONDS);
            long startTime = msecs >= 0L ? System.currentTimeMillis() : 0L;
            long waitTime = msecs;
            do {
                if (startTime > 0L) {
                    if (waitTime <= 0L) {
                        return null;
                    }
                    this.wait(waitTime);
                    waitTime = msecs - (System.currentTimeMillis() - startTime);
                    continue;
                }
                this.wait();
            } while (this.length <= 0);
        }
        return this.take0();
    }

    public Object peek() {
        if (this.length <= 0) {
            return null;
        }
        return this.peek0();
    }

    public synchronized Object poll() {
        if (this.length <= 0) {
            return null;
        }
        return this.take0();
    }

    private Object take0() {
        Object ret = this.buf[this.beg];
        this.buf[this.beg] = null;
        ++this.beg;
        if (this.beg >= this.buf.length) {
            this.beg = 0;
        }
        --this.length;
        this.notifyAll();
        return ret;
    }

    private Object peek0() {
        return this.buf[this.beg];
    }

    private void put0(Object o) {
        this.buf[this.end++] = o;
        if (this.end >= this.buf.length) {
            this.end = 0;
        }
        ++this.length;
        this.notifyAll();
    }

    private void putAtHead0(Object o) {
        --this.beg;
        if (this.beg < 0) {
            this.beg = this.buf.length - 1;
        }
        this.buf[this.beg] = o;
        ++this.length;
        this.notifyAll();
    }

    private boolean enlargeForPut() {
        if (this.maxcap <= 0 || this.length < this.maxcap) {
            int newcap = this.maxcap <= 0 ? this.length * 2 : Math.min(this.maxcap, this.length * 2);
            Object[] newbuf = new Object[newcap];
            System.arraycopy(this.buf, this.beg, newbuf, 0, this.length - this.beg);
            System.arraycopy(this.buf, 0, newbuf, this.length - this.beg, this.end);
            this.buf = newbuf;
            this.beg = 0;
            this.end = this.length;
            return true;
        }
        return false;
    }

    private boolean enlargeForPutAtHead() {
        if (this.maxcap <= 0 || this.length < this.maxcap) {
            int newcap = this.maxcap <= 0 ? this.length * 2 : Math.min(this.maxcap, this.length * 2);
            Object[] newbuf = new Object[newcap];
            System.arraycopy(this.buf, this.beg, newbuf, 1, this.length - this.beg);
            System.arraycopy(this.buf, 0, newbuf, this.beg + 1, this.end);
            this.buf = newbuf;
            this.beg = 1;
            this.end = this.length + 1;
            return true;
        }
        return false;
    }

    private boolean full() {
        return this.beg == this.end && this.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int drained = 0;
        DynamicArrayBlockingQueue dynamicArrayBlockingQueue = this;
        synchronized (dynamicArrayBlockingQueue) {
            while (this.length > 0) {
                c.add(this.take0());
                ++drained;
            }
        }
        return drained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c, int maxElements) {
        int drained;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        DynamicArrayBlockingQueue dynamicArrayBlockingQueue = this;
        synchronized (dynamicArrayBlockingQueue) {
            for (drained = 0; drained < maxElements && this.length > 0; ++drained) {
                c.add(this.take0());
            }
        }
        return drained;
    }
}

