/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.util.concurrent.DelegatableThreadLocal;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Map;

public class ThreadContext {
    final ClassLoader ccl;
    final int priority;
    final Map delegThreadLocals;
    int hash = 0;

    private ThreadContext(ClassLoader ccl, int priority, Map delegThreadLocals) {
        this.ccl = ccl;
        this.priority = priority;
        this.delegThreadLocals = delegThreadLocals;
    }

    public static ThreadContext getContext() {
        final Thread current = Thread.currentThread();
        ClassLoader ccl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return current.getContextClassLoader();
            }
        });
        int priority = current.getPriority();
        Map delegThreadLocals = DelegatableThreadLocal.takeSnapshot();
        return new ThreadContext(ccl, priority, delegThreadLocals);
    }

    public static ThreadContext create(ClassLoader ccl, int priority) {
        return new ThreadContext(ccl, priority, Collections.EMPTY_MAP);
    }

    public static ThreadContext create(ClassLoader ccl) {
        return ThreadContext.create(ccl, 5);
    }

    public void perform(final Runnable task) {
        this.perform(new PrivilegedAction(){

            public Object run() {
                task.run();
                return null;
            }
        });
    }

    public Object perform(final Callable call) throws Exception {
        try {
            return this.perform(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return call.call();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    public Object perform(final PrivilegedAction action) {
        final Thread current = Thread.currentThread();
        final AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object run() {
                Throwable throwable3;
                Object t;
                ClassLoader savedCcl = current.getContextClassLoader();
                int savedPriority = current.getPriority();
                if (ThreadContext.this.ccl != savedCcl) {
                    current.setContextClassLoader(ThreadContext.this.ccl);
                }
                if (ThreadContext.this.priority < savedPriority) {
                    current.setPriority(ThreadContext.this.priority);
                }
                Map savedDtl = DelegatableThreadLocal.delegate(ThreadContext.this.delegThreadLocals);
                try {
                    t = AccessController.doPrivileged(action, acc);
                }
                catch (Throwable throwable2) {
                    try {
                        DelegatableThreadLocal.restore(savedDtl);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Object var7_6 = null;
                        if (ThreadContext.this.ccl != savedCcl) {
                            current.setContextClassLoader(savedCcl);
                        }
                        if (ThreadContext.this.priority >= savedPriority) throw throwable3;
                        current.setPriority(savedPriority);
                    }
                }
                DelegatableThreadLocal.restore(savedDtl);
                Object var7_5 = null;
                if (ThreadContext.this.ccl != savedCcl) {
                    current.setContextClassLoader(savedCcl);
                }
                if (ThreadContext.this.priority >= savedPriority) return t;
                current.setPriority(savedPriority);
                return t;
                throw throwable3;
            }
        });
    }

    public Object perform(final PrivilegedExceptionAction action) throws PrivilegedActionException {
        final Thread current = Thread.currentThread();
        final AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedExceptionAction(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() throws Exception {
                ClassLoader savedCcl = current.getContextClassLoader();
                int savedPriority = current.getPriority();
                try {
                    if (ThreadContext.this.ccl != savedCcl) {
                        current.setContextClassLoader(ThreadContext.this.ccl);
                    }
                    if (ThreadContext.this.priority < savedPriority) {
                        current.setPriority(ThreadContext.this.priority);
                    }
                    Map savedDtl = DelegatableThreadLocal.delegate(ThreadContext.this.delegThreadLocals);
                    try {
                        Object t = AccessController.doPrivileged(action, acc);
                        return t;
                    }
                    catch (PrivilegedActionException pae) {
                        throw pae.getException();
                    }
                    finally {
                        DelegatableThreadLocal.restore(savedDtl);
                    }
                }
                catch (Throwable throwable2) {
                    Object var7_7 = null;
                    if (ThreadContext.this.ccl != savedCcl) {
                        current.setContextClassLoader(savedCcl);
                    }
                    if (ThreadContext.this.priority >= savedPriority) throw throwable2;
                    current.setPriority(savedPriority);
                    throw throwable2;
                }
            }
        });
    }

    public PrivilegedAction wrap(final PrivilegedAction action) {
        return new PrivilegedAction(){

            public Object run() {
                return ThreadContext.this.perform(action);
            }
        };
    }

    public PrivilegedExceptionAction wrap(final PrivilegedExceptionAction action) {
        return new PrivilegedExceptionAction(){

            public Object run() throws PrivilegedActionException {
                return ThreadContext.this.perform(action);
            }
        };
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.priority + ((this.ccl != null ? this.ccl.hashCode() : 1) ^ ((Object)this.delegThreadLocals).hashCode());
        return this.hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ThreadContext)) {
            return false;
        }
        ThreadContext that = (ThreadContext)other;
        return this.priority == that.priority && (this.ccl == null ? that.ccl == null : this.ccl.equals(that.ccl)) && ((Object)this.delegThreadLocals).equals(that.delegThreadLocals);
    }
}

