/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.util.concurrent.AsyncTask;
import edu.emory.mathcs.util.concurrent.Callback;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;

public class ThreadUtils {
    private static Method stopThreadMethod;
    private static Method suspendThreadMethod;
    private static Method resumeThreadMethod;
    private static ThreadGroup prvTGroup;

    private ThreadUtils() {
    }

    public static ThreadGroup getTopLevelThreadGroup() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        return tg;
    }

    public static void stopThread(Thread t) {
        ThreadUtils.stopThread(t, new ThreadDeath());
    }

    public static void stopThread(Thread t, ThreadDeath cause) {
        try {
            ThreadUtils.stopThread(t, 0L, cause);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean isTerminated(Thread thread) {
        if (thread.isAlive()) {
            return false;
        }
        ThreadGroup tg = thread.getThreadGroup();
        return tg == null;
    }

    public static boolean stopThread(Thread t, long timeout, ThreadDeath cause) throws InterruptedException {
        if (stopThreadMethod != null) {
            try {
                try {
                    t.start();
                }
                catch (Exception e) {
                    // empty catch block
                }
                stopThreadMethod.invoke((Object)t, cause);
                t.interrupt();
                if (timeout == 0L) {
                    return t.isAlive();
                }
                if (timeout > 0L) {
                    t.join(timeout);
                } else {
                    t.join();
                }
                return t.isAlive();
            }
            catch (InvocationTargetException e) {
                Throwable e1 = e.getTargetException();
                if (e1 instanceof Error) {
                    throw (Error)e1;
                }
                if (e1 instanceof RuntimeException) {
                    throw (RuntimeException)e1;
                }
                throw new InternalError(e1.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e.getMessage());
            }
        }
        return false;
    }

    public static boolean suspendThread(Thread t) {
        if (suspendThreadMethod != null) {
            try {
                suspendThreadMethod.invoke((Object)t, null);
                return true;
            }
            catch (InvocationTargetException e) {
                Throwable e1 = e.getTargetException();
                if (e1 instanceof Error) {
                    throw (Error)e1;
                }
                if (e1 instanceof RuntimeException) {
                    throw (RuntimeException)e1;
                }
                throw new InternalError(e1.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e.getMessage());
            }
        }
        return false;
    }

    public static void resumeThread(Thread t) {
        if (resumeThreadMethod != null) {
            try {
                resumeThreadMethod.invoke((Object)t, null);
            }
            catch (InvocationTargetException e) {
                throw new InternalError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e.getMessage());
            }
        }
    }

    public static boolean destroyThreadGroup(ThreadGroup tg, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        return ThreadUtils.sync(ThreadUtils.asyncDestroyThreadGroup(tg, null), timeout);
    }

    public static Future asyncDestroyThreadGroup(ThreadGroup tg, Callback cb) {
        return ThreadUtils.asyncDestroyThreadGroup(tg, cb, new ThreadDeath());
    }

    public static boolean destroyThreadGroup(ThreadGroup tg, long timeout, ThreadDeath cause) throws InterruptedException, ExecutionException, TimeoutException {
        return ThreadUtils.sync(ThreadUtils.asyncDestroyThreadGroup(tg, null, null, cause), timeout);
    }

    public static Future asyncDestroyThreadGroup(ThreadGroup tg, Callback cb, ThreadDeath cause) {
        return Executioner.doOp(1, tg, null, cause, cb);
    }

    public static boolean destroyThreadGroup(ThreadGroup tg, long timeout, boolean suicide, ThreadDeath cause) throws InterruptedException, ExecutionException, TimeoutException {
        return ThreadUtils.sync(ThreadUtils.asyncDestroyThreadGroup(tg, suicide, null, cause), timeout);
    }

    public static Future asyncDestroyThreadGroup(ThreadGroup tg, boolean suicide, Callback cb, ThreadDeath cause) {
        Thread[] threadArray;
        if (suicide) {
            threadArray = null;
        } else {
            Thread[] threadArray2 = new Thread[1];
            threadArray = threadArray2;
            threadArray2[0] = Thread.currentThread();
        }
        return Executioner.doOp(1, tg, threadArray, cause, cb);
    }

    public static boolean destroyThreadGroup(ThreadGroup tg, long timeout, Thread[] waitFor, ThreadDeath cause) throws InterruptedException, ExecutionException, TimeoutException {
        return ThreadUtils.sync(ThreadUtils.asyncDestroyThreadGroup(tg, waitFor, null, cause), timeout);
    }

    public static Future asyncDestroyThreadGroup(ThreadGroup tg, Thread[] waitFor, Callback cb, ThreadDeath cause) {
        return Executioner.doOp(1, tg, waitFor, cause, cb);
    }

    public static boolean stopThreadGroup(ThreadGroup tg, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        return ThreadUtils.sync(ThreadUtils.asyncStopThreadGroup(tg, null), timeout);
    }

    public static Future asyncStopThreadGroup(ThreadGroup tg, Callback cb) {
        return ThreadUtils.asyncStopThreadGroup(tg, true, cb, new ThreadDeath());
    }

    public static boolean stopThreadGroup(ThreadGroup tg, long timeout, boolean suicide, ThreadDeath cause) throws InterruptedException, ExecutionException, TimeoutException {
        return ThreadUtils.sync(ThreadUtils.asyncStopThreadGroup(tg, suicide, null, cause), timeout);
    }

    public static Future asyncStopThreadGroup(ThreadGroup tg, boolean suicide, Callback cb, ThreadDeath cause) {
        Thread[] threadArray;
        if (suicide) {
            threadArray = null;
        } else {
            Thread[] threadArray2 = new Thread[1];
            threadArray = threadArray2;
            threadArray2[0] = Thread.currentThread();
        }
        return ThreadUtils.asyncStopThreadGroup(tg, threadArray, cb, cause);
    }

    public static boolean stopThreadGroup(ThreadGroup tg, long timeout, Thread[] exclude, ThreadDeath cause) throws InterruptedException, ExecutionException, TimeoutException {
        return ThreadUtils.sync(ThreadUtils.asyncStopThreadGroup(tg, exclude, null, cause), timeout);
    }

    public static Future asyncStopThreadGroup(ThreadGroup tg, Thread[] exclude, Callback cb, ThreadDeath cause) {
        return Executioner.doOp(2, tg, exclude, cause, cb);
    }

    public static boolean suspendThreadGroup(ThreadGroup tg, long timeout, boolean suicide) throws InterruptedException, ExecutionException, TimeoutException {
        return ThreadUtils.sync(ThreadUtils.asyncSuspendThreadGroup(tg, suicide, null), timeout);
    }

    public static Future asyncSuspendThreadGroup(ThreadGroup tg, boolean suicide, Callback cb) {
        Thread[] threadArray;
        if (suicide) {
            threadArray = null;
        } else {
            Thread[] threadArray2 = new Thread[1];
            threadArray = threadArray2;
            threadArray2[0] = Thread.currentThread();
        }
        return ThreadUtils.asyncSuspendThreadGroup(tg, threadArray, cb);
    }

    public static boolean suspendThreadGroup(ThreadGroup tg, long timeout, Thread[] exclude) throws InterruptedException, ExecutionException, TimeoutException {
        return ThreadUtils.sync(ThreadUtils.asyncSuspendThreadGroup(tg, exclude, null), timeout);
    }

    public static Future asyncSuspendThreadGroup(ThreadGroup tg, Thread[] exclude, Callback cb) {
        return Executioner.doOp(3, tg, exclude, null, cb);
    }

    public static boolean resumeThreadGroup(ThreadGroup tg, long timeout, Thread[] exclude) throws InterruptedException, ExecutionException, TimeoutException {
        return ThreadUtils.sync(ThreadUtils.asyncResumeThreadGroup(tg, exclude, null), timeout);
    }

    public static Future asyncResumeThreadGroup(ThreadGroup tg, Thread[] exclude, Callback cb) {
        return Executioner.doOp(4, tg, exclude, null, cb);
    }

    private static boolean sync(Future future, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        if (timeout < 0L) {
            future.get();
        } else {
            future.get(timeout, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    static {
        prvTGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ThreadGroup(ThreadUtils.getTopLevelThreadGroup(), "_thread-utils");
            }
        });
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        try {
            Class<?> threadCls = Class.forName("java.lang.Thread", true, cl);
            try {
                stopThreadMethod = threadCls.getMethod("stop", Throwable.class);
                suspendThreadMethod = threadCls.getMethod("suspend", null);
                resumeThreadMethod = threadCls.getMethod("resume", null);
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e.getMessage());
            }
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e.getMessage());
        }
    }

    private static class Executioner
    extends Thread
    implements Callable {
        static final int DESTROY = 1;
        static final int STOP = 2;
        static final int SUSPEND = 3;
        static final int RESUME = 4;
        final ThreadGroup tg;
        final int op;
        final Thread[] exclude;
        volatile boolean done = false;
        final ThreadDeath cause;
        final Result result;
        private static Comparator threadComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                int h2;
                if (o1 == o2) {
                    return 0;
                }
                Thread t1 = (Thread)o1;
                Thread t2 = (Thread)o2;
                int h1 = t1.hashCode();
                if (h1 != (h2 = t2.hashCode())) {
                    return h2 - h1;
                }
                String s1 = t1.toString();
                String s2 = t2.toString();
                return s1.compareTo(s2);
            }
        };

        Executioner(ThreadGroup tg, int op, Thread[] exclude, ThreadDeath cause, Callback cb) {
            super(prvTGroup, "exec");
            this.tg = tg;
            this.op = op;
            this.setPriority(10);
            this.cause = cause;
            this.result = new Result(cb);
            if (exclude == null) {
                exclude = new Thread[]{};
            }
            ArrayList<Thread> excludeList = new ArrayList<Thread>(exclude.length);
            for (int i = 0; i < exclude.length; ++i) {
                ThreadGroup localTg;
                for (localTg = exclude[i].getThreadGroup(); localTg != null && localTg != tg; localTg = localTg.getParent()) {
                }
                if (localTg == null) continue;
                excludeList.add(exclude[i]);
            }
            exclude = excludeList.toArray(new Thread[excludeList.size()]);
            Arrays.sort(exclude, 0, exclude.length, threadComparator);
            this.exclude = exclude;
        }

        public static Future doOp(int doWhat, ThreadGroup tg, Thread[] exclude, ThreadDeath cause, Callback cb) {
            return (Future)AccessController.doPrivileged(new PrivilegedAction(tg, doWhat, exclude, cause, cb){
                private final /* synthetic */ ThreadGroup val$tg;
                private final /* synthetic */ int val$doWhat;
                private final /* synthetic */ Thread[] val$exclude;
                private final /* synthetic */ ThreadDeath val$cause;
                private final /* synthetic */ Callback val$cb;
                {
                    this.val$tg = val$tg;
                    this.val$doWhat = val$doWhat;
                    this.val$exclude = val$exclude;
                    this.val$cause = val$cause;
                    this.val$cb = val$cb;
                }

                public Object run() {
                    Executioner executioner = new Executioner(this.val$tg, this.val$doWhat, this.val$exclude, this.val$cause, this.val$cb);
                    return Executioner.access$100(executioner);
                }
            });
        }

        private Future exec() {
            this.start();
            return this.result;
        }

        public void run() {
            this.result.getPerformer(this).run();
        }

        public Object call() throws InterruptedException {
            switch (this.op) {
                case 3: 
                case 4: {
                    this.execTGOperation(this.tg, this.exclude, this.op);
                    return null;
                }
                case 2: {
                    while (true) {
                        this.execTGOperation(this.tg, this.exclude, this.op);
                        int nthreads = this.tg.activeCount();
                        if (nthreads == 0) {
                            return null;
                        }
                        if (nthreads <= this.exclude.length) {
                            Thread[] check = new Thread[nthreads];
                            nthreads = this.tg.enumerate(check, true);
                            for (int i = nthreads - 1; i >= 0; --i) {
                                if (Arrays.binarySearch(this.exclude, check[i], threadComparator) < 0) continue;
                                --nthreads;
                            }
                            if (nthreads == 0) {
                                return null;
                            }
                        }
                        Thread.yield();
                    }
                }
                case 1: {
                    int nthreads;
                    do {
                        this.execTGOperation(this.tg, this.exclude, this.op);
                        nthreads = this.tg.activeCount();
                        if (nthreads > 0 && nthreads <= this.exclude.length) {
                            Thread[] check = new Thread[nthreads];
                            nthreads = this.tg.enumerate(check, true);
                            for (int i = nthreads - 1; i >= 0; --i) {
                                if (Arrays.binarySearch(this.exclude, check[i], threadComparator) < 0) continue;
                                check[i].join();
                                --nthreads;
                            }
                        }
                        if (this.tg.activeCount() != 0) continue;
                        this.tg.destroy();
                    } while (nthreads != 0);
                    return null;
                }
            }
            throw new RuntimeException();
        }

        private void execTGOperation(ThreadGroup tg, Thread[] exclude, int op) throws InterruptedException {
            boolean all;
            int nthreads = tg.activeCount();
            Thread[] threads = new Thread[nthreads];
            HashSet<Thread> processed = new HashSet<Thread>(nthreads * 2);
            do {
                if (Executioner.interrupted()) {
                    throw new InterruptedException();
                }
                all = true;
                int active = tg.enumerate(threads, true);
                for (int i = 0; i < active; ++i) {
                    Thread t = threads[i];
                    if (processed.contains(t) || Arrays.binarySearch(exclude, t, threadComparator) >= 0) continue;
                    switch (op) {
                        case 1: 
                        case 2: {
                            ThreadUtils.stopThread(threads[i], this.cause);
                            break;
                        }
                        case 3: {
                            ThreadUtils.suspendThread(threads[i]);
                            break;
                        }
                        case 4: {
                            ThreadUtils.resumeThread(threads[i]);
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    processed.add(t);
                    all = false;
                }
            } while (!all);
        }

        static /* synthetic */ Future access$100(Executioner x0) {
            return x0.exec();
        }

        private static class Result
        extends AsyncTask {
            Result(Callback cb) {
                super(cb);
            }

            protected Runnable getPerformer(Callable call) {
                return super.createPerformer(call, true);
            }

            protected void setFailed(Throwable cause) {
                super.setFailed(cause);
            }
        }
    }
}

