/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.kbinani.BEvent;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.Base64;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;
import org.kbinani.ValuePair;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AmplifyCoefficient;
import org.kbinani.cadencii.AttachedCurve;
import org.kbinani.cadencii.BezierChain;
import org.kbinani.cadencii.BgmFile;
import org.kbinani.cadencii.CadenciiCommand;
import org.kbinani.cadencii.CadenciiCommandType;
import org.kbinani.cadencii.ClipboardEntry;
import org.kbinani.cadencii.CurveType;
import org.kbinani.cadencii.DrawObject;
import org.kbinani.cadencii.EditMode;
import org.kbinani.cadencii.EditTool;
import org.kbinani.cadencii.EditorConfig;
import org.kbinani.cadencii.FormCompileResult;
import org.kbinani.cadencii.FormIconPalette;
import org.kbinani.cadencii.FormMain;
import org.kbinani.cadencii.FormMixer;
import org.kbinani.cadencii.ICommand;
import org.kbinani.cadencii.OtoArgs;
import org.kbinani.cadencii.PlayPositionSpecifier;
import org.kbinani.cadencii.PlaySound;
import org.kbinani.cadencii.QuantizeModeUtil;
import org.kbinani.cadencii.RenderedStatus;
import org.kbinani.cadencii.ScreenStatus;
import org.kbinani.cadencii.SelectedBezierPoint;
import org.kbinani.cadencii.SelectedEventChangedEventHandler;
import org.kbinani.cadencii.SelectedEventEntry;
import org.kbinani.cadencii.SelectedRegion;
import org.kbinani.cadencii.SelectedTempoEntry;
import org.kbinani.cadencii.SelectedTimesigEntry;
import org.kbinani.cadencii.TextBoxEx;
import org.kbinani.cadencii.UtauVoiceDB;
import org.kbinani.cadencii.Utility;
import org.kbinani.cadencii.VSTiProxy;
import org.kbinani.cadencii.VibratoLengthEditingRule;
import org.kbinani.cadencii.VsqFileEx;
import org.kbinani.vsq.IconHandle;
import org.kbinani.vsq.SingerConfig;
import org.kbinani.vsq.SymbolTable;
import org.kbinani.vsq.TempoTableEntry;
import org.kbinani.vsq.TimeSigTableEntry;
import org.kbinani.vsq.Timesig;
import org.kbinani.vsq.UstEvent;
import org.kbinani.vsq.VocaloSysUtil;
import org.kbinani.vsq.VsqBPList;
import org.kbinani.vsq.VsqCommandType;
import org.kbinani.vsq.VsqEvent;
import org.kbinani.vsq.VsqID;
import org.kbinani.vsq.VsqIDType;
import org.kbinani.vsq.VsqPhoneticSymbol;
import org.kbinani.vsq.VsqTrack;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BKeys;
import org.kbinani.windows.forms.BTimer;
import org.kbinani.xml.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppManager {
    public static final int MIN_KEY_WIDTH = 68;
    public static final int MAX_KEY_WIDTH = 340;
    private static final String CONFIG_FILE_NAME = "config.xml";
    private static final String CLIP_PREFIX = "CADENCIIOBJ";
    public static final int DYNAFF_ITEM_WIDTH = 40;
    public static final int FONT_SIZE8 = 14;
    public static final int FONT_SIZE9 = 15;
    public static final int FONT_SIZE10 = 16;
    public static final int FONT_SIZE50 = 56;
    public static int keyWidth = 136;
    public static final int keyOffset = 6;
    public static EditorConfig editorConfig = new EditorConfig();
    public static XmlSerializer xmlSerializerListBezierCurves = new XmlSerializer(AttachedCurve.class);
    public static Font superFont8 = new Font("Dialog", 0, 14);
    public static Font superFont9 = new Font("Dialog", 0, 15);
    public static Font superFont10 = new Font("Dialog", 0, 16);
    public static Font superFont10Bold = new Font("Dialog", 1, 16);
    public static Font superFont50Bold = new Font("Dialog", 1, 56);
    public static int superFont10OffsetHeight = 0;
    public static int superFont8OffsetHeight = 0;
    public static int superFont9OffsetHeight = 0;
    public static int superFont50OffsetHeight = 0;
    public static int superFont8Height = 14;
    public static int superFont9Height = 15;
    public static int superFont10Height = 16;
    public static int superFont50Height = 56;
    public static FormIconPalette iconPalette = null;
    public static final Color[] HILIGHT = new Color[]{new Color(181, 220, 16), new Color(231, 244, 49), new Color(252, 230, 29), new Color(247, 171, 20), new Color(249, 94, 17), new Color(234, 27, 47), new Color(175, 20, 80), new Color(183, 24, 149), new Color(105, 22, 158), new Color(22, 36, 163), new Color(37, 121, 204), new Color(29, 179, 219), new Color(24, 239, 239), new Color(25, 206, 175), new Color(23, 160, 134), new Color(79, 181, 21)};
    public static final Color[] RENDER = new Color[]{new Color(19, 143, 52), new Color(158, 154, 18), new Color(160, 143, 23), new Color(145, 98, 15), new Color(142, 52, 12), new Color(142, 19, 37), new Color(96, 13, 47), new Color(117, 17, 98), new Color(62, 15, 99), new Color(13, 23, 84), new Color(25, 84, 132), new Color(20, 119, 142), new Color(19, 142, 139), new Color(17, 122, 102), new Color(13, 86, 72), new Color(43, 91, 12)};
    public static final String[] USINGS = new String[]{"using System;", "using System.IO;", "using org.kbinani.vsq;", "using org.kbinani.cadencii;", "using org.kbinani;", "using org.kbinani.java.io;", "using org.kbinani.java.util;", "using org.kbinani.java.awt;", "using org.kbinani.media;", "using org.kbinani.apputil;", "using System.Windows.Forms;", "using System.Collections.Generic;", "using System.Drawing;", "using System.Text;", "using System.Xml.Serialization;"};
    public static final Vector<BKeys> SHORTCUT_ACCEPTABLE = new Vector<BKeys>(Arrays.asList(BKeys.A, BKeys.B, BKeys.C, BKeys.D, BKeys.D0, BKeys.D1, BKeys.D2, BKeys.D3, BKeys.D4, BKeys.D5, BKeys.D6, BKeys.D7, BKeys.D8, BKeys.D9, BKeys.Down, BKeys.E, BKeys.F, BKeys.F1, BKeys.F2, BKeys.F3, BKeys.F4, BKeys.F5, BKeys.F6, BKeys.F7, BKeys.F8, BKeys.F9, BKeys.F10, BKeys.F11, BKeys.F12, BKeys.F13, BKeys.F14, BKeys.F15, BKeys.F16, BKeys.F17, BKeys.F18, BKeys.F19, BKeys.F20, BKeys.F21, BKeys.F22, BKeys.F23, BKeys.F24, BKeys.G, BKeys.H, BKeys.I, BKeys.J, BKeys.K, BKeys.L, BKeys.Left, BKeys.M, BKeys.N, BKeys.NumPad0, BKeys.NumPad1, BKeys.NumPad2, BKeys.NumPad3, BKeys.NumPad4, BKeys.NumPad5, BKeys.NumPad6, BKeys.NumPad7, BKeys.NumPad8, BKeys.NumPad9, BKeys.O, BKeys.P, BKeys.PageDown, BKeys.PageUp, BKeys.Q, BKeys.R, BKeys.Right, BKeys.S, BKeys.Space, BKeys.T, BKeys.U, BKeys.Up, BKeys.V, BKeys.W, BKeys.X, BKeys.Y, BKeys.Z, BKeys.Delete, BKeys.Home, BKeys.End));
    private static int s_super_tempo = 480000;
    private static Color s_hilight_brush = PortUtil.CornflowerBlue;
    private static Object s_locker;
    private static BTimer s_auto_backup_timer;
    private static VsqFileEx s_vsq;
    private static String s_file;
    private static int s_selected;
    private static int s_current_clock;
    private static boolean s_playing;
    private static boolean s_repeat_mode;
    private static boolean s_grid_visible;
    private static EditMode s_edit_mode;
    private static boolean s_overlay;
    private static Vector<SelectedEventEntry> s_selected_events;
    private static TreeMap<Integer, SelectedTempoEntry> s_selected_tempo;
    private static int s_last_selected_tempo;
    private static TreeMap<Integer, SelectedTimesigEntry> s_selected_timesig;
    private static int s_last_selected_timesig;
    private static EditTool s_selected_tool;
    private static Vector<ICommand> s_commands;
    private static int s_command_position;
    private static Vector<SelectedBezierPoint> s_selected_bezier;
    private static SelectedBezierPoint s_last_selected_bezier;
    private static PlayPositionSpecifier s_current_play_position;
    private static CurveType selectedPointCurveType;
    private static Vector<Long> selectedPointIDs;
    private static Object playingPropertyLocker;
    private static boolean wholeSelectedIntervalEnabled;
    public static SelectedRegion wholeSelectedInterval;
    public static Rectangle curveSelectingRectangle;
    public static SelectedRegion curveSelectedInterval;
    private static boolean curveSelectedIntervalEnabled;
    public static int wholeSelectedIntervalStartForMoving;
    public static boolean autoNormalize;
    public static int endMarker;
    public static boolean endMarkerEnabled;
    public static float scaleX;
    public static int startMarker;
    private static boolean s_is_curve_mode;
    public static boolean startMarkerEnabled;
    public static boolean autoScroll;
    public static boolean firstBufferWritten;
    public static boolean rendererAvailable;
    public static double previewStartedTime;
    public static int startToDrawX;
    public static String selectedPaletteTool;
    public static ScreenStatus lastScreenStatus;
    private static String s_id;
    public static FormMain mainWindow;
    public static FormMixer mixerWindow;
    public static Vector<Vector<DrawObject>> drawObjects;
    public static TextBoxEx inputTextBox;
    public static int addingEventLength;
    public static VsqEvent addingEvent;
    public static int[] drawStartIndex;
    public static boolean isPointerDowned;
    public static Point mouseDownLocation;
    public static int lastTrackSelectorHeight;
    public static TreeMap<String, UtauVoiceDB> utauVoiceDB;
    public static RenderedStatus[] lastRenderedStatus;
    public static XmlSerializer renderingStatusSerializer;
    private static String tempWaveDir;
    public static double forbidFlipPlayingThresholdSeconds;
    public static boolean curveOnPianoroll;
    public static TreeMap<Integer, Float> curveOnPianorollMouseTrace;
    public static boolean skipDrawingWaveformWhenPlaying;
    public static boolean drawItemBorderInControlCurveView;
    public static boolean drawCurveDotInControlCurveView;
    public static boolean drawOverSynthNameOnPianoroll;
    public static VibratoLengthEditingRule vibratoLengthEditingRule;
    public static boolean showContextMenuWhenRightClickedOnPianoroll;
    public static BEvent<BEventHandler> gridVisibleChangedEvent;
    public static BEvent<BEventHandler> previewStartedEvent;
    public static BEvent<BEventHandler> previewAbortedEvent;
    public static BEvent<SelectedEventChangedEventHandler> selectedEventChangedEvent;
    public static BEvent<BEventHandler> selectedToolChangedEvent;
    public static BEvent<BEventHandler> currentClockChangedEvent;
    private static final String TEMPDIR_NAME = "cadencii";

    public static void changePhrase(VsqFileEx vsqFileEx, int n, VsqEvent vsqEvent, int n2, String string) {
        ByRef<String> byRef = new ByRef<String>("");
        SymbolTable.attatch(string, byRef);
        String string2 = (String)byRef.value;
        String[] stringArray = PortUtil.splitString(string2, new char[]{' ', ','}, true);
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = string3 + (i == 0 ? "" : " ") + (VsqPhoneticSymbol.isConsonant(stringArray[i]) ? 64 : 0);
        }
        if (vsqFileEx != null) {
            VsqTrack vsqTrack = (VsqTrack)vsqFileEx.Track.get(n);
            VsqEvent vsqEvent2 = vsqTrack.getSingerEventAt(n2);
            SingerConfig singerConfig = AppManager.getSingerInfoUtau(vsqEvent2.ID.IconHandle.Language, vsqEvent2.ID.IconHandle.Program);
            if (singerConfig != null && utauVoiceDB.containsKey(singerConfig.VOICEIDSTR)) {
                UtauVoiceDB utauVoiceDB = AppManager.utauVoiceDB.get(singerConfig.VOICEIDSTR);
                OtoArgs otoArgs = utauVoiceDB.attachFileNameFromLyric(string);
                if (vsqEvent.UstEvent == null) {
                    vsqEvent.UstEvent = new UstEvent();
                }
                vsqEvent.UstEvent.VoiceOverlap = otoArgs.msOverlap;
                vsqEvent.UstEvent.PreUtterance = otoArgs.msPreUtterance;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeRenderingStatus(String string, int n) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(PortUtil.combinePath(string, n + ".xml"));
            renderingStatusSerializer.serialize(fileOutputStream, lastRenderedStatus[n - 1]);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("FormMain#patchWorkToFreeze; ex=" + exception);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("FormMain#patchWorkToFreeze; ex2=" + exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportError(Exception exception, String string, int n) {
        PortUtil.stderr.println(string + "; ex=" + exception);
        if (n < 0) {
            FormCompileResult formCompileResult = null;
            try {
                formCompileResult = new FormCompileResult(string, exception.toString());
                AppManager.beginShowDialog();
                formCompileResult.setModal(true);
                formCompileResult.setVisible(true);
                AppManager.endShowDialog();
            }
            catch (Exception exception2) {
            }
            finally {
                if (formCompileResult != null) {
                    try {
                        formCompileResult.close();
                    }
                    catch (Exception exception3) {}
                }
            }
        }
    }

    public static int xCoordFromClocks(double d) {
        return (int)((double)keyWidth + d * (double)scaleX - (double)startToDrawX) + 6;
    }

    public static int clockFromXCoord(int n) {
        return (int)((float)(n + startToDrawX - 6 - keyWidth) / scaleX);
    }

    public static boolean isWholeSelectedIntervalEnabled() {
        return wholeSelectedIntervalEnabled;
    }

    public static boolean isCurveSelectedIntervalEnabled() {
        return curveSelectedIntervalEnabled;
    }

    public static void setWholeSelectedIntervalEnabled(boolean bl) {
        wholeSelectedIntervalEnabled = bl;
        if (bl) {
            curveSelectedIntervalEnabled = false;
        }
    }

    public static void setCurveSelectedIntervalEnabled(boolean bl) {
        curveSelectedIntervalEnabled = bl;
        if (bl) {
            wholeSelectedIntervalEnabled = false;
        }
    }

    public static BDialogResult showMessageBox(String string) {
        return AppManager.showMessageBox(string, "", -1, -1);
    }

    public static BDialogResult showMessageBox(String string, String string2) {
        return AppManager.showMessageBox(string, string2, -1, -1);
    }

    public static BDialogResult showMessageBox(String string, String string2, int n) {
        return AppManager.showMessageBox(string, string2, n, -1);
    }

    public static void beginShowDialog() {
        boolean bl;
        boolean bl2 = bl = mixerWindow != null ? mixerWindow.isAlwaysOnTop() : false;
        if (bl) {
            mixerWindow.setAlwaysOnTop(false);
        }
    }

    public static void endShowDialog() {
        boolean bl;
        boolean bl2 = bl = mixerWindow != null ? mixerWindow.isAlwaysOnTop() : false;
        if (bl) {
            mixerWindow.setAlwaysOnTop(true);
        }
        if (mainWindow != null) {
            mainWindow.requestFocus();
        }
    }

    public static BDialogResult showMessageBox(String string, String string2, int n, int n2) {
        AppManager.beginShowDialog();
        BDialogResult bDialogResult = PortUtil.showMessageBox(string, string2, n, n2);
        AppManager.endShowDialog();
        return bDialogResult;
    }

    public static int getBgmCount() {
        if (s_vsq == null) {
            return 0;
        }
        return AppManager.s_vsq.BgmFiles.size();
    }

    public static BgmFile getBgm(int n) {
        if (s_vsq == null) {
            return null;
        }
        return AppManager.s_vsq.BgmFiles.get(n);
    }

    public static void removeBgm(int n) {
        if (s_vsq == null) {
            return;
        }
        Vector<BgmFile> vector = new Vector<BgmFile>();
        int n2 = AppManager.s_vsq.BgmFiles.size();
        for (int i = 0; i < n2; ++i) {
            if (i == n) continue;
            vector.add((BgmFile)AppManager.s_vsq.BgmFiles.get(i).clone());
        }
        CadenciiCommand cadenciiCommand = VsqFileEx.generateCommandBgmUpdate(vector);
        AppManager.register(s_vsq.executeCommand(cadenciiCommand));
        mainWindow.setEdited(true);
        mixerWindow.updateStatus();
    }

    public static void clearBgm() {
        if (s_vsq == null) {
            return;
        }
        Vector<BgmFile> vector = new Vector<BgmFile>();
        CadenciiCommand cadenciiCommand = VsqFileEx.generateCommandBgmUpdate(vector);
        AppManager.register(s_vsq.executeCommand(cadenciiCommand));
        mainWindow.setEdited(true);
        mixerWindow.updateStatus();
    }

    public static void addBgm(String string) {
        if (s_vsq == null) {
            return;
        }
        Vector<BgmFile> vector = new Vector<BgmFile>();
        int n = AppManager.s_vsq.BgmFiles.size();
        for (int i = 0; i < n; ++i) {
            vector.add((BgmFile)AppManager.s_vsq.BgmFiles.get(i).clone());
        }
        BgmFile bgmFile = new BgmFile();
        bgmFile.file = string;
        bgmFile.feder = 0;
        bgmFile.panpot = 0;
        vector.add(bgmFile);
        CadenciiCommand cadenciiCommand = VsqFileEx.generateCommandBgmUpdate(vector);
        AppManager.register(s_vsq.executeCommand(cadenciiCommand));
        mainWindow.setEdited(true);
        mixerWindow.updateStatus();
    }

    public static AmplifyCoefficient getAmplifyCoeffNormalTrack(int n) {
        AmplifyCoefficient amplifyCoefficient = new AmplifyCoefficient();
        amplifyCoefficient.left = 1.0;
        amplifyCoefficient.right = 1.0;
        if (s_vsq != null && 1 <= n && n < AppManager.s_vsq.Track.size()) {
            double d = VocaloSysUtil.getAmplifyCoeffFromFeder(AppManager.s_vsq.Mixer.MasterFeder);
            double d2 = VocaloSysUtil.getAmplifyCoeffFromPanLeft(AppManager.s_vsq.Mixer.MasterPanpot);
            double d3 = VocaloSysUtil.getAmplifyCoeffFromPanRight(AppManager.s_vsq.Mixer.MasterPanpot);
            double d4 = VocaloSysUtil.getAmplifyCoeffFromFeder(AppManager.s_vsq.Mixer.Slave.get((int)(n - 1)).Feder);
            double d5 = VocaloSysUtil.getAmplifyCoeffFromPanLeft(AppManager.s_vsq.Mixer.Slave.get((int)(n - 1)).Panpot);
            double d6 = VocaloSysUtil.getAmplifyCoeffFromPanRight(AppManager.s_vsq.Mixer.Slave.get((int)(n - 1)).Panpot);
            amplifyCoefficient.left = d * d4 * d2 * d5;
            amplifyCoefficient.right = d * d4 * d3 * d6;
        }
        return amplifyCoefficient;
    }

    public static AmplifyCoefficient getAmplifyCoeffBgm(int n) {
        AmplifyCoefficient amplifyCoefficient = new AmplifyCoefficient();
        amplifyCoefficient.left = 1.0;
        amplifyCoefficient.right = 1.0;
        if (s_vsq != null && 0 <= n && n < AppManager.s_vsq.BgmFiles.size()) {
            BgmFile bgmFile = AppManager.s_vsq.BgmFiles.get(n);
            if (bgmFile.mute == 1) {
                amplifyCoefficient.left = 0.0;
                amplifyCoefficient.right = 0.0;
            } else {
                double d = VocaloSysUtil.getAmplifyCoeffFromFeder(AppManager.s_vsq.Mixer.MasterFeder);
                double d2 = VocaloSysUtil.getAmplifyCoeffFromPanLeft(AppManager.s_vsq.Mixer.MasterPanpot);
                double d3 = VocaloSysUtil.getAmplifyCoeffFromPanRight(AppManager.s_vsq.Mixer.MasterPanpot);
                double d4 = VocaloSysUtil.getAmplifyCoeffFromFeder(bgmFile.feder);
                double d5 = VocaloSysUtil.getAmplifyCoeffFromPanLeft(bgmFile.panpot);
                double d6 = VocaloSysUtil.getAmplifyCoeffFromPanRight(bgmFile.panpot);
                amplifyCoefficient.left = d * d4 * d2 * d5;
                amplifyCoefficient.right = d * d4 * d3 * d6;
            }
        }
        return amplifyCoefficient;
    }

    public static void updateAutoBackupTimerStatus() {
        if (!s_file.equals("") && AppManager.editorConfig.AutoBackupIntervalMinutes > 0) {
            double d = (double)AppManager.editorConfig.AutoBackupIntervalMinutes * 60.0 * 1000.0;
            int n = (int)d;
            if (d > 2.147483647E9) {
                n = Integer.MAX_VALUE;
            }
            s_auto_backup_timer.setDelay(n);
            s_auto_backup_timer.start();
        } else {
            s_auto_backup_timer.stop();
        }
    }

    private static void handleAutoBackupTimerTick(Object object, BEventArgs bEventArgs) {
        if (!s_file.equals("") && PortUtil.isFileExists(s_file)) {
            String string = PortUtil.getDirectoryName(s_file);
            String string2 = PortUtil.combinePath(string, "~$" + PortUtil.getFileName(s_file));
            String string3 = PortUtil.combinePath(string, PortUtil.getFileNameWithoutExtension(string2) + ".vsq");
            if (PortUtil.isFileExists(string2)) {
                try {
                    PortUtil.deleteFile(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (PortUtil.isFileExists(string3)) {
                try {
                    PortUtil.deleteFile(string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            AppManager.saveToCor(string2);
        }
    }

    public static void debugWriteLine(String string) {
    }

    public static String getID() {
        return s_id;
    }

    public static String _(String string) {
        return Messaging.getMessage(string);
    }

    public static void setTempWaveDir(String string) {
        tempWaveDir = string;
    }

    public static String getTempWaveDir() {
        return tempWaveDir;
    }

    public static String getCadenciiTempDir() {
        String string = PortUtil.combinePath(PortUtil.getTempPath(), TEMPDIR_NAME);
        if (!PortUtil.isDirectoryExists(string)) {
            PortUtil.createDirectory(string);
        }
        return string;
    }

    public static boolean isCurveMode() {
        return s_is_curve_mode;
    }

    public static void setCurveMode(boolean bl) {
        boolean bl2 = s_is_curve_mode;
        if (bl2 != (s_is_curve_mode = bl)) {
            try {
                selectedToolChangedEvent.raise(AppManager.class, new BEventArgs());
            }
            catch (Exception exception) {
                PortUtil.stderr.println("AppManager#setCurveMode; ex=" + exception);
            }
        }
    }

    public static void clearCommandBuffer() {
        s_commands.clear();
        s_command_position = -1;
    }

    public static void undo() {
        if (AppManager.isUndoAvailable()) {
            int n;
            Object object;
            Vector<ValuePair<Integer, Integer>> vector = new Vector<ValuePair<Integer, Integer>>();
            Object object2 = AppManager.getSelectedEventIterator();
            while (object2.hasNext()) {
                object = object2.next();
                vector.add(new ValuePair<Integer, Integer>(((SelectedEventEntry)object).track, ((SelectedEventEntry)object).original.InternalID));
            }
            object2 = s_commands.get(s_command_position);
            object = (CadenciiCommand)object2;
            if (((CadenciiCommand)object).vsqCommand != null && ((CadenciiCommand)object).vsqCommand.Type == VsqCommandType.TRACK_DELETE && (n = ((Integer)((CadenciiCommand)object).vsqCommand.Args[0]).intValue()) == AppManager.getSelected() && n >= 2) {
                AppManager.setSelected(n - 1);
            }
            ICommand iCommand = s_vsq.executeCommand((ICommand)object);
            if (((CadenciiCommand)object).type == CadenciiCommandType.BGM_UPDATE && mainWindow != null) {
                mainWindow.updateBgmMenuState();
            }
            s_commands.set(s_command_position, iCommand);
            --s_command_position;
            AppManager.cleanupDeadSelection(vector);
            AppManager.updateSelectedEventInstance();
        }
    }

    public static void redo() {
        if (AppManager.isRedoAvailable()) {
            int n;
            Object object;
            Vector<ValuePair<Integer, Integer>> vector = new Vector<ValuePair<Integer, Integer>>();
            Object object2 = AppManager.getSelectedEventIterator();
            while (object2.hasNext()) {
                object = object2.next();
                vector.add(new ValuePair<Integer, Integer>(((SelectedEventEntry)object).track, ((SelectedEventEntry)object).original.InternalID));
            }
            object2 = s_commands.get(s_command_position + 1);
            object = (CadenciiCommand)object2;
            if (((CadenciiCommand)object).vsqCommand != null && ((CadenciiCommand)object).vsqCommand.Type == VsqCommandType.TRACK_DELETE && (n = ((Integer)((CadenciiCommand)object).args[0]).intValue()) == AppManager.getSelected() && n >= 2) {
                AppManager.setSelected(n - 1);
            }
            ICommand iCommand = s_vsq.executeCommand((ICommand)object);
            if (((CadenciiCommand)object).type == CadenciiCommandType.BGM_UPDATE && mainWindow != null) {
                mainWindow.updateBgmMenuState();
            }
            s_commands.set(s_command_position + 1, iCommand);
            ++s_command_position;
            AppManager.cleanupDeadSelection(vector);
            AppManager.updateSelectedEventInstance();
        }
    }

    public static void updateSelectedEventInstance() {
        if (s_vsq == null) {
            return;
        }
        VsqTrack vsqTrack = (VsqTrack)AppManager.s_vsq.Track.get(s_selected);
        Iterator<SelectedEventEntry> iterator = AppManager.getSelectedEventIterator();
        while (iterator.hasNext()) {
            SelectedEventEntry selectedEventEntry = iterator.next();
            int n = selectedEventEntry.original.InternalID;
            selectedEventEntry.original = vsqTrack.findEventFromID(n);
        }
    }

    public static void cleanupDeadSelection(Vector<ValuePair<Integer, Integer>> vector) {
        for (ValuePair<Integer, Integer> valuePair : vector) {
            boolean bl = false;
            Iterator<VsqEvent> iterator = ((VsqTrack)AppManager.s_vsq.Track.get(valuePair.getKey())).getNoteEventIterator();
            while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                if (vsqEvent.InternalID != valuePair.getValue()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            AppManager.removeSelectedEvent(valuePair.getValue());
        }
    }

    public static void register(ICommand iCommand) {
        if (s_command_position == s_commands.size() - 1) {
            s_commands.add(iCommand);
            s_command_position = s_commands.size() - 1;
        } else {
            s_commands.set(s_command_position + 1, iCommand);
            for (int i = s_commands.size() - 1; i >= s_command_position + 2; --i) {
                s_commands.removeElementAt(i);
            }
            ++s_command_position;
        }
    }

    public static boolean isRedoAvailable() {
        return s_commands.size() > 0 && 0 <= s_command_position + 1 && s_command_position + 1 < s_commands.size();
    }

    public static boolean isUndoAvailable() {
        return s_commands.size() > 0 && 0 <= s_command_position && s_command_position < s_commands.size();
    }

    public static EditTool getSelectedTool() {
        return s_selected_tool;
    }

    public static void setSelectedTool(EditTool editTool) {
        EditTool editTool2 = s_selected_tool;
        if (editTool2 != (s_selected_tool = editTool)) {
            try {
                selectedToolChangedEvent.raise(AppManager.class, new BEventArgs());
            }
            catch (Exception exception) {
                PortUtil.stderr.println("AppManager#setSelectedTool; ex=" + exception);
            }
        }
    }

    public static Iterator<SelectedBezierPoint> getSelectedBezierIterator() {
        return s_selected_bezier.iterator();
    }

    public static SelectedBezierPoint getLastSelectedBezier() {
        if (AppManager.s_last_selected_bezier.chainID < 0 || AppManager.s_last_selected_bezier.pointID < 0) {
            return null;
        }
        return s_last_selected_bezier;
    }

    public static void addSelectedBezier(SelectedBezierPoint selectedBezierPoint) {
        s_last_selected_bezier = selectedBezierPoint;
        int n = -1;
        for (int i = 0; i < s_selected_bezier.size(); ++i) {
            if (AppManager.s_selected_bezier.get((int)i).chainID != selectedBezierPoint.chainID || AppManager.s_selected_bezier.get((int)i).pointID != selectedBezierPoint.pointID) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            s_selected_bezier.set(n, selectedBezierPoint);
        } else {
            s_selected_bezier.add(selectedBezierPoint);
        }
        AppManager.checkSelectedItemExistence();
    }

    public static void clearSelectedBezier() {
        s_selected_bezier.clear();
        AppManager.s_last_selected_bezier.chainID = -1;
        AppManager.s_last_selected_bezier.pointID = -1;
        AppManager.checkSelectedItemExistence();
    }

    public static SelectedTimesigEntry getLastSelectedTimesig() {
        if (s_selected_timesig.containsKey(s_last_selected_timesig)) {
            return s_selected_timesig.get(s_last_selected_timesig);
        }
        return null;
    }

    public static int getLastSelectedTimesigBarcount() {
        return s_last_selected_timesig;
    }

    public static void addSelectedTimesig(int n) {
        AppManager.clearSelectedEvent();
        AppManager.clearSelectedTempo();
        s_last_selected_timesig = n;
        if (!s_selected_timesig.containsKey(n)) {
            for (TimeSigTableEntry timeSigTableEntry : AppManager.s_vsq.TimesigTable) {
                if (timeSigTableEntry.BarCount != n) continue;
                s_selected_timesig.put(n, new SelectedTimesigEntry(timeSigTableEntry, (TimeSigTableEntry)timeSigTableEntry.clone()));
                break;
            }
        }
        AppManager.checkSelectedItemExistence();
    }

    public static void clearSelectedTimesig() {
        s_selected_timesig.clear();
        s_last_selected_timesig = -1;
        AppManager.checkSelectedItemExistence();
    }

    public static int getSelectedTimesigCount() {
        return s_selected_timesig.size();
    }

    public static Iterator<ValuePair<Integer, SelectedTimesigEntry>> getSelectedTimesigIterator() {
        Vector<ValuePair<Integer, SelectedTimesigEntry>> vector = new Vector<ValuePair<Integer, SelectedTimesigEntry>>();
        for (int n : s_selected_timesig.keySet()) {
            vector.add(new ValuePair<Integer, SelectedTimesigEntry>(n, s_selected_timesig.get(n)));
        }
        return vector.iterator();
    }

    public static boolean isSelectedTimesigContains(int n) {
        return s_selected_timesig.containsKey(n);
    }

    public static SelectedTimesigEntry getSelectedTimesig(int n) {
        if (s_selected_timesig.containsKey(n)) {
            return s_selected_timesig.get(n);
        }
        return null;
    }

    public static void removeSelectedTimesig(int n) {
        if (s_selected_timesig.containsKey(n)) {
            s_selected_timesig.remove(n);
            AppManager.checkSelectedItemExistence();
        }
    }

    public static SelectedTempoEntry getLastSelectedTempo() {
        if (s_selected_tempo.containsKey(s_last_selected_tempo)) {
            return s_selected_tempo.get(s_last_selected_tempo);
        }
        return null;
    }

    public static int getLastSelectedTempoClock() {
        return s_last_selected_tempo;
    }

    public static void addSelectedTempo(int n) {
        AppManager.clearSelectedEvent();
        AppManager.clearSelectedTimesig();
        s_last_selected_tempo = n;
        if (!s_selected_tempo.containsKey(n)) {
            for (TempoTableEntry tempoTableEntry : AppManager.s_vsq.TempoTable) {
                if (tempoTableEntry.Clock != n) continue;
                s_selected_tempo.put(n, new SelectedTempoEntry(tempoTableEntry, (TempoTableEntry)tempoTableEntry.clone()));
                break;
            }
        }
        AppManager.checkSelectedItemExistence();
    }

    public static void clearSelectedTempo() {
        s_selected_tempo.clear();
        s_last_selected_tempo = -1;
        AppManager.checkSelectedItemExistence();
    }

    public static int getSelectedTempoCount() {
        return s_selected_tempo.size();
    }

    public static Iterator<ValuePair<Integer, SelectedTempoEntry>> getSelectedTempoIterator() {
        Vector<ValuePair<Integer, SelectedTempoEntry>> vector = new Vector<ValuePair<Integer, SelectedTempoEntry>>();
        for (int n : s_selected_tempo.keySet()) {
            vector.add(new ValuePair<Integer, SelectedTempoEntry>(n, s_selected_tempo.get(n)));
        }
        return vector.iterator();
    }

    public static boolean isSelectedTempoContains(int n) {
        return s_selected_tempo.containsKey(n);
    }

    public static SelectedTempoEntry getSelectedTempo(int n) {
        if (s_selected_tempo.containsKey(n)) {
            return s_selected_tempo.get(n);
        }
        return null;
    }

    public static void removeSelectedTempo(int n) {
        if (s_selected_tempo.containsKey(n)) {
            s_selected_tempo.remove(n);
            AppManager.checkSelectedItemExistence();
        }
    }

    public static void removeSelectedEvent(int n) {
        AppManager.removeSelectedEventCor(n, false);
        AppManager.checkSelectedItemExistence();
    }

    public static void removeSelectedEventSilent(int n) {
        AppManager.removeSelectedEventCor(n, true);
        AppManager.checkSelectedItemExistence();
    }

    private static void removeSelectedEventCor(int n, boolean bl) {
        int n2 = s_selected_events.size();
        for (int i = 0; i < n2; ++i) {
            if (AppManager.s_selected_events.get((int)i).original.InternalID != n) continue;
            s_selected_events.removeElementAt(i);
            break;
        }
        if (!bl) {
            // empty if block
        }
    }

    public static void removeSelectedEventRange(int[] nArray) {
        int n;
        Vector<Integer> vector = new Vector<Integer>(Arrays.asList(PortUtil.convertIntArray(nArray)));
        Vector<Integer> vector2 = new Vector<Integer>();
        int n2 = s_selected_events.size();
        for (n = 0; n < n2; ++n) {
            if (!vector.contains(AppManager.s_selected_events.get((int)n).original.InternalID)) continue;
            vector2.add(n);
            if (vector2.size() == nArray.length) break;
        }
        n2 = vector2.size();
        for (n = n2 - 1; n >= 0; --n) {
            s_selected_events.removeElementAt(n);
        }
        AppManager.checkSelectedItemExistence();
    }

    public static void addSelectedEventAll(Vector<Integer> vector) {
        AppManager.clearSelectedTempo();
        AppManager.clearSelectedTimesig();
        VsqEvent[] vsqEventArray = new VsqEvent[vector.size()];
        int n = 0;
        int n2 = vector.size();
        Iterator<VsqEvent> iterator = ((VsqTrack)AppManager.s_vsq.Track.get(s_selected)).getEventIterator();
        while (iterator.hasNext()) {
            VsqEvent vsqEvent = iterator.next();
            int n3 = -1;
            for (int i = 0; i < n2; ++i) {
                if (vector.get(i) != vsqEvent.InternalID) continue;
                n3 = i;
                break;
            }
            if (0 <= n3) {
                vsqEventArray[n3] = vsqEvent;
                ++n;
            }
            if (n != vector.size()) continue;
            break;
        }
        for (int i = 0; i < vsqEventArray.length; ++i) {
            if (AppManager.isSelectedEventContains(s_selected, vsqEventArray[i].InternalID)) continue;
            s_selected_events.add(new SelectedEventEntry(s_selected, vsqEventArray[i], (VsqEvent)vsqEventArray[i].clone()));
        }
        AppManager.checkSelectedItemExistence();
    }

    public static void addSelectedEvent(int n) {
        AppManager.addSelectedEventCor(n, false);
        AppManager.checkSelectedItemExistence();
    }

    public static void addSelectedEventSilent(int n) {
        AppManager.addSelectedEventCor(n, true);
        AppManager.checkSelectedItemExistence();
    }

    private static void addSelectedEventCor(int n, boolean bl) {
        AppManager.clearSelectedTempo();
        AppManager.clearSelectedTimesig();
        Iterator<VsqEvent> iterator = ((VsqTrack)AppManager.s_vsq.Track.get(s_selected)).getEventIterator();
        while (iterator.hasNext()) {
            VsqEvent vsqEvent = iterator.next();
            if (vsqEvent.InternalID != n) continue;
            if (AppManager.isSelectedEventContains(s_selected, n)) {
                int n2 = s_selected_events.size();
                for (int i = 0; i < n2; ++i) {
                    SelectedEventEntry selectedEventEntry = s_selected_events.get(i);
                    if (selectedEventEntry.original.InternalID != n) continue;
                    s_selected_events.removeElementAt(i);
                    break;
                }
            }
            s_selected_events.add(new SelectedEventEntry(s_selected, vsqEvent, (VsqEvent)vsqEvent.clone()));
            if (bl) break;
            try {
                selectedEventChangedEvent.raise(AppManager.class, false);
            }
            catch (Exception exception) {
                PortUtil.stderr.println("AppManager#addSelectedEventCor; ex=" + exception);
            }
            break;
        }
        if (!bl) {
            // empty if block
        }
    }

    public static void clearSelectedEvent() {
        s_selected_events.clear();
        AppManager.checkSelectedItemExistence();
    }

    public static boolean isSelectedEventContains(int n, int n2) {
        int n3 = s_selected_events.size();
        for (int i = 0; i < n3; ++i) {
            SelectedEventEntry selectedEventEntry = s_selected_events.get(i);
            if (selectedEventEntry.original.InternalID != n2 || selectedEventEntry.track != n) continue;
            return true;
        }
        return false;
    }

    public static Iterator<SelectedEventEntry> getSelectedEventIterator() {
        return s_selected_events.iterator();
    }

    public static SelectedEventEntry getLastSelectedEvent() {
        if (s_selected_events.size() <= 0) {
            return null;
        }
        return s_selected_events.get(s_selected_events.size() - 1);
    }

    public static int getSelectedEventCount() {
        return s_selected_events.size();
    }

    public static void clearSelectedPoint() {
        selectedPointIDs.clear();
        selectedPointCurveType = CurveType.Empty;
        AppManager.checkSelectedItemExistence();
    }

    public static void addSelectedPoint(CurveType curveType, long l) {
        AppManager.addSelectedPointAll(curveType, new long[]{l});
        AppManager.checkSelectedItemExistence();
    }

    public static void addSelectedPointAll(CurveType curveType, long[] lArray) {
        if (!curveType.equals(selectedPointCurveType)) {
            selectedPointIDs.clear();
            selectedPointCurveType = curveType;
        }
        for (int i = 0; i < lArray.length; ++i) {
            if (selectedPointIDs.contains(lArray[i])) continue;
            selectedPointIDs.add(lArray[i]);
        }
        AppManager.checkSelectedItemExistence();
    }

    public static boolean isSelectedPointContains(long l) {
        return selectedPointIDs.contains(l);
    }

    public static CurveType getSelectedPointCurveType() {
        return selectedPointCurveType;
    }

    public static Iterator<Long> getSelectedPointIDIterator() {
        return selectedPointIDs.iterator();
    }

    public static int getSelectedPointIDCount() {
        return selectedPointIDs.size();
    }

    public static void removeSelectedPoint(long l) {
        selectedPointIDs.removeElement(l);
        AppManager.checkSelectedItemExistence();
    }

    private static void checkSelectedItemExistence() {
        boolean bl = s_selected_bezier.size() == 0 && s_selected_events.size() == 0 && s_selected_tempo.size() == 0 && s_selected_timesig.size() == 0 && selectedPointIDs.size() == 0;
        try {
            selectedEventChangedEvent.raise(AppManager.class, bl);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("AppManager#checkSelectedItemExistence; ex=" + exception);
        }
    }

    public static boolean isOverlay() {
        return s_overlay;
    }

    public static void setOverlay(boolean bl) {
        s_overlay = bl;
    }

    public static boolean getRenderRequired(int n) {
        if (s_vsq == null) {
            return false;
        }
        return AppManager.s_vsq.editorStatus.renderRequired[n - 1];
    }

    public static void setRenderRequired(int n, boolean bl) {
        if (s_vsq == null) {
            return;
        }
        AppManager.s_vsq.editorStatus.renderRequired[n - 1] = bl;
    }

    public static EditMode getEditMode() {
        return s_edit_mode;
    }

    public static void setEditMode(EditMode editMode) {
        s_edit_mode = editMode;
    }

    public static boolean isGridVisible() {
        return s_grid_visible;
    }

    public static void setGridVisible(boolean bl) {
        if (bl != s_grid_visible) {
            s_grid_visible = bl;
            try {
                gridVisibleChangedEvent.raise(AppManager.class, new BEventArgs());
            }
            catch (Exception exception) {
                PortUtil.stderr.println("AppManager#setGridVisible; ex=" + exception);
            }
        }
    }

    public static boolean isRepeatMode() {
        return s_repeat_mode;
    }

    public static void setRepeatMode(boolean bl) {
        s_repeat_mode = bl;
    }

    public static boolean isPlaying() {
        return s_playing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPlaying(boolean bl) {
        Object object = playingPropertyLocker;
        synchronized (object) {
            boolean bl2 = s_playing;
            s_playing = bl;
            if (bl2 != s_playing) {
                if (s_playing) {
                    try {
                        previewStartedEvent.raise(AppManager.class, new BEventArgs());
                    }
                    catch (Exception exception) {
                        PortUtil.stderr.println("AppManager#setPlaying; ex=" + exception);
                    }
                } else if (!s_playing) {
                    try {
                        previewAbortedEvent.raise(AppManager.class, new BEventArgs());
                    }
                    catch (Exception exception) {
                        PortUtil.stderr.println("AppManager#setPlaying; ex=" + exception);
                    }
                }
            }
        }
    }

    public static String getFileName() {
        return s_file;
    }

    private static void saveToCor(String string) {
        boolean bl = false;
        if (s_vsq != null) {
            String string2 = PortUtil.getDirectoryName(string);
            String string3 = PortUtil.combinePath(string2, PortUtil.getFileNameWithoutExtension(string) + ".vsq");
            s_vsq.writeAsXml(string);
            s_vsq.write(string3);
        }
    }

    public static void saveTo(String string) {
        if (s_vsq != null && AppManager.editorConfig.UseProjectCache) {
            String string2;
            String string3;
            String string4 = PortUtil.getDirectoryName(string);
            String string5 = PortUtil.combinePath(string4, (string3 = PortUtil.getFileNameWithoutExtension(string)) + ".cadencii");
            if (!PortUtil.isDirectoryExists(string5)) {
                try {
                    PortUtil.createDirectory(string5);
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("AppManager#saveTo; ex=" + exception);
                    AppManager.showMessageBox(PortUtil.formatMessage(AppManager._("failed creating cache directory, '{0}'."), string5), AppManager._("Info."), 0, 1);
                    return;
                }
            }
            if (!(string2 = AppManager.getTempWaveDir()).equals(string5)) {
                for (int i = 1; i < AppManager.s_vsq.Track.size(); ++i) {
                    String string6 = PortUtil.combinePath(string2, i + ".wav");
                    String string7 = PortUtil.combinePath(string5, i + ".wav");
                    if (PortUtil.isFileExists(string6)) {
                        if (PortUtil.isFileExists(string7)) {
                            try {
                                PortUtil.deleteFile(string7);
                            }
                            catch (Exception exception) {
                                PortUtil.stderr.println("AppManager#saveTo; ex=" + exception);
                            }
                        }
                        try {
                            PortUtil.moveFile(string6, string7);
                        }
                        catch (Exception exception) {
                            PortUtil.stderr.println("AppManager#saveTo; ex=" + exception);
                            AppManager.showMessageBox(PortUtil.formatMessage(AppManager._("failed copying WAVE cache file, '{0}'."), string6), AppManager._("Error"), 0, 2);
                            break;
                        }
                    }
                    String string8 = PortUtil.combinePath(string2, i + ".xml");
                    String string9 = PortUtil.combinePath(string5, i + ".xml");
                    if (!PortUtil.isFileExists(string8)) continue;
                    if (PortUtil.isFileExists(string9)) {
                        try {
                            PortUtil.deleteFile(string9);
                        }
                        catch (Exception exception) {
                            PortUtil.stderr.println("AppManager#saveTo; ex=" + exception);
                        }
                    }
                    try {
                        PortUtil.moveFile(string8, string9);
                        continue;
                    }
                    catch (Exception exception) {
                        PortUtil.stderr.println("AppManager#saveTo; ex=" + exception);
                        AppManager.showMessageBox(PortUtil.formatMessage(AppManager._("failed copying XML cache file, '{0}'."), string8), AppManager._("Error"), 0, 2);
                        break;
                    }
                }
                AppManager.setTempWaveDir(string5);
            }
            AppManager.s_vsq.cacheDir = string5;
        }
        AppManager.saveToCor(string);
        if (s_vsq != null) {
            s_file = string;
            editorConfig.pushRecentFiles(s_file);
            if (!s_auto_backup_timer.isRunning() && AppManager.editorConfig.AutoBackupIntervalMinutes > 0) {
                double d = (double)AppManager.editorConfig.AutoBackupIntervalMinutes * 60.0 * 1000.0;
                int n = (int)d;
                if (d > 2.147483647E9) {
                    n = Integer.MAX_VALUE;
                }
                s_auto_backup_timer.setDelay(n);
                s_auto_backup_timer.start();
            }
        }
    }

    public static int getCurrentClock() {
        return s_current_clock;
    }

    public static void setCurrentClock(int n) {
        int n2 = s_current_clock;
        s_current_clock = n;
        int n3 = s_vsq.getBarCountFromClock(s_current_clock);
        int n4 = s_vsq.getClockFromBarCount(n3);
        Timesig timesig = s_vsq.getTimesigAt(s_current_clock);
        int n5 = 120 * timesig.denominator;
        int n6 = (s_current_clock - n4) / n5;
        AppManager.s_current_play_position.barCount = n3 - s_vsq.getPreMeasure() + 1;
        AppManager.s_current_play_position.beat = n6 + 1;
        AppManager.s_current_play_position.clock = s_current_clock - n4 - n5 * n6;
        AppManager.s_current_play_position.denominator = timesig.denominator;
        AppManager.s_current_play_position.numerator = timesig.numerator;
        AppManager.s_current_play_position.tempo = s_vsq.getTempoAt(s_current_clock);
        if (n2 != s_current_clock) {
            try {
                currentClockChangedEvent.raise(AppManager.class, new BEventArgs());
            }
            catch (Exception exception) {
                PortUtil.stderr.println("AppManager#setCurrentClock; ex=" + exception);
            }
        }
    }

    public static PlayPositionSpecifier getPlayPosition() {
        return s_current_play_position;
    }

    public static int getSelected() {
        int n = AppManager.s_vsq.Track.size();
        if (n <= s_selected) {
            s_selected = n - 1;
        }
        return s_selected;
    }

    public static void setSelected(int n) {
        s_selected = n;
    }

    public static void readVsq(String string) {
        int n;
        s_selected = 1;
        s_file = string;
        VsqFileEx vsqFileEx = null;
        try {
            vsqFileEx = VsqFileEx.readFromXml(string);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("AppManager#readVsq; ex=" + exception);
            return;
        }
        if (vsqFileEx == null) {
            return;
        }
        s_vsq = vsqFileEx;
        for (n = 0; n < AppManager.s_vsq.editorStatus.renderRequired.length; ++n) {
            AppManager.s_vsq.editorStatus.renderRequired[n] = n < AppManager.s_vsq.Track.size() - 1;
        }
        startMarker = s_vsq.getPreMeasureClocks();
        n = s_vsq.getPreMeasure() + 1;
        endMarker = s_vsq.getClockFromBarCount(n);
        s_selected = AppManager.s_vsq.Track.size() >= 1 ? 1 : -1;
        if (mainWindow != null) {
            mainWindow.updateBgmMenuState();
        }
    }

    public static VsqFileEx getVsqFile() {
        return s_vsq;
    }

    public static void setVsqFile(VsqFileEx vsqFileEx) {
        int n;
        s_vsq = vsqFileEx;
        for (n = 0; n < AppManager.s_vsq.editorStatus.renderRequired.length; ++n) {
            AppManager.s_vsq.editorStatus.renderRequired[n] = n < AppManager.s_vsq.Track.size() - 1;
        }
        s_file = "";
        startMarker = s_vsq.getPreMeasureClocks();
        n = s_vsq.getPreMeasure() + 1;
        endMarker = s_vsq.getClockFromBarCount(n);
        s_auto_backup_timer.stop();
        if (mainWindow != null) {
            mainWindow.updateBgmMenuState();
        }
    }

    public static void init() {
        Object object;
        Object object2;
        AppManager.loadConfig();
        VSTiProxy.init();
        PlaySound.init();
        s_locker = new Object();
        SymbolTable.loadDictionary();
        VSTiProxy.CurrentUser = "";
        Util.isApplyFontRecurseEnabled = false;
        try {
            int n;
            object2 = new Vector<ValuePair<String, Boolean>>();
            for (int i = 0; i < SymbolTable.getCount(); ++i) {
                ((Vector)object2).add(new ValuePair<String, Boolean>(SymbolTable.getSymbolTable(i).getName(), false));
            }
            Vector<ValuePair<String, Boolean>> vector = new Vector<ValuePair<String, Boolean>>();
            int n2 = AppManager.editorConfig.UserDictionaries.size();
            for (int i = 0; i < n2; ++i) {
                String[] stringArray = PortUtil.splitString(AppManager.editorConfig.UserDictionaries.get(i), new char[]{'\t'}, 2);
                vector.add(new ValuePair<String, Boolean>(stringArray[0], stringArray[1].equals("T")));
            }
            object = new Vector<ValuePair<String, Boolean>>();
            block6: for (n = 0; n < vector.size(); ++n) {
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    if (!((String)((ValuePair)vector.get(n)).getKey()).equals(((ValuePair)((Vector)object2).get(i)).getKey())) continue;
                    ((ValuePair)((Vector)object2).get(i)).setValue(true);
                    ((Vector)object).add(new ValuePair(((ValuePair)vector.get(n)).getKey(), ((ValuePair)vector.get(n)).getValue()));
                    continue block6;
                }
            }
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                if (((Boolean)((ValuePair)((Vector)object2).get(n)).getValue()).booleanValue()) continue;
                ((Vector)object).add(new ValuePair(((ValuePair)((Vector)object2).get(n)).getKey(), false));
            }
            SymbolTable.changeOrder(object);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("AppManager#init; ex=" + exception);
        }
        s_id = PortUtil.getMD5FromString((long)PortUtil.getCurrentTime() + "").replace("_", "");
        tempWaveDir = PortUtil.combinePath(AppManager.getCadenciiTempDir(), s_id);
        if (!PortUtil.isDirectoryExists(tempWaveDir)) {
            PortUtil.createDirectory(tempWaveDir);
        }
        object2 = PortUtil.combinePath(AppManager.getTempWaveDir(), "run.log");
        for (SingerConfig singerConfig : AppManager.editorConfig.UtauSingers) {
            object = null;
            String string = PortUtil.combinePath(singerConfig.VOICEIDSTR, "oto.ini");
            try {
                object = new UtauVoiceDB(string);
            }
            catch (Exception exception) {
                PortUtil.stderr.println("AppManager#init; ex=" + exception);
                object = null;
            }
            if (object == null) continue;
            utauVoiceDB.put(singerConfig.VOICEIDSTR, (UtauVoiceDB)object);
        }
        s_auto_backup_timer = new BTimer();
        AppManager.s_auto_backup_timer.tickEvent.add(new BEventHandler(AppManager.class, "handleAutoBackupTimerTick"));
    }

    private static String getSerializedText(Object object) throws IOException {
        String string = "";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        string = "CADENCIIOBJ:" + object.getClass().getName() + ":" + Base64.encode(byArray);
        return string;
    }

    private static Object getDeserializedObjectFromText(String string) {
        if (string.startsWith(CLIP_PREFIX)) {
            int n = string.indexOf(":");
            n = string.indexOf(":", n + 1);
            Object object = null;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode(string.substring(n + 1)));
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                object = null;
            }
            return object;
        }
        return null;
    }

    public static void clearClipBoard() {
        String string;
        if (PortUtil.isClipboardContainsText() && (string = PortUtil.getClipboardText()) != null && string.startsWith(CLIP_PREFIX)) {
            PortUtil.clearClipboard();
        }
    }

    public static void setClipboard(ClipboardEntry clipboardEntry) {
        String string = "";
        try {
            string = AppManager.getSerializedText(clipboardEntry);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("AppManager#setClipboard; ex=" + exception);
            return;
        }
        PortUtil.clearClipboard();
        PortUtil.setClipboardText(string);
    }

    public static ClipboardEntry getCopiedItems() {
        int n;
        int n2;
        String string;
        String string2;
        ClipboardEntry clipboardEntry = null;
        if (PortUtil.isClipboardContainsText() && (string2 = PortUtil.getClipboardText()).startsWith(CLIP_PREFIX) && (string = string2.substring((n2 = string2.indexOf(":")) + 1, (n = string2.indexOf(":", n2 + 1)) - n2 - 1)).equals(ClipboardEntry.class.getName())) {
            try {
                clipboardEntry = (ClipboardEntry)AppManager.getDeserializedObjectFromText(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (clipboardEntry == null) {
            clipboardEntry = new ClipboardEntry();
        }
        if (clipboardEntry.beziers == null) {
            clipboardEntry.beziers = new TreeMap();
        }
        if (clipboardEntry.events == null) {
            clipboardEntry.events = new Vector();
        }
        if (clipboardEntry.points == null) {
            clipboardEntry.points = new TreeMap();
        }
        if (clipboardEntry.tempo == null) {
            clipboardEntry.tempo = new Vector();
        }
        if (clipboardEntry.timesig == null) {
            clipboardEntry.timesig = new Vector();
        }
        return clipboardEntry;
    }

    private static void setClipboard(Vector<VsqEvent> vector, Vector<TempoTableEntry> vector2, Vector<TimeSigTableEntry> vector3, TreeMap<CurveType, VsqBPList> treeMap, TreeMap<CurveType, Vector<BezierChain>> treeMap2, int n) {
        ClipboardEntry clipboardEntry = new ClipboardEntry();
        clipboardEntry.events = vector;
        clipboardEntry.tempo = vector2;
        clipboardEntry.timesig = vector3;
        clipboardEntry.points = treeMap;
        clipboardEntry.beziers = treeMap2;
        clipboardEntry.copyStartedClock = n;
        String string = "";
        try {
            string = AppManager.getSerializedText(clipboardEntry);
        }
        catch (Exception exception) {
            System.err.println("AppManager#setCopiedEvent; ex=" + exception);
            return;
        }
        PortUtil.clearClipboard();
        PortUtil.setClipboardText(string);
    }

    public static void setCopiedEvent(Vector<VsqEvent> vector, int n) {
        AppManager.setClipboard(vector, null, null, null, null, n);
    }

    public static void setCopiedTempo(Vector<TempoTableEntry> vector, int n) {
        AppManager.setClipboard(null, vector, null, null, null, n);
    }

    public static void setCopiedTimesig(Vector<TimeSigTableEntry> vector, int n) {
        AppManager.setClipboard(null, null, vector, null, null, n);
    }

    public static void setCopiedCurve(TreeMap<CurveType, VsqBPList> treeMap, int n) {
        AppManager.setClipboard(null, null, null, treeMap, null, n);
    }

    public static void setCopiedBezier(TreeMap<CurveType, Vector<BezierChain>> treeMap, int n) {
        AppManager.setClipboard(null, null, null, null, treeMap, n);
    }

    public static int getPositionQuantizeClock() {
        return QuantizeModeUtil.getQuantizeClock(editorConfig.getPositionQuantize(), editorConfig.isPositionQuantizeTriplet());
    }

    public static int getLengthQuantizeClock() {
        return QuantizeModeUtil.getQuantizeClock(editorConfig.getLengthQuantize(), editorConfig.isLengthQuantizeTriplet());
    }

    public static void saveConfig() {
        AppManager.editorConfig.UserDictionaries.clear();
        int n = SymbolTable.getCount();
        for (int i = 0; i < n; ++i) {
            SymbolTable symbolTable = SymbolTable.getSymbolTable(i);
            AppManager.editorConfig.UserDictionaries.add(symbolTable.getName() + "\t" + (symbolTable.isEnabled() ? "T" : "F"));
        }
        AppManager.editorConfig.KeyWidth = keyWidth;
        String string = PortUtil.combinePath(Utility.getApplicationDataPath(), CONFIG_FILE_NAME);
        try {
            EditorConfig.serialize(editorConfig, string);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("AppManager#saveConfig; ex=" + exception);
        }
    }

    public static void loadConfig() {
        int n;
        String string = Utility.getApplicationDataPath();
        if (string.equals("")) {
            editorConfig = new EditorConfig();
            return;
        }
        String string2 = PortUtil.combinePath(string, CONFIG_FILE_NAME);
        EditorConfig editorConfig = null;
        if (PortUtil.isFileExists(string2)) {
            try {
                editorConfig = EditorConfig.deserialize(string2);
            }
            catch (Exception exception) {
                PortUtil.stderr.println("AppManager#loadConfig; ex=" + exception);
                editorConfig = null;
            }
        } else {
            string2 = PortUtil.combinePath(string, CONFIG_FILE_NAME);
            if (PortUtil.isFileExists(string2)) {
                try {
                    editorConfig = EditorConfig.deserialize(string2);
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("AppManager#locdConfig; ex=" + exception);
                    editorConfig = null;
                }
            }
        }
        if (editorConfig == null) {
            editorConfig = new EditorConfig();
        }
        AppManager.editorConfig = editorConfig;
        int n2 = SymbolTable.getCount();
        for (n = 0; n < n2; ++n) {
            SymbolTable symbolTable = SymbolTable.getSymbolTable(n);
            boolean bl = false;
            for (String string3 : AppManager.editorConfig.UserDictionaries) {
                String[] stringArray = PortUtil.splitString(string3, new char[]{'\t'}, 2);
                if (!symbolTable.getName().equals(stringArray[0])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            AppManager.editorConfig.UserDictionaries.add(symbolTable.getName() + "\tT");
        }
        n = AppManager.editorConfig.KeyWidth;
        if (n < 68) {
            n = 68;
        } else if (340 < n) {
            n = 340;
        }
        keyWidth = n;
    }

    public static VsqID getSingerIDUtau(int n, int n2) {
        VsqID vsqID = new VsqID(0);
        vsqID.type = VsqIDType.Singer;
        int n3 = n << 7 | n2;
        if (0 <= n3 && n3 < AppManager.editorConfig.UtauSingers.size()) {
            SingerConfig singerConfig = AppManager.editorConfig.UtauSingers.get(n3);
            vsqID.IconHandle = new IconHandle();
            vsqID.IconHandle.IconID = "$0701" + PortUtil.toHexString(n, 2) + PortUtil.toHexString(n2, 2);
            vsqID.IconHandle.IDS = singerConfig.VOICENAME;
            vsqID.IconHandle.Index = 0;
            vsqID.IconHandle.Language = n;
            vsqID.IconHandle.setLength(1);
            vsqID.IconHandle.Original = n << 8 | n2;
            vsqID.IconHandle.Program = n2;
            vsqID.IconHandle.Caption = "";
            return vsqID;
        }
        vsqID.IconHandle = new IconHandle();
        vsqID.IconHandle.Program = 0;
        vsqID.IconHandle.Language = 0;
        vsqID.IconHandle.IconID = "$0701" + PortUtil.toHexString(0L, 4);
        vsqID.IconHandle.IDS = "Unknown";
        vsqID.type = VsqIDType.Singer;
        return vsqID;
    }

    public static SingerConfig getSingerInfoUtau(int n, int n2) {
        int n3 = n << 7 | n2;
        if (0 <= n3 && n3 < AppManager.editorConfig.UtauSingers.size()) {
            return AppManager.editorConfig.UtauSingers.get(n3);
        }
        return null;
    }

    public static SingerConfig getSingerInfoAquesTone(int n) {
        return null;
    }

    public static VsqID getSingerIDAquesTone(int n) {
        VsqID vsqID = new VsqID(0);
        vsqID.type = VsqIDType.Singer;
        int n2 = -1;
        vsqID.IconHandle = new IconHandle();
        vsqID.IconHandle.Program = 0;
        vsqID.IconHandle.Language = 0;
        vsqID.IconHandle.IconID = "$0701" + PortUtil.toHexString(0L, 2) + PortUtil.toHexString(0L, 2);
        vsqID.IconHandle.IDS = "Unknown";
        vsqID.type = VsqIDType.Singer;
        return vsqID;
    }

    public static Color getHilightColor() {
        return s_hilight_brush;
    }

    public static void setHilightColor(Color color) {
        s_hilight_brush = color;
    }

    public static int getBaseTempo() {
        return s_super_tempo;
    }

    public static void setBaseTempo(int n) {
        s_super_tempo = n;
    }

    static {
        s_file = "";
        s_selected = 1;
        s_current_clock = 0;
        s_playing = false;
        s_repeat_mode = false;
        s_grid_visible = false;
        s_edit_mode = EditMode.NONE;
        s_overlay = true;
        s_selected_events = new Vector();
        s_selected_tempo = new TreeMap();
        s_last_selected_tempo = -1;
        s_selected_timesig = new TreeMap();
        s_last_selected_timesig = -1;
        s_selected_tool = EditTool.PENCIL;
        s_commands = new Vector();
        s_command_position = -1;
        s_selected_bezier = new Vector();
        s_last_selected_bezier = new SelectedBezierPoint();
        s_current_play_position = new PlayPositionSpecifier();
        selectedPointCurveType = CurveType.Empty;
        selectedPointIDs = new Vector();
        playingPropertyLocker = new Object();
        wholeSelectedIntervalEnabled = false;
        wholeSelectedInterval = new SelectedRegion(0);
        curveSelectingRectangle = new Rectangle();
        curveSelectedInterval = new SelectedRegion(0);
        curveSelectedIntervalEnabled = false;
        wholeSelectedIntervalStartForMoving = 0;
        autoNormalize = false;
        endMarker = 0;
        endMarkerEnabled = false;
        scaleX = 0.1f;
        startMarker = 0;
        s_is_curve_mode = false;
        startMarkerEnabled = false;
        autoScroll = true;
        firstBufferWritten = false;
        rendererAvailable = false;
        selectedPaletteTool = "";
        lastScreenStatus = new ScreenStatus();
        s_id = "";
        mainWindow = null;
        inputTextBox = null;
        drawStartIndex = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        isPointerDowned = false;
        mouseDownLocation = new Point();
        utauVoiceDB = new TreeMap();
        lastRenderedStatus = new RenderedStatus[16];
        renderingStatusSerializer = new XmlSerializer(RenderedStatus.class);
        tempWaveDir = "";
        forbidFlipPlayingThresholdSeconds = 0.2;
        curveOnPianoroll = false;
        curveOnPianorollMouseTrace = null;
        skipDrawingWaveformWhenPlaying = true;
        drawItemBorderInControlCurveView = true;
        drawCurveDotInControlCurveView = true;
        drawOverSynthNameOnPianoroll = true;
        vibratoLengthEditingRule = VibratoLengthEditingRule.PERCENTAGE;
        showContextMenuWhenRightClickedOnPianoroll = false;
        gridVisibleChangedEvent = new BEvent();
        previewStartedEvent = new BEvent();
        previewAbortedEvent = new BEvent();
        selectedEventChangedEvent = new BEvent();
        selectedToolChangedEvent = new BEvent();
        currentClockChangedEvent = new BEvent();
    }
}

