/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.PortUtil;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.BezierChain;
import org.kbinani.cadencii.BezierControlType;
import org.kbinani.cadencii.BezierPickedSide;
import org.kbinani.cadencii.BezierPoint;
import org.kbinani.cadencii.CurveType;
import org.kbinani.cadencii.Resources;
import org.kbinani.cadencii.TrackSelector;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BCheckBox;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BGroupBox;
import org.kbinani.windows.forms.BLabel;
import org.kbinani.windows.forms.BMouseButtons;
import org.kbinani.windows.forms.BMouseEventArgs;
import org.kbinani.windows.forms.BMouseEventHandler;
import org.kbinani.windows.forms.BTextBox;

public class FormBezierPointEdit
extends BDialog {
    private BezierPoint m_point;
    private int m_min;
    private int m_max;
    private Point m_last_mouse_global_location;
    private TrackSelector m_parent;
    private boolean m_btn_datapoint_downed = false;
    private double m_min_opacity = 0.4;
    private CurveType m_curve_type;
    private int m_track;
    private int m_chain_id = -1;
    private int m_point_id = -1;
    private BezierPickedSide m_picked_side = BezierPickedSide.BASE;
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private BButton btnBackward = null;
    private BCheckBox chkEnableSmooth = null;
    private BButton btnForward = null;
    private BGroupBox groupLeft = null;
    private BLabel lblLeftClock = null;
    private BTextBox txtLeftClock = null;
    private BLabel lblLeftValue = null;
    private BTextBox txtLeftValue = null;
    private BButton btnLeft = null;
    private BGroupBox groupDataPoint = null;
    private BLabel lblDataPointClock = null;
    private BTextBox txtDataPointClock = null;
    private BLabel lblDataPointValue = null;
    private BTextBox txtDataPointValue = null;
    private BButton btnDataPoint = null;
    private BGroupBox groupRight = null;
    private BLabel lblRightClock = null;
    private BTextBox txtRightClock = null;
    private BLabel lblRightValue = null;
    private BTextBox txtRightValue = null;
    private BButton btnRight = null;
    private BButton btnOK = null;
    private BButton btnCancel = null;
    private BLabel jLabel4 = null;
    private BLabel jLabel5 = null;
    private JPanel jPanel3 = null;

    public FormBezierPointEdit(TrackSelector trackSelector, CurveType curveType, int n, int n2) {
        int n3;
        this.initialize();
        this.registerEventHandlers();
        this.setResources();
        this.applyLanguage();
        this.m_parent = trackSelector;
        this.m_curve_type = curveType;
        this.m_track = AppManager.getSelected();
        this.m_chain_id = n;
        this.m_point_id = n2;
        boolean bl = false;
        Vector<BezierChain> vector = AppManager.getVsqFile().AttachedCurves.get(this.m_track - 1).get(this.m_curve_type);
        for (n3 = 0; n3 < vector.size(); ++n3) {
            if (vector.get((int)n3).id != this.m_chain_id) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        n3 = 0;
        for (BezierPoint bezierPoint : AppManager.getVsqFile().AttachedCurves.get((int)(this.m_track - 1)).getBezierChain((CurveType)this.m_curve_type, (int)this.m_chain_id).points) {
            if (bezierPoint.getID() != this.m_point_id) continue;
            this.m_point = bezierPoint;
            n3 = bezierPoint.getControlLeftType() != BezierControlType.None || bezierPoint.getControlRightType() != BezierControlType.None ? 1 : 0;
            break;
        }
        this.UpdateStatus();
        Util.applyFontRecurse(this, AppManager.editorConfig.getBaseFont());
    }

    public void applyLanguage() {
        this.setTitle(FormBezierPointEdit._("Edit Bezier Data Point"));
        this.groupDataPoint.setTitle(FormBezierPointEdit._("Data Poin"));
        this.lblDataPointClock.setText(FormBezierPointEdit._("Clock"));
        this.lblDataPointValue.setText(FormBezierPointEdit._("Value"));
        this.groupLeft.setTitle(FormBezierPointEdit._("Left Control Point"));
        this.lblLeftClock.setText(FormBezierPointEdit._("Clock"));
        this.lblLeftValue.setText(FormBezierPointEdit._("Value"));
        this.groupRight.setTitle(FormBezierPointEdit._("Right Control Point"));
        this.lblRightClock.setText(FormBezierPointEdit._("Clock"));
        this.lblRightValue.setText(FormBezierPointEdit._("Value"));
        this.chkEnableSmooth.setText(FormBezierPointEdit._("Smooth"));
    }

    private void UpdateStatus() {
        this.txtDataPointClock.setText(this.m_point.getBase().getX() + "");
        this.txtDataPointValue.setText(this.m_point.getBase().getY() + "");
        this.txtLeftClock.setText((int)(this.m_point.getBase().getX() + this.m_point.controlLeft.getX()) + "");
        this.txtLeftValue.setText((int)(this.m_point.getBase().getY() + this.m_point.controlLeft.getY()) + "");
        this.txtRightClock.setText((int)(this.m_point.getBase().getX() + this.m_point.controlRight.getX()) + "");
        this.txtRightValue.setText((int)(this.m_point.getBase().getY() + this.m_point.controlRight.getY()) + "");
        boolean bl = this.m_point.getControlLeftType() != BezierControlType.None || this.m_point.getControlRightType() != BezierControlType.None;
        this.chkEnableSmooth.setSelected(bl);
        this.btnLeft.setEnabled(bl);
        this.btnRight.setEnabled(bl);
        this.m_min = this.m_curve_type.getMinimum();
        this.m_max = this.m_curve_type.getMaximum();
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private void registerEventHandlers() {
        this.btnOK.clickEvent.add(new BEventHandler(this, "btnOK_Click"));
        this.btnCancel.clickEvent.add(new BEventHandler(this, "btnCancel_Click"));
        this.chkEnableSmooth.checkedChangedEvent.add(new BEventHandler(this, "chkEnableSmooth_CheckedChanged"));
        this.btnLeft.mouseMoveEvent.add(new BMouseEventHandler(this, "common_MouseMove"));
        this.btnLeft.mouseDownEvent.add(new BMouseEventHandler(this, "btnLeft_MouseDown"));
        this.btnLeft.mouseUpEvent.add(new BMouseEventHandler(this, "common_MouseUp"));
        this.btnDataPoint.mouseMoveEvent.add(new BMouseEventHandler(this, "common_MouseMove"));
        this.btnDataPoint.mouseDownEvent.add(new BMouseEventHandler(this, "btnDataPoint_MouseDown"));
        this.btnDataPoint.mouseUpEvent.add(new BMouseEventHandler(this, "common_MouseUp"));
        this.btnRight.mouseMoveEvent.add(new BMouseEventHandler(this, "common_MouseMove"));
        this.btnRight.mouseDownEvent.add(new BMouseEventHandler(this, "btnRight_MouseDown"));
        this.btnRight.mouseUpEvent.add(new BMouseEventHandler(this, "common_MouseUp"));
        this.btnBackward.clickEvent.add(new BEventHandler(this, "btnBackward_Click"));
        this.btnForward.clickEvent.add(new BEventHandler(this, "btnForward_Click"));
    }

    private void setResources() {
        this.btnLeft.setIcon(new ImageIcon(Resources.get_target__pencil()));
        this.btnDataPoint.setIcon(new ImageIcon(Resources.get_target__pencil()));
        this.btnRight.setIcon(new ImageIcon(Resources.get_target__pencil()));
    }

    public void btnOK_Click(Object object, BEventArgs bEventArgs) {
        try {
            int n = PortUtil.parseInt(this.txtDataPointClock.getText());
            int n2 = PortUtil.parseInt(this.txtDataPointValue.getText());
            if (n2 < this.m_min || this.m_max < n2) {
                AppManager.showMessageBox(FormBezierPointEdit._("Invalid value"), FormBezierPointEdit._("Error"), -1, 0);
                return;
            }
            if (this.chkEnableSmooth.isSelected()) {
                n = PortUtil.parseInt(this.txtLeftClock.getText());
                n2 = PortUtil.parseInt(this.txtLeftValue.getText());
                n = PortUtil.parseInt(this.txtRightClock.getText());
                n2 = PortUtil.parseInt(this.txtRightValue.getText());
            }
            this.setDialogResult(BDialogResult.OK);
        }
        catch (Exception exception) {
            AppManager.showMessageBox(FormBezierPointEdit._("Integer format error"), FormBezierPointEdit._("Error"), -1, 0);
            this.setDialogResult(BDialogResult.CANCEL);
        }
    }

    public void chkEnableSmooth_CheckedChanged(Object object, BEventArgs bEventArgs) {
        boolean bl;
        boolean bl2 = this.chkEnableSmooth.isSelected();
        this.txtLeftClock.setEnabled(bl2);
        this.txtLeftValue.setEnabled(bl2);
        this.btnLeft.setEnabled(bl2);
        this.txtRightClock.setEnabled(bl2);
        this.txtRightValue.setEnabled(bl2);
        this.btnRight.setEnabled(bl2);
        boolean bl3 = bl = this.m_point.getControlLeftType() != BezierControlType.None || this.m_point.getControlRightType() != BezierControlType.None;
        if (bl2) {
            this.m_point.setControlLeftType(BezierControlType.Normal);
            this.m_point.setControlRightType(BezierControlType.Normal);
        } else {
            this.m_point.setControlLeftType(BezierControlType.None);
            this.m_point.setControlRightType(BezierControlType.None);
        }
        this.txtLeftClock.setText((int)(this.m_point.getBase().getX() + this.m_point.controlLeft.getX()) + "");
        this.txtLeftValue.setText((int)(this.m_point.getBase().getY() + this.m_point.controlLeft.getY()) + "");
        this.txtRightClock.setText((int)(this.m_point.getBase().getX() + this.m_point.controlRight.getX()) + "");
        this.txtRightValue.setText((int)(this.m_point.getBase().getY() + this.m_point.controlRight.getY()) + "");
        this.m_parent.invalidate();
    }

    public void btnDataPoint_MouseDown(Object object, BMouseEventArgs bMouseEventArgs) {
        this.m_last_mouse_global_location = PortUtil.getMousePosition();
        Point point = new Point(AppManager.xCoordFromClocks((int)this.m_point.getBase().getX()), this.m_parent.yCoordFromValue((int)this.m_point.getBase().getY()));
        Point point2 = this.m_parent.getLocationOnScreen();
        Point point3 = new Point(point2.x + point.x, point2.y + point.y);
        PortUtil.setMousePosition(point3);
        BMouseEventArgs bMouseEventArgs2 = new BMouseEventArgs(BMouseButtons.Left, 0, point.x, point.y, 0);
        this.m_parent.TrackSelector_MouseDown(this, bMouseEventArgs2);
        this.m_picked_side = BezierPickedSide.BASE;
        this.m_btn_datapoint_downed = true;
    }

    public void btnLeft_MouseDown(Object object, BMouseEventArgs bMouseEventArgs) {
        this.setVisible(false);
        this.m_last_mouse_global_location = PortUtil.getMousePosition();
        Point point = new Point(AppManager.xCoordFromClocks((int)this.m_point.getControlLeft().getX()), this.m_parent.yCoordFromValue((int)this.m_point.getControlLeft().getY()));
        Point point2 = this.m_parent.getLocationOnScreen();
        Point point3 = new Point(point.x + point2.x, point.y + point2.y);
        PortUtil.setMousePosition(point3);
        BMouseEventArgs bMouseEventArgs2 = new BMouseEventArgs(BMouseButtons.Left, 0, point.x, point.y, 0);
        this.m_parent.TrackSelector_MouseDown(this, bMouseEventArgs2);
        this.m_picked_side = BezierPickedSide.LEFT;
        this.m_btn_datapoint_downed = true;
    }

    public void btnRight_MouseDown(Object object, BMouseEventArgs bMouseEventArgs) {
        this.setVisible(false);
        this.m_last_mouse_global_location = PortUtil.getMousePosition();
        Point point = new Point(AppManager.xCoordFromClocks((int)this.m_point.getControlRight().getX()), this.m_parent.yCoordFromValue((int)this.m_point.getControlRight().getY()));
        Point point2 = this.m_parent.getLocationOnScreen();
        Point point3 = new Point(point.x + point2.x, point.y + point2.y);
        PortUtil.setMousePosition(point3);
        BMouseEventArgs bMouseEventArgs2 = new BMouseEventArgs(BMouseButtons.Left, 0, point.x, point.y, 0);
        this.m_parent.TrackSelector_MouseDown(this, bMouseEventArgs2);
        this.m_picked_side = BezierPickedSide.RIGHT;
        this.m_btn_datapoint_downed = true;
    }

    public void common_MouseUp(Object object, BMouseEventArgs bMouseEventArgs) {
        this.m_btn_datapoint_downed = false;
        this.setVisible(true);
        Point point = PortUtil.getMousePosition();
        Point point2 = this.m_parent.getLocationOnScreen();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        BMouseEventArgs bMouseEventArgs2 = new BMouseEventArgs(BMouseButtons.Left, 0, point3.x, point3.y, 0);
        this.m_parent.TrackSelector_MouseUp(this, bMouseEventArgs2);
        PortUtil.setMousePosition(this.m_last_mouse_global_location);
        this.m_parent.invalidate();
    }

    public void common_MouseMove(Object object, BMouseEventArgs bMouseEventArgs) {
        if (this.m_btn_datapoint_downed) {
            Point point = PortUtil.getMousePosition();
            Point point2 = this.m_parent.getLocationOnScreen();
            Point point3 = new Point(point.x - point2.x, point.y - point2.y);
            BMouseEventArgs bMouseEventArgs2 = new BMouseEventArgs(BMouseButtons.Left, 0, point3.x, point3.y, 0);
            BezierPoint bezierPoint = this.m_parent.HandleMouseMoveForBezierMove(bMouseEventArgs2, this.m_picked_side);
            this.txtDataPointClock.setText((int)bezierPoint.getBase().getX() + "");
            this.txtDataPointValue.setText((int)bezierPoint.getBase().getY() + "");
            this.txtLeftClock.setText((int)bezierPoint.getControlLeft().getX() + "");
            this.txtLeftValue.setText((int)bezierPoint.getControlLeft().getY() + "");
            this.txtRightClock.setText((int)bezierPoint.getControlRight().getX() + "");
            this.txtRightValue.setText((int)bezierPoint.getControlRight().getY() + "");
            this.m_parent.invalidate();
        }
    }

    public void btnBackward_Click(Object object, BEventArgs bEventArgs) {
        BezierChain bezierChain = AppManager.getVsqFile().AttachedCurves.get(this.m_track - 1).getBezierChain(this.m_curve_type, this.m_chain_id);
        int n = -1;
        for (int i = 0; i < bezierChain.size(); ++i) {
            if (bezierChain.points.get(i).getID() != this.m_point_id) continue;
            n = i - 1;
            break;
        }
        if (0 <= n) {
            this.m_point_id = bezierChain.points.get(n).getID();
            this.m_point = bezierChain.points.get(n);
            this.UpdateStatus();
            this.m_parent.EditingPointID = this.m_point_id;
            this.m_parent.invalidate();
        }
    }

    public void btnForward_Click(Object object, BEventArgs bEventArgs) {
        BezierChain bezierChain = AppManager.getVsqFile().AttachedCurves.get(this.m_track - 1).getBezierChain(this.m_curve_type, this.m_chain_id);
        int n = -2;
        for (int i = 0; i < bezierChain.size(); ++i) {
            if (bezierChain.points.get(i).getID() != this.m_point_id) continue;
            n = i + 1;
            break;
        }
        if (0 <= n && n < bezierChain.size()) {
            this.m_point_id = bezierChain.points.get(n).getID();
            this.m_point = bezierChain.points.get(n);
            this.UpdateStatus();
            this.m_parent.EditingPointID = this.m_point_id;
            this.m_parent.invalidate();
        }
    }

    public void btnCancel_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.CANCEL);
    }

    private void initialize() {
        this.setSize(469, 266);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Edit Bezier Data Point");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 4;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridwidth = 3;
            gridBagConstraints2.gridy = 3;
            this.jLabel5 = new BLabel();
            this.jLabel5.setText("    ");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridwidth = 3;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 1;
            this.jLabel4 = new BLabel();
            this.jLabel4.setText("     ");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints5.gridy = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.gridy = 2;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints7.gridy = 2;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 2;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridy = 0;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridy = 0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.anchor = 13;
            gridBagConstraints10.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getBtnBackward(), gridBagConstraints10);
            this.jContentPane.add((Component)this.getChkEnableSmooth(), gridBagConstraints9);
            this.jContentPane.add((Component)this.getBtnForward(), gridBagConstraints8);
            this.jContentPane.add((Component)this.getGroupLeft(), gridBagConstraints7);
            this.jContentPane.add((Component)this.getGroupDataPoint(), gridBagConstraints6);
            this.jContentPane.add((Component)this.getGroupRight(), gridBagConstraints5);
            this.jContentPane.add((Component)this.jLabel4, gridBagConstraints3);
            this.jContentPane.add((Component)this.jLabel5, gridBagConstraints2);
            this.jContentPane.add((Component)this.getJPanel3(), gridBagConstraints);
            this.jContentPane.add((Component)this.jLabel4, gridBagConstraints4);
        }
        return this.jContentPane;
    }

    private BButton getBtnBackward() {
        if (this.btnBackward == null) {
            this.btnBackward = new BButton();
            this.btnBackward.setText("<<");
        }
        return this.btnBackward;
    }

    private BCheckBox getChkEnableSmooth() {
        if (this.chkEnableSmooth == null) {
            this.chkEnableSmooth = new BCheckBox();
            this.chkEnableSmooth.setText("Smooth");
        }
        return this.chkEnableSmooth;
    }

    private BButton getBtnForward() {
        if (this.btnForward == null) {
            this.btnForward = new BButton();
            this.btnForward.setText(">>");
        }
        return this.btnForward;
    }

    private JPanel getGroupLeft() {
        if (this.groupLeft == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.insets = new Insets(5, 20, 5, 20);
            gridBagConstraints.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 15);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(0, 15, 0, 0);
            gridBagConstraints3.gridy = 1;
            this.lblLeftValue = new BLabel();
            this.lblLeftValue.setText("Value");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 15);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(0, 15, 0, 0);
            gridBagConstraints5.gridy = 0;
            this.lblLeftClock = new BLabel();
            this.lblLeftClock.setText("Clock");
            this.groupLeft = new BGroupBox();
            this.groupLeft.setLayout(new GridBagLayout());
            this.groupLeft.setTitle("Left Control Point");
            this.groupLeft.add((Component)this.lblLeftClock, gridBagConstraints5);
            this.groupLeft.add((Component)this.getJTextField(), gridBagConstraints4);
            this.groupLeft.add((Component)this.lblLeftValue, gridBagConstraints3);
            this.groupLeft.add((Component)this.getTxtLeftValue(), gridBagConstraints2);
            this.groupLeft.add((Component)this.getBtnLeft(), gridBagConstraints);
        }
        return this.groupLeft;
    }

    private BTextBox getJTextField() {
        if (this.txtLeftClock == null) {
            this.txtLeftClock = new BTextBox();
        }
        return this.txtLeftClock;
    }

    private BTextBox getTxtLeftValue() {
        if (this.txtLeftValue == null) {
            this.txtLeftValue = new BTextBox();
        }
        return this.txtLeftValue;
    }

    private BButton getBtnLeft() {
        if (this.btnLeft == null) {
            this.btnLeft = new BButton();
            this.btnLeft.setText("");
            this.btnLeft.setIcon(new ImageIcon(this.getClass().getResource("/target--pencil.png")));
        }
        return this.btnLeft;
    }

    private JPanel getGroupDataPoint() {
        if (this.groupDataPoint == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 20, 5, 20);
            gridBagConstraints.gridwidth = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 15);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 15, 0, 0);
            gridBagConstraints3.gridy = 1;
            this.lblDataPointValue = new BLabel();
            this.lblDataPointValue.setText("Value");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 15);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(0, 15, 0, 0);
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridy = 0;
            this.lblDataPointClock = new BLabel();
            this.lblDataPointClock.setText("Clock");
            this.groupDataPoint = new BGroupBox();
            this.groupDataPoint.setLayout(new GridBagLayout());
            this.groupDataPoint.setTitle("Data Point");
            this.groupDataPoint.add((Component)this.lblDataPointClock, gridBagConstraints5);
            this.groupDataPoint.add((Component)this.getTxtDataPointClock(), gridBagConstraints4);
            this.groupDataPoint.add((Component)this.lblDataPointValue, gridBagConstraints3);
            this.groupDataPoint.add((Component)this.getTxtDataPointValue(), gridBagConstraints2);
            this.groupDataPoint.add((Component)this.getBtnDataPoint(), gridBagConstraints);
        }
        return this.groupDataPoint;
    }

    private BTextBox getTxtDataPointClock() {
        if (this.txtDataPointClock == null) {
            this.txtDataPointClock = new BTextBox();
        }
        return this.txtDataPointClock;
    }

    private BTextBox getTxtDataPointValue() {
        if (this.txtDataPointValue == null) {
            this.txtDataPointValue = new BTextBox();
        }
        return this.txtDataPointValue;
    }

    private BButton getBtnDataPoint() {
        if (this.btnDataPoint == null) {
            this.btnDataPoint = new BButton();
            this.btnDataPoint.setText("");
            this.btnDataPoint.setIcon(new ImageIcon(this.getClass().getResource("/target--pencil.png")));
        }
        return this.btnDataPoint;
    }

    private JPanel getGroupRight() {
        if (this.groupRight == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 20, 5, 20);
            gridBagConstraints.gridwidth = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 15);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(0, 15, 0, 0);
            gridBagConstraints3.gridy = 1;
            this.lblRightValue = new BLabel();
            this.lblRightValue.setText("Value");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 15);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(0, 15, 0, 0);
            gridBagConstraints5.gridy = 0;
            this.lblRightClock = new BLabel();
            this.lblRightClock.setText("Clock");
            this.groupRight = new BGroupBox();
            this.groupRight.setLayout(new GridBagLayout());
            this.groupRight.setTitle("Right Control Point");
            this.groupRight.add((Component)this.lblRightClock, gridBagConstraints5);
            this.groupRight.add((Component)this.getTxtRightClock(), gridBagConstraints4);
            this.groupRight.add((Component)this.lblRightValue, gridBagConstraints3);
            this.groupRight.add((Component)this.getTxtRightValue(), gridBagConstraints2);
            this.groupRight.add((Component)this.getBtnRight(), gridBagConstraints);
        }
        return this.groupRight;
    }

    private BTextBox getTxtRightClock() {
        if (this.txtRightClock == null) {
            this.txtRightClock = new BTextBox();
        }
        return this.txtRightClock;
    }

    private BTextBox getTxtRightValue() {
        if (this.txtRightValue == null) {
            this.txtRightValue = new BTextBox();
        }
        return this.txtRightValue;
    }

    private BButton getBtnRight() {
        if (this.btnRight == null) {
            this.btnRight = new BButton();
            this.btnRight.setText("");
            this.btnRight.setIcon(new ImageIcon(this.getClass().getResource("/target--pencil.png")));
        }
        return this.btnRight;
    }

    private BButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new BButton();
            this.btnOK.setText("OK");
        }
        return this.btnOK;
    }

    private BButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new BButton();
            this.btnCancel.setText("Cancel");
        }
        return this.btnCancel;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints2.gridy = 0;
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
            this.jPanel3.add((Component)this.getBtnCancel(), gridBagConstraints2);
            this.jPanel3.add((Component)this.getBtnOK(), gridBagConstraints);
        }
        return this.jPanel3;
    }
}

