/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.PortUtil;
import org.kbinani.apputil.Messaging;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.CadenciiCommand;
import org.kbinani.cadencii.CurveType;
import org.kbinani.cadencii.EditedZone;
import org.kbinani.cadencii.EditedZoneUnit;
import org.kbinani.cadencii.Utility;
import org.kbinani.cadencii.VsqBPListComparisonContext;
import org.kbinani.cadencii.VsqFileEx;
import org.kbinani.vsq.VsqBPList;
import org.kbinani.vsq.VsqBPPair;
import org.kbinani.vsq.VsqBPPairSearchContext;
import org.kbinani.vsq.VsqCommand;
import org.kbinani.vsq.VsqTrack;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BKeyEventArgs;
import org.kbinani.windows.forms.BKeyEventHandler;
import org.kbinani.windows.forms.BTextBox;

public class FormCurvePointEdit
extends BDialog {
    long m_editing_id = -1L;
    CurveType m_curve;
    boolean m_changed = false;
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private BButton btnBackward3 = null;
    private BButton btnBackward2 = null;
    private BButton btnBackward = null;
    private BButton btnForward = null;
    private BButton btnForward2 = null;
    private BButton btnForward3 = null;
    private JPanel jPanel1 = null;
    private JLabel lblDataPointValue = null;
    private BTextBox txtDataPointValue = null;
    private BButton btnUndo = null;
    private JLabel lblDataPointClock = null;
    private BTextBox txtDataPointClock = null;
    private BButton btnRedo = null;
    private JPanel jPanel3 = null;
    private BButton btnExit = null;
    private BButton btnApply = null;

    public FormCurvePointEdit(long l, CurveType curveType) {
        this.initialize();
        this.registerEventHandlers();
        this.setResources();
        this.applyLanguage();
        this.m_editing_id = l;
        this.m_curve = curveType;
        VsqBPPairSearchContext vsqBPPairSearchContext = ((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected())).getCurve(this.m_curve.getName()).findElement(this.m_editing_id);
        this.txtDataPointClock.setText(vsqBPPairSearchContext.clock + "");
        this.txtDataPointValue.setText(vsqBPPairSearchContext.point.value + "");
        this.txtDataPointValue.selectAll();
        this.btnUndo.setEnabled(AppManager.isUndoAvailable());
        this.btnRedo.setEnabled(AppManager.isRedoAvailable());
    }

    public void applyLanguage() {
        this.setTitle(this._("Edit Value"));
        this.lblDataPointClock.setText(this._("Clock"));
        this.lblDataPointValue.setText(this._("Value"));
        this.btnApply.setText(this._("Apply"));
        this.btnExit.setText(this._("Exit"));
    }

    private String _(String string) {
        return Messaging.getMessage(string);
    }

    private void applyValue(boolean bl) {
        if (!this.m_changed) {
            return;
        }
        int n = this.m_curve.getDefault();
        try {
            n = PortUtil.parseInt(this.txtDataPointValue.getText());
        }
        catch (Exception exception) {
            return;
        }
        if (n < this.m_curve.getMinimum()) {
            n = this.m_curve.getMinimum();
        } else if (this.m_curve.getMaximum() < n) {
            n = this.m_curve.getMaximum();
        }
        int n2 = 0;
        try {
            n2 = PortUtil.parseInt(this.txtDataPointClock.getText());
        }
        catch (Exception exception) {
            return;
        }
        int n3 = AppManager.getSelected();
        VsqTrack vsqTrack = (VsqTrack)AppManager.getVsqFile().Track.get(n3);
        VsqBPList vsqBPList = vsqTrack.getCurve(this.m_curve.getName());
        VsqBPList vsqBPList2 = (VsqBPList)vsqBPList.clone();
        VsqBPPairSearchContext vsqBPPairSearchContext = vsqBPList2.findElement(this.m_editing_id);
        vsqBPList2.move(vsqBPPairSearchContext.clock, n2, n);
        CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandTrackCurveReplace(n3, this.m_curve.getName(), vsqBPList2));
        EditedZone editedZone = new EditedZone();
        Utility.compareList(editedZone, new VsqBPListComparisonContext(vsqBPList2, vsqBPList));
        Vector<EditedZoneUnit> vector = new Vector<EditedZoneUnit>();
        Iterator<EditedZoneUnit> iterator = editedZone.iterator();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        AppManager.register(AppManager.getVsqFile().executeCommand(cadenciiCommand));
        this.txtDataPointClock.setText(n2 + "");
        this.txtDataPointValue.setText(n + "");
        if (AppManager.mainWindow != null) {
            AppManager.mainWindow.setEdited(true);
            AppManager.mainWindow.ensureVisible(n2);
            AppManager.mainWindow.refreshScreen();
        }
        if (bl) {
            this.txtDataPointClock.selectAll();
        } else {
            this.txtDataPointValue.selectAll();
        }
        this.btnUndo.setEnabled(AppManager.isUndoAvailable());
        this.btnRedo.setEnabled(AppManager.isRedoAvailable());
        this.m_changed = false;
    }

    private void setResources() {
    }

    private void registerEventHandlers() {
        this.btnForward.clickEvent.add(new BEventHandler(this, "commonButton_Click"));
        this.btnBackward.clickEvent.add(new BEventHandler(this, "commonButton_Click"));
        this.btnBackward2.clickEvent.add(new BEventHandler(this, "commonButton_Click"));
        this.btnForward2.clickEvent.add(new BEventHandler(this, "commonButton_Click"));
        this.btnApply.clickEvent.add(new BEventHandler(this, "btnApply_Click"));
        this.txtDataPointClock.textChangedEvent.add(new BEventHandler(this, "commonTextBox_TextChanged"));
        this.txtDataPointClock.keyUpEvent.add(new BKeyEventHandler(this, "commonTextBox_KeyUp"));
        this.txtDataPointValue.textChangedEvent.add(new BEventHandler(this, "commonTextBox_TextChanged"));
        this.txtDataPointValue.keyUpEvent.add(new BKeyEventHandler(this, "commonTextBox_KeyUp"));
        this.btnBackward3.clickEvent.add(new BEventHandler(this, "commonButton_Click"));
        this.btnForward3.clickEvent.add(new BEventHandler(this, "commonButton_Click"));
        this.btnUndo.clickEvent.add(new BEventHandler(this, "handleUndoRedo_Click"));
        this.btnRedo.clickEvent.add(new BEventHandler(this, "handleUndoRedo_Click"));
        this.btnExit.clickEvent.add(new BEventHandler(this, "btnExit_Click"));
    }

    public void commonTextBox_KeyUp(Object object, BKeyEventArgs bKeyEventArgs) {
        if ((bKeyEventArgs.KeyValue & 0xA) != 10) {
            return;
        }
        this.applyValue(object == this.txtDataPointClock);
    }

    public void commonButton_Click(Object object, BEventArgs bEventArgs) {
        VsqBPList vsqBPList = ((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected())).getCurve(this.m_curve.getName());
        VsqBPPairSearchContext vsqBPPairSearchContext = vsqBPList.findElement(this.m_editing_id);
        int n = vsqBPPairSearchContext.index;
        if (object == this.btnForward) {
            ++n;
        } else if (object == this.btnBackward) {
            --n;
        } else if (object == this.btnBackward2) {
            n -= 5;
        } else if (object == this.btnForward2) {
            n += 5;
        } else if (object == this.btnForward3) {
            n += 10;
        } else if (object == this.btnBackward3) {
            n -= 10;
        }
        if (n < 0) {
            n = 0;
        }
        if (vsqBPList.size() <= n) {
            n = vsqBPList.size() - 1;
        }
        VsqBPPair vsqBPPair = vsqBPList.getElementB(n);
        this.m_editing_id = vsqBPPair.id;
        int n2 = vsqBPList.getKeyClock(n);
        this.txtDataPointClock.textChangedEvent.remove(new BEventHandler(this, "commonTextBox_TextChanged"));
        this.txtDataPointValue.textChangedEvent.remove(new BEventHandler(this, "commonTextBox_TextChanged"));
        this.txtDataPointClock.setText(n2 + "");
        this.txtDataPointValue.setText(vsqBPPair.value + "");
        this.txtDataPointClock.textChangedEvent.add(new BEventHandler(this, "commonTextBox_TextChanged"));
        this.txtDataPointValue.textChangedEvent.add(new BEventHandler(this, "commonTextBox_TextChanged"));
        this.txtDataPointValue.requestFocus();
        this.txtDataPointValue.selectAll();
        AppManager.clearSelectedPoint();
        AppManager.addSelectedPoint(this.m_curve, vsqBPPair.id);
        if (AppManager.mainWindow != null) {
            AppManager.mainWindow.ensureVisible(n2);
            AppManager.mainWindow.refreshScreen();
        }
    }

    public void btnApply_Click(Object object, BEventArgs bEventArgs) {
        this.applyValue(true);
    }

    public void commonTextBox_TextChanged(Object object, BEventArgs bEventArgs) {
        this.m_changed = true;
    }

    public void handleUndoRedo_Click(Object object, BEventArgs bEventArgs) {
        if (object == this.btnUndo) {
            AppManager.undo();
        } else if (object == this.btnRedo) {
            AppManager.redo();
        } else {
            return;
        }
        VsqFileEx vsqFileEx = AppManager.getVsqFile();
        boolean bl = false;
        if (vsqFileEx != null) {
            bl = ((VsqTrack)vsqFileEx.Track.get((int)AppManager.getSelected())).getCurve((String)this.m_curve.getName()).findElement((long)this.m_editing_id).index >= 0;
        }
        this.txtDataPointClock.setEnabled(bl);
        this.txtDataPointValue.setEnabled(bl);
        this.btnApply.setEnabled(bl);
        this.btnBackward.setEnabled(bl);
        this.btnBackward2.setEnabled(bl);
        this.btnBackward3.setEnabled(bl);
        this.btnForward.setEnabled(bl);
        this.btnForward2.setEnabled(bl);
        this.btnForward3.setEnabled(bl);
        if (bl) {
            AppManager.clearSelectedPoint();
            AppManager.addSelectedPoint(this.m_curve, this.m_editing_id);
        }
        if (AppManager.mainWindow != null) {
            AppManager.mainWindow.updateDrawObjectList();
            AppManager.mainWindow.refreshScreen();
        }
        this.btnUndo.setEnabled(AppManager.isUndoAvailable());
        this.btnRedo.setEnabled(AppManager.isRedoAvailable());
    }

    public void btnExit_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.CANCEL);
    }

    private void initialize() {
        this.setSize(new Dimension(322, 198));
        this.setTitle("FormCurvePointEdit");
        this.setContentPane(this.getJPanel1());
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 5;
            gridBagConstraints.insets = new Insets(0, 1, 0, 1);
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 4;
            gridBagConstraints2.insets = new Insets(0, 1, 0, 1);
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.insets = new Insets(0, 1, 0, 1);
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.insets = new Insets(0, 1, 0, 1);
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.insets = new Insets(0, 1, 0, 1);
            gridBagConstraints5.gridy = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(0, 1, 0, 1);
            gridBagConstraints6.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getBtnBackward3(), gridBagConstraints6);
            this.jPanel.add((Component)this.getBtnBackward2(), gridBagConstraints5);
            this.jPanel.add((Component)this.getBtnBackward(), gridBagConstraints4);
            this.jPanel.add((Component)this.getBtnForward(), gridBagConstraints3);
            this.jPanel.add((Component)this.getBtnForward2(), gridBagConstraints2);
            this.jPanel.add((Component)this.getBtnForward3(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private BButton getBtnBackward3() {
        if (this.btnBackward3 == null) {
            this.btnBackward3 = new BButton();
            this.btnBackward3.setText("<10");
            this.btnBackward3.setPreferredSize(new Dimension(55, 30));
        }
        return this.btnBackward3;
    }

    private BButton getBtnBackward2() {
        if (this.btnBackward2 == null) {
            this.btnBackward2 = new BButton();
            this.btnBackward2.setText("<5");
            this.btnBackward2.setPreferredSize(new Dimension(48, 30));
        }
        return this.btnBackward2;
    }

    private BButton getBtnBackward() {
        if (this.btnBackward == null) {
            this.btnBackward = new BButton();
            this.btnBackward.setText("<");
            this.btnBackward.setPreferredSize(new Dimension(41, 30));
        }
        return this.btnBackward;
    }

    private BButton getBtnForward() {
        if (this.btnForward == null) {
            this.btnForward = new BButton();
            this.btnForward.setText(">");
            this.btnForward.setPreferredSize(new Dimension(41, 30));
        }
        return this.btnForward;
    }

    private BButton getBtnForward2() {
        if (this.btnForward2 == null) {
            this.btnForward2 = new BButton();
            this.btnForward2.setText("5>");
            this.btnForward2.setPreferredSize(new Dimension(48, 30));
        }
        return this.btnForward2;
    }

    private BButton getBtnForward3() {
        if (this.btnForward3 == null) {
            this.btnForward3 = new BButton();
            this.btnForward3.setText("10>");
            this.btnForward3.setPreferredSize(new Dimension(55, 30));
        }
        return this.btnForward3;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(12, 0, 12, 0);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(4, 0, 0, 12);
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(4, 0, 0, 0);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 12;
            gridBagConstraints4.insets = new Insets(4, 0, 0, 0);
            gridBagConstraints4.gridy = 2;
            this.lblDataPointClock = new JLabel();
            this.lblDataPointClock.setText("Clock");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.insets = new Insets(4, 0, 0, 12);
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridwidth = 3;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.insets = new Insets(12, 0, 12, 0);
            gridBagConstraints6.gridx = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 0;
            gridBagConstraints7.gridy = 1;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(4, 0, 0, 0);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 13;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(4, 0, 0, 0);
            gridBagConstraints8.gridy = 1;
            this.lblDataPointValue = new JLabel();
            this.lblDataPointValue.setText("Value");
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.add((Component)this.getJPanel(), gridBagConstraints6);
            this.jPanel1.add((Component)this.lblDataPointValue, gridBagConstraints8);
            this.jPanel1.add((Component)this.getTxtDataPointValue(), gridBagConstraints7);
            this.jPanel1.add((Component)this.getBtnUndo(), gridBagConstraints5);
            this.jPanel1.add((Component)this.lblDataPointClock, gridBagConstraints4);
            this.jPanel1.add((Component)this.getTxtDataPointClock(), gridBagConstraints3);
            this.jPanel1.add((Component)this.getBtnRedo(), gridBagConstraints2);
            this.jPanel1.add((Component)this.getJPanel3(), gridBagConstraints);
        }
        return this.jPanel1;
    }

    private BTextBox getTxtDataPointValue() {
        if (this.txtDataPointValue == null) {
            this.txtDataPointValue = new BTextBox();
            this.txtDataPointValue.setPreferredSize(new Dimension(71, 20));
        }
        return this.txtDataPointValue;
    }

    private BButton getBtnUndo() {
        if (this.btnUndo == null) {
            this.btnUndo = new BButton();
            this.btnUndo.setText("undo");
            this.btnUndo.setPreferredSize(new Dimension(63, 23));
        }
        return this.btnUndo;
    }

    private BTextBox getTxtDataPointClock() {
        if (this.txtDataPointClock == null) {
            this.txtDataPointClock = new BTextBox();
            this.txtDataPointClock.setPreferredSize(new Dimension(71, 20));
        }
        return this.txtDataPointClock;
    }

    private BButton getBtnRedo() {
        if (this.btnRedo == null) {
            this.btnRedo = new BButton();
            this.btnRedo.setText("redo");
            this.btnRedo.setPreferredSize(new Dimension(63, 23));
        }
        return this.btnRedo;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 2;
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
            this.jPanel3.add((Component)this.getBtnExit(), gridBagConstraints2);
            this.jPanel3.add((Component)this.getBtnApply(), gridBagConstraints);
        }
        return this.jPanel3;
    }

    private BButton getBtnExit() {
        if (this.btnExit == null) {
            this.btnExit = new BButton();
            this.btnExit.setText("Exit");
        }
        return this.btnExit;
    }

    private BButton getBtnApply() {
        if (this.btnApply == null) {
            this.btnApply = new BButton();
            this.btnApply.setText("Apply");
        }
        return this.btnApply;
    }
}

