/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.Resources;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BLabel;
import org.kbinani.windows.forms.BPanel;
import org.kbinani.windows.forms.BPictureBox;
import org.kbinani.windows.forms.BProgressBar;
import org.kbinani.windows.forms.BTimer;

public class FormGameControlerConfig
extends BDialog {
    private Vector<Integer> m_list = new Vector();
    private Vector<Integer> m_povs = new Vector();
    private int index;
    private BTimer timer;
    private static final long serialVersionUID = 1L;
    private BPanel BPanel = null;
    private BLabel lblMessage = null;
    private BPictureBox pictButton = null;
    private BProgressBar progressCount = null;
    private BButton btnSkip = null;
    private BButton btnReset = null;
    private BPanel jPanel11 = null;
    private BButton btnOK = null;
    private BButton btnCancel = null;
    private BLabel jLabel4 = null;

    public FormGameControlerConfig() {
        int n;
        this.initialize();
        this.timer = new BTimer();
        this.registerEventHandlers();
        this.setResources();
        for (n = 0; n < 10; ++n) {
            this.m_list.add(-1);
        }
        for (n = 0; n < 4; ++n) {
            this.m_povs.add(Integer.MIN_VALUE);
        }
        this.applyLanguage();
        n = 0;
        if (n > 0) {
            this.pictButton.setImage(Resources.get_btn1());
            this.progressCount.setMaximum(8);
            this.progressCount.setMinimum(0);
            this.progressCount.setValue(0);
            this.index = 1;
            this.btnSkip.setEnabled(true);
            this.btnReset.setEnabled(true);
            this.timer.start();
        } else {
            this.btnSkip.setEnabled(false);
            this.btnReset.setEnabled(false);
        }
        Util.applyFontRecurse(this, AppManager.editorConfig.getBaseFont());
    }

    public void applyLanguage() {
        int n = 0;
        if (n > 0) {
            this.lblMessage.setText(FormGameControlerConfig._("Push buttons in turn as shown below"));
        } else {
            this.lblMessage.setText(FormGameControlerConfig._("Game controler instanceof not available"));
        }
        this.setTitle(FormGameControlerConfig._("Game Controler Configuration"));
        this.btnOK.setText(FormGameControlerConfig._("OK"));
        this.btnCancel.setText(FormGameControlerConfig._("Cancel"));
        this.btnReset.setText(FormGameControlerConfig._("Reset And Exit"));
        this.btnSkip.setText(FormGameControlerConfig._("Skip"));
    }

    public int getRectangle() {
        return this.m_list.get(0);
    }

    public int getTriangle() {
        return this.m_list.get(1);
    }

    public int getCircle() {
        return this.m_list.get(2);
    }

    public int getCross() {
        return this.m_list.get(3);
    }

    public int getL1() {
        return this.m_list.get(4);
    }

    public int getL2() {
        return this.m_list.get(5);
    }

    public int getR1() {
        return this.m_list.get(6);
    }

    public int getR2() {
        return this.m_list.get(7);
    }

    public int getSelect() {
        return this.m_list.get(8);
    }

    public int getStart() {
        return this.m_list.get(9);
    }

    public int getPovDown() {
        return this.m_povs.get(0);
    }

    public int getPovLeft() {
        return this.m_povs.get(1);
    }

    public int getPovUp() {
        return this.m_povs.get(2);
    }

    public int getPovRight() {
        return this.m_povs.get(3);
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private void registerEventHandlers() {
        this.timer.tickEvent.add(new BEventHandler(this, "timer_Tick"));
        this.btnSkip.clickEvent.add(new BEventHandler(this, "btnSkip_Click"));
        this.btnReset.clickEvent.add(new BEventHandler(this, "btnReset_Click"));
        this.btnOK.clickEvent.add(new BEventHandler(this, "btnOK_Click"));
        this.btnCancel.clickEvent.add(new BEventHandler(this, "btnCancel_Click"));
    }

    private void setResources() {
    }

    public void timer_Tick(Object object, BEventArgs bEventArgs) {
        boolean bl;
        block11: {
            byte[] byArray;
            block10: {
                int n = -1;
                byArray = new byte[]{};
                bl = false;
                if (this.index > 4) break block10;
                if (n < 0 || this.m_povs.contains(n)) break block11;
                this.m_povs.set(this.index - 1, n);
                bl = true;
                break block11;
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] <= 0 || this.m_list.contains(i)) continue;
                this.m_list.set(this.index - 5, i);
                bl = true;
                break;
            }
        }
        if (bl) {
            if (this.index <= 8) {
                this.progressCount.setValue(this.index);
            } else if (this.index <= 12) {
                this.progressCount.setValue(this.index - 8);
            } else {
                this.progressCount.setValue(this.index - 12);
            }
            if (this.index == 8) {
                this.pictButton.setImage(Resources.get_btn2());
                this.progressCount.setValue(0);
                this.progressCount.setMaximum(4);
            } else if (this.index == 12) {
                this.pictButton.setImage(Resources.get_btn3());
                this.progressCount.setValue(0);
                this.progressCount.setMaximum(2);
            }
            if (this.index == 14) {
                this.btnSkip.setEnabled(false);
                this.btnOK.setEnabled(true);
                this.timer.stop();
            }
            ++this.index;
        }
    }

    public void btnSkip_Click(Object object, BEventArgs bEventArgs) {
        if (this.index <= 4) {
            this.m_povs.set(this.index - 1, Integer.MIN_VALUE);
        } else {
            this.m_list.set(this.index - 5, -1);
        }
        if (this.index <= 8) {
            this.progressCount.setValue(this.index);
        } else if (this.index <= 12) {
            this.progressCount.setValue(this.index - 8);
        } else {
            this.progressCount.setValue(this.index - 12);
        }
        if (this.index == 8) {
            this.pictButton.setImage(Resources.get_btn2());
            this.progressCount.setValue(0);
            this.progressCount.setMaximum(4);
        } else if (this.index == 12) {
            this.pictButton.setImage(Resources.get_btn3());
            this.progressCount.setValue(0);
            this.progressCount.setMaximum(2);
        }
        if (this.index == 14) {
            this.btnSkip.setEnabled(false);
            this.btnOK.setEnabled(true);
            this.timer.stop();
        }
        ++this.index;
    }

    public void btnReset_Click(Object object, BEventArgs bEventArgs) {
        this.m_list.set(0, 3);
        this.m_list.set(1, 0);
        this.m_list.set(2, 1);
        this.m_list.set(3, 2);
        this.m_list.set(4, 4);
        this.m_list.set(5, 6);
        this.m_list.set(6, 5);
        this.m_list.set(7, 7);
        this.m_list.set(8, 8);
        this.m_list.set(9, 9);
        this.m_povs.set(0, 18000);
        this.m_povs.set(1, 27000);
        this.m_povs.set(2, 0);
        this.m_povs.set(3, 9000);
        this.setDialogResult(BDialogResult.OK);
    }

    public void btnCancel_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.CANCEL);
    }

    public void btnOK_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.OK);
    }

    private void initialize() {
        this.setSize(new Dimension(356, 224));
        this.setTitle("Game Controler Configuration");
        this.setContentPane(this.getJPanel());
    }

    private BPanel getJPanel() {
        if (this.BPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(12, 0, 12, 0);
            gridBagConstraints.gridy = 4;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 0.5;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(0, 12, 0, 12);
            gridBagConstraints2.gridy = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 0.5;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 24, 0, 12);
            gridBagConstraints3.gridy = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(12, 12, 12, 12);
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.ipadx = 1;
            gridBagConstraints5.gridwidth = 2;
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridwidth = 2;
            gridBagConstraints6.insets = new Insets(16, 12, 0, 12);
            gridBagConstraints6.gridy = 0;
            this.lblMessage = new BLabel();
            this.lblMessage.setText(" ");
            this.BPanel = new BPanel();
            this.BPanel.setLayout(new GridBagLayout());
            this.BPanel.add((Component)this.lblMessage, gridBagConstraints6);
            this.BPanel.add((Component)this.getPictButton(), gridBagConstraints5);
            this.BPanel.add((Component)this.getProgressCount(), gridBagConstraints4);
            this.BPanel.add((Component)this.getBtnSkip(), gridBagConstraints3);
            this.BPanel.add((Component)this.getBtnReset(), gridBagConstraints2);
            this.BPanel.add((Component)this.getJPanel11(), gridBagConstraints);
        }
        return this.BPanel;
    }

    private BPictureBox getPictButton() {
        if (this.pictButton == null) {
            this.pictButton = new BPictureBox();
            this.pictButton.setLayout(new GridBagLayout());
        }
        return this.pictButton;
    }

    private BProgressBar getProgressCount() {
        if (this.progressCount == null) {
            this.progressCount = new BProgressBar();
        }
        return this.progressCount;
    }

    private BButton getBtnSkip() {
        if (this.btnSkip == null) {
            this.btnSkip = new BButton();
            this.btnSkip.setText("Skip");
        }
        return this.btnSkip;
    }

    private BButton getBtnReset() {
        if (this.btnReset == null) {
            this.btnReset = new BButton();
            this.btnReset.setText("Reset and Exit");
        }
        return this.btnReset;
    }

    private BPanel getJPanel11() {
        if (this.jPanel11 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            this.jLabel4 = new BLabel();
            this.jLabel4.setText(" ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints2.gridx = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints3.gridx = 1;
            this.jPanel11 = new BPanel();
            this.jPanel11.setLayout(new GridBagLayout());
            this.jPanel11.add((Component)this.getBtnOK(), gridBagConstraints3);
            this.jPanel11.add((Component)this.getBtnCancel(), gridBagConstraints2);
            this.jPanel11.add((Component)this.jLabel4, gridBagConstraints);
        }
        return this.jPanel11;
    }

    private BButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new BButton();
            this.btnOK.setText("OK");
        }
        return this.btnOK;
    }

    private BButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new BButton();
            this.btnCancel.setText("Cancel");
        }
        return this.btnCancel;
    }
}

