/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.kbinani.BEventArgs;
import org.kbinani.PortUtil;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.Utility;
import org.kbinani.cadencii.VSTiProxy;
import org.kbinani.cadencii.VsqFileEx;
import org.kbinani.componentmodel.BBackgroundWorker;
import org.kbinani.componentmodel.BDoWorkEventArgs;
import org.kbinani.componentmodel.BDoWorkEventHandler;
import org.kbinani.componentmodel.BProgressChangedEventArgs;
import org.kbinani.componentmodel.BRunWorkerCompletedEventArgs;
import org.kbinani.componentmodel.BRunWorkerCompletedEventHandler;
import org.kbinani.media.Wave;
import org.kbinani.media.WaveReader;
import org.kbinani.media.WaveWriter;
import org.kbinani.vsq.LyricHandle;
import org.kbinani.vsq.SingerConfig;
import org.kbinani.vsq.SynthesizerType;
import org.kbinani.vsq.VocaloSysUtil;
import org.kbinani.vsq.VsqEvent;
import org.kbinani.vsq.VsqID;
import org.kbinani.vsq.VsqIDType;
import org.kbinani.vsq.VsqTrack;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BFolderBrowser;
import org.kbinani.windows.forms.BForm;
import org.kbinani.windows.forms.BFormClosedEventArgs;

public class FormGenerateKeySound
extends BForm {
    static final int _SAMPLE_RATE = 44100;
    private BFolderBrowser folderBrowser;
    private BBackgroundWorker bgWork;
    private SingerConfig[] m_singer_config1;
    private SingerConfig[] m_singer_config2;
    private SingerConfig[] m_singer_config_utau;
    private boolean m_cancel_required = false;
    private boolean m_close_when_finished = false;
    private static final long serialVersionUID = 3420499863033740708L;
    private JPanel jPanel1 = null;
    private BButton btnCancel = null;
    private BButton btnExecute = null;
    private JPanel jPanel = null;
    private JPanel jPanel2 = null;
    private JLabel lblDir = null;
    private JTextField txtDir = null;
    private BButton btnBrowse = null;
    private JLabel lblSingingSynthSystem = null;
    private JComboBox comboSingingSynthSystem = null;
    private JLabel lblSinger = null;
    private JComboBox comboSinger = null;
    private JCheckBox chkIgnoreExistingWavs = null;

    public FormGenerateKeySound(boolean bl) {
        this.initialize();
        this.bgWork = new BBackgroundWorker();
        this.folderBrowser = new BFolderBrowser();
        this.m_close_when_finished = bl;
        this.m_singer_config1 = VocaloSysUtil.getSingerConfigs(SynthesizerType.VOCALOID1);
        this.m_singer_config2 = VocaloSysUtil.getSingerConfigs(SynthesizerType.VOCALOID2);
        this.m_singer_config_utau = AppManager.editorConfig.UtauSingers.toArray(new SingerConfig[0]);
        if (this.m_singer_config1.length > 0) {
            this.comboSingingSynthSystem.addItem("VOCALOID1");
        }
        if (this.m_singer_config2.length > 0) {
            this.comboSingingSynthSystem.addItem("VOCALOID2");
        }
        if (this.m_singer_config_utau.length > 0) {
            this.comboSingingSynthSystem.addItem("UTAU");
        }
        if (this.comboSingingSynthSystem.getItemCount() > 0) {
            this.comboSingingSynthSystem.setSelectedIndex(0);
        }
        this.updateSinger();
        this.txtDir.setText(Utility.getKeySoundPath());
    }

    private void registerEventHandlers() {
        this.bgWork.doWorkEvent.add(new BDoWorkEventHandler(this, "this.bgWork_DoWork"));
        this.bgWork.runWorkerCompletedEvent.add(new BRunWorkerCompletedEventHandler(this, "bgWork_RunWorkerCompleted"));
    }

    private void updateSinger() {
        if (this.comboSingingSynthSystem.getSelectedIndex() < 0) {
            return;
        }
        String string = (String)this.comboSingingSynthSystem.getSelectedItem();
        SingerConfig[] singerConfigArray = null;
        if (string.equals("VOCALOID1")) {
            singerConfigArray = this.m_singer_config1;
        } else if (string.equals("VOCALOID2")) {
            singerConfigArray = this.m_singer_config2;
        } else if (string.equals("UTAU")) {
            singerConfigArray = this.m_singer_config_utau;
        }
        this.comboSinger.removeAllItems();
        if (singerConfigArray == null) {
            return;
        }
        for (int i = 0; i < singerConfigArray.length; ++i) {
            this.comboSinger.addItem(singerConfigArray[i].VOICENAME);
        }
        if (this.comboSinger.getItemCount() > 0) {
            this.comboSinger.setSelectedIndex(0);
        }
    }

    private void updateTitle(String string) {
        this.setTitle(string);
    }

    private void updateEnabled(boolean bl) {
        this.comboSinger.setEnabled(bl);
        this.comboSingingSynthSystem.setEnabled(bl);
        this.txtDir.setEditable(bl);
        this.btnBrowse.setEnabled(bl);
        this.btnExecute.setEnabled(bl);
        this.chkIgnoreExistingWavs.setEnabled(bl);
        if (bl) {
            this.btnCancel.setText("Close");
        } else {
            this.btnCancel.setText("Cancel");
        }
    }

    public void comboSingingSynthSystem_SelectedIndexChanged(Object object, BEventArgs bEventArgs) {
        this.updateSinger();
    }

    public void btnBrowse_Click(Object object, BEventArgs bEventArgs) {
        this.folderBrowser.setSelectedPath(this.txtDir.getText());
        this.folderBrowser.setVisible(true);
        if (this.folderBrowser.getDialogResult() != BDialogResult.OK) {
            return;
        }
        this.txtDir.setText(this.folderBrowser.getSelectedPath());
    }

    public void btnCancel_Click(Object object, BEventArgs bEventArgs) {
        if (this.bgWork.isBusy()) {
            this.m_cancel_required = true;
            while (this.m_cancel_required) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        } else {
            this.close();
        }
    }

    public void btnExecute_Click(Object object, BEventArgs bEventArgs) {
        PrepareStartArgument prepareStartArgument = new PrepareStartArgument();
        prepareStartArgument.singer = (String)this.comboSinger.getSelectedItem();
        prepareStartArgument.amplitude = 1.0;
        prepareStartArgument.directory = this.txtDir.getText();
        prepareStartArgument.replace = this.chkIgnoreExistingWavs.isSelected();
        this.updateEnabled(false);
        this.bgWork.runWorkerAsync(prepareStartArgument);
    }

    private void bgWork_DoWork(Object object, BDoWorkEventArgs bDoWorkEventArgs) {
        PrepareStartArgument prepareStartArgument = (PrepareStartArgument)bDoWorkEventArgs.Argument;
        String string = prepareStartArgument.singer;
        double d = prepareStartArgument.amplitude;
        String string2 = prepareStartArgument.directory;
        boolean bl = prepareStartArgument.replace;
        if (!PortUtil.isDirectoryExists(string2)) {
            PortUtil.createDirectory(string2);
        }
        for (int i = 0; i < 127; ++i) {
            String string3 = PortUtil.combinePath(string2, i + ".wav");
            PortUtil.println("writing \"" + string3 + "\" ...");
            if (bl || !bl && !PortUtil.isFileExists(string3)) {
                try {
                    FormGenerateKeySound.GenerateSinglePhone(i, string, string3, d);
                    if (PortUtil.isFileExists(string3)) {
                        try {
                            Wave wave = new Wave(string3);
                            wave.trimSilence();
                            wave.monoralize();
                            wave.write(string3);
                        }
                        catch (Exception exception) {
                            PortUtil.stderr.println("FormGenerateKeySound#bgWork_DoWork; ex0=" + exception);
                        }
                    }
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("FormGenerateKeySound#bgWork_DoWork; ex=" + exception);
                }
            }
            PortUtil.println(" done");
            if (this.m_cancel_required) {
                this.m_cancel_required = false;
                break;
            }
            this.bgWork.reportProgress((int)((double)i / 127.0 * 100.0));
        }
        this.m_cancel_required = false;
    }

    private void bgWork_ProgressChanged(Object object, BProgressChangedEventArgs bProgressChangedEventArgs) {
        String string = "Progress: " + bProgressChangedEventArgs.ProgressPercentage + "%";
        this.updateTitle(string);
    }

    public void Program_FormClosed(Object object, BFormClosedEventArgs bFormClosedEventArgs) {
        VSTiProxy.terminate();
    }

    public void bgWork_RunWorkerCompleted(Object object, BRunWorkerCompletedEventArgs bRunWorkerCompletedEventArgs) {
        this.updateEnabled(true);
        if (this.m_close_when_finished) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void GenerateSinglePhone(int n, String string, String string2, double d) {
        Cloneable cloneable2;
        String string3 = "";
        SingerConfig[] singerConfigArray = VocaloSysUtil.getSingerConfigs(SynthesizerType.VOCALOID1);
        int n2 = singerConfigArray.length;
        String string4 = "";
        String string5 = "";
        for (int i = 0; i < n2; ++i) {
            if (string4.equals("")) {
                string4 = singerConfigArray[i].VOICENAME;
                string5 = "DSB2";
            }
            if (!singerConfigArray[i].VOICENAME.equals(string)) continue;
            string3 = "DSB2";
            break;
        }
        SingerConfig[] singerConfigArray2 = VocaloSysUtil.getSingerConfigs(SynthesizerType.VOCALOID2);
        n2 = singerConfigArray2.length;
        for (int i = 0; i < n2; ++i) {
            if (string4.equals("")) {
                string4 = singerConfigArray2[i].VOICENAME;
                string5 = "DSB3";
            }
            if (!singerConfigArray2[i].VOICENAME.equals(string)) continue;
            string3 = "DSB3";
            break;
        }
        for (Cloneable cloneable2 : AppManager.editorConfig.UtauSingers) {
            if (string4.equals("")) {
                string4 = cloneable2.VOICENAME;
                string5 = "UTU0";
            }
            if (!cloneable2.VOICENAME.equals(string)) continue;
            string3 = "UTU0";
            break;
        }
        VsqFileEx vsqFileEx = new VsqFileEx(string, 1, 4, 4, 500000);
        if (string3.equals("")) {
            string = string4;
            string3 = string5;
        }
        ((VsqTrack)vsqFileEx.Track.get((int)1)).getCommon().Version = string3;
        cloneable2 = new VsqEvent(1920, new VsqID(0));
        ((VsqEvent)cloneable2).ID.LyricHandle = new LyricHandle("\u3042", "a");
        ((VsqEvent)cloneable2).ID.setLength(480);
        ((VsqEvent)cloneable2).ID.Note = n;
        ((VsqEvent)cloneable2).ID.VibratoHandle = null;
        ((VsqEvent)cloneable2).ID.type = VsqIDType.Anote;
        ((VsqTrack)vsqFileEx.Track.get(1)).addEvent((VsqEvent)cloneable2);
        vsqFileEx.updateTotalClocks();
        int n3 = 500;
        String string6 = PortUtil.combinePath(AppManager.getCadenciiTempDir(), AppManager.getID());
        if (!PortUtil.isDirectoryExists(string6)) {
            try {
                PortUtil.createDirectory(string6);
            }
            catch (Exception exception) {
                PortUtil.stderr.println("Program#GenerateSinglePhone; ex=" + exception);
                return;
            }
        }
        WaveWriter waveWriter = null;
        try {
            waveWriter = new WaveWriter(string2);
            VSTiProxy.render(vsqFileEx, 1, waveWriter, 0.0, vsqFileEx.getSecFromClock(vsqFileEx.TotalClocks) + 1.0, n3, false, new WaveReader[0], 0.0, false, string6, false);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("FormGenerateKeySound#GenerateSinglePhone; ex=" + exception);
        }
        finally {
            if (waveWriter != null) {
                try {
                    waveWriter.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("FormGenerateKeySound#GenerateSinglePhone; ex2=" + exception);
                }
            }
        }
    }

    private void initialize() {
        this.setSize(new Dimension(342, 197));
        this.setContentPane(this.getJPanel());
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 16);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 16);
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.add((Component)this.getBtnCancel(), gridBagConstraints2);
            this.jPanel1.add((Component)this.getBtnExecute(), gridBagConstraints);
        }
        return this.jPanel1;
    }

    private BButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new BButton();
            this.btnCancel.setText("Close");
        }
        return this.btnCancel;
    }

    private BButton getBtnExecute() {
        if (this.btnExecute == null) {
            this.btnExecute = new BButton();
            this.btnExecute.setText("Execute");
        }
        return this.btnExecute;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 4;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(6, 12, 6, 12);
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridy = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 0;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(4, 12, 4, 12);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(6, 12, 6, 12);
            gridBagConstraints5.gridy = 1;
            this.lblSinger = new JLabel();
            this.lblSinger.setText("Singer");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(12, 12, 4, 12);
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.insets = new Insets(12, 12, 6, 12);
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridy = 0;
            this.lblSingingSynthSystem = new JLabel();
            this.lblSingingSynthSystem.setText("Singing Synth. System");
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.lblSingingSynthSystem, gridBagConstraints7);
            this.jPanel.add((Component)this.getComboSingingSynthSystem(), gridBagConstraints6);
            this.jPanel.add((Component)this.lblSinger, gridBagConstraints5);
            this.jPanel.add((Component)this.getComboSinger(), gridBagConstraints4);
            this.jPanel.add((Component)this.getJPanel2(), gridBagConstraints3);
            this.jPanel.add((Component)this.getChkIgnoreExistingWavs(), gridBagConstraints2);
            this.jPanel.add((Component)this.getJPanel1(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 12, 0, 12);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints3.gridy = 0;
            this.lblDir = new JLabel();
            this.lblDir.setText("Output Path");
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.add((Component)this.lblDir, gridBagConstraints3);
            this.jPanel2.add((Component)this.getTxtDir(), gridBagConstraints2);
            this.jPanel2.add((Component)this.getBtnBrowse(), gridBagConstraints);
        }
        return this.jPanel2;
    }

    private JTextField getTxtDir() {
        if (this.txtDir == null) {
            this.txtDir = new JTextField();
        }
        return this.txtDir;
    }

    private BButton getBtnBrowse() {
        if (this.btnBrowse == null) {
            this.btnBrowse = new BButton();
            this.btnBrowse.setPreferredSize(new Dimension(41, 23));
            this.btnBrowse.setText("...");
        }
        return this.btnBrowse;
    }

    private JComboBox getComboSingingSynthSystem() {
        if (this.comboSingingSynthSystem == null) {
            this.comboSingingSynthSystem = new JComboBox();
            this.comboSingingSynthSystem.setPreferredSize(new Dimension(121, 20));
        }
        return this.comboSingingSynthSystem;
    }

    private JComboBox getComboSinger() {
        if (this.comboSinger == null) {
            this.comboSinger = new JComboBox();
            this.comboSinger.setPreferredSize(new Dimension(121, 20));
        }
        return this.comboSinger;
    }

    private JCheckBox getChkIgnoreExistingWavs() {
        if (this.chkIgnoreExistingWavs == null) {
            this.chkIgnoreExistingWavs = new JCheckBox();
            this.chkIgnoreExistingWavs.setText("Ignore Existing WAVs");
        }
        return this.chkIgnoreExistingWavs;
    }

    public class PrepareStartArgument {
        public String singer = "Miku";
        public double amplitude = 1.0;
        public String directory = "";
        public boolean replace = true;
    }
}

