/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.PortUtil;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.NumberTextBox;
import org.kbinani.cadencii.VsqFileEx;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BCheckBox;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BFormClosingEventArgs;
import org.kbinani.windows.forms.BFormClosingEventHandler;
import org.kbinani.windows.forms.BGroupBox;
import org.kbinani.windows.forms.BLabel;
import org.kbinani.windows.forms.BListView;
import org.kbinani.windows.forms.BRadioButton;

public class FormMidiImExport
extends BDialog {
    private FormMidiMode m_mode;
    private VsqFileEx m_vsq;
    private static int columnWidthTrack = 54;
    private static int columnWidthName = 122;
    private static int columnWidthNotes = 126;
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private BButton btnCheckAll = null;
    private BButton btnUncheckAll = null;
    private JLabel jLabel = null;
    public BListView listTrack = null;
    private BGroupBox groupCommonOption = null;
    private BCheckBox chkTempo = null;
    private JPanel jPanel2 = null;
    private BButton btnOK = null;
    private BButton btnCancel = null;
    private JPanel jPanel3 = null;
    private BCheckBox chkBeat = null;
    private BCheckBox chkLyric = null;
    private JLabel jLabel1 = null;
    private JPanel panel2 = null;
    private BCheckBox chkNote = null;
    private BCheckBox chkMetaText = null;
    private JLabel jLabel11 = null;
    private JPanel jPanel32 = null;
    private BCheckBox chkExportVocaloidNrpn = null;
    private BCheckBox chkPreMeasure = null;
    private JLabel jLabel12 = null;
    private BGroupBox groupMode = null;
    private JPanel jPanel31 = null;
    private JLabel jLabel13 = null;
    private JPanel panel21 = null;
    private JLabel jLabel111 = null;
    private BRadioButton radioGateTime = null;
    private BRadioButton radioPlayTime = null;
    private BLabel lblOffset = null;
    private NumberTextBox txtOffset = null;
    private BLabel lblOffsetUnit = null;

    public FormMidiImExport() {
        this.initialize();
        this.applyLanguage();
        this.setMode(FormMidiMode.EXPORT);
        Util.applyFontRecurse(this, AppManager.editorConfig.getBaseFont());
        this.listTrack.setColumnHeaders(new String[]{FormMidiImExport._("Track"), FormMidiImExport._("Name"), FormMidiImExport._("Notes")});
        this.listTrack.setColumnWidth(0, columnWidthTrack);
        this.listTrack.setColumnWidth(1, columnWidthName);
        this.listTrack.setColumnWidth(2, columnWidthNotes);
        Point point = this.btnCheckAll.getLocation();
        this.btnUncheckAll.setLocation(point.x + this.btnCheckAll.getWidth() + 6, point.y);
        this.registerEventHandlers();
        this.setResources();
    }

    public void applyLanguage() {
        if (this.m_mode == FormMidiMode.EXPORT) {
            this.setTitle(FormMidiImExport._("Midi Export"));
        } else if (this.m_mode == FormMidiMode.IMPORT) {
            this.setTitle(FormMidiImExport._("Midi Import"));
        } else {
            this.setTitle(FormMidiImExport._("VSQ/Vocaloid Midi Import"));
        }
        this.groupMode.setTitle(FormMidiImExport._("Import Basis"));
        this.radioGateTime.setText(FormMidiImExport._("gate-time"));
        this.radioPlayTime.setText(FormMidiImExport._("play-time"));
        this.listTrack.setColumnHeaders(new String[]{FormMidiImExport._("Track"), FormMidiImExport._("Name"), FormMidiImExport._("Notes")});
        this.btnCheckAll.setText(FormMidiImExport._("Check All"));
        this.btnUncheckAll.setText(FormMidiImExport._("Uncheck All"));
        this.groupCommonOption.setTitle(FormMidiImExport._("Option"));
        this.btnOK.setText(FormMidiImExport._("OK"));
        this.btnCancel.setText(FormMidiImExport._("Cancel"));
        this.chkTempo.setText(FormMidiImExport._("Tempo"));
        this.chkBeat.setText(FormMidiImExport._("Beat"));
        this.chkNote.setText(FormMidiImExport._("Note"));
        this.chkLyric.setText(FormMidiImExport._("Lyrics"));
        this.chkExportVocaloidNrpn.setText(FormMidiImExport._("vocaloid NRPN"));
        this.lblOffset.setText(FormMidiImExport._("offset"));
        if (this.radioGateTime.isSelected()) {
            this.lblOffsetUnit.setText(FormMidiImExport._("clocks"));
        } else {
            this.lblOffsetUnit.setText(FormMidiImExport._("seconds"));
        }
    }

    public double getOffsetSeconds() {
        double d = 0.0;
        try {
            d = PortUtil.parseDouble(this.txtOffset.getText());
        }
        catch (Exception exception) {
            PortUtil.stderr.println("FormMidiImExport#getOffsetClocks; ex=" + exception);
        }
        return d;
    }

    public int getOffsetClocks() {
        int n = 0;
        try {
            n = PortUtil.parseInt(this.txtOffset.getText());
        }
        catch (Exception exception) {
            PortUtil.stderr.println("FormMidiImExport#getOffsetClocks; ex=" + exception);
        }
        return n;
    }

    public boolean isSecondBasis() {
        return this.radioPlayTime.isSelected();
    }

    public FormMidiMode getMode() {
        return this.m_mode;
    }

    public void setMode(FormMidiMode formMidiMode) {
        this.m_mode = formMidiMode;
        this.chkExportVocaloidNrpn.setEnabled(this.m_mode == FormMidiMode.EXPORT);
        this.chkLyric.setEnabled(this.m_mode != FormMidiMode.IMPORT_VSQ);
        this.chkNote.setEnabled(this.m_mode != FormMidiMode.IMPORT_VSQ);
        this.chkPreMeasure.setEnabled(this.m_mode != FormMidiMode.IMPORT_VSQ);
        if (this.m_mode == FormMidiMode.EXPORT) {
            this.setTitle(FormMidiImExport._("Midi Export"));
            this.chkPreMeasure.setText(FormMidiImExport._("Export pre-measure part"));
            if (this.chkExportVocaloidNrpn.isSelected()) {
                this.chkPreMeasure.setEnabled(false);
                AppManager.editorConfig.MidiImExportConfigExport.LastPremeasureCheckStatus = this.chkPreMeasure.isSelected();
                this.chkPreMeasure.setSelected(true);
            } else {
                this.chkPreMeasure.setSelected(AppManager.editorConfig.MidiImExportConfigExport.LastPremeasureCheckStatus);
            }
            if (this.chkNote.isSelected()) {
                this.chkMetaText.setEnabled(false);
                AppManager.editorConfig.MidiImExportConfigExport.LastMetatextCheckStatus = this.chkMetaText.isSelected();
                this.chkMetaText.setSelected(false);
            } else {
                this.chkMetaText.setSelected(AppManager.editorConfig.MidiImExportConfigExport.LastMetatextCheckStatus);
            }
            this.groupMode.setEnabled(false);
        } else if (this.m_mode == FormMidiMode.IMPORT) {
            this.setTitle(FormMidiImExport._("Midi Import"));
            this.chkPreMeasure.setText(FormMidiImExport._("Inserting start at pre-measure"));
            this.chkMetaText.setEnabled(false);
            AppManager.editorConfig.MidiImExportConfigImport.LastMetatextCheckStatus = this.chkMetaText.isSelected();
            this.chkMetaText.setSelected(false);
            this.groupMode.setEnabled(true);
        } else {
            this.setTitle(FormMidiImExport._("VSQ/Vocaloid Midi Import"));
            this.chkPreMeasure.setText(FormMidiImExport._("Inserting start at pre-measure"));
            this.chkPreMeasure.setSelected(false);
            AppManager.editorConfig.MidiImExportConfigImportVsq.LastMetatextCheckStatus = this.chkMetaText.isSelected();
            this.chkMetaText.setSelected(true);
            this.groupMode.setEnabled(false);
        }
    }

    public boolean isVocaloidMetatext() {
        if (this.chkNote.isSelected()) {
            return false;
        }
        return this.chkMetaText.isSelected();
    }

    public boolean isVocaloidNrpn() {
        return this.chkExportVocaloidNrpn.isSelected();
    }

    public boolean isTempo() {
        return this.chkTempo.isSelected();
    }

    public void setTempo(boolean bl) {
        this.chkTempo.setSelected(bl);
    }

    public boolean isTimesig() {
        return this.chkBeat.isSelected();
    }

    public void setTimesig(boolean bl) {
        this.chkBeat.setSelected(bl);
    }

    public boolean isNotes() {
        return this.chkNote.isSelected();
    }

    public boolean isLyric() {
        return this.chkLyric.isSelected();
    }

    public boolean isPreMeasure() {
        return this.chkPreMeasure.isSelected();
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private void registerEventHandlers() {
        this.btnCheckAll.clickEvent.add(new BEventHandler(this, "btnCheckAll_Click"));
        this.btnUncheckAll.clickEvent.add(new BEventHandler(this, "btnUnckeckAll_Click"));
        this.chkNote.checkedChangedEvent.add(new BEventHandler(this, "chkNote_CheckedChanged"));
        this.chkMetaText.clickEvent.add(new BEventHandler(this, "chkMetaText_Click"));
        this.chkExportVocaloidNrpn.checkedChangedEvent.add(new BEventHandler(this, "chkExportVocaloidNrpn_CheckedChanged"));
        this.chkExportVocaloidNrpn.checkedChangedEvent.add(new BEventHandler(this, "chkExportVocaloidNrpn_CheckedChanged"));
        this.formClosingEvent.add(new BFormClosingEventHandler(this, "FormMidiImExport_FormClosing"));
        this.btnOK.clickEvent.add(new BEventHandler(this, "btnOK_Click"));
        this.btnCancel.clickEvent.add(new BEventHandler(this, "btnCancel_Click"));
        this.radioGateTime.checkedChangedEvent.add(new BEventHandler(this, "radioGateTime_CheckedChanged"));
        this.radioPlayTime.checkedChangedEvent.add(new BEventHandler(this, "radioPlayTime_CheckedChanged"));
    }

    private void setResources() {
    }

    public void btnCheckAll_Click(Object object, BEventArgs bEventArgs) {
        for (int i = 0; i < this.listTrack.getItemCount(""); ++i) {
            this.listTrack.setItemCheckedAt("", i, true);
        }
    }

    public void btnUnckeckAll_Click(Object object, BEventArgs bEventArgs) {
        for (int i = 0; i < this.listTrack.getItemCount(""); ++i) {
            this.listTrack.setItemCheckedAt("", i, false);
        }
    }

    public void chkExportVocaloidNrpn_CheckedChanged(Object object, BEventArgs bEventArgs) {
        if (this.m_mode == FormMidiMode.EXPORT) {
            if (this.chkExportVocaloidNrpn.isSelected()) {
                this.chkPreMeasure.setEnabled(false);
                AppManager.editorConfig.MidiImExportConfigExport.LastPremeasureCheckStatus = this.chkPreMeasure.isSelected();
                this.chkPreMeasure.setSelected(true);
            } else {
                this.chkPreMeasure.setEnabled(true);
                this.chkPreMeasure.setSelected(AppManager.editorConfig.MidiImExportConfigExport.LastPremeasureCheckStatus);
            }
        }
    }

    public void chkNote_CheckedChanged(Object object, BEventArgs bEventArgs) {
        if (this.m_mode == FormMidiMode.EXPORT) {
            if (this.chkNote.isSelected()) {
                this.chkMetaText.setEnabled(false);
                AppManager.editorConfig.MidiImExportConfigExport.LastMetatextCheckStatus = this.chkMetaText.isSelected();
                this.chkMetaText.setSelected(false);
            } else {
                this.chkMetaText.setEnabled(true);
                this.chkMetaText.setSelected(AppManager.editorConfig.MidiImExportConfigExport.LastMetatextCheckStatus);
            }
        }
    }

    public void chkMetaText_Click(Object object, BEventArgs bEventArgs) {
        if (this.m_mode == FormMidiMode.EXPORT) {
            AppManager.editorConfig.MidiImExportConfigExport.LastMetatextCheckStatus = this.chkMetaText.isSelected();
        }
    }

    public void FormMidiImExport_FormClosing(Object object, BFormClosingEventArgs bFormClosingEventArgs) {
        columnWidthTrack = this.listTrack.getColumnWidth(0);
        columnWidthName = this.listTrack.getColumnWidth(1);
        columnWidthNotes = this.listTrack.getColumnWidth(2);
    }

    public void btnCancel_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.CANCEL);
    }

    public void btnOK_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.OK);
    }

    public void radioGateTime_CheckedChanged(Object object, BEventArgs bEventArgs) {
        if (this.radioGateTime.isSelected()) {
            this.lblOffsetUnit.setText(FormMidiImExport._("clocks"));
            this.txtOffset.setType(NumberTextBox.ValueType.Integer);
        }
    }

    public void radioPlayTime_CheckedChanged(Object object, BEventArgs bEventArgs) {
        if (this.radioPlayTime.isSelected()) {
            this.lblOffsetUnit.setText(FormMidiImExport._("seconds"));
            this.txtOffset.setType(NumberTextBox.ValueType.Double);
        }
    }

    private void initialize() {
        this.setSize(357, 513);
        this.setContentPane(this.getJContentPane());
        this.setTitle("JFrame");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(12, 0, 12, 0);
            gridBagConstraints2.gridy = 4;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(12, 12, 6, 12);
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.ipadx = 146;
            gridBagConstraints5.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJPanel(), gridBagConstraints5);
            this.jContentPane.add((Component)this.getListTrack(), gridBagConstraints4);
            this.jContentPane.add((Component)this.getGroupCommonOption(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getJPanel2(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getGroupMode(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText(" ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints3.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getBtnCheckAll(), gridBagConstraints3);
            this.jPanel.add((Component)this.getBtnUncheckAll(), gridBagConstraints2);
            this.jPanel.add((Component)this.jLabel, gridBagConstraints);
        }
        return this.jPanel;
    }

    private BButton getBtnCheckAll() {
        if (this.btnCheckAll == null) {
            this.btnCheckAll = new BButton();
            this.btnCheckAll.setText("Check All");
            this.btnCheckAll.setName("btnCheckAll");
            this.btnCheckAll.setPreferredSize(new Dimension(87, 23));
        }
        return this.btnCheckAll;
    }

    private BButton getBtnUncheckAll() {
        if (this.btnUncheckAll == null) {
            this.btnUncheckAll = new BButton();
            this.btnUncheckAll.setText("Uncheck All");
            this.btnUncheckAll.setName("btnUncheckAll");
            this.btnUncheckAll.setPreferredSize(new Dimension(101, 23));
        }
        return this.btnUncheckAll;
    }

    private BListView getListTrack() {
        if (this.listTrack == null) {
            this.listTrack = new BListView();
        }
        return this.listTrack;
    }

    private JPanel getGroupCommonOption() {
        if (this.groupCommonOption == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridy = 0;
            this.groupCommonOption = new BGroupBox();
            this.groupCommonOption.setLayout(new GridBagLayout());
            this.groupCommonOption.setBorder(BorderFactory.createTitledBorder(null, "Option", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.groupCommonOption.add((Component)this.getJPanel3(), gridBagConstraints3);
            this.groupCommonOption.add((Component)this.getPanel2(), gridBagConstraints2);
            this.groupCommonOption.add((Component)this.getJPanel32(), gridBagConstraints);
        }
        return this.groupCommonOption;
    }

    private BCheckBox getChkTempo() {
        if (this.chkTempo == null) {
            this.chkTempo = new BCheckBox();
            this.chkTempo.setText("Tempo");
            this.chkTempo.setName("chkTempo");
        }
        return this.chkTempo;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 0;
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.add((Component)this.getBtnOK(), gridBagConstraints2);
            this.jPanel2.add((Component)this.getBtnCancel(), gridBagConstraints);
        }
        return this.jPanel2;
    }

    private BButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new BButton();
            this.btnOK.setText("OK");
        }
        return this.btnOK;
    }

    private BButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new BButton();
            this.btnCancel.setText("Cancel");
        }
        return this.btnCancel;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(" ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
            this.jPanel3.add((Component)this.getChkTempo(), gridBagConstraints4);
            this.jPanel3.add((Component)this.getChkBeat(), gridBagConstraints3);
            this.jPanel3.add((Component)this.getChkLyric(), gridBagConstraints2);
            this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        }
        return this.jPanel3;
    }

    private BCheckBox getChkBeat() {
        if (this.chkBeat == null) {
            this.chkBeat = new BCheckBox();
            this.chkBeat.setText("Beat");
        }
        return this.chkBeat;
    }

    private BCheckBox getChkLyric() {
        if (this.chkLyric == null) {
            this.chkLyric = new BCheckBox();
            this.chkLyric.setText("Lyrics");
        }
        return this.chkLyric;
    }

    private JPanel getPanel2() {
        if (this.panel2 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 3;
            this.jLabel11 = new JLabel();
            this.jLabel11.setText(" ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            this.panel2 = new JPanel();
            this.panel2.setLayout(new GridBagLayout());
            this.panel2.add((Component)this.getChkNote(), gridBagConstraints3);
            this.panel2.add((Component)this.getChkMetaText(), gridBagConstraints2);
            this.panel2.add((Component)this.jLabel11, gridBagConstraints);
        }
        return this.panel2;
    }

    private BCheckBox getChkNote() {
        if (this.chkNote == null) {
            this.chkNote = new BCheckBox();
            this.chkNote.setText("Note");
        }
        return this.chkNote;
    }

    private BCheckBox getChkMetaText() {
        if (this.chkMetaText == null) {
            this.chkMetaText = new BCheckBox();
            this.chkMetaText.setText("vocaloid meta-text");
        }
        return this.chkMetaText;
    }

    private JPanel getJPanel32() {
        if (this.jPanel32 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 3;
            this.jLabel12 = new JLabel();
            this.jLabel12.setText(" ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            this.jPanel32 = new JPanel();
            this.jPanel32.setLayout(new GridBagLayout());
            this.jPanel32.add((Component)this.getChkExportVocaloidNrpn(), gridBagConstraints3);
            this.jPanel32.add((Component)this.getChkPreMeasure(), gridBagConstraints2);
            this.jPanel32.add((Component)this.jLabel12, gridBagConstraints);
        }
        return this.jPanel32;
    }

    private BCheckBox getChkExportVocaloidNrpn() {
        if (this.chkExportVocaloidNrpn == null) {
            this.chkExportVocaloidNrpn = new BCheckBox();
            this.chkExportVocaloidNrpn.setText("vocaloid NRPN");
        }
        return this.chkExportVocaloidNrpn;
    }

    private BCheckBox getChkPreMeasure() {
        if (this.chkPreMeasure == null) {
            this.chkPreMeasure = new BCheckBox();
            this.chkPreMeasure.setText("Export pre-measure part");
        }
        return this.chkPreMeasure;
    }

    private BGroupBox getGroupMode() {
        if (this.groupMode == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridy = 1;
            this.groupMode = new BGroupBox();
            this.groupMode.setLayout(new GridBagLayout());
            this.groupMode.setBorder(BorderFactory.createTitledBorder(null, "Import Basis", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.groupMode.add((Component)this.getPanel21(), gridBagConstraints2);
            this.groupMode.add((Component)this.getJPanel31(), gridBagConstraints);
        }
        return this.groupMode;
    }

    private JPanel getJPanel31() {
        if (this.jPanel31 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 6;
            gridBagConstraints.gridy = 1;
            this.lblOffsetUnit = new BLabel();
            this.lblOffsetUnit.setText("clocks");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 5;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 4;
            gridBagConstraints3.gridy = 1;
            this.lblOffset = new BLabel();
            this.lblOffset.setText("offset");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridx = 7;
            this.jLabel13 = new JLabel();
            this.jLabel13.setText(" ");
            this.jPanel31 = new JPanel();
            this.jPanel31.setLayout(new GridBagLayout());
            this.jPanel31.add((Component)this.jLabel13, gridBagConstraints4);
            this.jPanel31.add((Component)this.lblOffset, gridBagConstraints3);
            this.jPanel31.add((Component)this.getTxtOffset(), gridBagConstraints2);
            this.jPanel31.add((Component)this.lblOffsetUnit, gridBagConstraints);
        }
        return this.jPanel31;
    }

    private JPanel getPanel21() {
        if (this.panel21 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridx = 4;
            this.jLabel111 = new JLabel();
            this.jLabel111.setText(" ");
            this.panel21 = new JPanel();
            this.panel21.setLayout(new GridBagLayout());
            this.panel21.add((Component)this.jLabel111, gridBagConstraints3);
            this.panel21.add((Component)this.getRadioGateTime(), gridBagConstraints2);
            this.panel21.add((Component)this.getRadioPlayTime(), gridBagConstraints);
        }
        return this.panel21;
    }

    private JRadioButton getRadioGateTime() {
        if (this.radioGateTime == null) {
            this.radioGateTime = new BRadioButton();
            this.radioGateTime.setText("gate-time");
        }
        return this.radioGateTime;
    }

    private JRadioButton getRadioPlayTime() {
        if (this.radioPlayTime == null) {
            this.radioPlayTime = new BRadioButton();
            this.radioPlayTime.setText("play-time");
        }
        return this.radioPlayTime;
    }

    private NumberTextBox getTxtOffset() {
        if (this.txtOffset == null) {
            this.txtOffset = new NumberTextBox();
        }
        return this.txtOffset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FormMidiMode {
        IMPORT,
        EXPORT,
        IMPORT_VSQ;

    }
}

