/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.PortUtil;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.DefaultVibratoLengthEnum;
import org.kbinani.vsq.SynthesizerType;
import org.kbinani.vsq.VibratoHandle;
import org.kbinani.vsq.VocaloSysUtil;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BComboBox;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BLabel;
import org.kbinani.windows.forms.BPanel;
import org.kbinani.windows.forms.BTextBox;

public class FormVibratoConfig
extends BDialog {
    private VibratoHandle m_vibrato;
    private int m_note_length;
    private SynthesizerType m_synthesizer_type;
    private static final long serialVersionUID = 1L;
    private BPanel jContentPane = null;
    private BPanel jPanel2 = null;
    private BButton btnOK = null;
    private BButton btnCancel = null;
    private BLabel lblVibratoLength = null;
    private BTextBox txtVibratoLength = null;
    private BLabel jLabel1 = null;
    private BLabel lblVibratoType = null;
    private BComboBox comboVibratoType = null;

    public FormVibratoConfig(VibratoHandle vibratoHandle, int n, DefaultVibratoLengthEnum defaultVibratoLengthEnum, SynthesizerType synthesizerType) {
        this.initialize();
        this.m_synthesizer_type = synthesizerType;
        if (vibratoHandle != null) {
            this.m_vibrato = (VibratoHandle)vibratoHandle.clone();
        }
        this.registerEventHandlers();
        this.setResources();
        this.applyLanguage();
        this.comboVibratoType.removeAllItems();
        VibratoHandle vibratoHandle2 = new VibratoHandle();
        vibratoHandle2.setCaption("[Non Vibrato]");
        vibratoHandle2.IconID = "$04040000";
        this.comboVibratoType.addItem(vibratoHandle2);
        this.comboVibratoType.setSelectedItem(vibratoHandle2);
        int n2 = 0;
        Object object = VocaloSysUtil.vibratoConfigIterator(this.m_synthesizer_type);
        while (object.hasNext()) {
            VibratoHandle vibratoHandle3 = object.next();
            this.comboVibratoType.addItem(vibratoHandle3);
            ++n2;
            if (vibratoHandle == null || !vibratoHandle.IconID.equals(vibratoHandle3.IconID)) continue;
            this.comboVibratoType.setSelectedItem(vibratoHandle3);
        }
        this.txtVibratoLength.setEnabled(vibratoHandle != null);
        if (vibratoHandle != null) {
            this.txtVibratoLength.setText((int)((float)vibratoHandle.getLength() / (float)n * 100.0f) + "");
        } else {
            object = "";
            if (defaultVibratoLengthEnum == DefaultVibratoLengthEnum.L100) {
                object = "100";
            } else if (defaultVibratoLengthEnum == DefaultVibratoLengthEnum.L50) {
                object = "50";
            } else if (defaultVibratoLengthEnum == DefaultVibratoLengthEnum.L66) {
                object = "66";
            } else if (defaultVibratoLengthEnum == DefaultVibratoLengthEnum.L75) {
                object = "75";
            }
            this.txtVibratoLength.setText((String)object);
        }
        this.comboVibratoType.selectedIndexChangedEvent.add(new BEventHandler(this, "comboVibratoType_SelectedIndexChanged"));
        this.txtVibratoLength.textChangedEvent.add(new BEventHandler(this, "txtVibratoLength_TextChanged"));
        this.m_note_length = n;
        Util.applyFontRecurse(this, AppManager.editorConfig.getBaseFont());
    }

    public void applyLanguage() {
        this.setTitle(FormVibratoConfig._("Vibrato property"));
        this.lblVibratoLength.setText(FormVibratoConfig._("Vibrato length") + "(&L)");
        this.lblVibratoType.setText(FormVibratoConfig._("Vibrato Type") + "(&T)");
        this.btnOK.setText(FormVibratoConfig._("OK"));
        this.btnCancel.setText(FormVibratoConfig._("Cancel"));
    }

    public VibratoHandle getVibratoHandle() {
        return this.m_vibrato;
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private void registerEventHandlers() {
        this.btnOK.clickEvent.add(new BEventHandler(this, "btnOK_Click"));
        this.btnCancel.clickEvent.add(new BEventHandler(this, "btnCancel_Click"));
    }

    private void setResources() {
    }

    public void btnOK_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.OK);
    }

    public void comboVibratoType_SelectedIndexChanged(Object object, BEventArgs bEventArgs) {
        int n = this.comboVibratoType.getSelectedIndex();
        if (n >= 0) {
            String string = ((VibratoHandle)this.comboVibratoType.getItemAt((int)n)).IconID;
            if (string.equals("$04040000")) {
                this.m_vibrato = null;
                this.txtVibratoLength.setEnabled(false);
                return;
            }
            this.txtVibratoLength.setEnabled(true);
            Iterator<VibratoHandle> iterator = VocaloSysUtil.vibratoConfigIterator(this.m_synthesizer_type);
            while (iterator.hasNext()) {
                int n2;
                VibratoHandle vibratoHandle = iterator.next();
                if (!string.equals(vibratoHandle.IconID)) continue;
                try {
                    n2 = PortUtil.parseInt(this.txtVibratoLength.getText());
                }
                catch (Exception exception) {
                    return;
                }
                this.m_vibrato = (VibratoHandle)vibratoHandle.clone();
                this.m_vibrato.setLength((int)((float)(this.m_note_length * n2) / 100.0f));
                return;
            }
        }
    }

    public void txtVibratoLength_TextChanged(Object object, BEventArgs bEventArgs) {
        int n = 0;
        try {
            n = PortUtil.parseInt(this.txtVibratoLength.getText());
            if (n < 0) {
                n = 0;
            } else if (100 < n) {
                n = 100;
            }
        }
        catch (Exception exception) {
            return;
        }
        if (n == 0) {
            this.m_vibrato = null;
            this.txtVibratoLength.setEnabled(false);
        } else if (this.m_vibrato != null) {
            int n2 = (int)((float)(this.m_note_length * n) / 100.0f);
            this.m_vibrato.setLength(n2);
        }
    }

    public void btnCancel_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.CANCEL);
    }

    private void initialize() {
        this.setSize(339, 157);
        this.setContentPane(this.getJContentPane());
        this.setTitle("JFrame");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 16;
            gridBagConstraints3.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints3.gridy = 1;
            this.lblVibratoType = new BLabel();
            this.lblVibratoType.setText("Vibrato Type");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.insets = new Insets(12, 3, 0, 0);
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridy = 0;
            this.jLabel1 = new BLabel();
            this.jLabel1.setText("% (0-100)");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 0;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(12, 12, 3, 0);
            gridBagConstraints5.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(12, 12, 3, 0);
            gridBagConstraints6.gridy = 0;
            this.lblVibratoLength = new BLabel();
            this.lblVibratoLength.setText("Vibrato Length");
            this.jContentPane = new BPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.lblVibratoLength, gridBagConstraints6);
            this.jContentPane.add((Component)this.getTxtVibratoLength(), gridBagConstraints5);
            this.jContentPane.add((Component)this.jLabel1, gridBagConstraints4);
            this.jContentPane.add((Component)this.lblVibratoType, gridBagConstraints3);
            this.jContentPane.add((Component)this.getComboVibratoType(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getJPanel2(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 16;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 16);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 16);
            this.jPanel2 = new BPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.add((Component)this.getBtnOK(), gridBagConstraints2);
            this.jPanel2.add((Component)this.getBtnCancel(), gridBagConstraints);
        }
        return this.jPanel2;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new BButton();
            this.btnOK.setText("OK");
        }
        return this.btnOK;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new BButton();
            this.btnCancel.setText("Cancel");
        }
        return this.btnCancel;
    }

    private JTextField getTxtVibratoLength() {
        if (this.txtVibratoLength == null) {
            this.txtVibratoLength = new BTextBox();
            this.txtVibratoLength.setPreferredSize(new Dimension(61, 19));
        }
        return this.txtVibratoLength;
    }

    private JComboBox getComboVibratoType() {
        if (this.comboVibratoType == null) {
            this.comboVibratoType = new BComboBox();
            this.comboVibratoType.setPreferredSize(new Dimension(167, 20));
        }
        return this.comboVibratoType;
    }
}

