/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.util.Vector;
import org.kbinani.PortUtil;
import org.kbinani.cadencii.AmplifyCoefficient;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.PlaySound;
import org.kbinani.cadencii.VSTiProxy;
import org.kbinani.media.WaveRateConverter;
import org.kbinani.media.WaveReader;
import org.kbinani.media.WaveWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RenderingRunner
implements Runnable {
    protected Object m_locker = null;
    protected boolean m_rendering = false;
    protected long totalSamples = 0L;
    protected long m_total_append = 0L;
    protected int m_trim_remain = 0;
    protected boolean m_abort_required = false;
    protected int renderingTrack = 0;
    protected boolean reflectAmp2Wave;
    protected WaveWriter waveWriter;
    protected double waveReadOffsetSeconds;
    protected Vector<WaveRateConverter> readers;
    protected boolean directPlay;
    protected int trimMillisec;
    protected int sampleRate;

    @Override
    public abstract void run();

    public abstract double getProgress();

    public abstract double getElapsedSeconds();

    public abstract double computeRemainingSeconds();

    protected RenderingRunner(int n, boolean bl, WaveWriter waveWriter, double d, Vector<WaveReader> vector, boolean bl2, int n2, long l, int n3) {
        this.renderingTrack = n;
        this.reflectAmp2Wave = bl;
        this.waveWriter = waveWriter;
        this.waveReadOffsetSeconds = d;
        int n4 = vector != null ? vector.size() : 0;
        this.readers = new Vector();
        for (int i = 0; i < n4; ++i) {
            this.readers.add(new WaveRateConverter(vector.get(i), n3));
        }
        this.directPlay = bl2;
        this.trimMillisec = n2;
        this.totalSamples = l;
        this.sampleRate = n3;
        this.m_locker = new Object();
        this.m_rendering = false;
        this.m_total_append = 0L;
        this.m_trim_remain = (int)((double)this.trimMillisec / 1000.0 * (double)this.sampleRate);
    }

    public boolean isRendering() {
        return this.m_rendering;
    }

    public void abortRendering() {
        this.m_abort_required = true;
        while (this.m_rendering) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        int n = this.readers.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.readers.get(i).close();
            }
            catch (Exception exception) {
                PortUtil.stderr.println("RenderingRunner#abortRendering; ex=" + exception);
            }
            this.readers.set(i, null);
        }
        this.readers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waveIncoming(double[] dArray, double[] dArray2) {
        if (!this.m_rendering) {
            return;
        }
        Object object = this.m_locker;
        synchronized (object) {
            int n;
            int n2;
            Object object2;
            WaveRateConverter waveRateConverter;
            int n3;
            Object object3;
            int n4;
            boolean bl = AppManager.editorConfig.WaveFileOutputFromMasterTrack;
            double[] dArray3 = dArray;
            double[] dArray4 = dArray2;
            if (this.m_trim_remain > 0) {
                if (dArray3.length <= this.m_trim_remain) {
                    this.m_trim_remain -= dArray3.length;
                    return;
                }
                dArray3 = new double[dArray.length - this.m_trim_remain];
                dArray4 = new double[dArray.length - this.m_trim_remain];
                for (n4 = this.m_trim_remain; n4 < dArray.length; ++n4) {
                    if (this.m_abort_required) {
                        return;
                    }
                    dArray3[n4 - this.m_trim_remain] = dArray[n4];
                    dArray4[n4 - this.m_trim_remain] = dArray2[n4];
                }
                this.m_trim_remain = 0;
            }
            if ((long)(n4 = dArray3.length) > this.totalSamples - this.m_total_append) {
                n4 = (int)(this.totalSamples - this.m_total_append);
                if (n4 <= 0) {
                    return;
                }
                object3 = dArray4;
                double[] dArray5 = dArray3;
                dArray3 = new double[n4];
                dArray4 = new double[n4];
                for (int i = 0; i < n4; ++i) {
                    if (this.m_abort_required) {
                        return;
                    }
                    dArray3[i] = dArray5[i];
                    dArray4[i] = (double)object3[i];
                }
                object3 = null;
                dArray5 = null;
            }
            object3 = AppManager.getAmplifyCoeffNormalTrack(this.renderingTrack);
            if (this.reflectAmp2Wave) {
                for (int i = 0; i < n4; ++i) {
                    if (this.m_abort_required) {
                        return;
                    }
                    if (i % 100 == 0) {
                        object3 = AppManager.getAmplifyCoeffNormalTrack(this.renderingTrack);
                    }
                    dArray3[i] = dArray3[i] * ((AmplifyCoefficient)object3).left;
                    dArray4[i] = dArray4[i] * ((AmplifyCoefficient)object3).right;
                }
                if (!bl && this.waveWriter != null) {
                    try {
                        this.waveWriter.append(dArray3, dArray4);
                    }
                    catch (Exception exception) {
                        PortUtil.stderr.println("RenderingRunner#waveIncoming; ex=" + exception);
                    }
                }
            } else {
                if (!bl && this.waveWriter != null) {
                    try {
                        this.waveWriter.append(dArray3, dArray4);
                    }
                    catch (Exception exception) {
                        PortUtil.stderr.println("RenderingRunner#waveIncoming; ex=" + exception);
                    }
                }
                for (int i = 0; i < n4; ++i) {
                    if (this.m_abort_required) {
                        return;
                    }
                    if (i % 100 == 0) {
                        object3 = AppManager.getAmplifyCoeffNormalTrack(this.renderingTrack);
                    }
                    dArray3[i] = dArray3[i] * ((AmplifyCoefficient)object3).left;
                    dArray4[i] = dArray4[i] * ((AmplifyCoefficient)object3).right;
                }
            }
            long l = this.m_total_append + (long)(this.waveReadOffsetSeconds * (double)VSTiProxy.SAMPLE_RATE);
            int n5 = this.readers.size();
            double[] dArray6 = new double[n4];
            double[] dArray7 = new double[n4];
            for (n3 = 0; n3 < n5; ++n3) {
                try {
                    waveRateConverter = this.readers.get(n3);
                    ((AmplifyCoefficient)object3).left = 1.0;
                    ((AmplifyCoefficient)object3).right = 1.0;
                    object2 = waveRateConverter.getTag();
                    if (object2 == null || !(object2 instanceof Integer)) continue;
                    n2 = (Integer)object2;
                    if (bl && 0 > n2) continue;
                    if (0 < n2) {
                        object3 = AppManager.getAmplifyCoeffNormalTrack(n2);
                    } else if (0 > n2) {
                        object3 = AppManager.getAmplifyCoeffBgm(-n2 - 1);
                    }
                    waveRateConverter.read(l, n4, dArray7, dArray6);
                    for (n = 0; n < n4; ++n) {
                        if (this.m_abort_required) {
                            return;
                        }
                        int n6 = n;
                        dArray3[n6] = dArray3[n6] + dArray7[n] * ((AmplifyCoefficient)object3).left;
                        int n7 = n;
                        dArray4[n7] = dArray4[n7] + dArray6[n] * ((AmplifyCoefficient)object3).right;
                    }
                    continue;
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("RenderingRunner_DRAFT#waveIncoming; ex=" + exception);
                }
            }
            if (bl && this.waveWriter != null) {
                try {
                    this.waveWriter.append(dArray3, dArray4);
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("RenderingRunner#waveIncoming; ex=" + exception);
                }
            }
            if (bl) {
                for (n3 = 0; n3 < n5; ++n3) {
                    try {
                        waveRateConverter = this.readers.get(n3);
                        object2 = waveRateConverter.getTag();
                        if (object2 == null || !(object2 instanceof Integer) || 0 < (n2 = ((Integer)object2).intValue())) continue;
                        object3 = AppManager.getAmplifyCoeffBgm(-n2 - 1);
                        waveRateConverter.read(l, n4, dArray7, dArray6);
                        for (n = 0; n < n4; ++n) {
                            if (this.m_abort_required) {
                                return;
                            }
                            int n8 = n;
                            dArray3[n8] = dArray3[n8] + dArray7[n] * ((AmplifyCoefficient)object3).left;
                            int n9 = n;
                            dArray4[n9] = dArray4[n9] + dArray6[n] * ((AmplifyCoefficient)object3).right;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        PortUtil.stderr.println("RenderingRunner#waveIncoming; ex=" + exception);
                    }
                }
            }
            dArray7 = null;
            dArray6 = null;
            if (this.directPlay) {
                PlaySound.append(dArray3, dArray4, dArray3.length);
            }
            this.m_total_append += (long)n4;
            for (n3 = 0; n3 < dArray.length; ++n3) {
                dArray[n3] = 0.0;
                dArray2[n3] = 0.0;
            }
        }
    }
}

