/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JToolTip;
import javax.swing.MenuElement;
import org.kbinani.BEvent;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;
import org.kbinani.ValuePair;
import org.kbinani.apputil.PolylineDrawer;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.BezierChain;
import org.kbinani.cadencii.BezierControlType;
import org.kbinani.cadencii.BezierCurves;
import org.kbinani.cadencii.BezierPickedSide;
import org.kbinani.cadencii.BezierPoint;
import org.kbinani.cadencii.CadenciiCommand;
import org.kbinani.cadencii.CurveType;
import org.kbinani.cadencii.DrawObject;
import org.kbinani.cadencii.EditTool;
import org.kbinani.cadencii.FormBezierPointEdit;
import org.kbinani.cadencii.FormCurvePointEdit;
import org.kbinani.cadencii.PlatformEnum;
import org.kbinani.cadencii.PointD;
import org.kbinani.cadencii.RenderRequiredEventHandler;
import org.kbinani.cadencii.RendererKind;
import org.kbinani.cadencii.SelectedBezierPoint;
import org.kbinani.cadencii.SelectedCurveChangedEventHandler;
import org.kbinani.cadencii.SelectedEventEntry;
import org.kbinani.cadencii.SelectedRegion;
import org.kbinani.cadencii.SelectedTrackChangedEventHandler;
import org.kbinani.cadencii.Utility;
import org.kbinani.cadencii.VsqFileEx;
import org.kbinani.vsq.BPPair;
import org.kbinani.vsq.IconHandle;
import org.kbinani.vsq.SingerConfig;
import org.kbinani.vsq.SynthesizerType;
import org.kbinani.vsq.UstEnvelope;
import org.kbinani.vsq.UstEvent;
import org.kbinani.vsq.VibratoBPList;
import org.kbinani.vsq.VibratoBPPair;
import org.kbinani.vsq.VocaloSysUtil;
import org.kbinani.vsq.VsqBPList;
import org.kbinani.vsq.VsqBPPair;
import org.kbinani.vsq.VsqBPPairSearchContext;
import org.kbinani.vsq.VsqBarLineType;
import org.kbinani.vsq.VsqCommand;
import org.kbinani.vsq.VsqEvent;
import org.kbinani.vsq.VsqID;
import org.kbinani.vsq.VsqIDType;
import org.kbinani.vsq.VsqTrack;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BKeyEventArgs;
import org.kbinani.windows.forms.BMenu;
import org.kbinani.windows.forms.BMenuItem;
import org.kbinani.windows.forms.BMouseButtons;
import org.kbinani.windows.forms.BMouseEventArgs;
import org.kbinani.windows.forms.BPanel;
import org.kbinani.windows.forms.BPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackSelector
extends BPanel {
    private static final Color DOT_COLOR_MASTER = Color.red;
    private static final Color CURVE_COLOR = PortUtil.Navy;
    private static final Color CONROL_LINE = Color.orange;
    private static final Color DOT_COLOR_NORMAL = new Color(237, 107, 158);
    private static final Color DOT_COLOR_BASE = new Color(125, 198, 34);
    private static final Color DOT_COLOR_NORMAL_AROUND = new Color(231, 50, 122);
    private static final Color DOT_COLOR_BASE_AROUND = new Color(90, 143, 24);
    private static final Color CURVE_COLOR_DOT = PortUtil.Coral;
    private static final Color BRS_A244_255_023_012 = new Color(255, 23, 12, 244);
    private static final Color BRS_A144_255_255_255 = new Color(255, 255, 255, 144);
    private static final Color s_brs_a072_255_255_255 = new Color(255, 255, 255, 72);
    private static final Color s_brs_a127_008_166_172 = new Color(8, 166, 172, 127);
    private static final Color s_brs_a098_000_000_000 = new Color(0, 0, 0, 98);
    private static final Color s_pen_050_140_150 = new Color(50, 140, 150);
    private static final Color s_pen_128_128_128 = new Color(128, 128, 128);
    private static final Color s_pen_246_251_010 = new Color(246, 251, 10);
    public static final int VEL_BAR_WIDTH = 8;
    static final int NUM_PCOUNTER = 50;
    public static final int OFFSET_TRACK_TAB = 19;
    static final int FOOTER = 7;
    public static final int HEADER = 8;
    static final int BUF_LEN = 512;
    static final int SINGER_ITEM_WIDTH = 66;
    static final int _PX_WIDTH_RENDER = 10;
    static final int DOT_WID = 3;
    static final Rectangle PLUS_MARK = new Rectangle(7, 38, 23, 21);
    static final Rectangle MINUS_MARK = new Rectangle(40, 38, 23, 21);
    static final int VSCROLL_WIDTH = 16;
    static final int ZOOMPANEL_HEIGHT = 33;
    static final int UNIT_HEIGHT_PER_CURVE = 18;
    static final int HEIGHT_WITHOUT_CURVE = 76;
    static final int TRACK_SELECTOR_MAX_WIDTH = 80;
    private CurveType m_selected_curve = CurveType.VEL;
    private CurveType m_last_selected_curve = CurveType.DYN;
    private boolean m_curve_visible = true;
    private int m_mouse_value;
    private int[] m_pointsx = new int[512];
    private int[] m_pointsy = new int[512];
    public int EditingChainID = -1;
    public int EditingPointID = -1;
    private Point m_line_start;
    private boolean m_mouse_downed = false;
    private TreeMap<Integer, Integer> m_mouse_trace;
    private int m_mouse_trace_last_x;
    private int m_mouse_trace_last_y;
    private boolean m_pencil_moved = false;
    private Thread m_mouse_hover_thread = null;
    private RendererKind m_cmenu_singer_prepared = RendererKind.NULL;
    private MouseDownMode m_mouse_down_mode = MouseDownMode.NONE;
    private boolean m_mouse_moved = false;
    private int m_singer_move_started_clock;
    private int[] m_cmenusinger_tooltip_width;
    private int m_veledit_last_selectedid = -1;
    private int m_veledit_shifty = 0;
    private TreeMap<Integer, SelectedEventEntry> m_veledit_selected = new TreeMap();
    private BezierChain m_editing_bezier_original = null;
    private int m_modifier_key = 2;
    private Vector<CurveType> m_viewing_curves = new Vector();
    private Color m_generic_line = new Color(118, 123, 138);
    private boolean m_spacekey_downed = false;
    private Point m_mouse_down_location;
    private int m_envelope_move_id = -1;
    private int m_envelope_point_kind = -1;
    private UstEnvelope m_envelope_original = null;
    private double m_envelope_dot_begin;
    private double m_envelope_dot_end;
    private UstEnvelope m_envelope_editing = null;
    private double m_envelope_range_begin;
    private double m_envelope_range_end;
    private int m_preutterance_viewing = -1;
    private Rectangle m_preutterance_bounds;
    private int m_preutterance_moving_id;
    private int m_overlap_viewing = -1;
    private Rectangle m_overlap_bounds;
    private int m_overlap_moving_id;
    private VsqEvent m_pre_ovl_original = null;
    private VsqEvent m_pre_ovl_editing = null;
    private int m_modifier_on_mouse_down = 0;
    private Vector<BPPair> m_moving_points = new Vector();
    private int m_last_preferred_min_height;
    private PolylineDrawer drawer = new PolylineDrawer(null, 1024);
    public BEvent<SelectedCurveChangedEventHandler> selectedCurveChangedEvent = new BEvent();
    public BEvent<SelectedTrackChangedEventHandler> selectedTrackChangedEvent = new BEvent();
    public BEvent<BEventHandler> commandExecutedEvent = new BEvent();
    public BEvent<RenderRequiredEventHandler> renderRequiredEvent = new BEvent();
    public BEvent<BEventHandler> preferredMinHeightChangedEvent = new BEvent();
    Object tag = null;
    private static final long serialVersionUID = 1L;
    private BPopupMenu cmenuCurve = null;
    private BMenuItem cmenuCurveVelocity = null;
    private BMenuItem cmenuCurveAccent = null;
    private BMenuItem cmenuCurveDecay = null;
    private BMenuItem cmenuCurveDynamics = null;
    private BMenuItem cmenuCurveVibratoRate = null;
    private BMenuItem cmenuCurveVibratoDepth = null;
    private BMenu cmenuCurveReso1 = null;
    private BMenuItem cmenuCurveReso1Freq = null;
    private BMenuItem cmenuCurveReso1BW = null;
    private BMenuItem cmenuCurveReso1Amp = null;
    private BMenu cmenuCurveReso4 = null;
    private BMenuItem cmenuCurveReso4Freq = null;
    private BMenuItem cmenuCurveReso4BW = null;
    private BMenuItem cmenuCurveReso4Amp = null;
    private BMenu cmenuCurveReso3 = null;
    private BMenuItem cmenuCurveReso3Freq = null;
    private BMenuItem cmenuCurveReso3BW = null;
    private BMenuItem cmenuCurveReso3Amp = null;
    private BMenu cmenuCurveReso2 = null;
    private BMenuItem cmenuCurveReso2Freq = null;
    private BMenuItem cmenuCurveReso2BW = null;
    private BMenuItem cmenuCurveReso2Amp = null;
    private BMenuItem cmenuCurveHarmonics = null;
    private BMenuItem cmenuCurveBreathiness = null;
    private BMenuItem cmenuCurveBrightness = null;
    private BMenuItem cmenuCurveClearness = null;
    private BMenuItem cmenuCurveOpening = null;
    private BMenuItem cmenuCurveGenderFactor = null;
    private BMenuItem cmenuCurvePortamentoTiming = null;
    private BMenuItem cmenuCurvePitchBend = null;
    private BMenuItem cmenuCurvePitchBendSensitivity = null;
    private BMenuItem cmenuCurveEffect2Depth = null;
    private BMenuItem cmenuCurveEnvelope = null;
    private JSeparator cmenuCurveSeparator1 = null;
    private JSeparator cmenuCurveSeparator2 = null;
    private JSeparator cmenuCurveSeparator3 = null;
    private JSeparator cmenuCurveSeparator4 = null;
    private JSeparator cmenuCurveSeparator5 = null;
    private BPopupMenu cmenuSinger = null;
    private JScrollBar vScroll = null;
    private JToolTip toolTip = null;

    public TrackSelector() {
        this.initialize();
        this.getCmenuCurve();
        this.getCmenuSinger();
        this.registerEventHandlers();
        this.setResources();
        this.m_modifier_key = AppManager.editorConfig.Platform == PlatformEnum.Macintosh ? 4 : 2;
        this.cmenuCurveVelocity.setTag(CurveType.VEL);
        this.cmenuCurveAccent.setTag(CurveType.Accent);
        this.cmenuCurveDecay.setTag(CurveType.Decay);
        this.cmenuCurveDynamics.setTag(CurveType.DYN);
        this.cmenuCurveVibratoRate.setTag(CurveType.VibratoRate);
        this.cmenuCurveVibratoDepth.setTag(CurveType.VibratoDepth);
        this.cmenuCurveReso1Amp.setTag(CurveType.reso1amp);
        this.cmenuCurveReso1BW.setTag(CurveType.reso1bw);
        this.cmenuCurveReso1Freq.setTag(CurveType.reso1freq);
        this.cmenuCurveReso2Amp.setTag(CurveType.reso2amp);
        this.cmenuCurveReso2BW.setTag(CurveType.reso2bw);
        this.cmenuCurveReso2Freq.setTag(CurveType.reso2freq);
        this.cmenuCurveReso3Amp.setTag(CurveType.reso3amp);
        this.cmenuCurveReso3BW.setTag(CurveType.reso3bw);
        this.cmenuCurveReso3Freq.setTag(CurveType.reso3freq);
        this.cmenuCurveReso4Amp.setTag(CurveType.reso4amp);
        this.cmenuCurveReso4BW.setTag(CurveType.reso4bw);
        this.cmenuCurveReso4Freq.setTag(CurveType.reso4freq);
        this.cmenuCurveHarmonics.setTag(CurveType.harmonics);
        this.cmenuCurveBreathiness.setTag(CurveType.BRE);
        this.cmenuCurveBrightness.setTag(CurveType.BRI);
        this.cmenuCurveClearness.setTag(CurveType.CLE);
        this.cmenuCurveOpening.setTag(CurveType.OPE);
        this.cmenuCurveGenderFactor.setTag(CurveType.GEN);
        this.cmenuCurvePortamentoTiming.setTag(CurveType.POR);
        this.cmenuCurvePitchBend.setTag(CurveType.PIT);
        this.cmenuCurvePitchBendSensitivity.setTag(CurveType.PBS);
        this.cmenuCurveEffect2Depth.setTag(CurveType.fx2depth);
        this.cmenuCurveEnvelope.setTag(CurveType.Env);
    }

    public Point pointToScreen(Point point) {
        Point point2 = this.getLocationOnScreen();
        return new Point(point2.x + point.x, point2.y + point.y);
    }

    public Point pointToClient(Point point) {
        Point point2 = this.getLocationOnScreen();
        return new Point(point.x - point2.x, point.y - point2.y);
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object object) {
        this.tag = object;
    }

    public void applyLanguage() {
    }

    public void applyFont(Font font) {
        Util.applyFontRecurse(this, font);
        Util.applyContextMenuFontRecurse(this.cmenuSinger, font);
        Util.applyContextMenuFontRecurse(this.cmenuCurve, font);
    }

    private int getMaxColumns() {
        int n = AppManager.keyWidth / 68;
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    public int getRowsPerColumn() {
        int n = this.getMaxColumns();
        int n2 = this.m_viewing_curves.size() / n;
        if (n2 * n < this.m_viewing_curves.size()) {
            ++n2;
        }
        return n2;
    }

    public int getPreferredMinSize() {
        return 76 + 18 * this.getRowsPerColumn();
    }

    public void addViewingCurve(CurveType curveType) {
        this.addViewingCurve(new CurveType[]{curveType});
    }

    public void addViewingCurve(CurveType[] curveTypeArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < curveTypeArray.length; ++n2) {
            n = 0;
            for (int i = 0; i < this.m_viewing_curves.size(); ++i) {
                if (!this.m_viewing_curves.get(i).equals(curveTypeArray[n2])) continue;
                n = 1;
                break;
            }
            if (n != 0) continue;
            this.m_viewing_curves.add(curveTypeArray[n2]);
        }
        if (this.m_viewing_curves.size() >= 2) {
            n2 = 1;
            while (n2 != 0) {
                n2 = 0;
                for (n = 0; n < this.m_viewing_curves.size() - 1; ++n) {
                    if (this.m_viewing_curves.get(n).getIndex() <= this.m_viewing_curves.get(n + 1).getIndex()) continue;
                    CurveType curveType = this.m_viewing_curves.get(n);
                    this.m_viewing_curves.set(n, this.m_viewing_curves.get(n + 1));
                    this.m_viewing_curves.set(n + 1, curveType);
                    n2 = 1;
                }
            }
        }
    }

    public void clearViewingCurve() {
        this.m_viewing_curves.clear();
    }

    public void removeViewingCurve(CurveType curveType) {
        for (int i = 0; i < this.m_viewing_curves.size(); ++i) {
            if (!this.m_viewing_curves.get(i).equals(curveType)) continue;
            this.m_viewing_curves.removeElementAt(i);
            break;
        }
    }

    private void executeCommand(CadenciiCommand cadenciiCommand, boolean bl) {
        if (bl) {
            AppManager.register(AppManager.getVsqFile().executeCommand(cadenciiCommand));
        } else {
            AppManager.getVsqFile().executeCommand(cadenciiCommand);
        }
        try {
            this.commandExecutedEvent.raise(this, new BEventArgs());
        }
        catch (Exception exception) {
            PortUtil.stderr.println("TrackSelector#executeCommand; ex=" + exception);
        }
    }

    public ValuePair<Integer, Integer> getSelectedRegion() {
        int n = AppManager.curveSelectedInterval.getStart();
        int n2 = AppManager.curveSelectedInterval.getEnd();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        return new ValuePair<Integer, Integer>(n3, n4);
    }

    public CurveType getSelectedCurve() {
        return this.m_selected_curve;
    }

    public void setSelectedCurve(CurveType curveType) {
        CurveType curveType2 = this.m_selected_curve;
        this.m_selected_curve = curveType;
        if (!curveType2.equals(this.m_selected_curve)) {
            this.m_last_selected_curve = curveType2;
            try {
                this.selectedCurveChangedEvent.raise(this, this.m_selected_curve);
            }
            catch (Exception exception) {
                PortUtil.stderr.println("TrackSelector#setSelectedCurve; ex=" + exception);
            }
        }
    }

    public int valueFromYCoord(int n) {
        int n2 = this.m_selected_curve.getMaximum();
        int n3 = this.m_selected_curve.getMinimum();
        return this.valueFromYCoord(n, n2, n3);
    }

    public int valueFromYCoord(int n, int n2, int n3) {
        int n4 = this.getHeight() - 42;
        float f = (float)this.getGraphHeight() / (float)(n2 - n3);
        return (int)((float)(n4 - n) / f) + n3;
    }

    public int yCoordFromValue(int n) {
        int n2 = this.m_selected_curve.getMaximum();
        int n3 = this.m_selected_curve.getMinimum();
        return this.yCoordFromValue(n, n2, n3);
    }

    public int yCoordFromValue(int n, int n2, int n3) {
        int n4 = this.getHeight() - 42;
        float f = (float)this.getGraphHeight() / (float)(n2 - n3);
        return n4 - (int)((float)(n - n3) * f);
    }

    public boolean isCurveVisible() {
        return this.m_curve_visible;
    }

    public void setCurveVisible(boolean bl) {
        this.m_curve_visible = bl;
    }

    public float getScaleY() {
        int n = this.m_selected_curve.getMaximum();
        int n2 = this.m_selected_curve.getMinimum();
        int n3 = this.getHeight() - 42;
        return (float)this.getGraphHeight() / (float)(n - n2);
    }

    public Rectangle getRectFromCurveType(CurveType curveType) {
        int n;
        int n2 = this.getRowsPerColumn();
        int n3 = 17 + this.getGraphHeight() / 2 + 8;
        int n4 = 100;
        for (n = 0; n < this.m_viewing_curves.size(); ++n) {
            if (!this.m_viewing_curves.get(n).equals(curveType)) continue;
            n4 = n;
            break;
        }
        n = n4 / n2;
        int n5 = n4 - n * n2;
        int n6 = 7 + n * 68;
        int n7 = n3 - n2 * 18 / 2 + 2 + 18 * n5;
        int n8 = this.getPreferredMinSize();
        if (this.m_last_preferred_min_height != n8) {
            try {
                this.preferredMinHeightChangedEvent.raise(this, new BEventArgs());
            }
            catch (Exception exception) {
                PortUtil.stderr.println("TrackSelector#getRectFromCurveType; ex=" + exception);
            }
            this.m_last_preferred_min_height = n8;
        }
        return new Rectangle(n6, n7, 56, 14);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = new Dimension(this.getWidth() - this.vScroll.getWidth() + 2, this.getHeight());
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = Color.black;
        Color color2 = new Color(41, 46, 55);
        int n = 8 + this.getGraphHeight() / 2;
        graphics2D.setColor(Color.darkGray);
        graphics2D.fillRect(0, dimension.height - 38, dimension.width, 38);
        int n2 = this.m_mouse_value;
        Point point = this.pointToClient(PortUtil.getMousePosition());
        Point point2 = new Point(point.x, point.y);
        VsqFileEx vsqFileEx = AppManager.getVsqFile();
        int n3 = AppManager.getSelected();
        int n4 = AppManager.keyWidth;
        int n5 = AppManager.startToDrawX;
        int n6 = this.getGraphHeight();
        int n7 = this.getWidth();
        try {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            Shape shape = graphics2D.getClip();
            graphics2D.setColor(this.m_generic_line);
            graphics2D.drawLine(2, dimension.height - 38, dimension.width - 3, dimension.height - 38);
            graphics2D.drawLine(n4, dimension.height - 38 + 1, n4, dimension.height - 38 + 15);
            graphics2D.setFont(AppManager.superFont8);
            graphics2D.setColor(color);
            graphics2D.drawString("SINGER", 9, dimension.height - 38 + 9 - AppManager.superFont8OffsetHeight);
            graphics2D.clipRect(n4, dimension.height - 38, dimension.width - n4, 19);
            VsqTrack vsqTrack = null;
            if (vsqFileEx != null) {
                vsqTrack = (VsqTrack)vsqFileEx.Track.get(n3);
            }
            if (vsqTrack != null) {
                n12 = vsqTrack.getEventCount();
                for (n11 = 0; n11 < n12; ++n11) {
                    VsqEvent vsqEvent = vsqTrack.getEvent(n11);
                    if (vsqEvent.ID.type != VsqIDType.Singer) continue;
                    n10 = vsqEvent.Clock;
                    IconHandle iconHandle = vsqEvent.ID.IconHandle;
                    n9 = AppManager.xCoordFromClocks(n10);
                    Rectangle rectangle = new Rectangle(n9, dimension.height - 38 + 1, 66, 14);
                    graphics2D.setColor(Color.white);
                    graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    if (AppManager.isSelectedEventContains(n3, vsqEvent.InternalID)) {
                        graphics2D.setColor(AppManager.getHilightColor());
                        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        graphics2D.setColor(color);
                        graphics2D.drawString(iconHandle.IDS, rectangle.x, rectangle.y);
                        continue;
                    }
                    graphics2D.setColor(new Color(182, 182, 182));
                    graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics2D.setColor(color);
                    graphics2D.drawString(iconHandle.IDS, rectangle.x, rectangle.y);
                }
            }
            graphics2D.setClip(shape);
            n12 = this.getSelectorWidth();
            graphics2D.setColor(this.m_generic_line);
            graphics2D.drawLine(1, dimension.height - 19, dimension.width - 2, dimension.height - 19);
            graphics2D.setColor(color);
            graphics2D.drawString("TRACK", 9, dimension.height - 19 + 9 - AppManager.superFont8OffsetHeight);
            if (vsqFileEx != null) {
                for (n11 = 0; n11 < 16; ++n11) {
                    int n13 = n4 + n11 * n12;
                    this.drawTrackTab(graphics2D, new Rectangle(n13, dimension.height - 19 + 1, n12, 18), n11 + 1 < vsqFileEx.Track.size() ? n11 + 1 + " " + ((VsqTrack)vsqFileEx.Track.get(n11 + 1)).getName() : "", n11 == n3 - 1, vsqTrack.getCommon().PlayMode >= 0, AppManager.getRenderRequired(n11 + 1), AppManager.HILIGHT[n11], AppManager.RENDER[n11]);
                }
            }
            n11 = AppManager.clockFromXCoord(point2.x);
            int n14 = 0;
            if (this.m_curve_visible) {
                int n15;
                int n16;
                int n172;
                int n18;
                int n19;
                int n20;
                Object object;
                int n21;
                Serializable serializable;
                Serializable serializable2;
                graphics2D.setColor(new Color(156, 161, 169));
                graphics2D.drawLine(n4, dimension.height - 42, dimension.width - 3, dimension.height - 42);
                graphics2D.setColor(new Color(46, 47, 50));
                graphics2D.drawLine(n4, 8, dimension.width - 3, 8);
                graphics2D.setColor(new Color(125, 123, 124));
                graphics2D.drawLine(n4, 0, n4, dimension.height);
                if (AppManager.isCurveSelectedIntervalEnabled()) {
                    n10 = AppManager.xCoordFromClocks(AppManager.curveSelectedInterval.getStart());
                    int n22 = AppManager.xCoordFromClocks(AppManager.curveSelectedInterval.getEnd());
                    graphics2D.setColor(s_brs_a072_255_255_255);
                    graphics2D.fillRect(n10, 8, n22 - n10, this.getGraphHeight());
                }
                if (AppManager.drawObjects != null && n3 - 1 < AppManager.drawObjects.size() && AppManager.drawItemBorderInControlCurveView && !this.m_selected_curve.equals(CurveType.VibratoDepth) && !this.m_selected_curve.equals(CurveType.VibratoRate)) {
                    Vector<Vector<DrawObject>> vector = AppManager.drawObjects;
                    synchronized (vector) {
                        Vector<DrawObject> vector2 = AppManager.drawObjects.get(n3 - 1);
                        n9 = AppManager.drawStartIndex[n3 - 1];
                        int n23 = vector2.size();
                        serializable2 = new Color(0, 0, 0, 128);
                        serializable = new Color(0, 0, 0, 32);
                        for (n21 = n9; n21 < n23; ++n21) {
                            object = vector2.get(n21);
                            n20 = ((DrawObject)object).pxRectangle.x + n4 - n5;
                            n19 = ((DrawObject)object).pxRectangle.width;
                            n18 = n20 + n19;
                            if (n7 < n20) break;
                            graphics2D.setColor((Color)serializable);
                            graphics2D.fillRect(n20, 8, n19, n6);
                            graphics2D.setColor((Color)serializable2);
                            graphics2D.drawLine(n20, 8, n20, 8 + n6);
                            graphics2D.drawLine(n18, 8, n18, 8 + n6);
                        }
                    }
                }
                if (vsqFileEx != null) {
                    int n24 = AppManager.getPositionQuantizeClock();
                    graphics2D.clipRect(n4, 8, dimension.width - n4, dimension.height - 38);
                    Color color3 = new Color(0, 0, 0, 100);
                    Iterator<VsqBarLineType> iterator = vsqFileEx.getBarLineIterator(AppManager.clockFromXCoord(this.getWidth()));
                    while (iterator.hasNext()) {
                        VsqBarLineType vsqBarLineType = iterator.next();
                        int n25 = AppManager.xCoordFromClocks(vsqBarLineType.clock());
                        int n26 = 1920 / vsqBarLineType.getLocalDenominator();
                        if (vsqBarLineType.isSeparator()) {
                            graphics2D.setColor(color3);
                            graphics2D.drawLine(n25, dimension.height - 42 - 1, n25, 9);
                        } else {
                            graphics2D.setColor(color3);
                            graphics2D.drawLine(n25, n - 5, n25, n + 6);
                            Color color4 = new Color(12, 12, 12);
                            graphics2D.setColor(color4);
                            graphics2D.drawLine(n25, 8, n25, 14);
                            graphics2D.drawLine(n25, dimension.height - 43, n25, dimension.height - 42 - 6);
                        }
                        if (n24 <= 1 || !AppManager.isGridVisible()) continue;
                        n21 = n26 / n24;
                        object = new Color(65, 65, 65);
                        graphics2D.setColor((Color)object);
                        for (n20 = 1; n20 < n21; ++n20) {
                            n19 = AppManager.xCoordFromClocks(vsqBarLineType.clock() + n20 * n24);
                            graphics2D.drawLine(n19, n - 2, n19, n + 3);
                            graphics2D.drawLine(n19, 8, n19, 12);
                            graphics2D.drawLine(n19, dimension.height - 43, n19, dimension.height - 43 - 4);
                        }
                    }
                    graphics2D.setClip(null);
                }
                if (vsqTrack != null) {
                    Color color5 = AppManager.getHilightColor();
                    Color color6 = new Color(color5.getRed(), color5.getGreen(), color5.getBlue(), 150);
                    Color color7 = new Color(255, 249, 255, 44);
                    Color color8 = new Color(64, 78, 30);
                    if (this.m_last_selected_curve.equals(CurveType.VEL) || this.m_last_selected_curve.equals(CurveType.Accent) || this.m_last_selected_curve.equals(CurveType.Decay)) {
                        this.drawVEL(graphics2D, vsqTrack, color7, false, this.m_last_selected_curve);
                    } else if (this.m_last_selected_curve.equals(CurveType.VibratoRate) || this.m_last_selected_curve.equals(CurveType.VibratoDepth)) {
                        this.drawVibratoControlCurve(graphics2D, vsqTrack, this.m_last_selected_curve, color7, false);
                    } else {
                        serializable2 = vsqTrack.getCurve(this.m_last_selected_curve.getName());
                        if (serializable2 != null) {
                            this.drawVsqBPList(graphics2D, (VsqBPList)serializable2, color7, false);
                        }
                    }
                    if (this.m_selected_curve.equals(CurveType.VEL) || this.m_selected_curve.equals(CurveType.Accent) || this.m_selected_curve.equals(CurveType.Decay)) {
                        this.drawVEL(graphics2D, vsqTrack, color8, true, this.m_selected_curve);
                    } else if (this.m_selected_curve.equals(CurveType.VibratoRate) || this.m_selected_curve.equals(CurveType.VibratoDepth)) {
                        this.drawVibratoControlCurve(graphics2D, vsqTrack, this.m_selected_curve, color6, true);
                    } else if (this.m_selected_curve.equals(CurveType.Env)) {
                        this.drawEnvelope(graphics2D, vsqTrack, color6);
                    } else {
                        serializable2 = vsqTrack.getCurve(this.m_selected_curve.getName());
                        if (serializable2 != null) {
                            this.drawVsqBPList(graphics2D, (VsqBPList)serializable2, color6, true);
                        }
                        if (this.m_selected_curve.equals(CurveType.PIT)) {
                            int n27;
                            int n28;
                            int n29;
                            int n30;
                            int n31;
                            int n32;
                            serializable = new Color(0, 0, 0, 190);
                            Color color9 = new Color(0, 0, 0, 128);
                            object = new BasicStroke();
                            BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
                            VsqBPList vsqBPList = vsqTrack.getCurve(CurveType.PBS.getName());
                            n14 = vsqBPList.getValue(n11);
                            n18 = vsqBPList.size();
                            n172 = vsqFileEx.getPreMeasureClocks();
                            n16 = AppManager.clockFromXCoord(n4);
                            n15 = AppManager.clockFromXCoord(this.getWidth());
                            if (n16 < n172 && n172 < n15) {
                                n16 = n172;
                            }
                            int n33 = vsqBPList.getValue(n16);
                            int n34 = n16;
                            int n35 = this.yCoordFromValue(0);
                            graphics2D.setColor((Color)serializable);
                            graphics2D.drawLine(n4, n35, this.getWidth(), n35);
                            for (n32 = 0; n32 < n18; ++n32) {
                                n31 = vsqBPList.getKeyClock(n32);
                                if (n31 < n16) continue;
                                if (n15 < n31) break;
                                n30 = vsqBPList.getElement(n32);
                                if (n33 == n30) continue;
                                n29 = n33;
                                n28 = -n33;
                                n27 = AppManager.xCoordFromClocks(n34);
                                int n36 = AppManager.xCoordFromClocks(n31);
                                for (int i = n28 + 1; i <= n29 - 1; ++i) {
                                    if (i == 0) continue;
                                    int n37 = this.yCoordFromValue((int)((double)(i * 8192) / (double)n33));
                                    if (i % 2 == 0) {
                                        graphics2D.setColor((Color)serializable);
                                        graphics2D.setStroke((Stroke)object);
                                        graphics2D.drawLine(n27, n37, n36, n37);
                                        continue;
                                    }
                                    graphics2D.setColor(color9);
                                    graphics2D.setStroke(basicStroke);
                                    graphics2D.drawLine(n27, n37, n36, n37);
                                }
                                graphics2D.setStroke(new BasicStroke());
                                n34 = n31;
                                n33 = n30;
                            }
                            n32 = n33;
                            n31 = -n33;
                            n30 = AppManager.xCoordFromClocks(n34);
                            n29 = AppManager.xCoordFromClocks(n15);
                            for (n28 = n31 + 1; n28 <= n32 - 1; ++n28) {
                                if (n28 == 0) continue;
                                n27 = this.yCoordFromValue((int)((double)(n28 * 8192) / (double)n33));
                                Serializable serializable3 = color9;
                                if (n28 % 2 == 0) {
                                    serializable3 = serializable;
                                }
                                graphics2D.setColor((Color)serializable3);
                                graphics2D.drawLine(n30, n27, n29, n27);
                            }
                        }
                        this.drawAttachedCurve(graphics2D, vsqFileEx.AttachedCurves.get(AppManager.getSelected() - 1).get(this.m_selected_curve));
                    }
                }
                if (AppManager.isWholeSelectedIntervalEnabled()) {
                    int n38 = AppManager.xCoordFromClocks(AppManager.wholeSelectedInterval.getStart()) + 2;
                    int n39 = AppManager.xCoordFromClocks(AppManager.wholeSelectedInterval.getEnd()) + 2;
                    graphics2D.setColor(s_brs_a098_000_000_000);
                    graphics2D.fillRect(n38, 8, n39 - n38, this.getGraphHeight());
                }
                if (this.m_mouse_downed) {
                    int n40 = this.valueFromYCoord(point2.y);
                    if (n11 < vsqFileEx.getPreMeasure()) {
                        n11 = vsqFileEx.getPreMeasure();
                    }
                    int n41 = this.m_selected_curve.getMaximum();
                    int n42 = this.m_selected_curve.getMinimum();
                    if (n40 < n42) {
                        n40 = n42;
                    } else if (n41 < n40) {
                        n40 = n41;
                    }
                    EditTool editTool = AppManager.getSelectedTool();
                    if (editTool == EditTool.LINE) {
                        int n43 = AppManager.xCoordFromClocks(this.m_line_start.x);
                        int n44 = this.yCoordFromValue(this.m_line_start.y);
                        graphics2D.setColor(s_pen_050_140_150);
                        graphics2D.drawLine(n43, n44, AppManager.xCoordFromClocks(n11), this.yCoordFromValue(n40));
                    } else if (editTool == EditTool.PENCIL) {
                        if (this.m_mouse_trace != null && !AppManager.isCurveMode()) {
                            serializable2 = new Vector();
                            serializable = new Vector();
                            n21 = this.getHeight() - 42;
                            int n45 = 0;
                            n20 = 0;
                            n19 = 0;
                            for (int n172 : this.m_mouse_trace.keySet()) {
                                n16 = n172 - n5;
                                n15 = this.m_mouse_trace.get(n172);
                                if (n15 < 8) {
                                    n15 = 8;
                                } else if (n21 < n15) {
                                    n15 = n21;
                                }
                                if (n45 == 0) {
                                    n19 = n21;
                                }
                                ((Vector)serializable2).add(n16);
                                ((Vector)serializable).add(n19);
                                ((Vector)serializable2).add(n16);
                                ((Vector)serializable).add(n15);
                                n20 = n16;
                                n19 = n15;
                                ++n45;
                            }
                            ((Vector)serializable2).add(n20);
                            ((Vector)serializable).add(n21);
                            graphics2D.setColor(new Color(8, 166, 172, 127));
                            n18 = ((Vector)serializable2).size();
                            graphics2D.fillPolygon(PortUtil.convertIntArray(((Vector)serializable2).toArray(new Integer[0])), PortUtil.convertIntArray(((Vector)serializable).toArray(new Integer[0])), n18);
                        }
                    } else if (editTool == EditTool.ERASER || editTool == EditTool.ARROW) {
                        if (this.m_mouse_down_mode == MouseDownMode.CURVE_EDIT && this.m_mouse_moved && AppManager.curveSelectingRectangle.width != 0) {
                            int n46;
                            int n47 = AppManager.xCoordFromClocks(AppManager.curveSelectingRectangle.x);
                            n21 = Math.min(n47, n46 = AppManager.xCoordFromClocks(AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width));
                            if (n21 < n4) {
                                n21 = n4;
                            }
                            int n48 = Math.max(n47, n46);
                            n20 = this.yCoordFromValue(AppManager.curveSelectingRectangle.y);
                            n19 = this.yCoordFromValue(AppManager.curveSelectingRectangle.y + AppManager.curveSelectingRectangle.height);
                            n18 = Math.min(n20, n19);
                            n172 = Math.max(n20, n19);
                            if (n18 < 8) {
                                n18 = 8;
                            }
                            if (n172 > this.getHeight() - 42 - 8) {
                                n172 = this.getHeight() - 42;
                            }
                            if (n21 < n48) {
                                graphics2D.setColor(BRS_A144_255_255_255);
                                graphics2D.fillRect(n21, n18, n48 - n21, n172 - n18);
                            }
                        } else if (this.m_mouse_down_mode == MouseDownMode.VEL_EDIT && this.m_veledit_selected.containsKey(this.m_veledit_last_selectedid)) {
                            if (this.m_selected_curve.equals(CurveType.VEL)) {
                                n2 = this.m_veledit_selected.get((Object)Integer.valueOf((int)this.m_veledit_last_selectedid)).editing.ID.Dynamics;
                            } else if (this.m_selected_curve.equals(CurveType.Accent)) {
                                n2 = this.m_veledit_selected.get((Object)Integer.valueOf((int)this.m_veledit_last_selectedid)).editing.ID.DEMaccent;
                            } else if (this.m_selected_curve.equals(CurveType.Decay)) {
                                n2 = this.m_veledit_selected.get((Object)Integer.valueOf((int)this.m_veledit_last_selectedid)).editing.ID.DEMdecGainRate;
                            }
                        }
                    }
                    if (this.m_mouse_down_mode == MouseDownMode.SINGER_LIST && AppManager.getSelectedTool() != EditTool.ERASER) {
                        Iterator<SelectedEventEntry> iterator = AppManager.getSelectedEventIterator();
                        while (iterator.hasNext()) {
                            SelectedEventEntry selectedEventEntry = iterator.next();
                            n21 = AppManager.xCoordFromClocks(selectedEventEntry.editing.Clock);
                            graphics2D.setColor(s_pen_128_128_128);
                            graphics2D.drawPolyline(new int[]{n21, n21, n21 + 66, n21 + 66}, new int[]{dimension.height - 19, dimension.height - 38 + 1, dimension.height - 38 + 1, dimension.height - 19}, 4);
                            graphics2D.setColor(s_pen_246_251_010);
                            graphics2D.drawLine(n21, dimension.height - 19, n21 + 66, dimension.height - 19);
                        }
                    }
                }
            }
            if (this.m_curve_visible) {
                Color color10 = Color.black;
                graphics2D.setColor(new Color(212, 212, 212));
                graphics2D.fillRect(0, 0, n4, dimension.height - 38);
                Rectangle rectangle = new Rectangle(13, 4, 38, 16);
                graphics2D.setColor(new Color(125, 123, 124));
                graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics2D.setFont(AppManager.superFont9);
                graphics2D.setColor(color);
                graphics2D.drawString(n2 + "", rectangle.x, rectangle.y + rectangle.height / 2 - AppManager.superFont9OffsetHeight + 1);
                graphics2D.drawString(this.m_selected_curve.getName(), 7, 24 + AppManager.superFont9Height / 2 - AppManager.superFont9OffsetHeight + 1);
                for (CurveType curveType : this.m_viewing_curves) {
                    Rectangle rectangle2 = this.getRectFromCurveType(curveType);
                    if (curveType.equals(this.m_selected_curve) || curveType.equals(this.m_last_selected_curve)) {
                        graphics2D.setColor(new Color(108, 108, 108));
                        graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    }
                    graphics2D.setColor(color2);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y + rectangle2.height / 2 - AppManager.superFont9OffsetHeight, rectangle2.width, rectangle2.height);
                    rectangle3.y += 2;
                    if (curveType.equals(this.m_selected_curve)) {
                        graphics2D.setColor(Color.white);
                        graphics2D.drawString(curveType.getName(), rectangle3.x, rectangle3.y);
                        continue;
                    }
                    graphics2D.setColor(color10);
                    graphics2D.drawString(curveType.getName(), rectangle3.x, rectangle3.y);
                }
            }
            if (n4 <= (n8 = AppManager.xCoordFromClocks(AppManager.getCurrentClock())) && n8 <= dimension.width) {
                graphics2D.setColor(Color.white);
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.drawLine(n8, 0, n8, dimension.height - 18);
                graphics2D.setStroke(new BasicStroke());
            }
            if (TrackSelector.isInRect(point2.x, point2.y, new Rectangle(n4, 8, this.getWidth(), this.getGraphHeight())) && this.m_mouse_down_mode != MouseDownMode.PRE_UTTERANCE_MOVE && this.m_mouse_down_mode != MouseDownMode.OVERLAP_MOVE && this.m_mouse_down_mode != MouseDownMode.VEL_EDIT) {
                int n49 = 1;
                int n50 = 0;
                int n51 = 50;
                if (this.m_selected_curve.equals(CurveType.PIT)) {
                    n50 = 1;
                    n51 = 100;
                }
                graphics2D.setFont(AppManager.superFont10Bold);
                graphics2D.setColor(Color.white);
                PortUtil.drawStringEx(graphics2D, this.m_mouse_value + "", AppManager.superFont10Bold, new Rectangle(point2.x - 100, point2.y - n51, 100, 100), n49, n50);
                if (this.m_selected_curve.equals(CurveType.PIT)) {
                    float f = (float)(this.m_mouse_value * n14) / 8192.0f;
                    n49 = 1;
                    n50 = -1;
                    PortUtil.drawStringEx(graphics2D, PortUtil.formatDecimal("#0.00", f), AppManager.superFont10Bold, new Rectangle(point2.x - 100, point2.y, 100, 100), n49, n50);
                }
            }
            graphics2D.setColor(new Color(160, 160, 160));
            graphics2D.drawLine(0, 0, 0, dimension.height - 2);
            graphics2D.setColor(new Color(105, 105, 105));
            graphics2D.drawLine(1, 0, 1, dimension.height - 1);
            graphics2D.setColor(new Color(192, 192, 192));
            graphics2D.drawLine(1, dimension.height - 2, dimension.width + 20, dimension.height - 2);
            graphics2D.setColor(Color.white);
            graphics2D.drawLine(0, dimension.height - 1, dimension.width + 20, dimension.height - 1);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("TrackSelector#paint; ex= " + exception);
        }
    }

    private void drawEnvelope(Graphics2D graphics2D, VsqTrack vsqTrack, Color color) {
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2 = AppManager.clockFromXCoord(AppManager.keyWidth);
        int n3 = AppManager.clockFromXCoord(this.getWidth());
        VsqFileEx vsqFileEx = AppManager.getVsqFile();
        Object object4 = null;
        Object object5 = null;
        Point point = this.pointToClient(PortUtil.getMousePosition());
        Point point2 = new Point(point.x, point.y);
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = -1;
        int n7 = Integer.MAX_VALUE;
        float f = 0.0f;
        float f2 = 0.0f;
        Color color2 = color;
        Point point3 = new Point();
        boolean bl = false;
        boolean bl2 = 0 <= point2.y && point2.y <= this.getHeight();
        Iterator<VsqEvent> iterator = vsqTrack.getNoteEventIterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (object4 == null) {
                object4 = object3;
                continue;
            }
            if (((VsqEvent)object3).Clock + ((VsqEvent)object3).ID.getLength() < n2) {
                object4 = object3;
                continue;
            }
            if (n3 < ((VsqEvent)object3).Clock) break;
            object2 = new ByRef();
            object = new ByRef();
            Polygon polygon = this.getEnvelopePoints(vsqFileEx, (VsqEvent)object4, (VsqEvent)object3, (ByRef<Integer>)object2, (ByRef<Integer>)object);
            if (this.m_mouse_down_mode == MouseDownMode.ENVELOPE_MOVE || this.m_mouse_down_mode == MouseDownMode.PRE_UTTERANCE_MOVE || this.m_mouse_down_mode == MouseDownMode.OVERLAP_MOVE) {
                if (this.m_mouse_down_mode == MouseDownMode.ENVELOPE_MOVE && ((VsqEvent)object4).InternalID == this.m_envelope_move_id) {
                    point3 = new Point(polygon.xpoints[this.m_envelope_point_kind], polygon.ypoints[this.m_envelope_point_kind]);
                    bl = true;
                    object5 = polygon;
                    n5 = (Integer)((ByRef)object).value;
                    n4 = (Integer)((ByRef)object2).value;
                    f = ((VsqEvent)object4).UstEvent.PreUtterance;
                    f2 = ((VsqEvent)object4).UstEvent.VoiceOverlap;
                    n6 = ((VsqEvent)object4).InternalID;
                } else if (this.m_mouse_down_mode == MouseDownMode.PRE_UTTERANCE_MOVE && ((VsqEvent)object4).InternalID == this.m_preutterance_moving_id || this.m_mouse_down_mode == MouseDownMode.OVERLAP_MOVE && ((VsqEvent)object4).InternalID == this.m_overlap_moving_id) {
                    object5 = polygon;
                    n5 = (Integer)((ByRef)object).value;
                    n4 = (Integer)((ByRef)object2).value;
                    f = ((VsqEvent)object4).UstEvent.PreUtterance;
                    f2 = ((VsqEvent)object4).UstEvent.VoiceOverlap;
                    n6 = ((VsqEvent)object4).InternalID;
                }
            } else if (bl2) {
                n = Integer.MAX_VALUE;
                n = polygon.xpoints[0] <= point2.x && point2.x <= polygon.xpoints[6] ? 0 : (point2.x < polygon.xpoints[0] ? polygon.xpoints[0] - point2.x : point2.x - polygon.xpoints[6]);
                if (n7 > n) {
                    n7 = n;
                    object5 = polygon;
                    n5 = (Integer)((ByRef)object).value;
                    n4 = (Integer)((ByRef)object2).value;
                    f = ((VsqEvent)object4).UstEvent.PreUtterance;
                    f2 = ((VsqEvent)object4).UstEvent.VoiceOverlap;
                    n6 = ((VsqEvent)object4).InternalID;
                }
            }
            graphics2D.setColor(color2);
            graphics2D.fillPolygon(polygon);
            graphics2D.setColor(Color.white);
            graphics2D.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
            object4 = object3;
        }
        int n8 = 7;
        if (vsqFileEx != null && object4 != null) {
            object3 = new ByRef();
            object2 = new ByRef<Integer>();
            object = this.getEnvelopePoints(vsqFileEx, (VsqEvent)object4, null, (ByRef<Integer>)object3, (ByRef<Integer>)object2);
            if (this.m_mouse_down_mode == MouseDownMode.ENVELOPE_MOVE || this.m_mouse_down_mode == MouseDownMode.PRE_UTTERANCE_MOVE || this.m_mouse_down_mode == MouseDownMode.OVERLAP_MOVE) {
                if (this.m_mouse_down_mode == MouseDownMode.ENVELOPE_MOVE && ((VsqEvent)object4).InternalID == this.m_envelope_move_id) {
                    point3 = new Point(((Polygon)object).xpoints[this.m_envelope_point_kind], ((Polygon)object).ypoints[this.m_envelope_point_kind]);
                    bl = true;
                    object5 = object;
                    n5 = (Integer)((ByRef)object2).value;
                    n4 = (Integer)((ByRef)object3).value;
                    f = ((VsqEvent)object4).UstEvent.PreUtterance;
                    f2 = ((VsqEvent)object4).UstEvent.VoiceOverlap;
                    n6 = ((VsqEvent)object4).InternalID;
                } else if (this.m_mouse_down_mode == MouseDownMode.PRE_UTTERANCE_MOVE && ((VsqEvent)object4).InternalID == this.m_preutterance_moving_id || this.m_mouse_down_mode == MouseDownMode.OVERLAP_MOVE && ((VsqEvent)object4).InternalID == this.m_overlap_moving_id) {
                    object5 = object;
                    n5 = (Integer)((ByRef)object2).value;
                    n4 = (Integer)((ByRef)object3).value;
                    f = ((VsqEvent)object4).UstEvent.PreUtterance;
                    f2 = ((VsqEvent)object4).UstEvent.VoiceOverlap;
                    n6 = ((VsqEvent)object4).InternalID;
                }
            } else if (bl2) {
                int n9 = Integer.MAX_VALUE;
                if (((Polygon)object).xpoints[0] - n8 <= point2.x && point2.x <= ((Polygon)object).xpoints[6] + n8) {
                    for (n = 1; n < 6; ++n) {
                        Point point4 = new Point(((Polygon)object).xpoints[n], ((Polygon)object).ypoints[n]);
                        Rectangle rectangle = new Rectangle(point4.x - 3, point4.y - 3, n8, n8);
                        graphics2D.setColor(DOT_COLOR_NORMAL);
                        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        graphics2D.setColor(DOT_COLOR_NORMAL);
                        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                    n9 = 0;
                } else {
                    n9 = point2.x < ((Polygon)object).xpoints[0] ? ((Polygon)object).xpoints[0] - point2.x : point2.x - ((Polygon)object).xpoints[6];
                }
                if (n7 > n9) {
                    n7 = n9;
                    object5 = object;
                    n5 = (Integer)((ByRef)object2).value;
                    n4 = (Integer)((ByRef)object3).value;
                    f = ((VsqEvent)object4).UstEvent.PreUtterance;
                    f2 = ((VsqEvent)object4).UstEvent.VoiceOverlap;
                    n6 = ((VsqEvent)object4).InternalID;
                }
            }
            graphics2D.setColor(color2);
            graphics2D.fillPolygon((Polygon)object);
            graphics2D.setColor(Color.white);
            graphics2D.drawPolyline(((Polygon)object).xpoints, ((Polygon)object).ypoints, ((Polygon)object).npoints);
        }
        if (object5 != null) {
            for (int i = 1; i < 6; ++i) {
                object2 = new Point(((Polygon)object5).xpoints[i], ((Polygon)object5).ypoints[i]);
                object = new Rectangle(((Point)object2).x - 3, ((Point)object2).y - 3, n8, n8);
                graphics2D.setColor(DOT_COLOR_NORMAL);
                graphics2D.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
                graphics2D.setColor(DOT_COLOR_NORMAL);
                graphics2D.drawRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            }
        }
        if (bl) {
            Rectangle rectangle = new Rectangle(point3.x - 3, point3.y - 3, n8, n8);
            graphics2D.setColor(AppManager.getHilightColor());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setColor(DOT_COLOR_NORMAL);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (n4 != Integer.MIN_VALUE && n5 != Integer.MIN_VALUE) {
            this.drawPreutteranceAndOverlap(graphics2D, n4, n5, f, f2);
        }
        this.m_overlap_viewing = n6;
        this.m_preutterance_viewing = n6;
    }

    private void drawPreutteranceAndOverlap(Graphics2D graphics2D, int n, int n2, float f, float f2) {
        int n3 = 15;
        int n4 = 40;
        graphics2D.setColor(PortUtil.Orange);
        graphics2D.drawLine(n, 9, n, this.getGraphHeight() + 8);
        graphics2D.setColor(PortUtil.LawnGreen);
        graphics2D.drawLine(n2, 9, n2, this.getGraphHeight() + 8);
        String string = "Pre Utterance: " + f;
        Dimension dimension = Util.measureString(string, AppManager.superFont10);
        this.m_preutterance_bounds = new Rectangle(n + 1, n3, dimension.width, dimension.height);
        String string2 = "Overlap: " + f2;
        dimension = Util.measureString(string2, AppManager.superFont10);
        this.m_overlap_bounds = new Rectangle(n2 + 1, n4, dimension.width, dimension.height);
        Color color = new Color(0, 0, 0, 50);
        Color color2 = new Color(PortUtil.Orange.getRed(), PortUtil.Orange.getGreen(), PortUtil.Orange.getBlue(), 50);
        graphics2D.setColor(color2);
        graphics2D.fillRect(this.m_preutterance_bounds.x, this.m_preutterance_bounds.y, this.m_preutterance_bounds.width, this.m_preutterance_bounds.height);
        graphics2D.setColor(color);
        graphics2D.drawRect(this.m_preutterance_bounds.x, this.m_preutterance_bounds.y, this.m_preutterance_bounds.width, this.m_preutterance_bounds.height);
        color2 = new Color(PortUtil.LawnGreen.getRed(), PortUtil.LawnGreen.getGreen(), PortUtil.LawnGreen.getBlue(), 50);
        graphics2D.setColor(color2);
        graphics2D.fillRect(this.m_overlap_bounds.x, this.m_overlap_bounds.y, this.m_overlap_bounds.width, this.m_overlap_bounds.height);
        graphics2D.setColor(color);
        graphics2D.drawRect(this.m_overlap_bounds.x, this.m_overlap_bounds.y, this.m_overlap_bounds.width, this.m_overlap_bounds.height);
        graphics2D.setFont(AppManager.superFont10);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n + 1, n3);
        graphics2D.drawString(string2, n2 + 1, n4);
    }

    private long findDataPointAt(int n, int n2) {
        if (this.m_selected_curve.equals(CurveType.Accent) || this.m_selected_curve.equals(CurveType.Decay) || this.m_selected_curve.equals(CurveType.Env) || this.m_selected_curve.equals(CurveType.VEL)) {
            return -1L;
        }
        if (!this.m_selected_curve.equals(CurveType.VibratoDepth) && !this.m_selected_curve.equals(CurveType.VibratoRate)) {
            VsqBPList vsqBPList = ((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected())).getCurve(this.m_selected_curve.getName());
            int n3 = vsqBPList.size();
            int n4 = 7;
            for (int i = 0; i < n3; ++i) {
                int n5 = vsqBPList.getKeyClock(i);
                VsqBPPair vsqBPPair = vsqBPList.getElementB(i);
                int n6 = AppManager.xCoordFromClocks(n5);
                if (n6 + 3 < AppManager.keyWidth) continue;
                if (this.getWidth() < n6 - 3) break;
                int n7 = this.yCoordFromValue(vsqBPPair.value);
                Rectangle rectangle = new Rectangle(n6 - 3, n7 - 3, n4, n4);
                if (!TrackSelector.isInRect(n, n2, rectangle)) continue;
                return vsqBPPair.id;
            }
        }
        return -1L;
    }

    private boolean findEnvelopePointAt(int n, int n2, ByRef<Integer> byRef, ByRef<Integer> byRef2) {
        Serializable serializable;
        int n3 = AppManager.clockFromXCoord(AppManager.keyWidth);
        int n4 = AppManager.clockFromXCoord(this.getWidth());
        VsqEvent vsqEvent = null;
        int n5 = 7;
        VsqFileEx vsqFileEx = AppManager.getVsqFile();
        Object object = ((VsqTrack)vsqFileEx.Track.get(AppManager.getSelected())).getNoteEventIterator();
        while (object.hasNext()) {
            VsqEvent vsqEvent2 = object.next();
            if (vsqEvent == null) {
                vsqEvent = vsqEvent2;
                continue;
            }
            if (vsqEvent2.Clock + vsqEvent2.ID.getLength() < n3) {
                vsqEvent = vsqEvent2;
                continue;
            }
            if (n4 < vsqEvent.Clock) {
                vsqEvent = vsqEvent2;
                break;
            }
            serializable = this.getEnvelopePoints(vsqFileEx, vsqEvent, vsqEvent2);
            for (int i = 5; i >= 1; --i) {
                Point point = new Point(serializable.xpoints[i], serializable.ypoints[i]);
                Rectangle rectangle = new Rectangle(point.x - 3, point.y - 3, n5, n5);
                if (!TrackSelector.isInRect(n, n2, rectangle)) continue;
                byRef.value = vsqEvent.InternalID;
                byRef2.value = i;
                return true;
            }
            vsqEvent = vsqEvent2;
        }
        if (vsqEvent != null) {
            object = this.getEnvelopePoints(vsqFileEx, vsqEvent, null);
            for (int i = 5; i >= 1; --i) {
                serializable = new Point(((Polygon)object).xpoints[i], ((Polygon)object).ypoints[i]);
                Rectangle rectangle = new Rectangle(((Point)serializable).x - 3, ((Point)serializable).y - 3, n5, n5);
                if (!TrackSelector.isInRect(n, n2, rectangle)) continue;
                byRef.value = vsqEvent.InternalID;
                byRef2.value = i;
                return true;
            }
        }
        byRef.value = -1;
        byRef2.value = -1;
        return false;
    }

    private Polygon getEnvelopePoints(VsqFileEx vsqFileEx, VsqEvent vsqEvent, VsqEvent vsqEvent2) {
        ByRef<Integer> byRef = new ByRef<Integer>();
        ByRef<Integer> byRef2 = new ByRef<Integer>();
        return this.getEnvelopePoints(vsqFileEx, vsqEvent, vsqEvent2, byRef, byRef2);
    }

    private Polygon getEnvelopePoints(VsqFileEx vsqFileEx, VsqEvent vsqEvent, VsqEvent vsqEvent2, ByRef<Integer> byRef, ByRef<Integer> byRef2) {
        UstEnvelope ustEnvelope;
        double d = vsqFileEx.getSecFromClock(vsqEvent.Clock);
        double d2 = vsqFileEx.getSecFromClock(vsqEvent.Clock + vsqEvent.ID.getLength());
        UstEvent ustEvent = vsqEvent.UstEvent;
        if (ustEvent == null) {
            ustEvent = new UstEvent();
        }
        if ((ustEnvelope = ustEvent.Envelope) == null) {
            ustEnvelope = new UstEnvelope();
        }
        float f = ustEvent.PreUtterance;
        float f2 = ustEvent.VoiceOverlap;
        UstEvent ustEvent2 = null;
        double d3 = Double.MAX_VALUE;
        if (vsqEvent2 != null) {
            ustEvent2 = vsqEvent2.UstEvent;
            d3 = vsqFileEx.getSecFromClock(vsqEvent2.Clock);
        }
        if (ustEvent2 == null) {
            ustEvent2 = new UstEvent();
        }
        d3 -= (double)(ustEvent2.PreUtterance - ustEvent2.VoiceOverlap) / 1000.0;
        d -= (double)f / 1000.0;
        if (d3 < d2) {
            d2 = d3;
        }
        int n = AppManager.xCoordFromClocks((int)vsqFileEx.getClockFromSec(d));
        int n2 = AppManager.xCoordFromClocks((int)vsqFileEx.getClockFromSec(d2));
        byRef.value = n;
        byRef2.value = AppManager.xCoordFromClocks((int)vsqFileEx.getClockFromSec(d + (double)f2 / 1000.0));
        int n3 = AppManager.xCoordFromClocks((int)vsqFileEx.getClockFromSec(d + (double)ustEnvelope.p1 / 1000.0));
        int n4 = AppManager.xCoordFromClocks((int)vsqFileEx.getClockFromSec(d + (double)(ustEnvelope.p1 + ustEnvelope.p2) / 1000.0));
        int n5 = AppManager.xCoordFromClocks((int)vsqFileEx.getClockFromSec(d + (double)(ustEnvelope.p1 + ustEnvelope.p2 + ustEnvelope.p5) / 1000.0));
        int n6 = AppManager.xCoordFromClocks((int)vsqFileEx.getClockFromSec(d2 - (double)(ustEnvelope.p4 + ustEnvelope.p3) / 1000.0));
        int n7 = AppManager.xCoordFromClocks((int)vsqFileEx.getClockFromSec(d2 - (double)ustEnvelope.p4 / 1000.0));
        int n8 = this.yCoordFromValue(ustEnvelope.v1);
        int n9 = this.yCoordFromValue(ustEnvelope.v2);
        int n10 = this.yCoordFromValue(ustEnvelope.v3);
        int n11 = this.yCoordFromValue(ustEnvelope.v4);
        int n12 = this.yCoordFromValue(ustEnvelope.v5);
        int n13 = this.yCoordFromValue(0);
        return new Polygon(new int[]{n, n3, n4, n5, n6, n7, n2}, new int[]{n13, n8, n9, n12, n10, n11, n13}, 7);
    }

    private void drawTrackTab(Graphics2D graphics2D, Rectangle rectangle, String string, boolean bl, boolean bl2, boolean bl3, Color color, Color color2) {
        Color color3;
        int n = rectangle.x;
        int n2 = bl3 ? rectangle.width - 10 : rectangle.width;
        Color color4 = bl2 ? color : new Color(125, 123, 124);
        Color color5 = bl2 ? color2 : new Color(125, 123, 124);
        Color color6 = Color.black;
        Color color7 = bl ? Color.white : Color.black;
        Color color8 = color3 = bl ? Color.white : new Color(118, 123, 138);
        if (bl) {
            graphics2D.setColor(color4);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (bl3 && bl2) {
                graphics2D.setColor(color2);
                graphics2D.fillRect(rectangle.x + rectangle.width - 10, rectangle.y, 10, rectangle.height);
            }
        }
        graphics2D.setColor(color3);
        graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        if (PortUtil.getStringLength(string) > 0) {
            graphics2D.setColor(color3);
            graphics2D.drawLine(rectangle.x + 1, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        }
        if (bl3) {
            graphics2D.setColor(color3);
            graphics2D.drawLine(rectangle.x + rectangle.width - 10, rectangle.y, rectangle.x + rectangle.width - 10, rectangle.y + rectangle.height);
        }
        graphics2D.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        String string2 = Utility.trimString(string, AppManager.superFont8, n2);
        graphics2D.setFont(AppManager.superFont8);
        graphics2D.setColor(color6);
        graphics2D.drawString(string2, rectangle.x + 2, rectangle.y + rectangle.height / 2 - AppManager.superFont8OffsetHeight);
        if (bl3) {
            graphics2D.setColor(color7);
            graphics2D.drawString("R", rectangle.x + rectangle.width - 10, rectangle.y + rectangle.height / 2 - AppManager.superFont8OffsetHeight);
        }
        if (bl) {
            graphics2D.setColor(color3);
            graphics2D.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height);
            graphics2D.setColor(color3);
            graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
        }
        graphics2D.setClip(null);
        graphics2D.setColor(this.m_generic_line);
        graphics2D.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public int getSelectorWidth() {
        int n = 80;
        int n2 = this.getWidth() - this.vScroll.getWidth() - AppManager.keyWidth;
        int n3 = 1;
        VsqFileEx vsqFileEx = AppManager.getVsqFile();
        if (vsqFileEx != null) {
            n3 = vsqFileEx.Track.size();
        }
        if (n * (n3 - 1) <= n2) {
            return n;
        }
        return (int)((float)n2 / ((float)n3 - 1.0f));
    }

    public void drawVEL(Graphics2D graphics2D, VsqTrack vsqTrack, Color color, boolean bl, CurveType curveType) {
        Point point = this.pointToClient(PortUtil.getMousePosition());
        Point point2 = new Point(point.x, point.y);
        int n = 8;
        int n2 = this.getGraphHeight();
        float f = curveType.equals(CurveType.VEL) ? (float)n2 / 127.0f : (float)n2 / 100.0f;
        int n3 = this.getHeight() - 42;
        Shape shape = graphics2D.getClip();
        int n4 = 6 + AppManager.keyWidth - AppManager.startToDrawX;
        graphics2D.clipRect(AppManager.keyWidth, n, this.getWidth() - AppManager.keyWidth - this.vScroll.getWidth(), n2);
        float f2 = AppManager.scaleX;
        int n5 = vsqTrack.getEventCount();
        graphics2D.setFont(AppManager.superFont10Bold);
        boolean bl2 = false;
        for (int i = 0; i < n5; ++i) {
            int n6;
            int n7;
            VsqEvent vsqEvent = vsqTrack.getEvent(i);
            if (vsqEvent.ID.type != VsqIDType.Anote || (n7 = (int)((float)(n6 = vsqEvent.Clock) * f2) + n4) + 8 < 0) continue;
            if (this.getWidth() - this.vScroll.getWidth() < n7) break;
            int n8 = 0;
            if (curveType.equals(CurveType.VEL)) {
                n8 = vsqEvent.ID.Dynamics;
            } else if (curveType.equals(CurveType.Accent)) {
                n8 = vsqEvent.ID.DEMaccent;
            } else if (curveType.equals(CurveType.Decay)) {
                n8 = vsqEvent.ID.DEMdecGainRate;
            }
            int n9 = n3 - (int)((float)n8 * f);
            if (bl && AppManager.isSelectedEventContains(AppManager.getSelected(), vsqEvent.InternalID)) {
                graphics2D.setColor(s_brs_a127_008_166_172);
                graphics2D.fillRect(n7, n9, 8, n3 - n9);
                if (this.m_mouse_down_mode == MouseDownMode.VEL_EDIT) {
                    int n10 = 0;
                    if (this.m_veledit_selected.containsKey(vsqEvent.InternalID)) {
                        if (this.m_selected_curve.equals(CurveType.VEL)) {
                            n10 = this.m_veledit_selected.get((Object)Integer.valueOf((int)vsqEvent.InternalID)).editing.ID.Dynamics;
                        } else if (this.m_selected_curve.equals(CurveType.Accent)) {
                            n10 = this.m_veledit_selected.get((Object)Integer.valueOf((int)vsqEvent.InternalID)).editing.ID.DEMaccent;
                        } else if (this.m_selected_curve.equals(CurveType.Decay)) {
                            n10 = this.m_veledit_selected.get((Object)Integer.valueOf((int)vsqEvent.InternalID)).editing.ID.DEMdecGainRate;
                        }
                        int n11 = n3 - (int)((float)n10 * f);
                        graphics2D.setColor(BRS_A244_255_023_012);
                        graphics2D.fillRect(n7, n11, 8, n3 - n11);
                        graphics2D.setColor(Color.white);
                        graphics2D.drawString(n10 + "", n7 + 8, n11 > n3 - 20 ? n3 - 20 : n11);
                    }
                }
            } else {
                graphics2D.setColor(color);
                graphics2D.fillRect(n7, n9, 8, n3 - n9);
            }
            if (this.m_mouse_down_mode == MouseDownMode.VEL_EDIT) {
                bl2 = true;
                continue;
            }
            if (AppManager.getSelectedTool() != EditTool.ARROW || !bl || !TrackSelector.isInRect(point2.x, point2.y, new Rectangle(n7, n9, 8, n3 - n9))) continue;
            bl2 = true;
        }
        if (bl2) {
            if (this.getCursor().getType() != 12) {
                this.setCursor(new Cursor(12));
            }
        } else if (this.getCursor().getType() != 0) {
            this.setCursor(new Cursor(0));
        }
        graphics2D.setClip(shape);
    }

    private void drawAttachedCurve(Graphics2D graphics2D, Vector<BezierChain> vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Point point;
            BezierPoint bezierPoint;
            BezierChain bezierChain = vector.get(i);
            int n2 = bezierChain.id;
            if (bezierChain.points.size() <= 0) continue;
            BezierPoint bezierPoint2 = bezierChain.points.get(0);
            Point point2 = this.getScreenCoord(bezierPoint2.getBase());
            int n3 = bezierChain.points.size();
            for (int j = 0; j < n3; ++j) {
                Cloneable cloneable;
                bezierPoint = bezierChain.points.get(j);
                int n4 = AppManager.xCoordFromClocks((int)bezierPoint.getBase().getX());
                point = new Point(n4, this.yCoordFromValue((int)bezierPoint.getBase().getY()));
                Point point3 = this.getScreenCoord(bezierPoint2.getControlRight());
                Point point4 = this.getScreenCoord(bezierPoint.getControlLeft());
                if (bezierPoint2.getControlRightType() == BezierControlType.None && bezierPoint.getControlLeftType() == BezierControlType.None) {
                    graphics2D.setColor(CURVE_COLOR);
                    graphics2D.drawLine(point2.x, point2.y, point.x, point.y);
                } else {
                    cloneable = bezierPoint2.getControlRightType() == BezierControlType.None ? point2 : point3;
                    Point point5 = bezierPoint.getControlLeftType() == BezierControlType.None ? point : point4;
                    graphics2D.setColor(CURVE_COLOR);
                    PortUtil.drawBezier(graphics2D, point2.x, point2.y, cloneable.x, cloneable.y, point5.x, point5.y, point.x, point.y);
                }
                if (bezierPoint2.getControlRightType() != BezierControlType.None) {
                    graphics2D.setColor(CONROL_LINE);
                    graphics2D.drawLine(point2.x, point2.y, point3.x, point3.y);
                }
                if (bezierPoint.getControlLeftType() != BezierControlType.None) {
                    graphics2D.setColor(CONROL_LINE);
                    graphics2D.drawLine(point.x, point.y, point4.x, point4.y);
                }
                if (bezierPoint2.getControlRightType() == BezierControlType.Normal) {
                    cloneable = new Rectangle(point3.x - 3, point3.y - 3, 7, 7);
                    if (n2 == this.EditingChainID && bezierPoint2.getID() == this.EditingPointID) {
                        graphics2D.setColor(AppManager.getHilightColor());
                        graphics2D.fillOval(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
                    } else {
                        graphics2D.setColor(DOT_COLOR_NORMAL);
                        graphics2D.fillOval(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
                    }
                    graphics2D.setColor(DOT_COLOR_NORMAL);
                    graphics2D.drawOval(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
                }
                if (bezierPoint.getControlLeftType() == BezierControlType.Normal) {
                    cloneable = new Rectangle(point4.x - 3, point4.y - 3, 7, 7);
                    if (n2 == this.EditingChainID && bezierPoint.getID() == this.EditingPointID) {
                        graphics2D.setColor(AppManager.getHilightColor());
                        graphics2D.fillOval(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
                    } else {
                        graphics2D.setColor(DOT_COLOR_NORMAL);
                        graphics2D.fillOval(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
                    }
                    graphics2D.setColor(DOT_COLOR_NORMAL);
                    graphics2D.drawOval(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
                }
                cloneable = new Rectangle(point2.x - 3, point2.y - 3, 7, 7);
                if (n2 == this.EditingChainID && bezierPoint2.getID() == this.EditingPointID) {
                    graphics2D.setColor(AppManager.getHilightColor());
                    graphics2D.fillRect(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
                } else {
                    graphics2D.setColor(DOT_COLOR_BASE);
                    graphics2D.fillRect(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
                }
                graphics2D.setColor(DOT_COLOR_BASE);
                graphics2D.drawRect(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
                point2 = point;
                bezierPoint2 = bezierPoint;
            }
            bezierPoint = bezierChain.points.get(bezierChain.points.size() - 1);
            point = this.getScreenCoord(bezierPoint.getBase());
            Rectangle rectangle = new Rectangle(point.x - 3, point.y - 3, 7, 7);
            if (n2 == this.EditingChainID && bezierPoint.getID() == this.EditingPointID) {
                graphics2D.setColor(AppManager.getHilightColor());
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics2D.setColor(DOT_COLOR_BASE);
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            graphics2D.setColor(DOT_COLOR_BASE);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private Point getScreenCoord(PointD pointD) {
        return new Point(AppManager.xCoordFromClocks((int)pointD.getX()), this.yCoordFromValue((int)pointD.getY()));
    }

    public void drawVibratoControlCurve(Graphics2D graphics2D, VsqTrack vsqTrack, CurveType curveType, Color color, boolean bl) {
        Shape shape = graphics2D.getClip();
        int n = this.getGraphHeight();
        graphics2D.clipRect(AppManager.keyWidth, 8, this.getWidth() - AppManager.keyWidth - this.vScroll.getWidth(), n);
        int n2 = AppManager.clockFromXCoord(AppManager.keyWidth);
        int n3 = AppManager.clockFromXCoord(this.getWidth() - this.vScroll.getWidth());
        if (bl) {
            Color color2 = new Color(0, 0, 0, 127);
            int n4 = AppManager.keyWidth;
            Iterator<VsqEvent> iterator = vsqTrack.getNoteEventIterator();
            while (iterator.hasNext()) {
                int n5;
                int n6;
                VibratoBPPair vibratoBPPair;
                int n7;
                int n8;
                VibratoBPList vibratoBPList;
                int n9;
                int n10;
                VsqEvent vsqEvent = iterator.next();
                int n11 = vsqEvent.Clock + vsqEvent.ID.VibratoDelay;
                int n12 = vsqEvent.Clock + vsqEvent.ID.getLength();
                if (n12 < n2) continue;
                if (n3 < n11) break;
                if (vsqEvent.ID.VibratoHandle == null) continue;
                int n13 = AppManager.xCoordFromClocks(n11);
                graphics2D.setColor(color2);
                graphics2D.fillRect(n4, 8, n13 - n4, n);
                n4 = n10 = AppManager.xCoordFromClocks(n12);
                if (n13 >= n10) continue;
                Vector<Integer> vector = new Vector<Integer>();
                Vector<Integer> vector2 = new Vector<Integer>();
                int n14 = n10 - n13;
                vector.add(n13);
                vector2.add(this.yCoordFromValue(0, curveType.getMaximum(), curveType.getMinimum()));
                if (curveType.equals(CurveType.VibratoRate)) {
                    n9 = this.yCoordFromValue(vsqEvent.ID.VibratoHandle.getStartRate(), curveType.getMaximum(), curveType.getMinimum());
                    vector.add(n13);
                    vector2.add(n9);
                    vibratoBPList = vsqEvent.ID.VibratoHandle.getRateBP();
                    n8 = vibratoBPList.getCount();
                    for (n7 = 0; n7 < n8; ++n7) {
                        vibratoBPPair = vibratoBPList.getElement(n7);
                        n6 = n13 + (int)(vibratoBPPair.X * (float)n14);
                        n5 = this.yCoordFromValue(vibratoBPPair.Y, curveType.getMaximum(), curveType.getMinimum());
                        vector.add(n6);
                        vector2.add(n9);
                        vector.add(n6);
                        vector2.add(n5);
                        n9 = n5;
                    }
                    vector.add(n10);
                    vector2.add(n9);
                } else {
                    n9 = this.yCoordFromValue(vsqEvent.ID.VibratoHandle.getStartDepth(), curveType.getMaximum(), curveType.getMinimum());
                    vector.add(n13);
                    vector2.add(n9);
                    vibratoBPList = vsqEvent.ID.VibratoHandle.getDepthBP();
                    n8 = vibratoBPList.getCount();
                    for (n7 = 0; n7 < n8; ++n7) {
                        vibratoBPPair = vibratoBPList.getElement(n7);
                        n6 = n13 + (int)(vibratoBPPair.X * (float)n14);
                        n5 = this.yCoordFromValue(vibratoBPPair.Y, curveType.getMaximum(), curveType.getMinimum());
                        vector.add(n6);
                        vector2.add(n9);
                        vector.add(n6);
                        vector2.add(n5);
                        n9 = n5;
                    }
                    vector.add(n10);
                    vector2.add(n9);
                }
                vector.add(n10);
                vector2.add(this.yCoordFromValue(0, curveType.getMaximum(), curveType.getMinimum()));
                graphics2D.setColor(color);
                graphics2D.fillPolygon(PortUtil.convertIntArray(vector.toArray(new Integer[0])), PortUtil.convertIntArray(vector2.toArray(new Integer[0])), vector.size());
            }
            graphics2D.setColor(color2);
            graphics2D.fillRect(n4, 8, this.getWidth() - AppManager.keyWidth - this.vScroll.getWidth(), n);
        }
        graphics2D.setClip(shape);
    }

    public void drawVsqBPList_impl(Graphics2D graphics2D, VsqBPList vsqBPList, Color color, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = vsqBPList.getMaximum();
        int n10 = vsqBPList.getMinimum();
        int n11 = this.getGraphHeight();
        float f = (float)n11 / (float)(n9 - n10);
        int n12 = this.getHeight() - 42;
        Shape shape = graphics2D.getClip();
        graphics2D.clipRect(AppManager.keyWidth, 8, this.getWidth() - AppManager.keyWidth - this.vScroll.getWidth(), this.getHeight() - 38);
        Rectangle rectangle = new Rectangle(Math.min(AppManager.curveSelectingRectangle.x, AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width), Math.min(AppManager.curveSelectingRectangle.y, AppManager.curveSelectingRectangle.y + AppManager.curveSelectingRectangle.height), Math.abs(AppManager.curveSelectingRectangle.width), Math.abs(AppManager.curveSelectingRectangle.height));
        EditTool editTool = AppManager.getSelectedTool();
        boolean bl2 = !this.m_selected_curve.isScalar() && (editTool == EditTool.ARROW || editTool == EditTool.ERASER) && this.m_mouse_downed;
        int n13 = AppManager.keyWidth;
        int n14 = AppManager.clockFromXCoord(n13);
        int n15 = this.getWidth() - this.vScroll.getWidth();
        int n16 = AppManager.clockFromXCoord(n15);
        int n17 = AppManager.curveSelectedInterval.getStart();
        int n18 = AppManager.curveSelectedInterval.getEnd();
        int n19 = AppManager.xCoordFromClocks(n17);
        int n20 = AppManager.xCoordFromClocks(n18);
        Color color2 = color;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        vector.add(this.getWidth() - this.vScroll.getWidth());
        vector2.add(n12);
        vector.add(AppManager.keyWidth);
        vector2.add(n12);
        int n21 = vsqBPList.getValue(n14);
        int n22 = n12 - (int)((float)(n21 - n10) * f);
        boolean bl3 = true;
        if (vsqBPList.size() > 0) {
            n8 = vsqBPList.getKeyClock(0);
            n7 = AppManager.xCoordFromClocks(n8);
            n21 = vsqBPList.getValue(n8);
            n22 = n12 - (int)((float)(n21 - n10) * f);
            n6 = vsqBPList.size();
            for (n5 = 0; n5 < n6; ++n5) {
                n4 = vsqBPList.getKeyClock(n5);
                if (n4 < n14) continue;
                if (n16 < n4) break;
                if (bl3) {
                    n22 = this.yCoordFromValue(vsqBPList.getValue(AppManager.clockFromXCoord(AppManager.keyWidth)), n9, n10);
                    vector.add(AppManager.keyWidth);
                    vector2.add(n22);
                    bl3 = false;
                }
                n3 = AppManager.xCoordFromClocks(n4);
                VsqBPPair vsqBPPair = vsqBPList.getElementB(n5);
                n2 = n12 - (int)((float)(vsqBPPair.value - n10) * f);
                vector.add(n3);
                vector2.add(n22);
                vector.add(n3);
                vector2.add(n2);
                if (AppManager.isSelectedPointContains(vsqBPPair.id)) {
                    vector3.add(vector.size() - 1);
                } else if (bl2 && TrackSelector.isInRect(n4, vsqBPPair.value, rectangle)) {
                    vector3.add(vector.size() - 1);
                }
                n22 = n2;
            }
        }
        if (bl3) {
            n22 = this.yCoordFromValue(vsqBPList.getValue(AppManager.clockFromXCoord(AppManager.keyWidth)), n9, n10);
            vector.add(AppManager.keyWidth);
            vector2.add(n22);
        }
        n22 = n12 - (int)((float)(vsqBPList.getValue(n16) - n10) * f);
        vector.add(this.getWidth() - this.vScroll.getWidth());
        vector2.add(n22);
        graphics2D.setColor(color2);
        graphics2D.fillPolygon(PortUtil.convertIntArray(vector.toArray(new Integer[0])), PortUtil.convertIntArray(vector2.toArray(new Integer[0])), vector.size());
        if (bl) {
            n8 = vector.size();
            n7 = 7;
            Color color3 = Color.white;
            n5 = (Integer)vector.get(0);
            n4 = (Integer)vector2.get(0);
            n3 = (Integer)vector.get(1);
            int n23 = (Integer)vector2.get(1);
            vector.removeElementAt(0);
            vector2.removeElementAt(0);
            vector.removeElementAt(0);
            vector2.removeElementAt(0);
            graphics2D.setColor(color3);
            graphics2D.drawPolyline(PortUtil.convertIntArray(vector.toArray(new Integer[0])), PortUtil.convertIntArray(vector2.toArray(new Integer[0])), vector.size());
            vector.insertElementAt(n3, 0);
            vector2.insertElementAt(n23, 0);
            vector.insertElementAt(n5, 0);
            vector2.insertElementAt(n4, 0);
            n2 = 1;
            n = 200;
            Point point = this.pointToClient(PortUtil.getMousePosition());
            Point point2 = new Point(point.x, point.y);
            Color color4 = new Color(255, 255, 255, 200);
            for (int i = 4; i < n8; i += 2) {
                Point point3 = new Point((Integer)vector.get(i), (Integer)vector2.get(i));
                if (vector3.contains(i)) {
                    graphics2D.setColor(CURVE_COLOR_DOT);
                    graphics2D.fillRect(point3.x - 3, point3.y - 3, n7, n7);
                    continue;
                }
                if (n2 != 0) {
                    double d;
                    double d2;
                    int n24;
                    if (point2.y < 0 || this.getHeight() < point2.y || (n24 = (int)(255.0 * Math.exp(-((d2 = (double)Math.abs(point3.x - point2.x) / (double)n) * d2) / (2.0 * (d = 0.3) * d)))) <= 0) continue;
                    Color color5 = new Color(255, 255, 255, n24);
                    graphics2D.setColor(color5);
                    graphics2D.fillRect(point3.x - 3, point3.y - 3, n7, n7);
                    continue;
                }
                graphics2D.setColor(color4);
                graphics2D.fillRect(point3.x - 3, point3.y - 3, n7, n7);
            }
        }
        if (bl && this.m_mouse_down_mode == MouseDownMode.POINT_MOVE) {
            Point point = this.pointToClient(PortUtil.getMousePosition());
            Point point4 = new Point(point.x, point.y);
            n6 = point4.x + AppManager.startToDrawX - this.m_mouse_down_location.x;
            n5 = point4.y - this.m_mouse_down_location.y;
            n4 = 7;
            for (BPPair bPPair : this.m_moving_points) {
                n2 = AppManager.xCoordFromClocks(bPPair.Clock) + n6;
                n = this.yCoordFromValue(bPPair.Value) + n5;
                graphics2D.setColor(CURVE_COLOR_DOT);
                graphics2D.fillRect(n2 - 3, n - 3, n4, n4);
            }
        }
        graphics2D.setClip(shape);
    }

    public void drawVsqBPList(Graphics2D graphics2D, VsqBPList vsqBPList, Color color, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = vsqBPList.getMaximum();
        int n10 = vsqBPList.getMinimum();
        int n11 = this.getGraphHeight();
        int n12 = this.getWidth();
        float f = (float)n11 / (float)(n9 - n10);
        int n13 = this.getHeight() - 42;
        Shape shape = graphics2D.getClip();
        graphics2D.clipRect(AppManager.keyWidth, 8, n12 - AppManager.keyWidth - this.vScroll.getWidth(), this.getHeight() - 38);
        Rectangle rectangle = new Rectangle(Math.min(AppManager.curveSelectingRectangle.x, AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width), Math.min(AppManager.curveSelectingRectangle.y, AppManager.curveSelectingRectangle.y + AppManager.curveSelectingRectangle.height), Math.abs(AppManager.curveSelectingRectangle.width), Math.abs(AppManager.curveSelectingRectangle.height));
        EditTool editTool = AppManager.getSelectedTool();
        boolean bl2 = !this.m_selected_curve.isScalar() && (editTool == EditTool.ARROW || editTool == EditTool.ERASER) && this.m_mouse_downed;
        int n14 = AppManager.keyWidth;
        int n15 = AppManager.clockFromXCoord(n14);
        int n16 = n12 - this.vScroll.getWidth();
        int n17 = AppManager.clockFromXCoord(n16);
        int n18 = AppManager.curveSelectedInterval.getStart();
        int n19 = AppManager.curveSelectedInterval.getEnd();
        int n20 = AppManager.xCoordFromClocks(n18);
        int n21 = AppManager.xCoordFromClocks(n19);
        Color color2 = color;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        vector.add(n12 - this.vScroll.getWidth());
        vector2.add(n13);
        vector.add(AppManager.keyWidth);
        vector2.add(n13);
        int n22 = vsqBPList.getValue(n15);
        int n23 = n13 - (int)((float)(n22 - n10) * f);
        boolean bl3 = true;
        if (vsqBPList.size() > 0) {
            n8 = vsqBPList.getKeyClock(0);
            n7 = AppManager.xCoordFromClocks(n8);
            n22 = vsqBPList.getValue(n8);
            n23 = n13 - (int)((float)(n22 - n10) * f);
            n6 = vsqBPList.size();
            for (n5 = 0; n5 < n6; ++n5) {
                n4 = vsqBPList.getKeyClock(n5);
                if (n4 < n15) continue;
                if (n17 < n4) break;
                if (bl3) {
                    n23 = this.yCoordFromValue(vsqBPList.getValue(AppManager.clockFromXCoord(AppManager.keyWidth)), n9, n10);
                    vector.add(AppManager.keyWidth);
                    vector2.add(n23);
                    bl3 = false;
                }
                n3 = AppManager.xCoordFromClocks(n4);
                VsqBPPair vsqBPPair = vsqBPList.getElementB(n5);
                n2 = n13 - (int)((float)(vsqBPPair.value - n10) * f);
                vector.add(n3);
                vector2.add(n23);
                vector.add(n3);
                vector2.add(n2);
                if (AppManager.isSelectedPointContains(vsqBPPair.id)) {
                    vector3.add(vector.size() - 1);
                } else if (bl2 && TrackSelector.isInRect(n4, vsqBPPair.value, rectangle)) {
                    vector3.add(vector.size() - 1);
                }
                n23 = n2;
            }
        }
        if (bl3) {
            n23 = this.yCoordFromValue(vsqBPList.getValue(AppManager.clockFromXCoord(AppManager.keyWidth)), n9, n10);
            vector.add(AppManager.keyWidth);
            vector2.add(n23);
        }
        n23 = n13 - (int)((float)(vsqBPList.getValue(n17) - n10) * f);
        vector.add(n12 - this.vScroll.getWidth());
        vector2.add(n23);
        graphics2D.setColor(color2);
        graphics2D.fillPolygon(PortUtil.convertIntArray(vector.toArray(new Integer[0])), PortUtil.convertIntArray(vector2.toArray(new Integer[0])), vector.size());
        if (bl) {
            n8 = vector.size();
            n7 = 7;
            Color color3 = Color.white;
            n5 = (Integer)vector.get(0);
            n4 = (Integer)vector2.get(0);
            n3 = (Integer)vector.get(1);
            int n24 = (Integer)vector2.get(1);
            vector.removeElementAt(0);
            vector2.removeElementAt(0);
            vector.removeElementAt(0);
            vector2.removeElementAt(0);
            graphics2D.setColor(color3);
            graphics2D.drawPolyline(PortUtil.convertIntArray(vector.toArray(new Integer[0])), PortUtil.convertIntArray(vector2.toArray(new Integer[0])), vector.size());
            vector.insertElementAt(n3, 0);
            vector2.insertElementAt(n24, 0);
            vector.insertElementAt(n5, 0);
            vector2.insertElementAt(n4, 0);
            n2 = AppManager.drawCurveDotInControlCurveView ? 1 : 0;
            n = 200;
            Point point = this.pointToClient(PortUtil.getMousePosition());
            Point point2 = new Point(point.x, point.y);
            Color color4 = new Color(255, 255, 255, 200);
            for (int i = 4; i < n8; i += 2) {
                Point point3 = new Point((Integer)vector.get(i), (Integer)vector2.get(i));
                if (vector3.contains(i)) {
                    graphics2D.setColor(CURVE_COLOR_DOT);
                    graphics2D.fillRect(point3.x - 3, point3.y - 3, n7, n7);
                    continue;
                }
                if (n2 != 0) {
                    double d;
                    double d2;
                    int n25;
                    if (point2.y < 0 || this.getHeight() < point2.y || (n25 = (int)(255.0 * Math.exp(-((d2 = (double)Math.abs(point3.x - point2.x) / (double)n) * d2) / (2.0 * (d = 0.3) * d)))) <= 0) continue;
                    Color color5 = new Color(255, 255, 255, n25);
                    graphics2D.setColor(color5);
                    graphics2D.fillRect(point3.x - 3, point3.y - 3, n7, n7);
                    continue;
                }
                graphics2D.setColor(color4);
                graphics2D.fillRect(point3.x - 3, point3.y - 3, n7, n7);
            }
        }
        if (bl && this.m_mouse_down_mode == MouseDownMode.POINT_MOVE) {
            Point point = this.pointToClient(PortUtil.getMousePosition());
            Point point4 = new Point(point.x, point.y);
            n6 = point4.x + AppManager.startToDrawX - this.m_mouse_down_location.x;
            n5 = point4.y - this.m_mouse_down_location.y;
            n4 = 7;
            for (BPPair bPPair : this.m_moving_points) {
                n2 = AppManager.xCoordFromClocks(bPPair.Clock) + n6;
                n = this.yCoordFromValue(bPPair.Value) + n5;
                graphics2D.setColor(CURVE_COLOR_DOT);
                graphics2D.fillRect(n2 - 3, n - 3, n4, n4);
            }
        }
        graphics2D.setClip(shape);
    }

    public int getGraphHeight() {
        return this.getHeight() - 42 - 8;
    }

    public int getGraphWidth() {
        return this.getWidth() - AppManager.keyWidth - this.vScroll.getWidth();
    }

    private void TrackSelector_Load(Object object, BEventArgs bEventArgs) {
    }

    private void TrackSelector_MouseClick(Object object, BMouseEventArgs bMouseEventArgs) {
        if (this.m_curve_visible) {
            if (bMouseEventArgs.Button == BMouseButtons.Left) {
                for (CurveType curveType : this.m_viewing_curves) {
                    Rectangle rectangle = this.getRectFromCurveType(curveType);
                    if (!TrackSelector.isInRect(bMouseEventArgs.X, bMouseEventArgs.Y, rectangle)) continue;
                    this.changeCurve(curveType);
                    return;
                }
            } else if (bMouseEventArgs.Button == BMouseButtons.Right && 0 <= bMouseEventArgs.X && bMouseEventArgs.X <= AppManager.keyWidth && 0 <= bMouseEventArgs.Y && bMouseEventArgs.Y <= this.getHeight() - 38) {
                Object object2;
                Object object3;
                MenuElement menuElement;
                MenuElement[] menuElementArray = this.cmenuCurve.getSubElements();
                for (int i = 0; i < menuElementArray.length; ++i) {
                    MenuElement menuElement2 = menuElementArray[i];
                    if (!(menuElement2 instanceof BMenuItem)) continue;
                    menuElement = (BMenuItem)menuElement2;
                    menuElement.setSelected(false);
                    object3 = menuElement.getSubElements();
                    for (int j = 0; j < ((MenuElement[])object3).length; ++j) {
                        MenuElement menuElement3 = object3[j];
                        if (!(menuElement3 instanceof BMenuItem)) continue;
                        object2 = (BMenuItem)menuElement3;
                        ((AbstractButton)object2).setSelected(false);
                    }
                }
                RendererKind rendererKind = VsqFileEx.getTrackRendererKind((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected()));
                if (rendererKind == RendererKind.VOCALOID1_100 || rendererKind == RendererKind.VOCALOID1_101) {
                    this.cmenuCurveVelocity.setVisible(true);
                    this.cmenuCurveAccent.setVisible(true);
                    this.cmenuCurveDecay.setVisible(true);
                    this.cmenuCurveSeparator1.setVisible(true);
                    this.cmenuCurveDynamics.setVisible(true);
                    this.cmenuCurveVibratoRate.setVisible(true);
                    this.cmenuCurveVibratoDepth.setVisible(true);
                    this.cmenuCurveSeparator2.setVisible(true);
                    this.cmenuCurveReso1.setVisible(true);
                    this.cmenuCurveReso2.setVisible(true);
                    this.cmenuCurveReso3.setVisible(true);
                    this.cmenuCurveReso4.setVisible(true);
                    this.cmenuCurveSeparator3.setVisible(true);
                    this.cmenuCurveHarmonics.setVisible(true);
                    this.cmenuCurveBreathiness.setVisible(true);
                    this.cmenuCurveBrightness.setVisible(true);
                    this.cmenuCurveClearness.setVisible(true);
                    this.cmenuCurveOpening.setVisible(false);
                    this.cmenuCurveGenderFactor.setVisible(true);
                    this.cmenuCurveSeparator4.setVisible(true);
                    this.cmenuCurvePortamentoTiming.setVisible(true);
                    this.cmenuCurvePitchBend.setVisible(true);
                    this.cmenuCurvePitchBendSensitivity.setVisible(true);
                    this.cmenuCurveSeparator5.setVisible(true);
                    this.cmenuCurveEffect2Depth.setVisible(true);
                    this.cmenuCurveEnvelope.setVisible(false);
                    this.cmenuCurveBreathiness.setText("Noise");
                } else if (rendererKind == RendererKind.UTAU || rendererKind == RendererKind.STRAIGHT_UTAU) {
                    this.cmenuCurveVelocity.setVisible(false);
                    this.cmenuCurveAccent.setVisible(false);
                    this.cmenuCurveDecay.setVisible(false);
                    this.cmenuCurveSeparator1.setVisible(false);
                    this.cmenuCurveDynamics.setVisible(false);
                    this.cmenuCurveVibratoRate.setVisible(true);
                    this.cmenuCurveVibratoDepth.setVisible(true);
                    this.cmenuCurveSeparator2.setVisible(false);
                    this.cmenuCurveReso1.setVisible(false);
                    this.cmenuCurveReso2.setVisible(false);
                    this.cmenuCurveReso3.setVisible(false);
                    this.cmenuCurveReso4.setVisible(false);
                    this.cmenuCurveSeparator3.setVisible(false);
                    this.cmenuCurveHarmonics.setVisible(false);
                    this.cmenuCurveBreathiness.setVisible(false);
                    this.cmenuCurveBrightness.setVisible(false);
                    this.cmenuCurveClearness.setVisible(false);
                    this.cmenuCurveOpening.setVisible(false);
                    this.cmenuCurveGenderFactor.setVisible(false);
                    this.cmenuCurveSeparator4.setVisible(true);
                    this.cmenuCurvePortamentoTiming.setVisible(false);
                    this.cmenuCurvePitchBend.setVisible(true);
                    this.cmenuCurvePitchBendSensitivity.setVisible(true);
                    this.cmenuCurveSeparator5.setVisible(true);
                    this.cmenuCurveEffect2Depth.setVisible(false);
                    this.cmenuCurveEnvelope.setVisible(true);
                } else {
                    this.cmenuCurveVelocity.setVisible(true);
                    this.cmenuCurveAccent.setVisible(true);
                    this.cmenuCurveDecay.setVisible(true);
                    this.cmenuCurveSeparator1.setVisible(true);
                    this.cmenuCurveDynamics.setVisible(true);
                    this.cmenuCurveVibratoRate.setVisible(true);
                    this.cmenuCurveVibratoDepth.setVisible(true);
                    this.cmenuCurveSeparator2.setVisible(false);
                    this.cmenuCurveReso1.setVisible(false);
                    this.cmenuCurveReso2.setVisible(false);
                    this.cmenuCurveReso3.setVisible(false);
                    this.cmenuCurveReso4.setVisible(false);
                    this.cmenuCurveSeparator3.setVisible(true);
                    this.cmenuCurveHarmonics.setVisible(false);
                    this.cmenuCurveBreathiness.setVisible(true);
                    this.cmenuCurveBrightness.setVisible(true);
                    this.cmenuCurveClearness.setVisible(true);
                    this.cmenuCurveOpening.setVisible(true);
                    this.cmenuCurveGenderFactor.setVisible(true);
                    this.cmenuCurveSeparator4.setVisible(true);
                    this.cmenuCurvePortamentoTiming.setVisible(true);
                    this.cmenuCurvePitchBend.setVisible(true);
                    this.cmenuCurvePitchBendSensitivity.setVisible(true);
                    this.cmenuCurveSeparator5.setVisible(false);
                    this.cmenuCurveEffect2Depth.setVisible(false);
                    this.cmenuCurveEnvelope.setVisible(false);
                    this.cmenuCurveBreathiness.setText("Breathiness");
                }
                block3: for (int i = 0; i < menuElementArray.length; ++i) {
                    Object object4;
                    menuElement = menuElementArray[i];
                    if (!(menuElement instanceof BMenuItem)) continue;
                    object3 = menuElement;
                    if (((BMenuItem)object3).getTag() instanceof CurveType && ((CurveType)(object4 = (CurveType)((BMenuItem)object3).getTag())).equals(this.m_selected_curve)) {
                        ((AbstractButton)object3).setSelected(true);
                        break;
                    }
                    object4 = ((JMenuItem)object3).getSubElements();
                    for (int j = 0; j < ((Object)object4).length; ++j) {
                        CurveType curveType;
                        BMenuItem bMenuItem;
                        object2 = object4[j];
                        if (!(object2 instanceof BMenuItem) || !((bMenuItem = (BMenuItem)object2).getTag() instanceof CurveType) || !(curveType = (CurveType)bMenuItem.getTag()).equals(this.m_selected_curve)) continue;
                        bMenuItem.setSelected(true);
                        if (!curveType.equals(CurveType.reso1amp) && !curveType.equals(CurveType.reso1bw) && !curveType.equals(CurveType.reso1freq) && !curveType.equals(CurveType.reso2amp) && !curveType.equals(CurveType.reso2bw) && !curveType.equals(CurveType.reso2freq) && !curveType.equals(CurveType.reso3amp) && !curveType.equals(CurveType.reso3bw) && !curveType.equals(CurveType.reso3freq) && !curveType.equals(CurveType.reso4amp) && !curveType.equals(CurveType.reso4bw) && !curveType.equals(CurveType.reso4freq)) continue block3;
                        ((AbstractButton)object3).setSelected(true);
                        continue block3;
                    }
                }
                this.cmenuCurve.show(this, bMouseEventArgs.X, bMouseEventArgs.Y);
            }
        }
    }

    public void SelectNextCurve() {
        int n = 0;
        if (this.m_viewing_curves.size() >= 2) {
            for (int i = 0; i < this.m_viewing_curves.size(); ++i) {
                if (!this.m_viewing_curves.get(i).equals(this.m_selected_curve)) continue;
                n = i;
                break;
            }
            if (this.m_viewing_curves.size() <= ++n) {
                n = 0;
            }
            this.changeCurve(this.m_viewing_curves.get(n));
        }
    }

    public void SelectPreviousCurve() {
        int n = 0;
        if (this.m_viewing_curves.size() >= 2) {
            for (int i = 0; i < this.m_viewing_curves.size(); ++i) {
                if (!this.m_viewing_curves.get(i).equals(this.m_selected_curve)) continue;
                n = i;
                break;
            }
            if (--n < 0) {
                n = this.m_viewing_curves.size() - 1;
            }
            this.changeCurve(this.m_viewing_curves.get(n));
        }
    }

    private BezierPoint HandleMouseMoveForBezierMove(int n, int n2, int n3, BezierPickedSide bezierPickedSide) {
        BezierChain bezierChain = AppManager.getVsqFile().AttachedCurves.get(AppManager.getSelected() - 1).getBezierChain(this.m_selected_curve, AppManager.getLastSelectedBezier().chainID);
        int n4 = AppManager.getLastSelectedBezier().pointID;
        int n5 = -1;
        for (int i = 0; i < bezierChain.points.size(); ++i) {
            if (bezierChain.points.get(i).getID() != n4) continue;
            n5 = i;
            break;
        }
        float f = AppManager.scaleX;
        float f2 = this.getScaleY();
        BezierPoint bezierPoint = new BezierPoint(0.0, 0.0);
        if (n5 >= 0) {
            BezierPoint bezierPoint2 = bezierChain.points.get(n5);
            if (bezierPickedSide == BezierPickedSide.BASE) {
                Point point = bezierChain.points.get(n5).getBase().toPoint();
                bezierPoint2.setBase(new PointD(n, n2));
                if (!BezierChain.isBezierImplicit(bezierChain)) {
                    bezierPoint2.setBase(new PointD(point.x, point.y));
                }
                bezierPoint = (BezierPoint)bezierChain.points.get(n5).clone();
            } else if (bezierPickedSide == BezierPickedSide.LEFT) {
                if (bezierPoint2.getControlLeftType() != BezierControlType.Master) {
                    Point point = bezierPoint2.getControlLeft().toPoint();
                    Point point2 = bezierPoint2.getControlRight().toPoint();
                    Point point3 = bezierPoint2.getBase().toPoint();
                    bezierPoint2.setControlLeft(new PointD(n, n3));
                    double d = ((double)point3.x - bezierPoint2.getControlLeft().getX()) * (double)f;
                    double d2 = ((double)point3.y - bezierPoint2.getControlLeft().getY()) * (double)f2;
                    BezierPoint bezierPoint3 = AppManager.getLastSelectedBezier().original;
                    double d3 = Math.atan2(d2, d);
                    double d4 = (bezierPoint3.getControlRight().getX() - (double)point3.x) * (double)f;
                    double d5 = (bezierPoint3.getControlRight().getY() - (double)point3.y) * (double)f2;
                    double d6 = Math.sqrt(d4 * d4 + d5 * d5);
                    d4 = d6 * Math.cos(d3) / (double)f;
                    d5 = d6 * Math.sin(d3) / (double)f2;
                    bezierPoint2.setControlRight(new PointD(point3.x + (int)d4, point3.y + (int)d5));
                    if (!BezierChain.isBezierImplicit(bezierChain)) {
                        bezierPoint2.setControlLeft(new PointD(point.x, point.y));
                        bezierPoint2.setControlRight(new PointD(point2.x, point2.y));
                    }
                } else {
                    Point point = bezierPoint2.getControlLeft().toPoint();
                    bezierPoint2.setControlLeft(new PointD(n, n3));
                    if (!BezierChain.isBezierImplicit(bezierChain)) {
                        bezierPoint2.setControlLeft(new PointD(point.x, point.y));
                    }
                }
                bezierPoint = (BezierPoint)bezierPoint2.clone();
            } else if (bezierPickedSide == BezierPickedSide.RIGHT) {
                if (bezierPoint2.getControlRightType() != BezierControlType.Master) {
                    Point point = bezierPoint2.getControlLeft().toPoint();
                    Point point4 = bezierPoint2.getControlRight().toPoint();
                    Point point5 = bezierPoint2.getBase().toPoint();
                    bezierPoint2.setControlRight(new PointD(n, n3));
                    double d = (bezierPoint2.getControlRight().getX() - (double)point5.x) * (double)f;
                    double d7 = (bezierPoint2.getControlRight().getY() - (double)point5.y) * (double)f2;
                    BezierPoint bezierPoint4 = AppManager.getLastSelectedBezier().original;
                    double d8 = Math.atan2(d7, d);
                    double d9 = ((double)point5.x - bezierPoint4.getControlLeft().getX()) * (double)f;
                    double d10 = ((double)point5.y - bezierPoint4.getControlLeft().getY()) * (double)f2;
                    double d11 = Math.sqrt(d9 * d9 + d10 * d10);
                    d9 = d11 * Math.cos(d8) / (double)f;
                    d10 = d11 * Math.sin(d8) / (double)f2;
                    bezierPoint2.setControlLeft(new PointD(point5.x - (int)d9, point5.y - (int)d10));
                    if (!BezierChain.isBezierImplicit(bezierChain)) {
                        bezierPoint2.setControlLeft(new PointD(point.x, point.y));
                        bezierPoint2.setControlRight(new PointD(point4.x, point4.y));
                    }
                } else {
                    Point point = bezierPoint2.getControlRight().toPoint();
                    bezierPoint2.setControlRight(new PointD(n, n2));
                    if (!BezierChain.isBezierImplicit(bezierChain)) {
                        bezierPoint2.setControlRight(new PointD(point.x, point.y));
                    }
                }
                bezierPoint = (BezierPoint)bezierPoint2.clone();
            }
        }
        return bezierPoint;
    }

    public BezierPoint HandleMouseMoveForBezierMove(BMouseEventArgs bMouseEventArgs, BezierPickedSide bezierPickedSide) {
        int n;
        int n2 = AppManager.clockFromXCoord(bMouseEventArgs.X);
        int n3 = n = this.valueFromYCoord(bMouseEventArgs.Y);
        if (n2 < AppManager.getVsqFile().getPreMeasure()) {
            n2 = AppManager.getVsqFile().getPreMeasure();
        }
        int n4 = this.m_selected_curve.getMaximum();
        int n5 = this.m_selected_curve.getMinimum();
        if (n < n5) {
            n = n5;
        } else if (n4 < n) {
            n = n4;
        }
        return this.HandleMouseMoveForBezierMove(n2, n, n3, bezierPickedSide);
    }

    private void TrackSelector_MouseMove(Object object, BMouseEventArgs bMouseEventArgs) {
        int n;
        int n2 = n = this.valueFromYCoord(bMouseEventArgs.Y);
        int n3 = this.m_selected_curve.getMaximum();
        int n4 = this.m_selected_curve.getMinimum();
        if (n < n4) {
            n = n4;
        } else if (n3 < n) {
            n = n3;
        }
        this.m_mouse_value = n;
        if (bMouseEventArgs.Button == BMouseButtons.None) {
            return;
        }
        if (bMouseEventArgs.X + AppManager.startToDrawX != this.m_mouse_down_location.x || bMouseEventArgs.Y != this.m_mouse_down_location.y) {
            if (this.m_mouse_hover_thread != null && this.m_mouse_hover_thread.isAlive()) {
                this.m_mouse_hover_thread.stop();
            }
            if (this.m_mouse_down_mode == MouseDownMode.VEL_WAIT_HOVER) {
                this.m_mouse_down_mode = MouseDownMode.VEL_EDIT;
            }
            this.m_mouse_moved = true;
        }
        if (AppManager.isPlaying()) {
            return;
        }
        int n5 = AppManager.clockFromXCoord(bMouseEventArgs.X);
        if (n5 < AppManager.getVsqFile().getPreMeasure()) {
            n5 = AppManager.getVsqFile().getPreMeasure();
        }
        if (bMouseEventArgs.Button == BMouseButtons.Left && 0 <= bMouseEventArgs.Y && bMouseEventArgs.Y <= this.getHeight() - 38 && this.m_mouse_down_mode == MouseDownMode.CURVE_EDIT) {
            EditTool editTool = AppManager.getSelectedTool();
            if (editTool == EditTool.PENCIL) {
                this.m_pencil_moved = bMouseEventArgs.X + AppManager.startToDrawX != this.m_mouse_down_location.x || bMouseEventArgs.Y != this.m_mouse_down_location.y;
                if (this.m_mouse_trace != null) {
                    Vector<Integer> vector = new Vector<Integer>();
                    int n6 = bMouseEventArgs.X + AppManager.startToDrawX;
                    if (n6 < this.m_mouse_trace_last_x) {
                        for (int n7 : this.m_mouse_trace.keySet()) {
                            if (n6 > n7 || n7 >= this.m_mouse_trace_last_x) continue;
                            vector.add(n7);
                        }
                    } else if (this.m_mouse_trace_last_x < n6) {
                        for (int n7 : this.m_mouse_trace.keySet()) {
                            if (this.m_mouse_trace_last_x >= n7 || n7 > n6) continue;
                            vector.add(n7);
                        }
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        this.m_mouse_trace.remove(vector.get(i));
                    }
                    if (n6 == this.m_mouse_trace_last_x) {
                        this.m_mouse_trace.put(n6, bMouseEventArgs.Y);
                        this.m_mouse_trace_last_y = bMouseEventArgs.Y;
                    } else {
                        float f = (float)(bMouseEventArgs.Y - this.m_mouse_trace_last_y) / (float)(n6 - this.m_mouse_trace_last_x);
                        float f2 = (float)this.m_mouse_trace_last_y - f * (float)this.m_mouse_trace_last_x;
                        int n8 = Math.min(n6, this.m_mouse_trace_last_x);
                        int n9 = Math.max(n6, this.m_mouse_trace_last_x);
                        for (int i = n8; i <= n9; ++i) {
                            int n10 = (int)(f * (float)i + f2);
                            this.m_mouse_trace.put(i, n10);
                        }
                        this.m_mouse_trace_last_x = n6;
                        this.m_mouse_trace_last_y = bMouseEventArgs.Y;
                    }
                }
            } else if (editTool == EditTool.ARROW || editTool == EditTool.ERASER) {
                int n11 = n5;
                if (AppManager.editorConfig.CurveSelectingQuantized) {
                    int n12 = AppManager.getPositionQuantizeClock();
                    int n13 = n5 % n12;
                    int n14 = n5;
                    n14 -= n13;
                    if (n13 > n12 / 2) {
                        n14 += n12;
                    }
                    n11 = n14;
                }
                AppManager.curveSelectingRectangle.width = n11 - AppManager.curveSelectingRectangle.x;
                AppManager.curveSelectingRectangle.height = n - AppManager.curveSelectingRectangle.y;
            }
        } else if (this.m_mouse_down_mode == MouseDownMode.SINGER_LIST) {
            int n15 = n5 - this.m_singer_move_started_clock;
            Iterator<SelectedEventEntry> iterator = AppManager.getSelectedEventIterator();
            while (iterator.hasNext()) {
                SelectedEventEntry selectedEventEntry = iterator.next();
                selectedEventEntry.editing.Clock = selectedEventEntry.original.Clock + n15;
            }
        } else if (this.m_mouse_down_mode == MouseDownMode.VEL_EDIT) {
            int n16 = this.valueFromYCoord(bMouseEventArgs.Y - this.m_veledit_shifty);
            int n17 = 0;
            if (this.m_selected_curve.equals(CurveType.VEL)) {
                n17 = n16 - this.m_veledit_selected.get((Object)Integer.valueOf((int)this.m_veledit_last_selectedid)).original.ID.Dynamics;
            } else if (this.m_selected_curve.equals(CurveType.Accent)) {
                n17 = n16 - this.m_veledit_selected.get((Object)Integer.valueOf((int)this.m_veledit_last_selectedid)).original.ID.DEMaccent;
            } else if (this.m_selected_curve.equals(CurveType.Decay)) {
                n17 = n16 - this.m_veledit_selected.get((Object)Integer.valueOf((int)this.m_veledit_last_selectedid)).original.ID.DEMdecGainRate;
            }
            for (int n18 : this.m_veledit_selected.keySet()) {
                int n19;
                if (this.m_selected_curve.equals(CurveType.VEL)) {
                    n19 = this.m_veledit_selected.get((Object)Integer.valueOf((int)n18)).original.ID.Dynamics + n17;
                    if (n19 < this.m_selected_curve.getMinimum()) {
                        n19 = this.m_selected_curve.getMinimum();
                    } else if (this.m_selected_curve.getMaximum() < n19) {
                        n19 = this.m_selected_curve.getMaximum();
                    }
                    this.m_veledit_selected.get((Object)Integer.valueOf((int)n18)).editing.ID.Dynamics = n19;
                    continue;
                }
                if (this.m_selected_curve.equals(CurveType.Accent)) {
                    n19 = this.m_veledit_selected.get((Object)Integer.valueOf((int)n18)).original.ID.DEMaccent + n17;
                    if (n19 < this.m_selected_curve.getMinimum()) {
                        n19 = this.m_selected_curve.getMinimum();
                    } else if (this.m_selected_curve.getMaximum() < n19) {
                        n19 = this.m_selected_curve.getMaximum();
                    }
                    this.m_veledit_selected.get((Object)Integer.valueOf((int)n18)).editing.ID.DEMaccent = n19;
                    continue;
                }
                if (!this.m_selected_curve.equals(CurveType.Decay)) continue;
                n19 = this.m_veledit_selected.get((Object)Integer.valueOf((int)n18)).original.ID.DEMdecGainRate + n17;
                if (n19 < this.m_selected_curve.getMinimum()) {
                    n19 = this.m_selected_curve.getMinimum();
                } else if (this.m_selected_curve.getMaximum() < n19) {
                    n19 = this.m_selected_curve.getMaximum();
                }
                this.m_veledit_selected.get((Object)Integer.valueOf((int)n18)).editing.ID.DEMdecGainRate = n19;
            }
        } else if (this.m_mouse_down_mode == MouseDownMode.BEZIER_MODE) {
            this.HandleMouseMoveForBezierMove(n5, n, n2, AppManager.getLastSelectedBezier().picked);
        } else if (this.m_mouse_down_mode == MouseDownMode.BEZIER_ADD_NEW || this.m_mouse_down_mode == MouseDownMode.BEZIER_EDIT) {
            BezierChain bezierChain = AppManager.getVsqFile().AttachedCurves.get(AppManager.getSelected() - 1).getBezierChain(this.m_selected_curve, AppManager.getLastSelectedBezier().chainID);
            int n20 = AppManager.getLastSelectedBezier().pointID;
            int n21 = -1;
            for (int i = 0; i < bezierChain.points.size(); ++i) {
                if (bezierChain.points.get(i).getID() != n20) continue;
                n21 = i;
                break;
            }
            if (n21 >= 0) {
                BezierPoint bezierPoint = bezierChain.points.get(n21);
                Point point = bezierPoint.getControlRight().toPoint();
                Point point2 = bezierPoint.getControlLeft().toPoint();
                BezierControlType bezierControlType = bezierPoint.getControlRightType();
                BezierControlType bezierControlType2 = bezierPoint.getControlLeftType();
                int n22 = n5;
                int n23 = n2;
                int n24 = (int)bezierPoint.getBase().getX() - n22;
                int n25 = (int)bezierPoint.getBase().getY() - n23;
                if (bezierPoint.getBase().getX() + (double)n24 >= 0.0) {
                    bezierPoint.setControlRight(new PointD(n5, n2));
                    bezierPoint.setControlLeft(new PointD(n5 + 2 * n24, n2 + 2 * n25));
                    bezierPoint.setControlRightType(BezierControlType.Normal);
                    bezierPoint.setControlLeftType(BezierControlType.Normal);
                    if (!BezierChain.isBezierImplicit(bezierChain)) {
                        bezierPoint.setControlLeft(new PointD(point2.x, point2.y));
                        bezierPoint.setControlRight(new PointD(point.x, point.y));
                        bezierPoint.setControlLeftType(bezierControlType2);
                        bezierPoint.setControlRightType(bezierControlType);
                    }
                }
            }
        } else if (this.m_mouse_down_mode == MouseDownMode.ENVELOPE_MOVE) {
            double d = AppManager.getVsqFile().getSecFromClock(AppManager.clockFromXCoord(bMouseEventArgs.X));
            int n26 = this.valueFromYCoord(bMouseEventArgs.Y);
            if (n26 < 0) {
                n26 = 0;
            } else if (200 < n26) {
                n26 = 200;
            }
            if (d < this.m_envelope_dot_begin) {
                d = this.m_envelope_dot_begin;
            } else if (this.m_envelope_dot_end < d) {
                d = this.m_envelope_dot_end;
            }
            if (this.m_envelope_point_kind == 1) {
                this.m_envelope_editing.p1 = (int)((d - this.m_envelope_range_begin) * 1000.0);
                this.m_envelope_editing.v1 = n26;
            } else if (this.m_envelope_point_kind == 2) {
                this.m_envelope_editing.p2 = (int)((d - this.m_envelope_range_begin) * 1000.0) - this.m_envelope_editing.p1;
                this.m_envelope_editing.v2 = n26;
            } else if (this.m_envelope_point_kind == 3) {
                this.m_envelope_editing.p5 = (int)((d - this.m_envelope_range_begin) * 1000.0) - this.m_envelope_editing.p1 - this.m_envelope_editing.p2;
                this.m_envelope_editing.v5 = n26;
            } else if (this.m_envelope_point_kind == 4) {
                this.m_envelope_editing.p3 = (int)((this.m_envelope_range_end - d) * 1000.0) - this.m_envelope_editing.p4;
                this.m_envelope_editing.v3 = n26;
            } else if (this.m_envelope_point_kind == 5) {
                this.m_envelope_editing.p4 = (int)((this.m_envelope_range_end - d) * 1000.0);
                this.m_envelope_editing.v4 = n26;
            }
        } else if (this.m_mouse_down_mode == MouseDownMode.PRE_UTTERANCE_MOVE) {
            float f;
            int n27 = AppManager.clockFromXCoord(this.m_mouse_down_location.x - AppManager.startToDrawX);
            VsqFileEx vsqFileEx = AppManager.getVsqFile();
            double d = vsqFileEx.getSecFromClock(n5) - vsqFileEx.getSecFromClock(n27);
            this.m_pre_ovl_editing.UstEvent.PreUtterance = f = this.m_pre_ovl_original.UstEvent.PreUtterance - (float)(d * 1000.0);
        } else if (this.m_mouse_down_mode == MouseDownMode.OVERLAP_MOVE) {
            float f;
            int n28 = AppManager.clockFromXCoord(this.m_mouse_down_location.x - AppManager.startToDrawX);
            VsqFileEx vsqFileEx = AppManager.getVsqFile();
            double d = vsqFileEx.getSecFromClock(n5) - vsqFileEx.getSecFromClock(n28);
            this.m_pre_ovl_editing.UstEvent.VoiceOverlap = f = this.m_pre_ovl_original.UstEvent.VoiceOverlap + (float)(d * 1000.0);
        }
    }

    private void findBezierPointAt(int n, int n2, Vector<BezierChain> vector, ByRef<BezierChain> byRef, ByRef<BezierPoint> byRef2, ByRef<BezierPickedSide> byRef3, int n3, int n4) {
        byRef.value = null;
        byRef2.value = null;
        byRef3.value = BezierPickedSide.BASE;
        int n5 = n3 + n4;
        int n6 = (n3 + n4) * 2;
        int n7 = vector.size();
        Point point = new Point(n, n2);
        for (int i = 0; i < n7; ++i) {
            BezierChain bezierChain = vector.get(i);
            for (BezierPoint bezierPoint : bezierChain.points) {
                Point point2 = this.getScreenCoord(bezierPoint.getBase());
                Rectangle rectangle = new Rectangle(point2.x - n5, point2.y - n5, n6, n6);
                if (TrackSelector.isInRect(n, n2, rectangle)) {
                    byRef.value = bezierChain;
                    byRef2.value = bezierPoint;
                    byRef3.value = BezierPickedSide.BASE;
                    return;
                }
                if (bezierPoint.getControlLeftType() != BezierControlType.None) {
                    point2 = this.getScreenCoord(bezierPoint.getControlLeft());
                    rectangle = new Rectangle(point2.x - n5, point2.y - n5, n6, n6);
                    if (TrackSelector.isInRect(n, n2, rectangle)) {
                        byRef.value = bezierChain;
                        byRef2.value = bezierPoint;
                        byRef3.value = BezierPickedSide.LEFT;
                        return;
                    }
                }
                if (bezierPoint.getControlRightType() == BezierControlType.None) continue;
                point2 = this.getScreenCoord(bezierPoint.getControlRight());
                rectangle = new Rectangle(point2.x - n5, point2.y - n5, n6, n6);
                if (!TrackSelector.isInRect(n, n2, rectangle)) continue;
                byRef.value = bezierChain;
                byRef2.value = bezierPoint;
                byRef3.value = BezierPickedSide.RIGHT;
                return;
            }
        }
    }

    private void processMouseDownSelectRegion(BMouseEventArgs bMouseEventArgs) {
        int n;
        if ((PortUtil.getCurrentModifierKey() & 2) != 2) {
            AppManager.clearSelectedPoint();
        }
        int n2 = n = AppManager.clockFromXCoord(bMouseEventArgs.X);
        int n3 = AppManager.getPositionQuantizeClock();
        int n4 = n % n3;
        n2 -= n4;
        if (n4 > n3 / 2) {
            n2 += n3;
        }
        int n5 = this.m_selected_curve.getMaximum();
        int n6 = this.m_selected_curve.getMinimum();
        int n7 = this.valueFromYCoord(bMouseEventArgs.Y);
        if (n7 < n6) {
            n7 = n6;
        } else if (n5 < n7) {
            n7 = n5;
        }
        AppManager.curveSelectingRectangle = AppManager.editorConfig.CurveSelectingQuantized ? new Rectangle(n2, n7, 0, 0) : new Rectangle(n, n7, 0, 0);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void TrackSelector_MouseDown(Object object, BMouseEventArgs bMouseEventArgs) {
        block94: {
            boolean bl;
            int n;
            Object object2;
            block115: {
                int n2;
                BezierChain bezierChain;
                ByRef<BezierPoint> byRef;
                ByRef<BezierChain> byRef2;
                block114: {
                    int n3;
                    BezierChain bezierChain2;
                    int n4;
                    block113: {
                        Object object3;
                        Object object4;
                        int n5;
                        Cloneable cloneable;
                        block119: {
                            block118: {
                                Cloneable cloneable2;
                                int n6;
                                int n7;
                                int n8;
                                block116: {
                                    block117: {
                                        boolean bl2;
                                        block107: {
                                            int n9;
                                            int n10;
                                            block108: {
                                                block100: {
                                                    block101: {
                                                        block111: {
                                                            VsqBPList vsqBPList;
                                                            block110: {
                                                                block112: {
                                                                    VsqFileEx vsqFileEx;
                                                                    block109: {
                                                                        block105: {
                                                                            block106: {
                                                                                block103: {
                                                                                    block104: {
                                                                                        block102: {
                                                                                            int n11;
                                                                                            int n12;
                                                                                            boolean bl3;
                                                                                            block99: {
                                                                                                int n13;
                                                                                                block96: {
                                                                                                    block97: {
                                                                                                        VsqEvent vsqEvent;
                                                                                                        block98: {
                                                                                                            block95: {
                                                                                                                vsqFileEx = AppManager.getVsqFile();
                                                                                                                this.m_mouse_down_location = new Point(bMouseEventArgs.X + AppManager.startToDrawX, bMouseEventArgs.Y);
                                                                                                                n8 = AppManager.clockFromXCoord(bMouseEventArgs.X);
                                                                                                                n4 = AppManager.getSelected();
                                                                                                                this.m_mouse_moved = false;
                                                                                                                this.m_mouse_downed = true;
                                                                                                                if (AppManager.keyWidth < bMouseEventArgs.X && n8 < vsqFileEx.getPreMeasure()) {
                                                                                                                    return;
                                                                                                                }
                                                                                                                this.m_modifier_on_mouse_down = PortUtil.getCurrentModifierKey();
                                                                                                                int n14 = this.m_selected_curve.getMaximum();
                                                                                                                int n15 = this.m_selected_curve.getMinimum();
                                                                                                                n7 = this.valueFromYCoord(bMouseEventArgs.Y);
                                                                                                                if (n7 < n15) {
                                                                                                                    n7 = n15;
                                                                                                                } else if (n14 < n7) {
                                                                                                                    n7 = n14;
                                                                                                                }
                                                                                                                if (this.getHeight() - 19 > bMouseEventArgs.Y || bMouseEventArgs.Y >= this.getHeight()) break block95;
                                                                                                                if (bMouseEventArgs.Button != BMouseButtons.Left) break block94;
                                                                                                                this.m_mouse_down_mode = MouseDownMode.TRACK_LIST;
                                                                                                                this.m_mouse_trace = null;
                                                                                                                n13 = this.getSelectorWidth();
                                                                                                                if (AppManager.getVsqFile() == null) break block94;
                                                                                                                break block96;
                                                                                                            }
                                                                                                            if (this.getHeight() - 38 > bMouseEventArgs.Y || bMouseEventArgs.Y >= this.getHeight() - 19) break block97;
                                                                                                            this.m_mouse_down_mode = MouseDownMode.SINGER_LIST;
                                                                                                            AppManager.clearSelectedPoint();
                                                                                                            this.m_mouse_trace = null;
                                                                                                            vsqEvent = this.findItemAt(bMouseEventArgs.X, bMouseEventArgs.Y);
                                                                                                            if (AppManager.getSelectedTool() != EditTool.ERASER) break block98;
                                                                                                            if (vsqEvent != null && vsqEvent.Clock > 0) {
                                                                                                                CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandEventDelete(n4, vsqEvent.InternalID));
                                                                                                                this.executeCommand(cadenciiCommand, true);
                                                                                                            }
                                                                                                            break block94;
                                                                                                        }
                                                                                                        if (vsqEvent != null) {
                                                                                                            if ((this.m_modifier_on_mouse_down & this.m_modifier_key) == this.m_modifier_key) {
                                                                                                                if (AppManager.isSelectedEventContains(AppManager.getSelected(), vsqEvent.InternalID)) {
                                                                                                                    Vector<Integer> vector = new Vector<Integer>();
                                                                                                                    Iterator<SelectedEventEntry> iterator = AppManager.getSelectedEventIterator();
                                                                                                                    while (iterator.hasNext()) {
                                                                                                                        SelectedEventEntry selectedEventEntry = iterator.next();
                                                                                                                        int n16 = selectedEventEntry.original.InternalID;
                                                                                                                        if (n16 == vsqEvent.InternalID) continue;
                                                                                                                        vector.add(n16);
                                                                                                                    }
                                                                                                                    AppManager.clearSelectedEvent();
                                                                                                                    AppManager.addSelectedEventAll(vector);
                                                                                                                } else {
                                                                                                                    AppManager.addSelectedEvent(vsqEvent.InternalID);
                                                                                                                }
                                                                                                            } else if ((PortUtil.getCurrentModifierKey() & 1) == 1) {
                                                                                                                int n17 = AppManager.getLastSelectedEvent().original.Clock;
                                                                                                                int n18 = Math.min(vsqEvent.Clock, n17);
                                                                                                                int n19 = Math.max(vsqEvent.Clock, n17);
                                                                                                                Vector<Integer> vector = new Vector<Integer>();
                                                                                                                Iterator<VsqEvent> iterator = ((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected())).getEventIterator();
                                                                                                                while (iterator.hasNext()) {
                                                                                                                    VsqEvent vsqEvent2 = iterator.next();
                                                                                                                    if (vsqEvent2.ID.type != VsqIDType.Singer || n18 > vsqEvent2.Clock || vsqEvent2.Clock > n19) continue;
                                                                                                                    vector.add(vsqEvent2.InternalID);
                                                                                                                }
                                                                                                                vector.add(vsqEvent.InternalID);
                                                                                                                AppManager.addSelectedEventAll(vector);
                                                                                                            } else {
                                                                                                                if (!AppManager.isSelectedEventContains(AppManager.getSelected(), vsqEvent.InternalID)) {
                                                                                                                    AppManager.clearSelectedEvent();
                                                                                                                }
                                                                                                                AppManager.addSelectedEvent(vsqEvent.InternalID);
                                                                                                            }
                                                                                                            this.m_singer_move_started_clock = n8;
                                                                                                            break block94;
                                                                                                        } else {
                                                                                                            AppManager.clearSelectedEvent();
                                                                                                        }
                                                                                                        break block94;
                                                                                                    }
                                                                                                    bl3 = false;
                                                                                                    n12 = AppManager.clockFromXCoord(AppManager.keyWidth);
                                                                                                    n11 = AppManager.clockFromXCoord(this.getWidth() - this.vScroll.getWidth());
                                                                                                    object2 = ((VsqTrack)vsqFileEx.Track.get(AppManager.getSelected())).getEventIterator();
                                                                                                    break block99;
                                                                                                }
                                                                                                for (int i = 0; i < 16; ++i) {
                                                                                                    int n20 = AppManager.keyWidth + i * n13;
                                                                                                    if (AppManager.getVsqFile().Track.size() <= i + 1 || n20 > bMouseEventArgs.X || bMouseEventArgs.X >= n20 + n13) continue;
                                                                                                    int n21 = i + 1;
                                                                                                    if (AppManager.getSelected() != n21) {
                                                                                                        AppManager.setSelected(i + 1);
                                                                                                        try {
                                                                                                            this.selectedTrackChangedEvent.raise(this, i + 1);
                                                                                                        }
                                                                                                        catch (Exception exception) {
                                                                                                            PortUtil.stderr.println("TrackSelector#TrackSelector_MouseDown; ex=" + exception);
                                                                                                        }
                                                                                                        this.invalidate();
                                                                                                        return;
                                                                                                    }
                                                                                                    if (n20 + n13 - 10 > bMouseEventArgs.X || bMouseEventArgs.X >= bMouseEventArgs.X + n13 || !AppManager.getRenderRequired(AppManager.getSelected()) || AppManager.isPlaying()) continue;
                                                                                                    try {
                                                                                                        this.renderRequiredEvent.raise(this, new int[]{AppManager.getSelected()});
                                                                                                        continue;
                                                                                                    }
                                                                                                    catch (Exception exception) {
                                                                                                        PortUtil.stderr.println("TrackSelector#TrackSelector_MouseDown; ex=" + exception);
                                                                                                    }
                                                                                                }
                                                                                                break block94;
                                                                                            }
                                                                                            while (object2.hasNext()) {
                                                                                                VsqEvent vsqEvent = object2.next();
                                                                                                if (vsqEvent.ID.type != VsqIDType.Anote) continue;
                                                                                                n = vsqEvent.Clock;
                                                                                                if (n11 < n) break;
                                                                                                n10 = vsqEvent.Clock + vsqEvent.ID.getLength();
                                                                                                if (n10 < n12 || n > n8 || n8 >= n10) continue;
                                                                                                bl3 = true;
                                                                                                break;
                                                                                            }
                                                                                            if (AppManager.keyWidth > bMouseEventArgs.X) break block100;
                                                                                            if (bMouseEventArgs.Button != BMouseButtons.Left || this.m_spacekey_downed) break block101;
                                                                                            this.m_mouse_down_mode = MouseDownMode.CURVE_EDIT;
                                                                                            n6 = n8;
                                                                                            int n22 = AppManager.getPositionQuantizeClock();
                                                                                            n = n8 % n22;
                                                                                            n6 -= n;
                                                                                            if (n > n22 / 2) {
                                                                                                n6 += n22;
                                                                                            }
                                                                                            n10 = 3 + AppManager.editorConfig.PxToleranceBezier;
                                                                                            n9 = n10 * 2 + 1;
                                                                                            if (AppManager.getSelectedTool() != EditTool.LINE) break block102;
                                                                                            if (AppManager.isCurveMode()) {
                                                                                                if (this.m_selected_curve.equals(CurveType.Env)) {
                                                                                                    if (this.processMouseDownEnvelope(bMouseEventArgs)) {
                                                                                                        this.invalidate();
                                                                                                        return;
                                                                                                    }
                                                                                                    if (this.processMouseDownPreutteranceAndOverlap(bMouseEventArgs)) {
                                                                                                        this.invalidate();
                                                                                                        return;
                                                                                                    }
                                                                                                } else if (!(this.m_selected_curve.equals(CurveType.VEL) || this.m_selected_curve.equals(CurveType.Accent) || this.m_selected_curve.equals(CurveType.Decay) || this.m_selected_curve.equals(CurveType.Env) || !this.processMouseDownBezier(bMouseEventArgs))) {
                                                                                                    this.invalidate();
                                                                                                    return;
                                                                                                }
                                                                                            } else if (this.m_selected_curve.equals(CurveType.Env)) {
                                                                                                if (this.processMouseDownEnvelope(bMouseEventArgs)) {
                                                                                                    this.invalidate();
                                                                                                    return;
                                                                                                }
                                                                                                if (this.processMouseDownPreutteranceAndOverlap(bMouseEventArgs)) {
                                                                                                    this.invalidate();
                                                                                                    return;
                                                                                                }
                                                                                            }
                                                                                            this.m_line_start = new Point(n8, n7);
                                                                                            break block94;
                                                                                        }
                                                                                        if (AppManager.getSelectedTool() != EditTool.PENCIL) break block103;
                                                                                        if (!AppManager.isCurveMode()) break block104;
                                                                                        if (!this.m_selected_curve.equals(CurveType.VibratoRate) && !this.m_selected_curve.equals(CurveType.VibratoDepth)) {
                                                                                            if (this.m_selected_curve.equals(CurveType.Env)) {
                                                                                                if (this.processMouseDownEnvelope(bMouseEventArgs)) {
                                                                                                    this.invalidate();
                                                                                                    return;
                                                                                                }
                                                                                                if (this.processMouseDownPreutteranceAndOverlap(bMouseEventArgs)) {
                                                                                                    this.invalidate();
                                                                                                    return;
                                                                                                }
                                                                                                break block94;
                                                                                            } else if (!(this.m_selected_curve.equals(CurveType.VEL) || this.m_selected_curve.equals(CurveType.Accent) || this.m_selected_curve.equals(CurveType.Decay) || this.m_selected_curve.equals(CurveType.Env))) {
                                                                                                if (this.processMouseDownBezier(bMouseEventArgs)) {
                                                                                                    this.invalidate();
                                                                                                    return;
                                                                                                }
                                                                                                break block94;
                                                                                            } else {
                                                                                                this.m_mouse_down_mode = MouseDownMode.NONE;
                                                                                            }
                                                                                        }
                                                                                        break block94;
                                                                                    }
                                                                                    if (this.m_selected_curve.equals(CurveType.Env)) {
                                                                                        if (this.processMouseDownEnvelope(bMouseEventArgs)) {
                                                                                            this.invalidate();
                                                                                            return;
                                                                                        }
                                                                                        if (this.processMouseDownPreutteranceAndOverlap(bMouseEventArgs)) {
                                                                                            this.invalidate();
                                                                                            return;
                                                                                        }
                                                                                    }
                                                                                    this.m_mouse_trace = null;
                                                                                    this.m_mouse_trace = new TreeMap();
                                                                                    int n23 = bMouseEventArgs.X + AppManager.startToDrawX;
                                                                                    this.m_mouse_trace.put(n23, bMouseEventArgs.Y);
                                                                                    this.m_mouse_trace_last_x = n23;
                                                                                    this.m_mouse_trace_last_y = bMouseEventArgs.Y;
                                                                                    this.m_pencil_moved = false;
                                                                                    this.m_mouse_hover_thread = new MouseHoverEventGeneratorProc();
                                                                                    this.m_mouse_hover_thread.start();
                                                                                    break block94;
                                                                                }
                                                                                if (AppManager.getSelectedTool() != EditTool.ARROW) break block105;
                                                                                bl2 = false;
                                                                                if (!this.m_selected_curve.isScalar() && !this.m_selected_curve.isAttachNote()) break block106;
                                                                                if (this.m_selected_curve.equals(CurveType.Env)) {
                                                                                    if (this.processMouseDownEnvelope(bMouseEventArgs)) {
                                                                                        this.invalidate();
                                                                                        return;
                                                                                    }
                                                                                    if (this.processMouseDownPreutteranceAndOverlap(bMouseEventArgs)) {
                                                                                        this.invalidate();
                                                                                        return;
                                                                                    }
                                                                                }
                                                                                this.m_mouse_down_mode = MouseDownMode.NONE;
                                                                                break block107;
                                                                            }
                                                                            cloneable = AppManager.getVsqFile().AttachedCurves.get(AppManager.getSelected() - 1).get(this.m_selected_curve);
                                                                            AppManager.clearSelectedBezier();
                                                                            break block108;
                                                                        }
                                                                        if (AppManager.getSelectedTool() != EditTool.ERASER) break block94;
                                                                        VsqEvent vsqEvent = this.findItemAt(bMouseEventArgs.X, bMouseEventArgs.Y);
                                                                        if (vsqEvent == null) break block109;
                                                                        AppManager.clearSelectedEvent();
                                                                        CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandEventDelete(n4, vsqEvent.InternalID));
                                                                        this.executeCommand(cadenciiCommand, true);
                                                                        break block94;
                                                                    }
                                                                    if (!AppManager.isCurveMode()) break block110;
                                                                    Vector<BezierChain> vector = vsqFileEx.AttachedCurves.get(AppManager.getSelected() - 1).get(this.m_selected_curve);
                                                                    if (vector == null) break block111;
                                                                    byRef2 = new ByRef<BezierChain>();
                                                                    byRef = new ByRef<BezierPoint>();
                                                                    ByRef<BezierPickedSide> byRef3 = new ByRef<BezierPickedSide>();
                                                                    this.findBezierPointAt(bMouseEventArgs.X, bMouseEventArgs.Y, vector, byRef2, byRef, byRef3, 3, AppManager.editorConfig.PxToleranceBezier);
                                                                    if (byRef.value == null) break block111;
                                                                    if (byRef3.value != BezierPickedSide.BASE) break block112;
                                                                    bezierChain2 = (BezierChain)((BezierChain)byRef2.value).clone();
                                                                    n3 = bezierChain2.points.size();
                                                                    if (n3 <= 1) {
                                                                        CadenciiCommand cadenciiCommand = VsqFileEx.generateCommandDeleteBezierChain(AppManager.getSelected(), this.m_selected_curve, ((BezierChain)byRef2.value).id, AppManager.editorConfig.getControlCurveResolutionValue());
                                                                        this.executeCommand(cadenciiCommand, true);
                                                                        this.m_mouse_down_mode = MouseDownMode.NONE;
                                                                        this.invalidate();
                                                                        return;
                                                                    }
                                                                    break block113;
                                                                }
                                                                bezierChain = (BezierChain)((BezierChain)byRef2.value).clone();
                                                                n2 = bezierChain.points.size();
                                                                break block114;
                                                            }
                                                            long l = this.findDataPointAt(bMouseEventArgs.X, bMouseEventArgs.Y);
                                                            if (l > 0L && (vsqBPList = ((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected())).getCurve(this.m_selected_curve.getName())) != null) {
                                                                VsqBPList vsqBPList2 = (VsqBPList)vsqBPList.clone();
                                                                VsqBPPairSearchContext vsqBPPairSearchContext = vsqBPList2.findElement(l);
                                                                if (vsqBPPairSearchContext.point.id == l) {
                                                                    vsqBPList2.remove(vsqBPPairSearchContext.clock);
                                                                    CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandTrackCurveReplace(n4, this.m_selected_curve.getName(), vsqBPList2));
                                                                    this.executeCommand(cadenciiCommand, true);
                                                                    this.m_mouse_down_mode = MouseDownMode.NONE;
                                                                    this.invalidate();
                                                                    return;
                                                                }
                                                            }
                                                        }
                                                        if ((this.m_modifier_on_mouse_down & 1) != 1 && (this.m_modifier_on_mouse_down & this.m_modifier_key) != this.m_modifier_key) {
                                                            AppManager.clearSelectedPoint();
                                                        }
                                                        AppManager.curveSelectingRectangle = AppManager.editorConfig.CurveSelectingQuantized ? new Rectangle(n6, n7, 0, 0) : new Rectangle(n8, n7, 0, 0);
                                                        break block94;
                                                    }
                                                    if (bMouseEventArgs.Button != BMouseButtons.Right || !AppManager.isCurveMode() || this.m_selected_curve.equals(CurveType.VEL) || this.m_selected_curve.equals(CurveType.Env)) break block94;
                                                    object2 = AppManager.getVsqFile().AttachedCurves.get(AppManager.getSelected() - 1).get(this.m_selected_curve);
                                                    AppManager.clearSelectedBezier();
                                                    bl = false;
                                                    break block115;
                                                }
                                                AppManager.setCurveSelectedIntervalEnabled(false);
                                                break block94;
                                            }
                                            for (n5 = 0; n5 < ((Vector)cloneable).size(); ++n5) {
                                                object4 = (BezierChain)((Vector)cloneable).get(n5);
                                                for (BezierPoint bezierPoint : ((BezierChain)object4).points) {
                                                    Point point = this.getScreenCoord(bezierPoint.getBase());
                                                    cloneable2 = new Rectangle(point.x - n10, point.y - n10, n9, n9);
                                                    if (TrackSelector.isInRect(bMouseEventArgs.X, bMouseEventArgs.Y, (Rectangle)cloneable2)) {
                                                        AppManager.addSelectedBezier(new SelectedBezierPoint(((BezierChain)object4).id, bezierPoint.getID(), BezierPickedSide.BASE, bezierPoint));
                                                        this.m_editing_bezier_original = (BezierChain)((BezierChain)object4).clone();
                                                        bl2 = true;
                                                        break;
                                                    }
                                                    if (bezierPoint.getControlLeftType() != BezierControlType.None) {
                                                        Point point2 = this.getScreenCoord(bezierPoint.getControlLeft());
                                                        cloneable2 = new Rectangle(point2.x - n10, point2.y - n10, n9, n9);
                                                        if (TrackSelector.isInRect(bMouseEventArgs.X, bMouseEventArgs.Y, (Rectangle)cloneable2)) {
                                                            AppManager.addSelectedBezier(new SelectedBezierPoint(((BezierChain)object4).id, bezierPoint.getID(), BezierPickedSide.LEFT, bezierPoint));
                                                            this.m_editing_bezier_original = (BezierChain)((BezierChain)object4).clone();
                                                            bl2 = true;
                                                            break;
                                                        }
                                                    }
                                                    if (bezierPoint.getControlRightType() == BezierControlType.None) continue;
                                                    Point point3 = this.getScreenCoord(bezierPoint.getControlRight());
                                                    cloneable2 = new Rectangle(point3.x - n10, point3.y - n10, n9, n9);
                                                    if (!TrackSelector.isInRect(bMouseEventArgs.X, bMouseEventArgs.Y, (Rectangle)cloneable2)) continue;
                                                    AppManager.addSelectedBezier(new SelectedBezierPoint(((BezierChain)object4).id, bezierPoint.getID(), BezierPickedSide.RIGHT, bezierPoint));
                                                    this.m_editing_bezier_original = (BezierChain)((BezierChain)object4).clone();
                                                    bl2 = true;
                                                    break;
                                                }
                                                if (bl2) break;
                                            }
                                            if (bl2) {
                                                this.m_mouse_down_mode = MouseDownMode.BEZIER_MODE;
                                            }
                                        }
                                        if (bl2) break block94;
                                        cloneable = this.findItemAt(bMouseEventArgs.X, bMouseEventArgs.Y);
                                        if (cloneable == null) break block116;
                                        n5 = 0;
                                        if ((this.m_modifier_on_mouse_down & this.m_modifier_key) != this.m_modifier_key) break block117;
                                        object4 = new Vector();
                                        object3 = AppManager.getSelectedEventIterator();
                                        break block118;
                                    }
                                    if ((PortUtil.getCurrentModifierKey() & 1) == 1) {
                                        object4 = AppManager.getLastSelectedEvent();
                                        if (object4 != null) {
                                            int n24 = ((SelectedEventEntry)object4).original.Clock;
                                            int n25 = Math.min(((VsqEvent)cloneable).Clock, n24);
                                            int n26 = Math.max(((VsqEvent)cloneable).Clock, n24);
                                            cloneable2 = new Vector();
                                            Iterator<VsqEvent> iterator = ((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected())).getNoteEventIterator();
                                            while (iterator.hasNext()) {
                                                VsqEvent vsqEvent = iterator.next();
                                                if (n25 > vsqEvent.Clock || vsqEvent.Clock > n26) continue;
                                                ((Vector)cloneable2).add(vsqEvent.InternalID);
                                            }
                                            AppManager.addSelectedEventAll((Vector<Integer>)cloneable2);
                                        }
                                        break block119;
                                    } else if (!AppManager.isSelectedEventContains(AppManager.getSelected(), ((VsqEvent)cloneable).InternalID)) {
                                        AppManager.clearSelectedEvent();
                                    }
                                    break block119;
                                }
                                long l = this.findDataPointAt(bMouseEventArgs.X, bMouseEventArgs.Y);
                                if (l > 0L) {
                                    if (AppManager.isSelectedPointContains(l)) {
                                        if ((this.m_modifier_on_mouse_down & this.m_modifier_key) == this.m_modifier_key) {
                                            AppManager.removeSelectedPoint(l);
                                            this.m_mouse_down_mode = MouseDownMode.NONE;
                                            this.invalidate();
                                            return;
                                        }
                                    } else {
                                        if ((this.m_modifier_on_mouse_down & this.m_modifier_key) != this.m_modifier_key) {
                                            AppManager.clearSelectedPoint();
                                        }
                                        AppManager.addSelectedPoint(this.m_selected_curve, l);
                                    }
                                    this.m_mouse_down_mode = MouseDownMode.POINT_MOVE;
                                    this.m_moving_points.clear();
                                    object3 = ((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected())).getCurve(this.m_selected_curve.getName());
                                    if (object3 != null) {
                                        int n27 = ((VsqBPList)object3).size();
                                        boolean bl4 = false;
                                        while (true) {
                                            void var23_77;
                                            if (var23_77 >= n27) {
                                                this.invalidate();
                                                return;
                                            }
                                            cloneable2 = ((VsqBPList)object3).getElementB((int)var23_77);
                                            if (AppManager.isSelectedPointContains(((VsqBPPair)cloneable2).id)) {
                                                this.m_moving_points.add(new BPPair(((VsqBPList)object3).getKeyClock((int)var23_77), ((VsqBPPair)cloneable2).value));
                                            }
                                            ++var23_77;
                                        }
                                    }
                                } else {
                                    if ((this.m_modifier_on_mouse_down & 2) != 2) {
                                        AppManager.clearSelectedPoint();
                                    }
                                    if ((this.m_modifier_on_mouse_down & 1) != 1 && (this.m_modifier_on_mouse_down & this.m_modifier_key) != this.m_modifier_key) {
                                        AppManager.clearSelectedPoint();
                                    }
                                }
                                if ((this.m_modifier_on_mouse_down & this.m_modifier_key) != this.m_modifier_key) {
                                    AppManager.setCurveSelectedIntervalEnabled(false);
                                }
                                AppManager.curveSelectingRectangle = AppManager.editorConfig.CurveSelectingQuantized ? new Rectangle(n6, n7, 0, 0) : new Rectangle(n8, n7, 0, 0);
                                break block94;
                            }
                            while (object3.hasNext()) {
                                SelectedEventEntry selectedEventEntry = (SelectedEventEntry)object3.next();
                                VsqEvent vsqEvent = selectedEventEntry.original;
                                if (((VsqEvent)cloneable).InternalID == vsqEvent.InternalID) {
                                    n5 = 1;
                                    continue;
                                }
                                ((Vector)object4).add(vsqEvent.InternalID);
                            }
                            AppManager.clearSelectedEvent();
                            AppManager.addSelectedEventAll((Vector<Integer>)object4);
                        }
                        if (n5 == 0) {
                            AppManager.addSelectedEvent(((VsqEvent)cloneable).InternalID);
                        }
                        this.m_mouse_down_mode = MouseDownMode.VEL_WAIT_HOVER;
                        this.m_veledit_last_selectedid = ((VsqEvent)cloneable).InternalID;
                        if (this.m_selected_curve.equals(CurveType.VEL)) {
                            this.m_veledit_shifty = bMouseEventArgs.Y - this.yCoordFromValue(((VsqEvent)cloneable).ID.Dynamics);
                        } else if (this.m_selected_curve.equals(CurveType.Accent)) {
                            this.m_veledit_shifty = bMouseEventArgs.Y - this.yCoordFromValue(((VsqEvent)cloneable).ID.DEMaccent);
                        } else if (this.m_selected_curve.equals(CurveType.Decay)) {
                            this.m_veledit_shifty = bMouseEventArgs.Y - this.yCoordFromValue(((VsqEvent)cloneable).ID.DEMdecGainRate);
                        }
                        this.m_veledit_selected.clear();
                        if (AppManager.isSelectedEventContains(AppManager.getSelected(), this.m_veledit_last_selectedid)) {
                            object4 = AppManager.getSelectedEventIterator();
                            while (object4.hasNext()) {
                                object3 = object4.next();
                                this.m_veledit_selected.put(((SelectedEventEntry)object3).original.InternalID, new SelectedEventEntry(AppManager.getSelected(), ((SelectedEventEntry)object3).original, ((SelectedEventEntry)object3).editing));
                            }
                        } else {
                            this.m_veledit_selected.put(this.m_veledit_last_selectedid, new SelectedEventEntry(AppManager.getSelected(), (VsqEvent)((VsqEvent)cloneable).clone(), (VsqEvent)((VsqEvent)cloneable).clone()));
                        }
                        this.m_mouse_hover_thread = new MouseHoverEventGeneratorProc();
                        this.m_mouse_hover_thread.start();
                        this.invalidate();
                        return;
                    }
                    for (int i = 0; i < n3; ++i) {
                        BezierPoint bezierPoint = bezierChain2.points.get(i);
                        if (bezierPoint.getID() != ((BezierPoint)byRef.value).getID()) continue;
                        bezierChain2.points.removeElementAt(i);
                        break;
                    }
                    CadenciiCommand cadenciiCommand = VsqFileEx.generateCommandReplaceBezierChain(n4, this.m_selected_curve, ((BezierChain)byRef2.value).id, bezierChain2, AppManager.editorConfig.getControlCurveResolutionValue());
                    this.executeCommand(cadenciiCommand, true);
                    this.m_mouse_down_mode = MouseDownMode.NONE;
                    this.invalidate();
                    return;
                }
                for (int i = 0; i < n2; ++i) {
                    BezierPoint bezierPoint = bezierChain.points.get(i);
                    if (bezierPoint.getID() != ((BezierPoint)byRef.value).getID()) continue;
                    bezierPoint.setControlLeftType(BezierControlType.None);
                    bezierPoint.setControlRightType(BezierControlType.None);
                    break;
                }
                CadenciiCommand cadenciiCommand = VsqFileEx.generateCommandReplaceBezierChain(AppManager.getSelected(), this.m_selected_curve, ((BezierChain)byRef2.value).id, bezierChain, AppManager.editorConfig.getControlCurveResolutionValue());
                this.executeCommand(cadenciiCommand, true);
                this.m_mouse_down_mode = MouseDownMode.NONE;
                this.invalidate();
                return;
            }
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                BezierChain bezierChain = (BezierChain)((Vector)object2).get(n);
                for (BezierPoint bezierPoint : bezierChain.points) {
                    Point point = this.getScreenCoord(bezierPoint.getBase());
                    Rectangle rectangle = new Rectangle(point.x - 3, point.y - 3, 7, 7);
                    if (!TrackSelector.isInRect(bMouseEventArgs.X, bMouseEventArgs.Y, rectangle)) continue;
                    AppManager.addSelectedBezier(new SelectedBezierPoint(bezierChain.id, bezierPoint.getID(), BezierPickedSide.BASE, bezierPoint));
                    bl = true;
                    break;
                }
                if (!bl) {
                    continue;
                }
                break;
            }
        }
        this.invalidate();
    }

    private boolean processMouseDownBezier(BMouseEventArgs bMouseEventArgs) {
        int n = AppManager.clockFromXCoord(bMouseEventArgs.X);
        int n2 = this.m_selected_curve.getMaximum();
        int n3 = this.m_selected_curve.getMinimum();
        int n4 = this.valueFromYCoord(bMouseEventArgs.Y);
        if (n4 < n3) {
            n4 = n3;
        } else if (n2 < n4) {
            n4 = n2;
        }
        int n5 = 3 + AppManager.editorConfig.PxToleranceBezier;
        int n6 = n5 * 2 + 1;
        int n7 = PortUtil.getCurrentModifierKey();
        int n8 = AppManager.getSelected();
        boolean bl = false;
        boolean bl2 = false;
        Vector<BezierChain> vector = AppManager.getVsqFile().AttachedCurves.get(n8 - 1).get(this.m_selected_curve);
        ByRef<BezierChain> byRef = new ByRef<BezierChain>();
        ByRef<BezierPoint> byRef2 = new ByRef<BezierPoint>();
        ByRef<BezierPickedSide> byRef3 = new ByRef<BezierPickedSide>();
        this.findBezierPointAt(bMouseEventArgs.X, bMouseEventArgs.Y, vector, byRef, byRef2, byRef3, 3, AppManager.editorConfig.PxToleranceBezier);
        if (byRef.value != null) {
            AppManager.addSelectedBezier(new SelectedBezierPoint(((BezierChain)byRef.value).id, ((BezierPoint)byRef2.value).getID(), (BezierPickedSide)((Object)byRef3.value), (BezierPoint)byRef2.value));
            this.m_editing_bezier_original = (BezierChain)((BezierChain)byRef.value).clone();
            this.m_mouse_down_mode = MouseDownMode.BEZIER_MODE;
        } else {
            Object object;
            int n9;
            if (AppManager.getSelectedTool() != EditTool.PENCIL) {
                return false;
            }
            BezierChain bezierChain = null;
            for (n9 = 0; n9 < vector.size(); ++n9) {
                BezierChain bezierChain2 = vector.get(n9);
                block1: for (int i = 1; i < bezierChain2.size(); ++i) {
                    if (!bl2 && bezierChain2.points.get(i - 1).getBase().getX() <= (double)n && (double)n <= bezierChain2.points.get(i).getBase().getX()) {
                        bezierChain = (BezierChain)bezierChain2.clone();
                        bl2 = true;
                    }
                    if (bl) continue;
                    for (BezierPoint object2 : bezierChain2.points) {
                        object = this.getScreenCoord(object2.getBase());
                        Rectangle rectangle = new Rectangle(((Point)object).x - n5, ((Point)object).y - n5, n6, n6);
                        if (!TrackSelector.isInRect(bMouseEventArgs.X, bMouseEventArgs.Y, rectangle)) continue;
                        bl = true;
                        continue block1;
                    }
                }
            }
            if (!bl) {
                if ((n7 & this.m_modifier_key) != this.m_modifier_key && bezierChain == null) {
                    n9 = -1;
                    for (int i = 0; i < vector.size(); ++i) {
                        BezierChain bezierChain3 = vector.get(i);
                        Collections.sort(bezierChain3.points);
                        int n10 = (int)bezierChain3.points.get(bezierChain3.points.size() - 1).getBase().getX();
                        if (n9 >= n10 || n10 >= n) continue;
                        n9 = n10;
                        bezierChain = (BezierChain)bezierChain3.clone();
                    }
                }
                PointD pointD = new PointD(n, n4);
                BezierPoint bezierPoint = null;
                int n11 = -1;
                int n12 = -1;
                if (bezierChain == null) {
                    BezierChain bezierChain2 = new BezierChain();
                    bezierPoint = new BezierPoint(pointD, pointD, pointD);
                    n12 = bezierChain2.getNextId();
                    bezierPoint.setID(n12);
                    bezierChain2.add(bezierPoint);
                    n11 = AppManager.getVsqFile().AttachedCurves.get(n8 - 1).getNextId(this.m_selected_curve);
                    object = VsqFileEx.generateCommandAddBezierChain(n8, this.m_selected_curve, n11, AppManager.editorConfig.getControlCurveResolutionValue(), bezierChain2);
                    this.executeCommand((CadenciiCommand)object, false);
                    this.m_mouse_down_mode = MouseDownMode.BEZIER_ADD_NEW;
                } else {
                    this.m_editing_bezier_original = (BezierChain)bezierChain.clone();
                    bezierPoint = new BezierPoint(pointD, pointD, pointD);
                    n12 = bezierChain.getNextId();
                    bezierPoint.setID(n12);
                    bezierChain.add(bezierPoint);
                    Collections.sort(bezierChain.points);
                    n11 = bezierChain.id;
                    CadenciiCommand cadenciiCommand = VsqFileEx.generateCommandReplaceBezierChain(n8, this.m_selected_curve, bezierChain.id, bezierChain, AppManager.editorConfig.getControlCurveResolutionValue());
                    this.executeCommand(cadenciiCommand, false);
                    this.m_mouse_down_mode = MouseDownMode.BEZIER_EDIT;
                }
                AppManager.clearSelectedBezier();
                AppManager.addSelectedBezier(new SelectedBezierPoint(n11, n12, BezierPickedSide.BASE, bezierPoint));
            } else {
                this.m_mouse_down_mode = MouseDownMode.NONE;
            }
        }
        return true;
    }

    private boolean processMouseDownPreutteranceAndOverlap(BMouseEventArgs bMouseEventArgs) {
        if (this.m_preutterance_viewing >= 0 && TrackSelector.isInRect(bMouseEventArgs.X, bMouseEventArgs.Y, this.m_preutterance_bounds)) {
            this.m_preutterance_moving_id = this.m_preutterance_viewing;
            this.m_pre_ovl_editing = ((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected())).findEventFromID(this.m_preutterance_moving_id);
            if (this.m_pre_ovl_editing == null) {
                this.m_mouse_down_mode = MouseDownMode.NONE;
                return false;
            }
            this.m_pre_ovl_original = (VsqEvent)this.m_pre_ovl_editing.clone();
            this.m_mouse_down_mode = MouseDownMode.PRE_UTTERANCE_MOVE;
            return true;
        }
        if (this.m_overlap_viewing >= 0 && TrackSelector.isInRect(bMouseEventArgs.X, bMouseEventArgs.Y, this.m_overlap_bounds)) {
            this.m_overlap_moving_id = this.m_overlap_viewing;
            this.m_pre_ovl_editing = ((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected())).findEventFromID(this.m_overlap_moving_id);
            if (this.m_pre_ovl_editing == null) {
                this.m_mouse_down_mode = MouseDownMode.NONE;
                return false;
            }
            this.m_pre_ovl_original = (VsqEvent)this.m_pre_ovl_editing.clone();
            this.m_mouse_down_mode = MouseDownMode.OVERLAP_MOVE;
            return true;
        }
        return false;
    }

    private boolean processMouseDownEnvelope(BMouseEventArgs bMouseEventArgs) {
        double d;
        ByRef<Integer> byRef;
        ByRef<Integer> byRef2 = new ByRef<Integer>(-1);
        if (!this.findEnvelopePointAt(bMouseEventArgs.X, bMouseEventArgs.Y, byRef2, byRef = new ByRef<Integer>(-1))) {
            return false;
        }
        this.m_envelope_original = null;
        VsqTrack vsqTrack = (VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected());
        VsqEvent vsqEvent = vsqTrack.findEventFromID((Integer)byRef2.value);
        if (vsqEvent == null) {
            return false;
        }
        if (vsqEvent != null && vsqEvent.UstEvent != null && vsqEvent.UstEvent.Envelope != null) {
            this.m_envelope_original = (UstEnvelope)vsqEvent.UstEvent.Envelope.clone();
            this.m_envelope_editing = vsqEvent.UstEvent.Envelope;
        }
        if (this.m_envelope_original == null) {
            this.m_envelope_editing = vsqEvent.UstEvent.Envelope = new UstEnvelope();
            this.m_envelope_original = (UstEnvelope)vsqEvent.UstEvent.Envelope.clone();
        }
        this.m_mouse_down_mode = MouseDownMode.ENVELOPE_MOVE;
        this.m_envelope_move_id = (Integer)byRef2.value;
        this.m_envelope_point_kind = (Integer)byRef.value;
        VsqEvent vsqEvent2 = null;
        int n = vsqTrack.getEventCount();
        block0: for (int i = 0; i < n; ++i) {
            if (vsqTrack.getEvent((int)i).InternalID != this.m_envelope_move_id) continue;
            for (int j = i + 1; j < n; ++j) {
                if (vsqTrack.getEvent((int)j).ID.type != VsqIDType.Anote) continue;
                vsqEvent2 = vsqTrack.getEvent(j);
                break block0;
            }
            break;
        }
        double d2 = AppManager.getVsqFile().getSecFromClock(AppManager.clockFromXCoord(bMouseEventArgs.X));
        this.m_envelope_range_begin = AppManager.getVsqFile().getSecFromClock(vsqEvent.Clock) - (double)vsqEvent.UstEvent.PreUtterance / 1000.0;
        this.m_envelope_range_end = AppManager.getVsqFile().getSecFromClock(vsqEvent.Clock + vsqEvent.ID.getLength());
        if (vsqEvent2 != null && (d = AppManager.getVsqFile().getSecFromClock(vsqEvent2.Clock) - (double)vsqEvent2.UstEvent.PreUtterance / 1000.0 + (double)vsqEvent2.UstEvent.VoiceOverlap / 1000.0) < this.m_envelope_range_end) {
            this.m_envelope_range_end = d;
        }
        if (this.m_envelope_point_kind == 1) {
            this.m_envelope_dot_begin = this.m_envelope_range_begin;
            this.m_envelope_dot_end = this.m_envelope_range_end - (double)(this.m_envelope_original.p4 + this.m_envelope_original.p3 + this.m_envelope_original.p5 + this.m_envelope_original.p2) / 1000.0;
        } else if (this.m_envelope_point_kind == 2) {
            this.m_envelope_dot_begin = this.m_envelope_range_begin + (double)this.m_envelope_original.p1 / 1000.0;
            this.m_envelope_dot_end = this.m_envelope_range_end - (double)(this.m_envelope_original.p4 + this.m_envelope_original.p3 + this.m_envelope_original.p5) / 1000.0;
        } else if (this.m_envelope_point_kind == 3) {
            this.m_envelope_dot_begin = this.m_envelope_range_begin + (double)(this.m_envelope_original.p1 + this.m_envelope_original.p2) / 1000.0;
            this.m_envelope_dot_end = this.m_envelope_range_end - (double)(this.m_envelope_original.p4 + this.m_envelope_original.p3) / 1000.0;
        } else if (this.m_envelope_point_kind == 4) {
            this.m_envelope_dot_begin = this.m_envelope_range_begin + (double)(this.m_envelope_original.p1 + this.m_envelope_original.p2 + this.m_envelope_original.p5) / 1000.0;
            this.m_envelope_dot_end = this.m_envelope_range_end - (double)this.m_envelope_original.p4 / 1000.0;
        } else if (this.m_envelope_point_kind == 5) {
            this.m_envelope_dot_begin = this.m_envelope_range_begin + (double)(this.m_envelope_original.p1 + this.m_envelope_original.p2 + this.m_envelope_original.p5 + this.m_envelope_original.p3) / 1000.0;
            this.m_envelope_dot_end = this.m_envelope_range_end;
        }
        return true;
    }

    private void changeCurve(CurveType curveType) {
        if (!this.m_selected_curve.equals(curveType)) {
            this.m_last_selected_curve = this.m_selected_curve;
            this.m_selected_curve = curveType;
            try {
                this.selectedCurveChangedEvent.raise(this, curveType);
            }
            catch (Exception exception) {
                PortUtil.stderr.println("TrackSelector#changeCurve; ex=" + exception);
            }
        }
    }

    private static boolean isInRect(int n, int n2, Rectangle rectangle) {
        if (rectangle.x <= n && n <= rectangle.x + rectangle.width) {
            return rectangle.y <= n2 && n2 <= rectangle.y + rectangle.height;
        }
        return false;
    }

    private VsqEvent findItemAt(int n, int n2) {
        if (AppManager.getVsqFile() == null) {
            return null;
        }
        VsqTrack vsqTrack = (VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected());
        int n3 = vsqTrack.getEventCount();
        for (int i = 0; i < n3; ++i) {
            int n4;
            VsqEvent vsqEvent = vsqTrack.getEvent(i);
            if (vsqEvent.ID.type == VsqIDType.Singer) {
                n4 = AppManager.xCoordFromClocks(vsqEvent.Clock);
                if (this.getHeight() - 38 <= n2 && n2 <= this.getHeight() - 19 && n4 <= n && n <= n4 + 66) {
                    return vsqEvent;
                }
                if (this.getWidth() >= n4) continue;
            }
            if (vsqEvent.ID.type != VsqIDType.Anote) continue;
            n4 = AppManager.xCoordFromClocks(vsqEvent.Clock);
            int n5 = 0;
            if (this.m_selected_curve.equals(CurveType.VEL)) {
                n5 = this.yCoordFromValue(vsqEvent.ID.Dynamics);
            } else if (this.m_selected_curve.equals(CurveType.Accent)) {
                n5 = this.yCoordFromValue(vsqEvent.ID.DEMaccent);
            } else {
                if (!this.m_selected_curve.equals(CurveType.Decay)) continue;
                n5 = this.yCoordFromValue(vsqEvent.ID.DEMdecGainRate);
            }
            if (0 > n2 || n2 > this.getHeight() - 38 || AppManager.keyWidth > n || n > this.getWidth() || n5 > n2 || n2 > this.getHeight() - 7 || n4 > n || n > n4 + 8) continue;
            return vsqEvent;
        }
        return null;
    }

    public void TrackSelector_MouseUp(Object object, BMouseEventArgs bMouseEventArgs) {
        this.m_mouse_downed = false;
        if (this.m_mouse_hover_thread != null && this.m_mouse_hover_thread.isAlive()) {
            this.m_mouse_hover_thread.stop();
        }
        if (!this.m_curve_visible) {
            this.m_mouse_down_mode = MouseDownMode.NONE;
            this.invalidate();
            return;
        }
        int n = AppManager.getSelected();
        int n2 = this.m_selected_curve.getMaximum();
        int n3 = this.m_selected_curve.getMinimum();
        VsqFileEx vsqFileEx = AppManager.getVsqFile();
        VsqTrack vsqTrack = (VsqTrack)vsqFileEx.Track.get(n);
        if (this.m_mouse_down_mode == MouseDownMode.BEZIER_ADD_NEW || this.m_mouse_down_mode == MouseDownMode.BEZIER_MODE || this.m_mouse_down_mode == MouseDownMode.BEZIER_EDIT) {
            if (bMouseEventArgs.Button == BMouseButtons.Left && object instanceof TrackSelector) {
                int n4 = AppManager.getLastSelectedBezier().chainID;
                BezierChain bezierChain = (BezierChain)vsqFileEx.AttachedCurves.get(n - 1).getBezierChain(this.m_selected_curve, n4).clone();
                if (this.m_mouse_down_mode == MouseDownMode.BEZIER_ADD_NEW) {
                    bezierChain.id = n4;
                    CadenciiCommand cadenciiCommand = VsqFileEx.generateCommandDeleteBezierChain(n, this.m_selected_curve, n4, AppManager.editorConfig.getControlCurveResolutionValue());
                    this.executeCommand(cadenciiCommand, false);
                    CadenciiCommand cadenciiCommand2 = VsqFileEx.generateCommandAddBezierChain(n, this.m_selected_curve, n4, AppManager.editorConfig.getControlCurveResolutionValue(), bezierChain);
                    this.executeCommand(cadenciiCommand2, true);
                } else if (this.m_mouse_down_mode == MouseDownMode.BEZIER_EDIT) {
                    CadenciiCommand cadenciiCommand = VsqFileEx.generateCommandReplaceBezierChain(n, this.m_selected_curve, n4, this.m_editing_bezier_original, AppManager.editorConfig.getControlCurveResolutionValue());
                    this.executeCommand(cadenciiCommand, false);
                    CadenciiCommand cadenciiCommand3 = VsqFileEx.generateCommandReplaceBezierChain(n, this.m_selected_curve, n4, bezierChain, AppManager.editorConfig.getControlCurveResolutionValue());
                    this.executeCommand(cadenciiCommand3, true);
                } else if (this.m_mouse_down_mode == MouseDownMode.BEZIER_MODE && this.m_mouse_moved) {
                    vsqFileEx.AttachedCurves.get(n - 1).setBezierChain(this.m_selected_curve, n4, this.m_editing_bezier_original);
                    CadenciiCommand cadenciiCommand = VsqFileEx.generateCommandReplaceBezierChain(n, this.m_selected_curve, n4, bezierChain, AppManager.editorConfig.getControlCurveResolutionValue());
                    this.executeCommand(cadenciiCommand, true);
                }
            }
        } else if (this.m_mouse_down_mode == MouseDownMode.CURVE_EDIT || this.m_mouse_down_mode == MouseDownMode.VEL_WAIT_HOVER) {
            if (bMouseEventArgs.Button == BMouseButtons.Left) {
                if (AppManager.getSelectedTool() == EditTool.ARROW) {
                    if (!(this.m_selected_curve.equals(CurveType.Env) || this.m_selected_curve.equals(CurveType.VEL) || this.m_selected_curve.equals(CurveType.Accent) || this.m_selected_curve.equals(CurveType.Decay))) {
                        if (AppManager.curveSelectingRectangle.width == 0) {
                            AppManager.setCurveSelectedIntervalEnabled(false);
                        } else {
                            int n5;
                            int n6;
                            int n7;
                            if (!AppManager.isCurveSelectedIntervalEnabled()) {
                                n7 = Math.min(AppManager.curveSelectingRectangle.x, AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width);
                                n6 = Math.max(AppManager.curveSelectingRectangle.x, AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width);
                                AppManager.curveSelectedInterval = new SelectedRegion(n7);
                                AppManager.curveSelectedInterval.setEnd(n6);
                                AppManager.setCurveSelectedIntervalEnabled(true);
                            } else {
                                n7 = Math.min(AppManager.curveSelectingRectangle.x, AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width);
                                n6 = Math.max(AppManager.curveSelectingRectangle.x, AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width);
                                int n8 = AppManager.curveSelectedInterval.getStart();
                                n5 = AppManager.curveSelectedInterval.getEnd();
                                AppManager.curveSelectedInterval = new SelectedRegion(Math.min(n7, n8));
                                AppManager.curveSelectedInterval.setEnd(Math.max(n6, n5));
                            }
                            if ((this.m_modifier_on_mouse_down & 2) != 2) {
                                AppManager.clearSelectedPoint();
                            }
                            if (!(this.m_selected_curve.equals(CurveType.Accent) || this.m_selected_curve.equals(CurveType.Decay) || this.m_selected_curve.equals(CurveType.Env) || this.m_selected_curve.equals(CurveType.VEL) || this.m_selected_curve.equals(CurveType.VibratoDepth) || this.m_selected_curve.equals(CurveType.VibratoRate))) {
                                VsqBPList vsqBPList = vsqTrack.getCurve(this.m_selected_curve.getName());
                                n6 = vsqBPList.size();
                                Rectangle rectangle = new Rectangle(Math.min(AppManager.curveSelectingRectangle.x, AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width), Math.min(AppManager.curveSelectingRectangle.y, AppManager.curveSelectingRectangle.y + AppManager.curveSelectingRectangle.height), Math.abs(AppManager.curveSelectingRectangle.width), Math.abs(AppManager.curveSelectingRectangle.height));
                                for (n5 = 0; n5 < n6; ++n5) {
                                    int n9 = vsqBPList.getKeyClock(n5);
                                    VsqBPPair vsqBPPair = vsqBPList.getElementB(n5);
                                    if (!TrackSelector.isInRect(n9, vsqBPPair.value, rectangle)) continue;
                                    AppManager.addSelectedPoint(this.m_selected_curve, vsqBPPair.id);
                                }
                            }
                        }
                    }
                } else if (AppManager.getSelectedTool() == EditTool.ERASER) {
                    if (AppManager.isCurveMode()) {
                        Vector<BezierChain> vector = vsqFileEx.AttachedCurves.get(n - 1).get(this.m_selected_curve);
                        if (vector != null) {
                            Object object2;
                            int n10 = Math.min(AppManager.curveSelectingRectangle.x, AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width);
                            int n11 = Math.min(AppManager.curveSelectingRectangle.y, AppManager.curveSelectingRectangle.y + AppManager.curveSelectingRectangle.height);
                            Rectangle rectangle = new Rectangle(n10, n11, Math.abs(AppManager.curveSelectingRectangle.width), Math.abs(AppManager.curveSelectingRectangle.height));
                            boolean bl = false;
                            int n12 = vector.size();
                            Vector<BezierChain> vector2 = new Vector<BezierChain>();
                            for (int i = 0; i < n12; ++i) {
                                object2 = vector.get(i);
                                BezierChain bezierChain = new BezierChain();
                                bezierChain.setColor(((BezierChain)object2).getColor());
                                bezierChain.Default = ((BezierChain)object2).Default;
                                bezierChain.id = ((BezierChain)object2).id;
                                int n13 = ((BezierChain)object2).points.size();
                                for (int j = 0; j < n13; ++j) {
                                    BezierPoint bezierPoint = ((BezierChain)object2).points.get(j);
                                    Point point = bezierPoint.getBase().toPoint();
                                    Point point2 = bezierPoint.getControlLeft().toPoint();
                                    Point point3 = bezierPoint.getControlRight().toPoint();
                                    if (TrackSelector.isInRect(point.x, point.y, rectangle)) {
                                        bl = true;
                                        continue;
                                    }
                                    if (bezierPoint.getControlLeftType() != BezierControlType.None && TrackSelector.isInRect(point2.x, point2.y, rectangle) || bezierPoint.getControlRightType() != BezierControlType.None && TrackSelector.isInRect(point3.x, point3.y, rectangle)) {
                                        BezierPoint bezierPoint2 = (BezierPoint)bezierPoint.clone();
                                        bezierPoint2.setControlLeftType(BezierControlType.None);
                                        bezierPoint2.setControlRightType(BezierControlType.None);
                                        bezierChain.points.add(bezierPoint2);
                                        bl = true;
                                        continue;
                                    }
                                    bezierChain.points.add((BezierPoint)bezierPoint.clone());
                                }
                                if (bezierChain.points.size() <= 0) continue;
                                vector2.add(bezierChain);
                            }
                            if (bl) {
                                TreeMap<CurveType, Vector<BezierChain>> treeMap = new TreeMap<CurveType, Vector<BezierChain>>();
                                treeMap.put(this.m_selected_curve, vector2);
                                object2 = VsqFileEx.generateCommandReplaceAttachedCurveRange(n, treeMap);
                                this.executeCommand((CadenciiCommand)object2, true);
                            }
                        }
                    } else if (this.m_selected_curve.equals(CurveType.VEL) || this.m_selected_curve.equals(CurveType.Accent) || this.m_selected_curve.equals(CurveType.Decay)) {
                        int n14 = Math.min(AppManager.curveSelectingRectangle.x, AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width);
                        int n15 = Math.max(AppManager.curveSelectingRectangle.x, AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width);
                        int n16 = AppManager.curveSelectedInterval.getStart();
                        int n17 = AppManager.curveSelectedInterval.getEnd();
                        AppManager.curveSelectedInterval = new SelectedRegion(Math.min(n14, n16));
                        AppManager.curveSelectedInterval.setEnd(Math.max(n15, n17));
                        AppManager.clearSelectedEvent();
                        Vector<Integer> vector = new Vector<Integer>();
                        Object object3 = vsqTrack.getNoteEventIterator();
                        while (object3.hasNext()) {
                            VsqEvent vsqEvent = object3.next();
                            if (n14 > vsqEvent.Clock || vsqEvent.Clock > n15) continue;
                            vector.add(vsqEvent.InternalID);
                        }
                        if (vector.size() > 0) {
                            object3 = new CadenciiCommand(VsqCommand.generateCommandEventDeleteRange(n, vector));
                            this.executeCommand((CadenciiCommand)object3, true);
                        }
                    } else if (this.m_selected_curve.equals(CurveType.VibratoRate) || this.m_selected_curve.equals(CurveType.VibratoDepth)) {
                        int n18 = Math.min(AppManager.curveSelectingRectangle.x, AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width);
                        int n19 = Math.max(AppManager.curveSelectingRectangle.x, AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width);
                        Vector<Integer> vector = new Vector<Integer>();
                        Vector<VsqID> vector3 = new Vector<VsqID>();
                        Object object4 = vsqTrack.getNoteEventIterator();
                        while (object4.hasNext()) {
                            VsqEvent vsqEvent = object4.next();
                            if (vsqEvent.ID.VibratoHandle == null) continue;
                            int n20 = vsqEvent.Clock + vsqEvent.ID.VibratoDelay;
                            int n21 = vsqEvent.ID.getLength() - vsqEvent.ID.VibratoDelay;
                            int n22 = n20 + n21;
                            int n23 = Integer.MAX_VALUE;
                            int n24 = Integer.MIN_VALUE;
                            if (n18 < n20 && n20 < n19 && n19 <= n22) {
                                n23 = n20;
                                n24 = n19;
                            } else if (n20 <= n18 && n19 <= n22) {
                                n23 = n18;
                                n24 = n19;
                            } else if (n20 < n18 && n18 < n22 && n22 < n19) {
                                n23 = n18;
                                n24 = n22;
                            } else if (n18 < n20 && n22 < n19) {
                                n23 = n20;
                                n24 = n22;
                            }
                            if (n23 >= n24) continue;
                            float f = (float)(n23 - n20) / (float)n21;
                            float f2 = (float)(n24 - n20) / (float)n21;
                            VsqID vsqID = (VsqID)vsqEvent.ID.clone();
                            VibratoBPList vibratoBPList = null;
                            vibratoBPList = this.m_selected_curve.equals(CurveType.VibratoDepth) ? vsqID.VibratoHandle.getDepthBP() : vsqID.VibratoHandle.getRateBP();
                            Vector<Float> vector4 = new Vector<Float>();
                            Vector<Integer> vector5 = new Vector<Integer>();
                            boolean bl = false;
                            boolean bl2 = false;
                            for (int i = 0; i < vibratoBPList.getCount(); ++i) {
                                VibratoBPPair vibratoBPPair = vibratoBPList.getElement(i);
                                if (vibratoBPPair.X < f) {
                                    vector4.add(Float.valueOf(vibratoBPPair.X));
                                    vector5.add(vibratoBPPair.Y);
                                    continue;
                                }
                                if (f == vibratoBPPair.X) {
                                    vector4.add(Float.valueOf(vibratoBPPair.X));
                                    vector5.add(64);
                                    bl = true;
                                    continue;
                                }
                                if (f < vibratoBPPair.X && !bl) {
                                    vector4.add(Float.valueOf(f));
                                    vector5.add(64);
                                    bl = true;
                                    continue;
                                }
                                if (f2 == vibratoBPPair.X) {
                                    vector4.add(Float.valueOf(vibratoBPPair.X));
                                    vector5.add(vibratoBPPair.Y);
                                    bl2 = true;
                                    continue;
                                }
                                if (f2 < vibratoBPPair.X && !bl2) {
                                    int n25 = vibratoBPPair.Y;
                                    if (i > 0) {
                                        n25 = vibratoBPList.getElement((int)(i - 1)).Y;
                                    }
                                    vector4.add(Float.valueOf(f2));
                                    vector5.add(n25);
                                    bl2 = true;
                                    vector4.add(Float.valueOf(vibratoBPPair.X));
                                    vector5.add(vibratoBPPair.Y);
                                    continue;
                                }
                                if (!(f2 < vibratoBPPair.X)) continue;
                                vector4.add(Float.valueOf(vibratoBPPair.X));
                                vector5.add(vibratoBPPair.Y);
                            }
                            if (this.m_selected_curve.equals(CurveType.VibratoDepth)) {
                                vsqID.VibratoHandle.setDepthBP(new VibratoBPList(PortUtil.convertFloatArray(vector4.toArray(new Float[0])), PortUtil.convertIntArray(vector5.toArray(new Integer[0]))));
                            } else {
                                vsqID.VibratoHandle.setRateBP(new VibratoBPList(PortUtil.convertFloatArray(vector4.toArray(new Float[0])), PortUtil.convertIntArray(vector5.toArray(new Integer[0]))));
                            }
                            vector.add(vsqEvent.InternalID);
                            vector3.add(vsqID);
                        }
                        object4 = new CadenciiCommand(VsqCommand.generateCommandEventChangeIDContaintsRange(n, PortUtil.convertIntArray(vector.toArray(new Integer[0])), vector3.toArray(new VsqID[0])));
                        this.executeCommand((CadenciiCommand)object4, true);
                    } else if (!this.m_selected_curve.equals(CurveType.Env)) {
                        VsqBPList vsqBPList = vsqTrack.getCurve(this.m_selected_curve.getName());
                        int n26 = Math.min(AppManager.curveSelectingRectangle.x, AppManager.curveSelectingRectangle.x + AppManager.curveSelectingRectangle.width);
                        int n27 = Math.min(AppManager.curveSelectingRectangle.y, AppManager.curveSelectingRectangle.y + AppManager.curveSelectingRectangle.height);
                        Rectangle rectangle = new Rectangle(n26, n27, Math.abs(AppManager.curveSelectingRectangle.width), Math.abs(AppManager.curveSelectingRectangle.height));
                        Vector<Long> vector = new Vector<Long>();
                        int n28 = vsqBPList.size();
                        for (int i = 0; i < n28; ++i) {
                            int n29 = vsqBPList.getKeyClock(i);
                            VsqBPPair vsqBPPair = vsqBPList.getElementB(i);
                            if (!TrackSelector.isInRect(n29, vsqBPPair.value, rectangle)) continue;
                            vector.add(vsqBPPair.id);
                        }
                        if (vector.size() > 0) {
                            CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandTrackCurveEdit2(n, this.m_selected_curve.getName(), vector, new TreeMap<Integer, VsqBPPair>()));
                            this.executeCommand(cadenciiCommand, true);
                        }
                    }
                } else if (!AppManager.isCurveMode() && AppManager.getSelectedTool() == EditTool.PENCIL) {
                    if (this.m_pencil_moved) {
                        int n30 = AppManager.startToDrawX;
                        if (this.m_selected_curve.equals(CurveType.VEL) || this.m_selected_curve.equals(CurveType.Accent) || this.m_selected_curve.equals(CurveType.Decay)) {
                            int n31;
                            int n32;
                            Object object5;
                            int n33 = this.m_mouse_trace.firstKey();
                            int n34 = this.m_mouse_trace.lastKey();
                            n33 = AppManager.clockFromXCoord(n33 - n30);
                            n34 = AppManager.clockFromXCoord(n34 - n30);
                            TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
                            Object object6 = vsqTrack.getNoteEventIterator();
                            while (object6.hasNext()) {
                                object5 = object6.next();
                                if (n33 > ((VsqEvent)object5).Clock || ((VsqEvent)object5).Clock >= n34) continue;
                                n32 = -1;
                                n31 = 0;
                                int n35 = this.m_mouse_trace.size();
                                for (int n36 : this.m_mouse_trace.keySet()) {
                                    if (++n32 == 0) {
                                        n31 = n36;
                                        continue;
                                    }
                                    int n37 = n31;
                                    int n38 = n36;
                                    int n39 = AppManager.clockFromXCoord(n37 - n30);
                                    int n40 = AppManager.clockFromXCoord(n38 - n30);
                                    if (n39 < ((VsqEvent)object5).Clock && ((VsqEvent)object5).Clock < n40) {
                                        int n41 = this.valueFromYCoord(this.m_mouse_trace.get(n37));
                                        int n42 = this.valueFromYCoord(this.m_mouse_trace.get(n38));
                                        float f = (float)(n42 - n41) / (float)(n40 - n39);
                                        float f3 = (float)n41 - f * (float)n39;
                                        int n43 = (int)(f * (float)((VsqEvent)object5).Clock + f3);
                                        treeMap.put(((VsqEvent)object5).InternalID, n43);
                                    } else if (n39 == ((VsqEvent)object5).Clock) {
                                        treeMap.put(((VsqEvent)object5).InternalID, this.valueFromYCoord(this.m_mouse_trace.get(n37)));
                                    } else if (n40 == ((VsqEvent)object5).Clock) {
                                        treeMap.put(((VsqEvent)object5).InternalID, this.valueFromYCoord(this.m_mouse_trace.get(n38)));
                                    }
                                    n31 = n36;
                                }
                            }
                            if (treeMap.size() > 0) {
                                object6 = new Vector();
                                object5 = treeMap.keySet().iterator();
                                while (object5.hasNext()) {
                                    n32 = (Integer)object5.next();
                                    n31 = (Integer)treeMap.get(n32);
                                    ((Vector)object6).add(new ValuePair<Integer, Integer>(n32, n31));
                                }
                                object5 = null;
                                if (this.m_selected_curve.equals(CurveType.VEL)) {
                                    object5 = new CadenciiCommand(VsqCommand.generateCommandEventChangeVelocity(n, (Vector<ValuePair<Integer, Integer>>)object6));
                                } else if (this.m_selected_curve.equals(CurveType.Accent)) {
                                    object5 = new CadenciiCommand(VsqCommand.generateCommandEventChangeAccent(n, (Vector<ValuePair<Integer, Integer>>)object6));
                                } else if (this.m_selected_curve.equals(CurveType.Decay)) {
                                    object5 = new CadenciiCommand(VsqCommand.generateCommandEventChangeDecay(n, (Vector<ValuePair<Integer, Integer>>)object6));
                                }
                                this.executeCommand((CadenciiCommand)object5, true);
                            }
                        } else if (this.m_selected_curve.equals(CurveType.VibratoRate) || this.m_selected_curve.equals(CurveType.VibratoDepth)) {
                            int n44 = AppManager.editorConfig.getControlCurveResolutionValue();
                            int n45 = (int)((float)n44 * AppManager.scaleX);
                            if (n45 <= 0) {
                                n45 = 1;
                            }
                            int n46 = this.m_mouse_trace.firstKey();
                            int n47 = this.m_mouse_trace.lastKey();
                            Vector<Integer> vector = new Vector<Integer>();
                            Vector<VsqID> vector6 = new Vector<VsqID>();
                            Object object7 = vsqTrack.getNoteEventIterator();
                            while (object7.hasNext()) {
                                int n48;
                                Object object8;
                                int n49;
                                VsqEvent vsqEvent = object7.next();
                                int n50 = vsqEvent.Clock + vsqEvent.ID.VibratoDelay;
                                float f = vsqEvent.ID.getLength() - vsqEvent.ID.VibratoDelay;
                                int n51 = AppManager.xCoordFromClocks(n50) + n30;
                                int n52 = AppManager.xCoordFromClocks(vsqEvent.Clock + vsqEvent.ID.getLength()) + n30;
                                int n53 = Math.max(n51, n46);
                                int n54 = Math.min(n52, n47);
                                float f4 = (float)(AppManager.clockFromXCoord(n53 - n30) - n50) / f;
                                float f5 = (float)(AppManager.clockFromXCoord(n54 - n30) - n50) / f;
                                if (n53 >= n54) continue;
                                Vector<ValuePair<Float, Integer>> vector7 = new Vector<ValuePair<Float, Integer>>();
                                block11: for (n49 = n53; n49 < n54; n49 += n45) {
                                    if (this.m_mouse_trace.containsKey(n49)) {
                                        vector7.add(new ValuePair<Float, Integer>(Float.valueOf((float)(AppManager.clockFromXCoord(n49 - n30) - n50) / f), this.valueFromYCoord(this.m_mouse_trace.get(n49))));
                                        continue;
                                    }
                                    int n55 = -1;
                                    int n56 = 0;
                                    int n57 = 0;
                                    object8 = this.m_mouse_trace.keySet().iterator();
                                    while (object8.hasNext()) {
                                        int n58 = object8.next();
                                        n48 = this.m_mouse_trace.get(n58);
                                        if (++n55 == 0) {
                                            n56 = n58;
                                            n57 = n48;
                                            continue;
                                        }
                                        int n59 = n56;
                                        int n60 = n58;
                                        int n61 = n57;
                                        int n62 = n48;
                                        if (n59 <= n49 && n49 < n60) {
                                            float f6 = (float)(n62 - n61) / (float)(n60 - n59);
                                            int n63 = (int)((float)n61 + f6 * (float)(n49 - n59));
                                            int n64 = AppManager.clockFromXCoord(n49 - n30);
                                            int n65 = this.valueFromYCoord(n63);
                                            if (n65 < n3) {
                                                n65 = n3;
                                            } else if (n2 < n48) {
                                                n65 = n2;
                                            }
                                            vector7.add(new ValuePair<Float, Integer>(Float.valueOf((float)(n64 - n50) / f), n65));
                                            continue block11;
                                        }
                                        n56 = n58;
                                        n57 = n48;
                                    }
                                }
                                n49 = AppManager.clockFromXCoord(n47 - n30);
                                float f7 = (float)(n49 - n50) / f;
                                if (0.0f <= f7 && f7 <= 1.0f) {
                                    int n66 = this.valueFromYCoord(this.m_mouse_trace.get(n47));
                                    if (n66 < n3) {
                                        n66 = n3;
                                    } else if (n2 < n66) {
                                        n66 = n2;
                                    }
                                    vector7.add(new ValuePair<Float, Integer>(Float.valueOf(f7), n66));
                                }
                                if (vsqEvent.ID.VibratoHandle == null) continue;
                                VibratoBPList vibratoBPList = null;
                                vibratoBPList = this.m_selected_curve.equals(CurveType.VibratoRate) ? vsqEvent.ID.VibratoHandle.getRateBP() : vsqEvent.ID.VibratoHandle.getDepthBP();
                                if (vibratoBPList.getCount() > 0) {
                                    for (int i = 0; i < vibratoBPList.getCount(); ++i) {
                                        if (!(vibratoBPList.getElement((int)i).X < f4) && !(f5 < vibratoBPList.getElement((int)i).X)) continue;
                                        vector7.add(new ValuePair<Float, Integer>(Float.valueOf(vibratoBPList.getElement((int)i).X), vibratoBPList.getElement((int)i).Y));
                                    }
                                }
                                Collections.sort(vector7);
                                VsqID vsqID = (VsqID)vsqEvent.ID.clone();
                                object8 = new float[vector7.size()];
                                int[] nArray = new int[vector7.size()];
                                for (n48 = 0; n48 < vector7.size(); ++n48) {
                                    object8[n48] = ((Float)((ValuePair)vector7.get(n48)).getKey()).floatValue();
                                    nArray[n48] = (Integer)((ValuePair)vector7.get(n48)).getValue();
                                }
                                if (this.m_selected_curve.equals(CurveType.VibratoDepth)) {
                                    vsqID.VibratoHandle.setDepthBP(new VibratoBPList((float[])object8, nArray));
                                } else {
                                    vsqID.VibratoHandle.setRateBP(new VibratoBPList((float[])object8, nArray));
                                }
                                vector.add(vsqEvent.InternalID);
                                vector6.add(vsqID);
                            }
                            if (vector.size() > 0) {
                                object7 = new CadenciiCommand(VsqCommand.generateCommandEventChangeIDContaintsRange(n, PortUtil.convertIntArray(vector.toArray(new Integer[0])), vector6.toArray(new VsqID[0])));
                                this.executeCommand((CadenciiCommand)object7, true);
                            }
                        } else if (!this.m_selected_curve.equals(CurveType.Env)) {
                            int n67;
                            int n68;
                            int n69;
                            int n70 = n;
                            int n71 = AppManager.editorConfig.getControlCurveResolutionValue();
                            int n72 = (int)((float)n71 * AppManager.scaleX);
                            if (n72 <= 0) {
                                n72 = 1;
                            }
                            int n73 = this.m_mouse_trace.firstKey();
                            int n74 = this.m_mouse_trace.lastKey();
                            int n75 = AppManager.clockFromXCoord(n73 - n30);
                            int n76 = AppManager.clockFromXCoord(n74 - n30);
                            int n77 = n73;
                            VsqBPList vsqBPList = ((VsqTrack)vsqFileEx.Track.get(n70)).getCurve(this.m_selected_curve.getName());
                            long l = vsqBPList.getMaxID();
                            Vector<Long> vector = new Vector<Long>();
                            int n78 = vsqBPList.size();
                            for (int i = 0; i < n78; ++i) {
                                n69 = vsqBPList.getKeyClock(i);
                                if (n75 <= n69 && n69 <= n76) {
                                    vector.add(vsqBPList.getElementB((int)i).id);
                                    continue;
                                }
                                if (n76 < n69) break;
                            }
                            TreeMap<Integer, VsqBPPair> treeMap = new TreeMap<Integer, VsqBPPair>();
                            n69 = Integer.MIN_VALUE;
                            int n79 = 0;
                            block16: for (n68 = n73; n68 <= n74; n68 += n72) {
                                int n80;
                                if (this.m_mouse_trace.containsKey(n68)) {
                                    n67 = AppManager.clockFromXCoord(n68 - n30);
                                    n80 = this.valueFromYCoord(this.m_mouse_trace.get(n68));
                                    if (n80 < n3) {
                                        n80 = n3;
                                    } else if (n2 < n80) {
                                        n80 = n2;
                                    }
                                    if (n80 == n69) continue;
                                    treeMap.put(n67, new VsqBPPair(n80, l + (long)(++n79)));
                                    n69 = n80;
                                    continue;
                                }
                                n67 = -1;
                                n80 = 0;
                                int n81 = 0;
                                for (int n82 : this.m_mouse_trace.keySet()) {
                                    int n83 = this.m_mouse_trace.get(n82);
                                    if (++n67 == 0) {
                                        n80 = n82;
                                        n81 = n83;
                                        continue;
                                    }
                                    int n84 = n80;
                                    int n85 = n82;
                                    int n86 = n81;
                                    int n87 = n83;
                                    if (n84 <= n68 && n68 < n85) {
                                        float f = (float)(this.m_mouse_trace.get(n85) - this.m_mouse_trace.get(n84)) / (float)(n85 - n84);
                                        int n88 = (int)((float)this.m_mouse_trace.get(n84).intValue() + f * (float)(n68 - n84));
                                        int n89 = AppManager.clockFromXCoord(n68 - n30);
                                        int n90 = this.valueFromYCoord(n88, n2, n3);
                                        if (n90 < n3) {
                                            n90 = n3;
                                        } else if (n2 < n90) {
                                            n90 = n2;
                                        }
                                        if (n90 == n69) continue block16;
                                        treeMap.put(n89, new VsqBPPair(n83, l + (long)(++n79)));
                                        n69 = n83;
                                        continue block16;
                                    }
                                    n80 = n82;
                                    n81 = n83;
                                }
                            }
                            if ((n74 - n73) % n72 != 0) {
                                n68 = AppManager.clockFromXCoord(n74 - n30);
                                n67 = this.valueFromYCoord(this.m_mouse_trace.get(n74));
                                if (n67 < n3) {
                                    n67 = n3;
                                } else if (n2 < n67) {
                                    n67 = n2;
                                }
                                treeMap.put(n68, new VsqBPPair(n67, l + (long)(++n79)));
                            }
                            n68 = vsqBPList.getValue(n76);
                            if (treeMap.containsKey(n76)) {
                                VsqBPPair vsqBPPair = (VsqBPPair)treeMap.get(n76);
                                vsqBPPair.value = n68;
                                treeMap.put(n76, vsqBPPair);
                            } else {
                                treeMap.put(n76, new VsqBPPair(n68, l + (long)(++n79)));
                            }
                            CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandTrackCurveEdit2(n70, this.m_selected_curve.getName(), vector, treeMap));
                            this.executeCommand(cadenciiCommand, true);
                        }
                    }
                    this.m_mouse_trace = null;
                } else if (!AppManager.isCurveMode() && AppManager.getSelectedTool() == EditTool.LINE) {
                    int n91 = this.m_line_start.x;
                    int n92 = this.m_line_start.y;
                    int n93 = AppManager.clockFromXCoord(bMouseEventArgs.X);
                    int n94 = this.valueFromYCoord(bMouseEventArgs.Y);
                    if (n94 < n3) {
                        n94 = n3;
                    } else if (n2 < n94) {
                        n94 = n2;
                    }
                    if (n93 < n91) {
                        int n95 = n91;
                        n91 = n93;
                        n93 = n95;
                        n95 = n92;
                        n92 = n94;
                        n94 = n95;
                    }
                    if (n93 != n91) {
                        VsqBPList vsqBPList;
                        float f = (float)(n94 - n92) / (float)(n93 - n91);
                        float f8 = (float)n92 - f * (float)n91;
                        if (this.m_selected_curve.equals(CurveType.VEL) || this.m_selected_curve.equals(CurveType.Accent) || this.m_selected_curve.equals(CurveType.Decay)) {
                            Vector<ValuePair<Integer, Integer>> vector = new Vector<ValuePair<Integer, Integer>>();
                            Object object9 = vsqTrack.getNoteEventIterator();
                            while (object9.hasNext()) {
                                VsqEvent vsqEvent = object9.next();
                                if (n91 > vsqEvent.Clock || vsqEvent.Clock >= n93) continue;
                                int n96 = (int)(f * (float)vsqEvent.Clock + f8);
                                vector.add(new ValuePair<Integer, Integer>(vsqEvent.InternalID, n96));
                            }
                            object9 = null;
                            if (vector.size() > 0) {
                                if (this.m_selected_curve.equals(CurveType.VEL)) {
                                    object9 = new CadenciiCommand(VsqCommand.generateCommandEventChangeVelocity(n, vector));
                                } else if (this.m_selected_curve.equals(CurveType.Accent)) {
                                    object9 = new CadenciiCommand(VsqCommand.generateCommandEventChangeAccent(n, vector));
                                } else if (this.m_selected_curve.equals(CurveType.Decay)) {
                                    object9 = new CadenciiCommand(VsqCommand.generateCommandEventChangeDecay(n, vector));
                                }
                            }
                            if (object9 != null) {
                                this.executeCommand((CadenciiCommand)object9, true);
                            }
                        } else if (this.m_selected_curve.equals(CurveType.VibratoDepth) || this.m_selected_curve.equals(CurveType.VibratoRate)) {
                            int n97 = AppManager.startToDrawX;
                            int n98 = AppManager.editorConfig.getControlCurveResolutionValue();
                            int n99 = n91;
                            int n100 = n93;
                            Vector<Integer> vector = new Vector<Integer>();
                            Vector<VsqID> vector8 = new Vector<VsqID>();
                            Object object10 = vsqTrack.getNoteEventIterator();
                            while (object10.hasNext()) {
                                VsqEvent vsqEvent = object10.next();
                                int n101 = vsqEvent.Clock + vsqEvent.ID.VibratoDelay;
                                int n102 = vsqEvent.ID.getLength() - vsqEvent.ID.VibratoDelay;
                                int n103 = n101 + n102;
                                int n104 = Math.max(n101, n99);
                                int n105 = Math.min(n103, n100);
                                float f9 = (float)(n104 - n101) / (float)n102;
                                float f10 = (float)(n105 - n101) / (float)n102;
                                if (n104 >= n105) continue;
                                Vector<ValuePair<Float, Integer>> vector9 = new Vector<ValuePair<Float, Integer>>();
                                for (int i = n104; i < n105; i += n98) {
                                    float f11 = (float)(i - n101) / (float)n102;
                                    if (!(0.0f <= f11) || !(f11 <= 1.0f)) continue;
                                    int n106 = (int)(f * (float)i + f8);
                                    vector9.add(new ValuePair<Float, Integer>(Float.valueOf(f11), n106));
                                }
                                vector9.add(new ValuePair<Float, Integer>(Float.valueOf((float)(n105 - n101) / (float)n102), (int)(f * (float)n105 + f8)));
                                if (vsqEvent.ID.VibratoHandle == null) continue;
                                VibratoBPList vibratoBPList = null;
                                vibratoBPList = this.m_selected_curve.equals(CurveType.VibratoRate) ? vsqEvent.ID.VibratoHandle.getRateBP() : vsqEvent.ID.VibratoHandle.getDepthBP();
                                if (vibratoBPList.getCount() > 0) {
                                    for (int i = 0; i < vibratoBPList.getCount(); ++i) {
                                        if (!(vibratoBPList.getElement((int)i).X < f9) && !(f10 < vibratoBPList.getElement((int)i).X)) continue;
                                        vector9.add(new ValuePair<Float, Integer>(Float.valueOf(vibratoBPList.getElement((int)i).X), vibratoBPList.getElement((int)i).Y));
                                    }
                                }
                                Collections.sort(vector9);
                                VsqID vsqID = (VsqID)vsqEvent.ID.clone();
                                float[] fArray = new float[vector9.size()];
                                int[] nArray = new int[vector9.size()];
                                for (int i = 0; i < vector9.size(); ++i) {
                                    fArray[i] = ((Float)((ValuePair)vector9.get(i)).getKey()).floatValue();
                                    nArray[i] = (Integer)((ValuePair)vector9.get(i)).getValue();
                                }
                                if (this.m_selected_curve.equals(CurveType.VibratoDepth)) {
                                    vsqID.VibratoHandle.setDepthBP(new VibratoBPList(fArray, nArray));
                                } else {
                                    vsqID.VibratoHandle.setRateBP(new VibratoBPList(fArray, nArray));
                                }
                                vector.add(vsqEvent.InternalID);
                                vector8.add(vsqID);
                            }
                            if (vector.size() > 0) {
                                object10 = new CadenciiCommand(VsqCommand.generateCommandEventChangeIDContaintsRange(n, PortUtil.convertIntArray(vector.toArray(new Integer[0])), vector8.toArray(new VsqID[0])));
                                this.executeCommand((CadenciiCommand)object10, true);
                            }
                        } else if (!this.m_selected_curve.equals(CurveType.Env) && (vsqBPList = vsqTrack.getCurve(this.m_selected_curve.getName())) != null) {
                            int n107;
                            int n108 = AppManager.editorConfig.getControlCurveResolutionValue();
                            Vector<Long> vector = new Vector<Long>();
                            TreeMap<Integer, VsqBPPair> treeMap = new TreeMap<Integer, VsqBPPair>();
                            int n109 = vsqBPList.size();
                            for (n107 = 0; n107 < n109; ++n107) {
                                int n110 = vsqBPList.getKeyClock(n107);
                                if (n91 <= n110 && n110 <= n93) {
                                    vector.add(vsqBPList.getElementB((int)n107).id);
                                    continue;
                                }
                                if (n93 < n110) break;
                            }
                            n107 = 0;
                            long l = vsqBPList.getMaxID();
                            int n111 = Integer.MIN_VALUE;
                            for (int i = n91; i <= n93; i += n108) {
                                int n112 = (int)(f * (float)i + f8);
                                if (n111 == n112) continue;
                                treeMap.put(i, new VsqBPPair(n112, l + (long)(++n107)));
                                n111 = n112;
                            }
                            CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandTrackCurveEdit2(n, this.m_selected_curve.getName(), vector, treeMap));
                            this.executeCommand(cadenciiCommand, true);
                        }
                    }
                }
            }
            this.m_mouse_downed = false;
        } else if (this.m_mouse_down_mode == MouseDownMode.SINGER_LIST) {
            int n113;
            if (this.m_mouse_moved && (n113 = AppManager.getSelectedEventCount()) > 0) {
                int[] nArray = new int[n113];
                int[] nArray2 = new int[n113];
                VsqID[] vsqIDArray = new VsqID[n113];
                int n114 = -1;
                boolean bl = true;
                boolean bl3 = false;
                int n115 = vsqFileEx.getPreMeasureClocks();
                Iterator<SelectedEventEntry> iterator = AppManager.getSelectedEventIterator();
                while (iterator.hasNext()) {
                    SelectedEventEntry selectedEventEntry = iterator.next();
                    nArray[++n114] = selectedEventEntry.original.InternalID;
                    nArray2[n114] = selectedEventEntry.editing.Clock;
                    vsqIDArray[n114] = selectedEventEntry.original.ID;
                    if (nArray2[n114] < n115) {
                        bl = false;
                    }
                    if (selectedEventEntry.original.Clock != 0) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    if (!bl) {
                        int n116;
                        int n117 = nArray2[0];
                        for (n116 = 1; n116 < n113; ++n116) {
                            n117 = Math.min(n117, nArray2[n116]);
                        }
                        n116 = n115 - n117;
                        int n118 = 0;
                        while (n118 < n113) {
                            int n119 = n118++;
                            nArray2[n119] = nArray2[n119] + n116;
                        }
                    }
                    boolean bl4 = false;
                    for (int i = 0; i < nArray.length; ++i) {
                        Iterator<SelectedEventEntry> iterator2 = AppManager.getSelectedEventIterator();
                        while (iterator2.hasNext()) {
                            SelectedEventEntry selectedEventEntry = iterator2.next();
                            if (selectedEventEntry.original.InternalID != nArray[i] || selectedEventEntry.original.Clock == nArray2[i]) continue;
                            bl4 = true;
                            break;
                        }
                        if (bl4) break;
                    }
                    if (bl4) {
                        CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandEventChangeClockAndIDContaintsRange(n, nArray, nArray2, vsqIDArray));
                        this.executeCommand(cadenciiCommand, true);
                    }
                }
            }
        } else if (this.m_mouse_down_mode == MouseDownMode.VEL_EDIT) {
            int n120 = this.m_veledit_selected.size();
            int[] nArray = new int[n120];
            VsqID[] vsqIDArray = new VsqID[n120];
            int n121 = -1;
            Object object11 = this.m_veledit_selected.keySet().iterator();
            while (object11.hasNext()) {
                int n122 = object11.next();
                nArray[++n121] = n122;
                vsqIDArray[n121] = (VsqID)this.m_veledit_selected.get((Object)Integer.valueOf((int)n122)).editing.ID.clone();
            }
            object11 = new CadenciiCommand(VsqCommand.generateCommandEventChangeIDContaintsRange(n, nArray, vsqIDArray));
            this.executeCommand((CadenciiCommand)object11, true);
            if (this.m_veledit_selected.size() == 1) {
                AppManager.clearSelectedEvent();
                AppManager.addSelectedEvent(this.m_veledit_last_selectedid);
            }
        } else if (this.m_mouse_down_mode == MouseDownMode.ENVELOPE_MOVE) {
            this.m_mouse_down_mode = MouseDownMode.NONE;
            if (this.m_mouse_moved) {
                VsqTrack vsqTrack2 = vsqTrack;
                VsqEvent vsqEvent = (VsqEvent)vsqTrack2.findEventFromID(this.m_envelope_move_id).clone();
                int n123 = vsqTrack2.getEventCount();
                for (int i = 0; i < n123; ++i) {
                    VsqEvent vsqEvent2 = vsqTrack2.getEvent(i);
                    if (vsqEvent2.ID.type != VsqIDType.Anote || vsqEvent2.InternalID != this.m_envelope_move_id) continue;
                    vsqEvent2.UstEvent.Envelope = this.m_envelope_original;
                    vsqTrack2.setEvent(i, vsqEvent2);
                    break;
                }
                CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandEventReplace(n, vsqEvent));
                this.executeCommand(cadenciiCommand, true);
            }
        } else if (this.m_mouse_down_mode == MouseDownMode.PRE_UTTERANCE_MOVE) {
            this.m_mouse_down_mode = MouseDownMode.NONE;
            if (this.m_mouse_moved) {
                VsqTrack vsqTrack3 = vsqTrack;
                VsqEvent vsqEvent = (VsqEvent)vsqTrack3.findEventFromID(this.m_preutterance_moving_id).clone();
                int n124 = vsqTrack3.getEventCount();
                for (int i = 0; i < n124; ++i) {
                    VsqEvent vsqEvent3 = vsqTrack3.getEvent(i);
                    if (vsqEvent3.ID.type != VsqIDType.Anote || vsqEvent3.InternalID != this.m_preutterance_moving_id) continue;
                    vsqTrack3.setEvent(i, this.m_pre_ovl_original);
                    break;
                }
                CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandEventReplace(n, vsqEvent));
                this.executeCommand(cadenciiCommand, true);
            }
        } else if (this.m_mouse_down_mode == MouseDownMode.OVERLAP_MOVE) {
            this.m_mouse_down_mode = MouseDownMode.NONE;
            if (this.m_mouse_moved) {
                VsqTrack vsqTrack4 = vsqTrack;
                VsqEvent vsqEvent = (VsqEvent)vsqTrack4.findEventFromID(this.m_overlap_moving_id).clone();
                int n125 = vsqTrack4.getEventCount();
                for (int i = 0; i < n125; ++i) {
                    VsqEvent vsqEvent4 = vsqTrack4.getEvent(i);
                    if (vsqEvent4.ID.type != VsqIDType.Anote || vsqEvent4.InternalID != this.m_overlap_moving_id) continue;
                    vsqTrack4.setEvent(i, this.m_pre_ovl_original);
                    break;
                }
                CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandEventReplace(n, vsqEvent));
                this.executeCommand(cadenciiCommand, true);
            }
        } else if (this.m_mouse_down_mode == MouseDownMode.POINT_MOVE) {
            if (this.m_mouse_moved) {
                Point point = this.pointToClient(PortUtil.getMousePosition());
                Point point4 = new Point(point.x, point.y);
                int n126 = point4.x + AppManager.startToDrawX - this.m_mouse_down_location.x;
                int n127 = point4.y - this.m_mouse_down_location.y;
                String string = this.m_selected_curve.getName();
                VsqTrack vsqTrack5 = (VsqTrack)vsqTrack.clone();
                VsqBPList vsqBPList = vsqTrack5.getCurve(string);
                VsqBPList vsqBPList2 = (VsqBPList)vsqBPList.clone();
                int n128 = vsqBPList.getMinimum();
                int n129 = vsqBPList.getMaximum();
                int n130 = vsqBPList.size();
                for (int i = 0; i < n130; ++i) {
                    int n131 = vsqBPList.getKeyClock(i);
                    VsqBPPair vsqBPPair = vsqBPList.getElementB(i);
                    if (!AppManager.isSelectedPointContains(vsqBPPair.id)) continue;
                    int n132 = AppManager.xCoordFromClocks(n131) + n126 + 1;
                    int n133 = this.yCoordFromValue(vsqBPPair.value) + n127 - 1;
                    int n134 = AppManager.clockFromXCoord(n132);
                    int n135 = this.valueFromYCoord(n133);
                    if (n135 < n128) {
                        n135 = n128;
                    }
                    if (n129 < n135) {
                        n135 = n129;
                    }
                    vsqBPList2.move(n131, n134, n135);
                }
                vsqTrack5.setCurve(string, vsqBPList2);
                BezierCurves bezierCurves = vsqFileEx.AttachedCurves.get(n - 1);
                CadenciiCommand cadenciiCommand = VsqFileEx.generateCommandTrackReplace(n, vsqTrack5, bezierCurves);
                this.executeCommand(cadenciiCommand, true);
            }
            this.m_moving_points.clear();
        }
        this.m_mouse_down_mode = MouseDownMode.NONE;
        this.invalidate();
    }

    private void TrackSelector_MouseHover(Object object, BEventArgs bEventArgs) {
        if (this.m_selected_curve.equals(CurveType.Env)) {
            return;
        }
        if (this.m_mouse_downed && !this.m_pencil_moved && AppManager.getSelectedTool() == EditTool.PENCIL && !this.m_selected_curve.equals(CurveType.VEL)) {
            Point point = this.pointToClient(PortUtil.getMousePosition());
            Point point2 = new Point(point.x, point.y);
            int n = AppManager.clockFromXCoord(point2.x);
            int n2 = this.valueFromYCoord(point2.y);
            int n3 = this.m_selected_curve.getMinimum();
            int n4 = this.m_selected_curve.getMaximum();
            if (n2 < n3) {
                n2 = n3;
            } else if (n4 < n2) {
                n2 = n4;
            }
            if (this.m_selected_curve.equals(CurveType.VibratoRate) || this.m_selected_curve.equals(CurveType.VibratoDepth)) {
                int n5;
                Cloneable cloneable;
                float f = -1.0f;
                VsqID vsqID = null;
                int n6 = -1;
                Object object2 = ((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected())).getNoteEventIterator();
                while (object2.hasNext()) {
                    cloneable = object2.next();
                    if (((VsqEvent)cloneable).ID.VibratoHandle == null) continue;
                    n5 = ((VsqEvent)cloneable).Clock + ((VsqEvent)cloneable).ID.VibratoDelay;
                    int n7 = ((VsqEvent)cloneable).Clock + ((VsqEvent)cloneable).ID.getLength();
                    if (n5 > n || n >= n7) continue;
                    f = (float)(n - n5) / (float)(n7 - n5);
                    vsqID = (VsqID)((VsqEvent)cloneable).ID.clone();
                    n6 = ((VsqEvent)cloneable).InternalID;
                    break;
                }
                if (0.0f <= f && f <= 1.0f) {
                    if (this.m_selected_curve.equals(CurveType.VibratoRate)) {
                        if (f == 0.0f) {
                            vsqID.VibratoHandle.setStartRate(n2);
                        } else if (vsqID.VibratoHandle.getRateBP().getCount() <= 0) {
                            vsqID.VibratoHandle.setRateBP(new VibratoBPList(new float[]{f}, new int[]{n2}));
                        } else {
                            object2 = new Vector();
                            cloneable = new Vector();
                            n5 = 1;
                            VibratoBPList vibratoBPList = vsqID.VibratoHandle.getRateBP();
                            int n8 = vibratoBPList.getCount();
                            for (int i = 0; i < n8; ++i) {
                                VibratoBPPair vibratoBPPair = vibratoBPList.getElement(i);
                                if (vibratoBPPair.X < f) {
                                    ((Vector)object2).add(Float.valueOf(vibratoBPPair.X));
                                    ((Vector)cloneable).add(vibratoBPPair.Y);
                                    continue;
                                }
                                if (vibratoBPPair.X == f) {
                                    ((Vector)object2).add(Float.valueOf(f));
                                    ((Vector)cloneable).add(n2);
                                    n5 = 0;
                                    continue;
                                }
                                if (n5 != 0) {
                                    ((Vector)object2).add(Float.valueOf(f));
                                    ((Vector)cloneable).add(n2);
                                    n5 = 0;
                                }
                                ((Vector)object2).add(Float.valueOf(vibratoBPPair.X));
                                ((Vector)cloneable).add(vibratoBPPair.Y);
                            }
                            if (n5 != 0) {
                                ((Vector)object2).add(Float.valueOf(f));
                                ((Vector)cloneable).add(n2);
                            }
                            vsqID.VibratoHandle.setRateBP(new VibratoBPList(PortUtil.convertFloatArray(((Vector)object2).toArray(new Float[0])), PortUtil.convertIntArray(((Vector)cloneable).toArray(new Integer[0]))));
                        }
                    } else if (f == 0.0f) {
                        vsqID.VibratoHandle.setStartDepth(n2);
                    } else if (vsqID.VibratoHandle.getDepthBP().getCount() <= 0) {
                        vsqID.VibratoHandle.setDepthBP(new VibratoBPList(new float[]{f}, new int[]{n2}));
                    } else {
                        object2 = new Vector();
                        cloneable = new Vector();
                        n5 = 1;
                        VibratoBPList vibratoBPList = vsqID.VibratoHandle.getDepthBP();
                        int n9 = vibratoBPList.getCount();
                        for (int i = 0; i < n9; ++i) {
                            VibratoBPPair vibratoBPPair = vibratoBPList.getElement(i);
                            if (vibratoBPPair.X < f) {
                                ((Vector)object2).add(Float.valueOf(vibratoBPPair.X));
                                ((Vector)cloneable).add(vibratoBPPair.Y);
                                continue;
                            }
                            if (vibratoBPPair.X == f) {
                                ((Vector)object2).add(Float.valueOf(f));
                                ((Vector)cloneable).add(n2);
                                n5 = 0;
                                continue;
                            }
                            if (n5 != 0) {
                                ((Vector)object2).add(Float.valueOf(f));
                                ((Vector)cloneable).add(n2);
                                n5 = 0;
                            }
                            ((Vector)object2).add(Float.valueOf(vibratoBPPair.X));
                            ((Vector)cloneable).add(vibratoBPPair.Y);
                        }
                        if (n5 != 0) {
                            ((Vector)object2).add(Float.valueOf(f));
                            ((Vector)cloneable).add(n2);
                        }
                        vsqID.VibratoHandle.setDepthBP(new VibratoBPList(PortUtil.convertFloatArray(((Vector)object2).toArray(new Float[0])), PortUtil.convertIntArray(((Vector)cloneable).toArray(new Integer[0]))));
                    }
                    object2 = new CadenciiCommand(VsqCommand.generateCommandEventChangeIDContaints(AppManager.getSelected(), n6, vsqID));
                    this.executeCommand((CadenciiCommand)object2, true);
                }
            } else {
                VsqBPList vsqBPList = ((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected())).getCurve(this.m_selected_curve.getName());
                if (vsqBPList != null) {
                    Vector<Long> vector = new Vector<Long>();
                    TreeMap<Integer, VsqBPPair> treeMap = new TreeMap<Integer, VsqBPPair>();
                    long l = vsqBPList.getMaxID();
                    if (vsqBPList.isContainsKey(n)) {
                        int n10 = vsqBPList.size();
                        for (int i = 0; i < n10; ++i) {
                            int n11 = vsqBPList.getKeyClock(i);
                            if (n11 != n) continue;
                            vector.add(vsqBPList.getElementB((int)i).id);
                            break;
                        }
                    }
                    treeMap.put(n, new VsqBPPair(n2, l + 1L));
                    CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandTrackCurveEdit2(AppManager.getSelected(), this.m_selected_curve.getName(), vector, treeMap));
                    this.executeCommand(cadenciiCommand, true);
                }
            }
        } else if (this.m_mouse_down_mode == MouseDownMode.VEL_WAIT_HOVER) {
            this.m_mouse_down_mode = MouseDownMode.VEL_EDIT;
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void TrackSelector_MouseDoubleClick(Object object, BMouseEventArgs bMouseEventArgs) {
        if (this.m_mouse_hover_thread != null && this.m_mouse_hover_thread.isAlive()) {
            this.m_mouse_hover_thread.stop();
        }
        if (0 <= bMouseEventArgs.Y && bMouseEventArgs.Y <= this.getHeight() - 38) {
            int n;
            int n2;
            Object object2;
            BezierChain bezierChain;
            int n3;
            if (AppManager.keyWidth > bMouseEventArgs.X || bMouseEventArgs.X > this.getWidth() || this.m_selected_curve.equals(CurveType.VEL) || this.m_selected_curve.equals(CurveType.Accent) || this.m_selected_curve.equals(CurveType.Decay) || this.m_selected_curve.equals(CurveType.Env)) return;
            int n4 = AppManager.getSelected();
            int n5 = AppManager.clockFromXCoord(bMouseEventArgs.X);
            Vector<BezierChain> vector = AppManager.getVsqFile().AttachedCurves.get(n4 - 1).get(this.m_selected_curve);
            BezierChain bezierChain2 = null;
            BezierPoint bezierPoint = null;
            boolean bl = false;
            int n6 = vector.size();
            for (n3 = 0; n3 < n6; ++n3) {
                bezierChain = vector.get(n3);
                for (BezierPoint bezierPoint2 : bezierChain.points) {
                    Point point = this.getScreenCoord(bezierPoint2.getBase());
                    object2 = new Rectangle(point.x - 3, point.y - 3, 7, 7);
                    if (TrackSelector.isInRect(bMouseEventArgs.X, bMouseEventArgs.Y, (Rectangle)object2)) {
                        bl = true;
                        bezierPoint = (BezierPoint)bezierPoint2.clone();
                        bezierChain2 = (BezierChain)bezierChain.clone();
                        break;
                    }
                    if (bezierPoint2.getControlLeftType() != BezierControlType.None) {
                        Point point2 = this.getScreenCoord(bezierPoint2.getControlLeft());
                        object2 = new Rectangle(point2.x - 3, point2.y - 3, 7, 7);
                        if (TrackSelector.isInRect(bMouseEventArgs.X, bMouseEventArgs.Y, (Rectangle)object2)) {
                            bl = true;
                            bezierPoint = (BezierPoint)bezierPoint2.clone();
                            bezierChain2 = (BezierChain)bezierChain.clone();
                            break;
                        }
                    }
                    if (bezierPoint2.getControlRightType() == BezierControlType.None) continue;
                    Point point3 = this.getScreenCoord(bezierPoint2.getControlRight());
                    object2 = new Rectangle(point3.x - 3, point3.y - 3, 7, 7);
                    if (!TrackSelector.isInRect(bMouseEventArgs.X, bMouseEventArgs.Y, (Rectangle)object2)) continue;
                    bl = true;
                    bezierPoint = (BezierPoint)bezierPoint2.clone();
                    bezierChain2 = (BezierChain)bezierChain.clone();
                    break;
                }
                if (bl) break;
            }
            if (bl) {
                n3 = bezierChain2.id;
                bezierChain = (BezierChain)bezierChain2.clone();
                Object object3 = null;
                try {
                    object3 = new FormBezierPointEdit(this, this.m_selected_curve, n3, bezierPoint.getID());
                    this.EditingChainID = n3;
                    this.EditingPointID = bezierPoint.getID();
                    ((Dialog)object3).setModal(true);
                    ((Dialog)object3).setVisible(true);
                    BDialogResult bDialogResult = ((BDialog)object3).getDialogResult();
                    this.EditingChainID = -1;
                    this.EditingPointID = -1;
                    BezierChain bezierChain3 = AppManager.getVsqFile().AttachedCurves.get(AppManager.getSelected() - 1).getBezierChain(this.m_selected_curve, n3);
                    object2 = VsqFileEx.generateCommandReplaceBezierChain(n4, this.m_selected_curve, n3, bezierChain, AppManager.editorConfig.getControlCurveResolutionValue());
                    this.executeCommand((CadenciiCommand)object2, false);
                    if (bDialogResult != BDialogResult.OK || !BezierChain.isBezierImplicit(bezierChain2)) return;
                    CadenciiCommand cadenciiCommand = VsqFileEx.generateCommandReplaceBezierChain(n4, this.m_selected_curve, n3, bezierChain3, AppManager.editorConfig.getControlCurveResolutionValue());
                    this.executeCommand(cadenciiCommand, true);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
                finally {
                    if (object3 != null) {
                        try {
                            ((BDialog)object3).close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            VsqBPList vsqBPList = ((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected())).getCurve(this.m_selected_curve.getName());
            boolean bl2 = false;
            long l = -1L;
            boolean bl3 = false;
            if (vsqBPList != null) {
                int n7;
                int n8;
                int n9 = vsqBPList.size();
                for (n2 = 0; n2 < n9 && bMouseEventArgs.X >= (n8 = AppManager.xCoordFromClocks(n7 = vsqBPList.getKeyClock(n2))) - 3; ++n2) {
                    if (n8 - 3 > bMouseEventArgs.X || bMouseEventArgs.X > n8 + 3) continue;
                    VsqBPPair vsqBPPair = vsqBPList.getElementB(n2);
                    int n10 = this.yCoordFromValue(vsqBPPair.value);
                    if (n10 - 3 > bMouseEventArgs.Y || bMouseEventArgs.Y > n10 + 3) continue;
                    bl2 = true;
                    l = vsqBPPair.id;
                    n = n7;
                    break;
                }
            }
            if (!bl2) return;
            AppManager.clearSelectedPoint();
            AppManager.addSelectedPoint(this.m_selected_curve, l);
            FormCurvePointEdit formCurvePointEdit = new FormCurvePointEdit(l, this.m_selected_curve);
            n2 = AppManager.xCoordFromClocks(n);
            Point point = this.pointToScreen(new Point(n2, 0));
            this.invalidate();
            formCurvePointEdit.setLocation(new Point(point.x - formCurvePointEdit.getWidth() / 2, point.y - formCurvePointEdit.getHeight()));
            formCurvePointEdit.setModal(true);
            formCurvePointEdit.setVisible(true);
            return;
        }
        if (this.getHeight() - 38 > bMouseEventArgs.Y || bMouseEventArgs.Y > this.getHeight() - 19 || AppManager.getSelectedTool() == EditTool.ERASER) return;
        VsqEvent vsqEvent = this.findItemAt(bMouseEventArgs.X, bMouseEventArgs.Y);
        RendererKind rendererKind = VsqFileEx.getTrackRendererKind((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected()));
        if (vsqEvent != null) {
            if (vsqEvent.ID.type != VsqIDType.Singer) {
                return;
            }
            if (!this.m_cmenu_singer_prepared.equals((Object)rendererKind)) {
                this.prepareSingerMenu(rendererKind);
            }
            TagForCMenuSinger tagForCMenuSinger = new TagForCMenuSinger();
            tagForCMenuSinger.SingerChangeExists = true;
            tagForCMenuSinger.InternalID = vsqEvent.InternalID;
            this.cmenuSinger.setTag(tagForCMenuSinger);
            MenuElement[] menuElementArray = this.cmenuSinger.getSubElements();
            for (int i = 0; i < menuElementArray.length; ++i) {
                BMenuItem bMenuItem = (BMenuItem)menuElementArray[i];
                TagForCMenuSingerDropDown tagForCMenuSingerDropDown = (TagForCMenuSingerDropDown)bMenuItem.getTag();
                if (tagForCMenuSingerDropDown.Language == vsqEvent.ID.IconHandle.Language && tagForCMenuSingerDropDown.Program == vsqEvent.ID.IconHandle.Program) {
                    bMenuItem.setSelected(true);
                    continue;
                }
                bMenuItem.setSelected(false);
            }
            this.cmenuSinger.show(this, bMouseEventArgs.X, bMouseEventArgs.Y);
            return;
        } else {
            MenuElement[] menuElementArray;
            if (!this.m_cmenu_singer_prepared.equals((Object)rendererKind)) {
                this.prepareSingerMenu(rendererKind);
            }
            String string = AppManager.editorConfig.DefaultSingerName;
            int n = AppManager.clockFromXCoord(bMouseEventArgs.X);
            int n11 = 0;
            Object object4 = ((VsqTrack)AppManager.getVsqFile().Track.get(AppManager.getSelected())).getSingerEventIterator();
            while (object4.hasNext()) {
                menuElementArray = object4.next();
                if (n11 <= n && n < menuElementArray.Clock) {
                    string = menuElementArray.ID.IconHandle.IDS;
                    break;
                }
                n11 = menuElementArray.Clock;
            }
            object4 = new TagForCMenuSinger();
            ((TagForCMenuSinger)object4).SingerChangeExists = false;
            ((TagForCMenuSinger)object4).Clock = n;
            this.cmenuSinger.setTag(object4);
            menuElementArray = this.cmenuSinger.getSubElements();
            for (int i = 0; i < menuElementArray.length; ++i) {
                BMenuItem bMenuItem = (BMenuItem)menuElementArray[i];
                bMenuItem.setSelected(false);
            }
            this.cmenuSinger.show(this, bMouseEventArgs.X, bMouseEventArgs.Y);
        }
    }

    public void prepareSingerMenu(RendererKind rendererKind) {
        this.cmenuSinger.removeAll();
        Vector<SingerConfig> vector = null;
        if (rendererKind == RendererKind.UTAU || rendererKind == RendererKind.STRAIGHT_UTAU) {
            vector = AppManager.editorConfig.UtauSingers;
        } else if (rendererKind == RendererKind.VOCALOID1_100 || rendererKind == RendererKind.VOCALOID1_101) {
            vector = new Vector<SingerConfig>(Arrays.asList(VocaloSysUtil.getSingerConfigs(SynthesizerType.VOCALOID1)));
        } else if (rendererKind == RendererKind.VOCALOID2) {
            vector = new Vector<SingerConfig>(Arrays.asList(VocaloSysUtil.getSingerConfigs(SynthesizerType.VOCALOID2)));
        } else {
            return;
        }
        int n = 0;
        for (SingerConfig singerConfig : vector) {
            String string = "";
            if (rendererKind == RendererKind.UTAU || rendererKind == RendererKind.STRAIGHT_UTAU) {
                if (singerConfig != null) {
                    string = "Name: " + singerConfig.VOICENAME + "\nDirectory: " + singerConfig.VOICEIDSTR;
                }
            } else if (rendererKind == RendererKind.VOCALOID1_100 || rendererKind == RendererKind.VOCALOID1_101) {
                if (singerConfig != null) {
                    string = "Original: " + VocaloSysUtil.getOriginalSinger(singerConfig.Language, singerConfig.Program, SynthesizerType.VOCALOID1) + "\nHarmonics: " + singerConfig.Harmonics + "\nNoise: " + singerConfig.Breathiness + "\nBrightness: " + singerConfig.Brightness + "\nClearness: " + singerConfig.Clearness + "\nGender Factor: " + singerConfig.GenderFactor + "\nReso1(Freq,BandWidth,Amp): " + singerConfig.Resonance1Frequency + ", " + singerConfig.Resonance1BandWidth + ", " + singerConfig.Resonance1Amplitude + "\nReso2(Freq,BandWidth,Amp): " + singerConfig.Resonance2Frequency + ", " + singerConfig.Resonance2BandWidth + ", " + singerConfig.Resonance2Amplitude + "\nReso3(Freq,BandWidth,Amp): " + singerConfig.Resonance3Frequency + ", " + singerConfig.Resonance3BandWidth + ", " + singerConfig.Resonance3Amplitude + "\nReso4(Freq,BandWidth,Amp): " + singerConfig.Resonance4Frequency + ", " + singerConfig.Resonance4BandWidth + ", " + singerConfig.Resonance4Amplitude;
                }
            } else if (rendererKind == RendererKind.VOCALOID2) {
                if (singerConfig != null) {
                    string = "Original: " + VocaloSysUtil.getOriginalSinger(singerConfig.Language, singerConfig.Program, SynthesizerType.VOCALOID2) + "\nBreathiness: " + singerConfig.Breathiness + "\nBrightness: " + singerConfig.Brightness + "\nClearness: " + singerConfig.Clearness + "\nGender Factor: " + singerConfig.GenderFactor + "\nOpening: " + singerConfig.Opening;
                }
            } else if (rendererKind == RendererKind.AQUES_TONE && singerConfig != null) {
                string = "Name: " + singerConfig.VOICENAME;
            }
            if (singerConfig == null) continue;
            BMenuItem bMenuItem = new BMenuItem();
            bMenuItem.setText(singerConfig.VOICENAME);
            TagForCMenuSingerDropDown tagForCMenuSingerDropDown = new TagForCMenuSingerDropDown();
            tagForCMenuSingerDropDown.ToolTipText = string;
            tagForCMenuSingerDropDown.ToolTipPxWidth = 0;
            tagForCMenuSingerDropDown.Language = singerConfig.Language;
            tagForCMenuSingerDropDown.Program = singerConfig.Program;
            bMenuItem.setTag(tagForCMenuSingerDropDown);
            bMenuItem.clickEvent.add(new BEventHandler(this, "tsmi_Click"));
            if (AppManager.editorConfig.Platform == PlatformEnum.Windows) {
                // empty if block
            }
            this.cmenuSinger.add(bMenuItem);
            ++n;
        }
        this.cmenuSinger.visibleChangedEvent.add(new BEventHandler(this, "cmenuSinger_VisibleChanged"));
        this.m_cmenusinger_tooltip_width = new int[n];
        for (int i = 0; i < n; ++i) {
            this.m_cmenusinger_tooltip_width[i] = 0;
        }
        this.m_cmenu_singer_prepared = rendererKind;
    }

    private void cmenuSinger_VisibleChanged(Object object, BEventArgs bEventArgs) {
    }

    private void tsmi_MouseEnter(Object object, BEventArgs bEventArgs) {
        this.tsmi_MouseHover(object, bEventArgs);
    }

    private void tsmi_MouseHover(Object object, BEventArgs bEventArgs) {
    }

    private void tsmi_Click(Object object, BEventArgs bEventArgs) {
        if (object instanceof BMenuItem) {
            TagForCMenuSinger tagForCMenuSinger = (TagForCMenuSinger)this.cmenuSinger.getTag();
            TagForCMenuSingerDropDown tagForCMenuSingerDropDown = (TagForCMenuSingerDropDown)((BMenuItem)object).getTag();
            int n = tagForCMenuSingerDropDown.Language;
            int n2 = tagForCMenuSingerDropDown.Program;
            VsqID vsqID = null;
            if (this.m_cmenu_singer_prepared == RendererKind.VOCALOID1_100 || this.m_cmenu_singer_prepared == RendererKind.VOCALOID1_101) {
                vsqID = VocaloSysUtil.getSingerID(n, n2, SynthesizerType.VOCALOID1);
            } else if (this.m_cmenu_singer_prepared == RendererKind.VOCALOID2) {
                vsqID = VocaloSysUtil.getSingerID(n, n2, SynthesizerType.VOCALOID2);
            } else if (this.m_cmenu_singer_prepared == RendererKind.UTAU || this.m_cmenu_singer_prepared == RendererKind.STRAIGHT_UTAU) {
                vsqID = AppManager.getSingerIDUtau(n, n2);
            } else if (this.m_cmenu_singer_prepared == RendererKind.AQUES_TONE) {
                vsqID = AppManager.getSingerIDAquesTone(n2);
            }
            if (vsqID != null) {
                int n3 = AppManager.getSelected();
                if (tagForCMenuSinger.SingerChangeExists) {
                    int n4 = tagForCMenuSinger.InternalID;
                    CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandEventChangeIDContaints(n3, n4, vsqID));
                    this.executeCommand(cadenciiCommand, true);
                } else {
                    int n5 = tagForCMenuSinger.Clock;
                    VsqEvent vsqEvent = new VsqEvent(n5, vsqID);
                    CadenciiCommand cadenciiCommand = new CadenciiCommand(VsqCommand.generateCommandEventAdd(n3, vsqEvent));
                    this.executeCommand(cadenciiCommand, true);
                }
            }
        }
    }

    private void TrackSelector_KeyDown(Object object, BKeyEventArgs bKeyEventArgs) {
        if ((bKeyEventArgs.KeyCode & 0x20) == 32) {
            this.m_spacekey_downed = true;
        }
    }

    private void TrackSelector_KeyUp(Object object, BKeyEventArgs bKeyEventArgs) {
        if ((bKeyEventArgs.KeyCode & 0x20) == 32) {
            this.m_spacekey_downed = false;
        }
    }

    private void cmenuCurveCommon_Click(Object object, BEventArgs bEventArgs) {
        BMenuItem bMenuItem;
        if (object instanceof BMenuItem && (bMenuItem = (BMenuItem)object).getTag() instanceof CurveType) {
            CurveType curveType = (CurveType)bMenuItem.getTag();
            this.changeCurve(curveType);
        }
    }

    private void panelZoomButton_MouseDown(Object object, BMouseEventArgs bMouseEventArgs) {
    }

    private void registerEventHandlers() {
    }

    private void setResources() {
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(525, 200));
        this.setBackground(new Color(169, 169, 169));
        this.add((Component)this.getVScroll(), "East");
    }

    private BPopupMenu getCmenuCurve() {
        if (this.cmenuCurve == null) {
            this.cmenuCurve = new BPopupMenu();
            this.cmenuCurve.add(this.getCmenuCurveVelocity());
            this.cmenuCurve.add(this.getCmenuCurveAccent());
            this.cmenuCurve.add(this.getCmenuCurveDecay());
            this.cmenuCurve.add(this.getCmenuCurveSeparator1());
            this.cmenuCurve.add(this.getCmenuCurveDynamics());
            this.cmenuCurve.add(this.getCmenuCurveVibratoRate());
            this.cmenuCurve.add(this.getCmenuCurveVibratoDepth());
            this.cmenuCurve.add(this.getCmenuCurveSeparator2());
            this.cmenuCurve.add(this.getCmenuCurveReso1());
            this.cmenuCurve.add(this.getCmenuCurveReso2());
            this.cmenuCurve.add(this.getCmenuCurveReso3());
            this.cmenuCurve.add(this.getCmenuCurveReso4());
            this.cmenuCurve.add(this.getCmenuCurveSeparator3());
            this.cmenuCurve.add(this.getCmenuCurveHarmonics());
            this.cmenuCurve.add(this.getCmenuCurveBreathiness());
            this.cmenuCurve.add(this.getCmenuCurveBrightness());
            this.cmenuCurve.add(this.getCmenuCurveClearness());
            this.cmenuCurve.add(this.getCmenuCurveOpening());
            this.cmenuCurve.add(this.getCmenuCurveGenderFactor());
            this.cmenuCurve.add(this.getCmenuCurveSeparator4());
            this.cmenuCurve.add(this.getCmenuCurvePortamentoTiming());
            this.cmenuCurve.add(this.getCmenuCurvePitchBend());
            this.cmenuCurve.add(this.getCmenuCurvePitchBendSensitivity());
            this.cmenuCurve.add(this.getCmenuCurveSeparator5());
            this.cmenuCurve.add(this.getCmenuCurveEffect2Depth());
            this.cmenuCurve.add(this.getCmenuCurveEnvelope());
        }
        return this.cmenuCurve;
    }

    private BMenuItem getCmenuCurveVelocity() {
        if (this.cmenuCurveVelocity == null) {
            this.cmenuCurveVelocity = new BMenuItem();
            this.cmenuCurveVelocity.setText("Velocity");
        }
        return this.cmenuCurveVelocity;
    }

    private BMenuItem getCmenuCurveAccent() {
        if (this.cmenuCurveAccent == null) {
            this.cmenuCurveAccent = new BMenuItem();
            this.cmenuCurveAccent.setText("Accent");
        }
        return this.cmenuCurveAccent;
    }

    private BMenuItem getCmenuCurveDecay() {
        if (this.cmenuCurveDecay == null) {
            this.cmenuCurveDecay = new BMenuItem();
            this.cmenuCurveDecay.setText("Decay");
        }
        return this.cmenuCurveDecay;
    }

    private BMenuItem getCmenuCurveDynamics() {
        if (this.cmenuCurveDynamics == null) {
            this.cmenuCurveDynamics = new BMenuItem();
            this.cmenuCurveDynamics.setText("Dynamics");
        }
        return this.cmenuCurveDynamics;
    }

    private BMenuItem getCmenuCurveVibratoRate() {
        if (this.cmenuCurveVibratoRate == null) {
            this.cmenuCurveVibratoRate = new BMenuItem();
            this.cmenuCurveVibratoRate.setText("Vibrato Rate");
        }
        return this.cmenuCurveVibratoRate;
    }

    private BMenuItem getCmenuCurveVibratoDepth() {
        if (this.cmenuCurveVibratoDepth == null) {
            this.cmenuCurveVibratoDepth = new BMenuItem();
            this.cmenuCurveVibratoDepth.setText("Vibrato Depth");
        }
        return this.cmenuCurveVibratoDepth;
    }

    private BMenu getCmenuCurveReso1() {
        if (this.cmenuCurveReso1 == null) {
            this.cmenuCurveReso1 = new BMenu();
            this.cmenuCurveReso1.setText("Resonance 1");
            this.cmenuCurveReso1.add(this.getCmenuCurveReso1Freq());
            this.cmenuCurveReso1.add(this.getCmenuCurveReso1BW());
            this.cmenuCurveReso1.add(this.getCmenuCurveReso1Amp());
        }
        return this.cmenuCurveReso1;
    }

    private BMenuItem getCmenuCurveReso1Freq() {
        if (this.cmenuCurveReso1Freq == null) {
            this.cmenuCurveReso1Freq = new BMenuItem();
            this.cmenuCurveReso1Freq.setText("Frequency");
        }
        return this.cmenuCurveReso1Freq;
    }

    private BMenuItem getCmenuCurveReso1BW() {
        if (this.cmenuCurveReso1BW == null) {
            this.cmenuCurveReso1BW = new BMenuItem();
            this.cmenuCurveReso1BW.setText("Band Width");
        }
        return this.cmenuCurveReso1BW;
    }

    private BMenuItem getCmenuCurveReso1Amp() {
        if (this.cmenuCurveReso1Amp == null) {
            this.cmenuCurveReso1Amp = new BMenuItem();
            this.cmenuCurveReso1Amp.setText("Amplitude");
        }
        return this.cmenuCurveReso1Amp;
    }

    private BMenu getCmenuCurveReso4() {
        if (this.cmenuCurveReso4 == null) {
            this.cmenuCurveReso4 = new BMenu();
            this.cmenuCurveReso4.setText("Resonance 4");
            this.cmenuCurveReso4.add(this.getCmenuCurveReso4Freq());
            this.cmenuCurveReso4.add(this.getCmenuCurveReso4BW());
            this.cmenuCurveReso4.add(this.getCmenuCurveReso4Amp());
        }
        return this.cmenuCurveReso4;
    }

    private BMenuItem getCmenuCurveReso4Freq() {
        if (this.cmenuCurveReso4Freq == null) {
            this.cmenuCurveReso4Freq = new BMenuItem();
            this.cmenuCurveReso4Freq.setText("Frequency");
        }
        return this.cmenuCurveReso4Freq;
    }

    private BMenuItem getCmenuCurveReso4BW() {
        if (this.cmenuCurveReso4BW == null) {
            this.cmenuCurveReso4BW = new BMenuItem();
            this.cmenuCurveReso4BW.setText("Band Width");
        }
        return this.cmenuCurveReso4BW;
    }

    private BMenuItem getCmenuCurveReso4Amp() {
        if (this.cmenuCurveReso4Amp == null) {
            this.cmenuCurveReso4Amp = new BMenuItem();
            this.cmenuCurveReso4Amp.setText("Amplitude");
        }
        return this.cmenuCurveReso4Amp;
    }

    private BMenu getCmenuCurveReso3() {
        if (this.cmenuCurveReso3 == null) {
            this.cmenuCurveReso3 = new BMenu();
            this.cmenuCurveReso3.setText("Resonance 3");
            this.cmenuCurveReso3.add(this.getCmenuCurveReso3Freq());
            this.cmenuCurveReso3.add(this.getCmenuCurveReso3BW());
            this.cmenuCurveReso3.add(this.getCmenuCurveReso3Amp());
        }
        return this.cmenuCurveReso3;
    }

    private BMenuItem getCmenuCurveReso3Freq() {
        if (this.cmenuCurveReso3Freq == null) {
            this.cmenuCurveReso3Freq = new BMenuItem();
            this.cmenuCurveReso3Freq.setText("Frequency");
        }
        return this.cmenuCurveReso3Freq;
    }

    private BMenuItem getCmenuCurveReso3BW() {
        if (this.cmenuCurveReso3BW == null) {
            this.cmenuCurveReso3BW = new BMenuItem();
            this.cmenuCurveReso3BW.setText("Band Width");
        }
        return this.cmenuCurveReso3BW;
    }

    private BMenuItem getCmenuCurveReso3Amp() {
        if (this.cmenuCurveReso3Amp == null) {
            this.cmenuCurveReso3Amp = new BMenuItem();
            this.cmenuCurveReso3Amp.setText("Amplitude");
        }
        return this.cmenuCurveReso3Amp;
    }

    private BMenu getCmenuCurveReso2() {
        if (this.cmenuCurveReso2 == null) {
            this.cmenuCurveReso2 = new BMenu();
            this.cmenuCurveReso2.setText("Resonance 2");
            this.cmenuCurveReso2.add(this.getCmenuCurveReso2Freq());
            this.cmenuCurveReso2.add(this.getCmenuCurveReso2BW());
            this.cmenuCurveReso2.add(this.getCmenuCurveReso2Amp());
        }
        return this.cmenuCurveReso2;
    }

    private BMenuItem getCmenuCurveReso2Freq() {
        if (this.cmenuCurveReso2Freq == null) {
            this.cmenuCurveReso2Freq = new BMenuItem();
            this.cmenuCurveReso2Freq.setText("Frequency");
        }
        return this.cmenuCurveReso2Freq;
    }

    private BMenuItem getCmenuCurveReso2BW() {
        if (this.cmenuCurveReso2BW == null) {
            this.cmenuCurveReso2BW = new BMenuItem();
            this.cmenuCurveReso2BW.setText("Band Width");
        }
        return this.cmenuCurveReso2BW;
    }

    private BMenuItem getCmenuCurveReso2Amp() {
        if (this.cmenuCurveReso2Amp == null) {
            this.cmenuCurveReso2Amp = new BMenuItem();
            this.cmenuCurveReso2Amp.setText("Amplitude");
        }
        return this.cmenuCurveReso2Amp;
    }

    private BMenuItem getCmenuCurveHarmonics() {
        if (this.cmenuCurveHarmonics == null) {
            this.cmenuCurveHarmonics = new BMenuItem();
            this.cmenuCurveHarmonics.setText("Harmonics");
        }
        return this.cmenuCurveHarmonics;
    }

    private BMenuItem getCmenuCurveBreathiness() {
        if (this.cmenuCurveBreathiness == null) {
            this.cmenuCurveBreathiness = new BMenuItem();
            this.cmenuCurveBreathiness.setText("Noise");
        }
        return this.cmenuCurveBreathiness;
    }

    private BMenuItem getCmenuCurveBrightness() {
        if (this.cmenuCurveBrightness == null) {
            this.cmenuCurveBrightness = new BMenuItem();
            this.cmenuCurveBrightness.setText("Brightness");
        }
        return this.cmenuCurveBrightness;
    }

    private BMenuItem getCmenuCurveClearness() {
        if (this.cmenuCurveClearness == null) {
            this.cmenuCurveClearness = new BMenuItem();
            this.cmenuCurveClearness.setText("Clearness");
        }
        return this.cmenuCurveClearness;
    }

    private BMenuItem getCmenuCurveOpening() {
        if (this.cmenuCurveOpening == null) {
            this.cmenuCurveOpening = new BMenuItem();
            this.cmenuCurveOpening.setText("Opening");
        }
        return this.cmenuCurveOpening;
    }

    private BMenuItem getCmenuCurveGenderFactor() {
        if (this.cmenuCurveGenderFactor == null) {
            this.cmenuCurveGenderFactor = new BMenuItem();
            this.cmenuCurveGenderFactor.setText("Gender Factor");
        }
        return this.cmenuCurveGenderFactor;
    }

    private BMenuItem getCmenuCurvePortamentoTiming() {
        if (this.cmenuCurvePortamentoTiming == null) {
            this.cmenuCurvePortamentoTiming = new BMenuItem();
            this.cmenuCurvePortamentoTiming.setText("Portamento Timing");
        }
        return this.cmenuCurvePortamentoTiming;
    }

    private BMenuItem getCmenuCurvePitchBend() {
        if (this.cmenuCurvePitchBend == null) {
            this.cmenuCurvePitchBend = new BMenuItem();
            this.cmenuCurvePitchBend.setText("Pitch Bend");
        }
        return this.cmenuCurvePitchBend;
    }

    private BMenuItem getCmenuCurvePitchBendSensitivity() {
        if (this.cmenuCurvePitchBendSensitivity == null) {
            this.cmenuCurvePitchBendSensitivity = new BMenuItem();
            this.cmenuCurvePitchBendSensitivity.setText("Pitch Bend Sensitivity");
        }
        return this.cmenuCurvePitchBendSensitivity;
    }

    private BMenuItem getCmenuCurveEffect2Depth() {
        if (this.cmenuCurveEffect2Depth == null) {
            this.cmenuCurveEffect2Depth = new BMenuItem();
            this.cmenuCurveEffect2Depth.setText("Effect2 Depth");
        }
        return this.cmenuCurveEffect2Depth;
    }

    private BMenuItem getCmenuCurveEnvelope() {
        if (this.cmenuCurveEnvelope == null) {
            this.cmenuCurveEnvelope = new BMenuItem();
            this.cmenuCurveEnvelope.setText("Envelope");
        }
        return this.cmenuCurveEnvelope;
    }

    private JSeparator getCmenuCurveSeparator1() {
        if (this.cmenuCurveSeparator1 == null) {
            this.cmenuCurveSeparator1 = new JSeparator();
        }
        return this.cmenuCurveSeparator1;
    }

    private JSeparator getCmenuCurveSeparator2() {
        if (this.cmenuCurveSeparator2 == null) {
            this.cmenuCurveSeparator2 = new JSeparator();
        }
        return this.cmenuCurveSeparator2;
    }

    private JSeparator getCmenuCurveSeparator3() {
        if (this.cmenuCurveSeparator3 == null) {
            this.cmenuCurveSeparator3 = new JSeparator();
        }
        return this.cmenuCurveSeparator3;
    }

    private JSeparator getCmenuCurveSeparator4() {
        if (this.cmenuCurveSeparator4 == null) {
            this.cmenuCurveSeparator4 = new JSeparator();
        }
        return this.cmenuCurveSeparator4;
    }

    private JSeparator getCmenuCurveSeparator5() {
        if (this.cmenuCurveSeparator5 == null) {
            this.cmenuCurveSeparator5 = new JSeparator();
        }
        return this.cmenuCurveSeparator5;
    }

    private BPopupMenu getCmenuSinger() {
        if (this.cmenuSinger == null) {
            this.cmenuSinger = new BPopupMenu();
        }
        return this.cmenuSinger;
    }

    private JScrollBar getVScroll() {
        if (this.vScroll == null) {
            this.vScroll = new JScrollBar();
        }
        return this.vScroll;
    }

    private JToolTip getJLabel() {
        if (this.toolTip == null) {
            this.toolTip = new JToolTip();
            this.toolTip.setSize(new Dimension(73, 38));
        }
        return this.toolTip;
    }

    private class TagForCMenuSingerDropDown {
        public int ToolTipPxWidth;
        public String ToolTipText;
        public int Language;
        public int Program;

        private TagForCMenuSingerDropDown() {
        }
    }

    private class TagForCMenuSinger {
        public boolean SingerChangeExists;
        public int Clock;
        public int InternalID;

        private TagForCMenuSinger() {
        }
    }

    private class MouseHoverEventGeneratorProc
    extends Thread {
        private MouseHoverEventGeneratorProc() {
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                return;
            }
            TrackSelector.this.TrackSelector_MouseHover(this, new BEventArgs());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MouseDownMode {
        NONE,
        CURVE_EDIT,
        TRACK_LIST,
        SINGER_LIST,
        VEL_WAIT_HOVER,
        VEL_EDIT,
        BEZIER_MODE,
        BEZIER_SELECT,
        BEZIER_ADD_NEW,
        BEZIER_EDIT,
        ENVELOPE_MOVE,
        PRE_UTTERANCE_MOVE,
        OVERLAP_MOVE,
        POINT_MOVE;

    }
}

