/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.kbinani.BEventArgs;
import org.kbinani.PortUtil;
import org.kbinani.apputil.AuthorListEntry;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.Resources;
import org.kbinani.math;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BKeyEventArgs;
import org.kbinani.windows.forms.BPaintEventArgs;
import org.kbinani.windows.forms.BPictureBox;
import org.kbinani.windows.forms.BTimer;

public class VersionInfo
extends BDialog {
    double m_scroll_started;
    private AuthorListEntry[] m_credit;
    static final float m_speed = 35.0f;
    String m_version;
    boolean m_credit_mode = false;
    float m_last_t = 0.0f;
    float m_last_speed = 0.0f;
    float m_shift = 0.0f;
    int m_button_width_about = 75;
    int m_button_width_credit = 75;
    BufferedImage m_scroll;
    static final int m_height = 380;
    final Color m_background = Color.white;
    private String m_app_name = "";
    private Color m_app_name_color = Color.black;
    private Color m_version_color = new Color(105, 105, 105);
    private boolean m_shadow_enablde = false;
    private BTimer timer;
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private JScrollPane jScrollPane = null;
    private JPanel jPanel1 = null;
    private JPanel jPanel2 = null;
    private JButton btnFlip = null;
    private JButton btnSaveAuthorList = null;
    private JButton btnOK = null;
    private JLabel jLabel1 = null;
    private JTextArea lblVstLogo = null;
    private JTextArea lblStraightAcknowledgement = null;
    private BPictureBox pictVstLogo = null;

    public VersionInfo(String string, String string2) {
        this.initialize();
        this.timer = new BTimer();
        this.m_version = string2;
        this.m_app_name = string;
        this.timer.setDelay(30);
        this.registerEventHandlers();
        this.setResources();
        this.applyLanguage();
        this.m_credit = new AuthorListEntry[0];
        this.btnSaveAuthorList.setVisible(false);
        this.lblVstLogo.setForeground(this.m_version_color);
        this.lblStraightAcknowledgement.setForeground(this.m_version_color);
    }

    public void applyLanguage() {
        String string = PortUtil.formatMessage(VersionInfo._("About {0}"), this.m_app_name);
        String string2 = VersionInfo._("Credit");
        Dimension dimension = Util.measureString(string, this.btnFlip.getFont());
        Dimension dimension2 = Util.measureString(string2, this.btnFlip.getFont());
        this.m_button_width_about = Math.max(75, (int)((double)dimension.width * 1.3));
        this.m_button_width_credit = Math.max(75, (int)((double)dimension2.width * 1.3));
        if (this.m_credit_mode) {
            this.btnFlip.setPreferredSize(new Dimension(this.m_button_width_about, this.btnFlip.getHeight()));
            this.btnFlip.setText(string);
        } else {
            this.btnFlip.setPreferredSize(new Dimension(this.m_button_width_credit, this.btnFlip.getHeight()));
            this.btnFlip.setText(string2);
        }
        this.setTitle(string);
    }

    public void setSaveAuthorListVisible(boolean bl) {
        this.btnSaveAuthorList.setVisible(bl);
    }

    public static String _(String string) {
        return Messaging.getMessage(string);
    }

    public Color getVersionColor() {
        return this.m_version_color;
    }

    public void setVersionColor(Color color) {
        this.m_version_color = color;
        this.lblVstLogo.setForeground(color);
        this.lblStraightAcknowledgement.setForeground(color);
    }

    public Color getAppNameColor() {
        return this.m_app_name_color;
    }

    public void setAppNameColor(Color color) {
        this.m_app_name_color = color;
    }

    public String getAppName() {
        return this.m_app_name;
    }

    public void setAppName(String string) {
        this.m_app_name = string;
    }

    public void setAuthorList(AuthorListEntry[] authorListEntryArray) {
        this.m_credit = authorListEntryArray;
        this.generateAuthorList();
    }

    private void generateAuthorList() {
        int n = 2;
        String string = "Arial";
        int n2 = 10;
        Font font = new Font(string, 0, n2);
        Dimension dimension = Util.measureString("the quick brown fox jumped over the lazy dogs. THE QUICK BROWN FOX JUMPED OVER THE LAZY DOGS. 0123456789", font);
        int n3 = this.getWidth();
        int n4 = dimension.height;
        this.m_scroll = new BufferedImage(n3, (int)(40.0f + (float)(this.m_credit.length * n4) * 1.1f), 4);
        Graphics2D graphics2D = this.m_scroll.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.m_scroll.getWidth(null), this.m_scroll.getHeight(null));
        int n5 = 0;
        int n6 = 0;
        Font font2 = new Font(string, 1, (int)((float)n2 * 1.1f));
        if (this.m_shadow_enablde) {
            graphics2D.setColor(new Color(0, 0, 0, 40));
            PortUtil.drawStringEx(graphics2D, this.m_app_name, font2, new Rectangle(n, n, n3, n4), n5, n6);
        }
        graphics2D.setColor(Color.black);
        PortUtil.drawStringEx(graphics2D, this.m_app_name, font2, new Rectangle(0, 0, n3, n4), n5, n6);
        for (int i = 0; i < this.m_credit.length; ++i) {
            Font font3 = new Font(string, this.m_credit[i].getStyle(), n2);
            if (this.m_shadow_enablde) {
                graphics2D.setColor(new Color(0, 0, 0, 40));
                PortUtil.drawStringEx(graphics2D, this.m_credit[i].getName(), font, new Rectangle(0 + n, 40 + (int)((double)(i * n4) * 1.1) + n, n3, n4), n5, n6);
            }
            graphics2D.setColor(Color.black);
            PortUtil.drawStringEx(graphics2D, this.m_credit[i].getName(), font3, new Rectangle(0, 40 + (int)((double)(i * n4) * 1.1), n3, n4), n5, n6);
        }
    }

    void btnSaveAuthorList_Click(Object object, BEventArgs bEventArgs) {
    }

    private void btnOK_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.OK);
        this.close();
    }

    private void btnFlip_Click(Object object, BEventArgs bEventArgs) {
        boolean bl = this.m_credit_mode = !this.m_credit_mode;
        if (this.m_credit_mode) {
            this.btnFlip.setPreferredSize(new Dimension(this.m_button_width_about, this.btnFlip.getHeight()));
            try {
                this.btnFlip.setText(PortUtil.formatMessage(VersionInfo._("About {0}"), this.m_app_name));
            }
            catch (Exception exception) {
                this.btnFlip.setText("About " + this.m_app_name);
            }
            this.m_scroll_started = PortUtil.getCurrentTime();
            this.m_last_speed = 0.0f;
            this.m_last_t = 0.0f;
            this.m_shift = 0.0f;
            this.pictVstLogo.setVisible(false);
            this.lblVstLogo.setVisible(false);
            this.lblStraightAcknowledgement.setVisible(false);
            this.timer.start();
        } else {
            this.timer.stop();
            this.btnFlip.setPreferredSize(new Dimension(this.m_button_width_credit, this.btnFlip.getHeight()));
            this.btnFlip.setText(VersionInfo._("Credit"));
            this.pictVstLogo.setVisible(true);
            this.lblVstLogo.setVisible(true);
            this.lblStraightAcknowledgement.setVisible(true);
        }
        this.invalidate();
    }

    private void timer_Tick(Object object, BEventArgs bEventArgs) {
        this.invalidate();
    }

    private void VersionInfo_Paint(Object object, BPaintEventArgs bPaintEventArgs) {
        try {
            this.paint(bPaintEventArgs.Graphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.clipRect(0, 0, this.getWidth(), 380);
        graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.m_credit_mode) {
            float f = (float)(PortUtil.getCurrentTime() - this.m_scroll_started) - 3.0f;
            float f2 = (float)((2.0 - math.erfc((double)f * 0.8)) / 2.0) * 35.0f;
            float f3 = f - this.m_last_t;
            this.m_shift += (f2 + this.m_last_speed) * f3 / 2.0f;
            this.m_last_t = f;
            this.m_last_speed = f2;
            float f4 = (float)(this.getWidth() - this.m_scroll.getWidth(null)) * 0.5f;
            if (this.m_scroll != null) {
                graphics2D.drawImage((Image)this.m_scroll, (int)f4, (int)(90.0f - this.m_shift), null);
                if (90.0f - this.m_shift + (float)this.m_scroll.getHeight(null) < 0.0f) {
                    this.m_shift = -570.0f;
                }
            }
            int n = 60;
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), n);
            Rectangle rectangle2 = new Rectangle(0, 380 - n, this.getWidth(), n);
            graphics2D.clipRect(0, 380 - n + 1, this.getWidth(), n - 1);
            graphics2D.setClip(null);
        } else {
            graphics2D.setFont(new Font("Century Gorhic", 1, 24));
            graphics2D.setColor(this.m_app_name_color);
            graphics2D.drawString(this.m_app_name, 20, 60);
            graphics2D.setFont(new Font("Arial", 0, 10));
            graphics2D.drawString("version " + this.m_version, 25, 100);
        }
    }

    private void VersionInfo_KeyDown(Object object, BKeyEventArgs bKeyEventArgs) {
        if ((bKeyEventArgs.getKeyCode() & 0x1B) == 27) {
            this.setDialogResult(BDialogResult.CANCEL);
            this.close();
        }
    }

    private void VersionInfo_FontChanged(Object object, BEventArgs bEventArgs) {
        Util.applyFontRecurse(this, this.getFont());
    }

    private void registerEventHandlers() {
    }

    private void setResources() {
        this.pictVstLogo.setImage(Resources.get_VSTonWht());
    }

    private void initialize() {
        this.setSize(new Dimension(327, 464));
        this.setContentPane(this.getJPanel());
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 12, 0);
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(0, 0, 12, 0);
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridwidth = 3;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.insets = new Insets(0, 0, 12, 0);
            gridBagConstraints4.gridx = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getJPanel2(), gridBagConstraints4);
            this.jPanel.add((Component)this.getBtnFlip(), gridBagConstraints3);
            this.jPanel.add((Component)this.getBtnSaveAuthorList(), gridBagConstraints2);
            this.jPanel.add((Component)this.getBtnOK(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setName("jScrollPane");
        }
        return this.jScrollPane;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(6, 12, 12, 12);
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.insets = new Insets(0, 12, 6, 12);
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridy = 1;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(" ");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 3;
            gridBagConstraints4.gridwidth = 1;
            gridBagConstraints4.anchor = 11;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridy = 2;
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.setName("jPanel1");
            this.jPanel1.setBackground(Color.white);
            this.jPanel1.add((Component)this.jLabel1, gridBagConstraints3);
            this.jPanel1.add((Component)this.getLblVstLogo(), gridBagConstraints2);
            this.jPanel1.add((Component)this.getPictVstLogo(), new GridBagConstraints());
            this.jPanel1.add((Component)this.getLblStraightAcknowledgement(), gridBagConstraints);
        }
        return this.jPanel1;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new CardLayout());
            this.jPanel2.add((Component)this.getJScrollPane(), this.getJScrollPane().getName());
            this.jPanel2.add((Component)this.getJPanel1(), this.getJPanel1().getName());
        }
        return this.jPanel2;
    }

    private JButton getBtnFlip() {
        if (this.btnFlip == null) {
            this.btnFlip = new JButton();
            this.btnFlip.setText("Credit");
        }
        return this.btnFlip;
    }

    private JButton getBtnSaveAuthorList() {
        if (this.btnSaveAuthorList == null) {
            this.btnSaveAuthorList = new JButton();
            this.btnSaveAuthorList.setVisible(false);
        }
        return this.btnSaveAuthorList;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setText("OK");
        }
        return this.btnOK;
    }

    private JTextArea getLblVstLogo() {
        if (this.lblVstLogo == null) {
            this.lblVstLogo = new JTextArea();
            this.lblVstLogo.setText("VST PlugIn Technology by Steinberg Media Technologies GmbH");
            this.lblVstLogo.setLineWrap(true);
        }
        return this.lblVstLogo;
    }

    private JTextArea getLblStraightAcknowledgement() {
        if (this.lblStraightAcknowledgement == null) {
            this.lblStraightAcknowledgement = new JTextArea();
            this.lblStraightAcknowledgement.setText("Components of Cadencii, \"vConnect.exe\" and \"straightVoiceDB.exe\", are powererd by STRAIGHT LIBRARY.");
            this.lblStraightAcknowledgement.setLineWrap(true);
        }
        return this.lblStraightAcknowledgement;
    }

    private BPictureBox getPictVstLogo() {
        if (this.pictVstLogo == null) {
            this.pictVstLogo = new BPictureBox();
            this.pictVstLogo.setLayout(new GridBagLayout());
        }
        return this.pictVstLogo;
    }
}

