/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.media;

import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class BSoundPlayer {
    private static final int BUFLEN = 128000;
    private AudioInputStream m_stream = null;
    private boolean m_stop_required = false;
    private boolean m_playing = false;
    private String m_sound_location = "";

    public BSoundPlayer(String string) {
        this.setSoundLocation(string);
    }

    public BSoundPlayer() {
    }

    public String getSoundLocation() {
        return this.m_sound_location;
    }

    public void setSoundLocation(String string) {
        this.stop();
        this.m_sound_location = string;
        if (this.m_stream != null) {
            try {
                this.m_stream.close();
            }
            catch (Exception exception) {
                System.err.println("BSoundPlayer#setSoundLocation; ex0=" + exception);
            }
        }
        try {
            File file = new File(this.m_sound_location);
            this.m_stream = AudioSystem.getAudioInputStream(file);
        }
        catch (Exception exception) {
            System.err.println("BSoundPlayer#.ctor; ex=" + exception);
        }
    }

    public void play() {
        try {
            Thread thread = new Thread(new PlaySoundRunner());
            thread.start();
            thread.join();
        }
        catch (Exception exception) {
            System.out.println("BSoundPlayer#play; ex=" + exception);
        }
    }

    public void stop() {
        if (this.m_playing) {
            try {
                this.m_stop_required = true;
                while (this.m_playing) {
                    Thread.sleep(0L);
                }
                this.m_stop_required = false;
            }
            catch (Exception exception) {
                System.err.println("BSoundPlayer#stop; ex=" + exception);
            }
        }
    }

    public class PlaySoundRunner
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DataLine dataLine = null;
            BSoundPlayer.this.m_playing = true;
            try {
                AudioFormat audioFormat = BSoundPlayer.this.m_stream.getFormat();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                dataLine = (SourceDataLine)AudioSystem.getLine(info);
                dataLine.open(audioFormat);
                dataLine.start();
                int n = 1;
                byte[] byArray = new byte[128000];
                while (n > 0 && !BSoundPlayer.this.m_stop_required && (n = BSoundPlayer.this.m_stream.read(byArray, 0, byArray.length)) >= 0) {
                    int n2 = dataLine.write(byArray, 0, n);
                }
            }
            catch (Exception exception) {
                System.err.println("BSoundPlayer.PlaySoundRunner#run; ex=" + exception);
            }
            finally {
                if (dataLine != null) {
                    try {
                        dataLine.drain();
                        dataLine.close();
                    }
                    catch (Exception exception) {
                        System.err.println("BSoundPlayer.PlaySoundRunner#run; ex2=" + exception);
                    }
                }
            }
            BSoundPlayer.this.m_playing = false;
        }
    }
}

