/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.media;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaveReader {
    private int m_channel;
    private int m_byte_per_sample;
    private boolean m_opened;
    private RandomAccessFile m_stream;
    private int m_total_samples;
    private double m_amplify_left = 1.0;
    private double m_amplify_right = 1.0;
    private int m_header_offset = 46;
    private Object m_tag = null;
    private double m_offset_seconds = 0.0;
    private int m_sample_per_sec;
    private String m_file = "";

    public WaveReader() {
        this.m_opened = false;
    }

    public WaveReader(String string) throws IOException, FileNotFoundException {
        boolean bl = this.open(string);
        this.m_file = string;
    }

    public String getFilePath() {
        return this.m_file;
    }

    public int getSampleRate() {
        return this.m_sample_per_sec;
    }

    public double getOffsetSeconds() {
        return this.m_offset_seconds;
    }

    public void setOffsetSeconds(double d) {
        this.m_offset_seconds = d;
    }

    public Object getTag() {
        return this.m_tag;
    }

    public void setTag(Object object) {
        this.m_tag = object;
    }

    public double getAmplifyLeft() {
        return this.m_amplify_left;
    }

    public void setAmplifyLeft(double d) {
        this.m_amplify_left = d;
    }

    public double getAmplifyRight() {
        return this.m_amplify_right;
    }

    public void setAmplifyRight(double d) {
        this.m_amplify_right = d;
    }

    public boolean open(String string) throws IOException, FileNotFoundException {
        if (this.m_opened) {
            this.m_stream.close();
        }
        this.m_stream = new RandomAccessFile(string, "r");
        byte[] byArray = new byte[4];
        this.m_stream.read(byArray, 0, 4);
        if (byArray[0] != 82 || byArray[1] != 73 || byArray[2] != 70 || byArray[3] != 70) {
            this.m_stream.close();
            return false;
        }
        this.m_stream.read(byArray, 0, 4);
        this.m_stream.read(byArray, 0, 4);
        if (byArray[0] != 87 || byArray[1] != 65 || byArray[2] != 86 || byArray[3] != 69) {
            this.m_stream.close();
            return false;
        }
        this.m_stream.read(byArray, 0, 4);
        if (byArray[0] != 102 || byArray[1] != 109 || byArray[2] != 116 || byArray[3] != 32) {
            this.m_stream.close();
            return false;
        }
        this.m_stream.read(byArray, 0, 4);
        int n = (int)PortUtil.make_uint32_le(byArray);
        long l = this.m_stream.getFilePointer() + (long)n;
        this.m_stream.read(byArray, 0, 2);
        this.m_stream.read(byArray, 0, 2);
        this.m_channel = byArray[1] << 8 | byArray[0];
        this.m_stream.read(byArray, 0, 4);
        this.m_sample_per_sec = (int)PortUtil.make_uint32_le(byArray);
        this.m_stream.read(byArray, 0, 4);
        this.m_stream.read(byArray, 0, 2);
        this.m_stream.read(byArray, 0, 2);
        int n2 = byArray[1] << 8 | byArray[0];
        this.m_byte_per_sample = n2 / 8;
        this.m_stream.seek(l);
        this.m_stream.read(byArray, 0, 4);
        if (byArray[0] != 100 || byArray[1] != 97 || byArray[2] != 116 || byArray[3] != 97) {
            this.m_stream.close();
            return false;
        }
        this.m_stream.read(byArray, 0, 4);
        int n3 = (int)PortUtil.make_uint32_le(byArray);
        this.m_total_samples = n3 / (this.m_channel * this.m_byte_per_sample);
        this.m_opened = true;
        this.m_header_offset = (int)this.m_stream.getFilePointer();
        return true;
    }

    public int getTotalSamples() {
        return this.m_total_samples;
    }

    public void read(long l, int n, double[] dArray, double[] dArray2) throws IOException {
        int n2;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = 0.0;
            dArray2[n2] = 0.0;
        }
        if (!this.m_opened) {
            return;
        }
        n2 = 0;
        int n3 = n - 1;
        long l2 = l + (long)(this.m_offset_seconds * (double)this.m_sample_per_sec);
        long l3 = l2 + (long)n;
        if (l2 < 0L) {
            n2 = -((int)l2) + 1;
            if (n2 >= n) {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = 0.0;
                    dArray2[i] = 0.0;
                }
                return;
            }
            for (int i = 0; i < n2; ++i) {
                dArray[i] = 0.0;
                dArray2[i] = 0.0;
            }
            this.m_stream.seek(this.m_header_offset);
        } else {
            long l4 = (long)this.m_header_offset + (long)(this.m_byte_per_sample * this.m_channel) * l2;
            this.m_stream.seek(l4);
        }
        if ((long)this.m_total_samples < l3) {
            n3 = n - 1 - (int)l3 + this.m_total_samples;
            if (n3 < 0) {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = 0.0;
                    dArray2[i] = 0.0;
                }
                return;
            }
            for (int i = n3 + 1; i < n; ++i) {
                dArray[i] = 0.0;
                dArray2[i] = 0.0;
            }
        }
        if (this.m_byte_per_sample == 2) {
            if (this.m_channel == 2) {
                byte[] byArray = new byte[4];
                double d = this.m_amplify_left / 32768.0;
                double d2 = this.m_amplify_right / 32768.0;
                for (int i = n2; i <= n3; ++i) {
                    int n4;
                    int n5 = this.m_stream.read(byArray, 0, 4);
                    if (n5 < 4) {
                        for (n4 = i; n4 < n; ++n4) {
                            dArray[n4] = 0.0;
                            dArray2[n4] = 0.0;
                        }
                        break;
                    }
                    n4 = (short)(byArray[0] | byArray[1] << 8);
                    short s = (short)(byArray[2] | byArray[3] << 8);
                    dArray[i] = (double)n4 * d;
                    dArray2[i] = (double)s * d2;
                }
            } else {
                byte[] byArray = new byte[2];
                double d = this.m_amplify_left / 32768.0;
                for (int i = n2; i <= n3; ++i) {
                    int n6;
                    int n7 = this.m_stream.read(byArray, 0, 2);
                    if (n7 < 2) {
                        for (n6 = i; n6 < n; ++n6) {
                            dArray[n6] = 0.0;
                            dArray2[n6] = 0.0;
                        }
                        break;
                    }
                    n6 = (short)(byArray[0] | byArray[1] << 8);
                    dArray[i] = (double)n6 * d;
                    dArray2[i] = dArray[i];
                }
            }
        } else if (this.m_channel == 2) {
            byte[] byArray = new byte[2];
            double d = this.m_amplify_left / 64.0;
            double d3 = this.m_amplify_right / 64.0;
            for (int i = n2; i <= n3; ++i) {
                int n8 = this.m_stream.read(byArray, 0, 2);
                if (n8 < 2) {
                    for (int j = i; j < n; ++j) {
                        dArray[j] = 0.0;
                        dArray2[j] = 0.0;
                    }
                    break;
                }
                dArray[i] = (double)((float)byArray[0] - 64.0f) * d;
                dArray2[i] = (double)((float)byArray[1] - 64.0f) * d3;
            }
        } else {
            byte[] byArray = new byte[1];
            double d = this.m_amplify_left / 64.0;
            for (int i = n2; i <= n3; ++i) {
                int n9 = this.m_stream.read(byArray, 0, 1);
                if (n9 < 1) {
                    for (int j = i; j < n; ++j) {
                        dArray[j] = 0.0;
                        dArray2[j] = 0.0;
                    }
                    break;
                }
                dArray[i] = (double)((float)byArray[0] - 64.0f) * d;
                dArray2[i] = dArray[i];
            }
        }
    }

    public void read(long l, int n, ByRef<float[]> byRef, ByRef<float[]> byRef2) throws IOException {
        int n2;
        byRef.value = new float[n];
        byRef2.value = new float[n];
        if (!this.m_opened) {
            return;
        }
        int n3 = 0;
        int n4 = n;
        long l2 = l + (long)(this.m_offset_seconds * (double)this.m_sample_per_sec);
        long l3 = l2 + (long)n;
        if (l2 < 0L) {
            n3 = -((int)l2) + 1;
            for (n2 = 0; n2 < n3; ++n2) {
                ((float[])byRef.value)[n2] = 0.0f;
                ((float[])byRef2.value)[n2] = 0.0f;
            }
            this.m_stream.seek(this.m_header_offset);
        } else {
            long l4 = (long)this.m_header_offset + (long)(this.m_byte_per_sample * this.m_channel) * l2;
            this.m_stream.seek(l4);
        }
        if ((long)this.m_total_samples < l3) {
            n4 = n - 1 - (int)l3 + this.m_total_samples;
            for (n2 = n4 + 1; n2 < n; ++n2) {
                ((float[])byRef.value)[n2] = 0.0f;
                ((float[])byRef2.value)[n2] = 0.0f;
            }
        }
        if (this.m_byte_per_sample == 2) {
            if (this.m_channel == 2) {
                byte[] byArray = new byte[4];
                float f = (float)(this.m_amplify_left / 32768.0);
                float f2 = (float)(this.m_amplify_right / 32768.0);
                for (int i = 0; i < n; ++i) {
                    int n5;
                    int n6 = this.m_stream.read(byArray, 0, 4);
                    if (n6 < 4) {
                        for (n5 = i; n5 < n; ++n5) {
                            ((float[])byRef.value)[n5] = 0.0f;
                            ((float[])byRef2.value)[n5] = 0.0f;
                        }
                        break;
                    }
                    n5 = (short)(byArray[0] | byArray[1] << 8);
                    short s = (short)(byArray[2] | byArray[3] << 8);
                    ((float[])byRef.value)[i] = (float)n5 * f;
                    ((float[])byRef2.value)[i] = (float)s * f2;
                }
            } else {
                byte[] byArray = new byte[2];
                float f = (float)(this.m_amplify_left / 32768.0);
                for (int i = 0; i < n; ++i) {
                    int n7;
                    int n8 = this.m_stream.read(byArray, 0, 2);
                    if (n8 < 2) {
                        for (n7 = i; n7 < n; ++n7) {
                            ((float[])byRef.value)[n7] = 0.0f;
                            ((float[])byRef2.value)[n7] = 0.0f;
                        }
                        break;
                    }
                    n7 = (short)(byArray[0] | byArray[1] << 8);
                    ((float[])byRef.value)[i] = (float)n7 * f;
                    ((float[])byRef2.value)[i] = ((float[])byRef.value)[i];
                }
            }
        } else if (this.m_channel == 2) {
            byte[] byArray = new byte[2];
            float f = (float)(this.m_amplify_left / 64.0);
            float f3 = (float)(this.m_amplify_right / 64.0);
            for (int i = 0; i < n; ++i) {
                int n9 = this.m_stream.read(byArray, 0, 2);
                if (n9 < 2) {
                    for (int j = i; j < n; ++j) {
                        ((float[])byRef.value)[j] = 0.0f;
                        ((float[])byRef2.value)[j] = 0.0f;
                    }
                    break;
                }
                ((float[])byRef.value)[i] = ((float)byArray[0] - 64.0f) * f;
                ((float[])byRef2.value)[i] = ((float)byArray[1] - 64.0f) * f3;
            }
        } else {
            byte[] byArray = new byte[1];
            float f = (float)(this.m_amplify_left / 64.0);
            for (int i = 0; i < n; ++i) {
                int n10 = this.m_stream.read(byArray, 0, 1);
                if (n10 < 1) {
                    for (int j = i; j < n; ++j) {
                        ((float[])byRef.value)[j] = 0.0f;
                        ((float[])byRef2.value)[j] = 0.0f;
                    }
                    break;
                }
                ((float[])byRef.value)[i] = ((float)byArray[0] - 64.0f) * f;
                ((float[])byRef2.value)[i] = ((float[])byRef.value)[i];
            }
        }
    }

    public void close() throws IOException {
        this.m_opened = false;
        if (this.m_stream != null) {
            this.m_stream.close();
            this.m_stream = null;
        }
    }
}

