/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.Serializable;
import org.kbinani.PortUtil;
import org.kbinani.vsq.VsqPhoneticSymbol;

public class Lyric
implements Serializable {
    public String Phrase;
    private String[] m_phonetic_symbol;
    public float UnknownFloat;
    private int[] m_consonant_adjustment;
    public boolean PhoneticSymbolProtected;

    public boolean equalsForSynth(Lyric lyric) {
        if (this.PhoneticSymbolProtected != lyric.PhoneticSymbolProtected) {
            return false;
        }
        if (!this.getPhoneticSymbol().equals(lyric.getPhoneticSymbol())) {
            return false;
        }
        return this.getConsonantAdjustment().equals(lyric.getConsonantAdjustment());
    }

    public boolean equals(Lyric lyric) {
        if (!this.equalsForSynth(lyric)) {
            return false;
        }
        if (!this.Phrase.equals(lyric.Phrase)) {
            return false;
        }
        return this.UnknownFloat == lyric.UnknownFloat;
    }

    public String getConsonantAdjustment() {
        String string = "";
        int[] nArray = this.getConsonantAdjustmentList();
        for (int i = 0; i < nArray.length; ++i) {
            string = string + (i == 0 ? "" : " ") + nArray[i];
        }
        return string;
    }

    public void setConsonantAdjustment(String string) {
        String[] stringArray = PortUtil.splitString(string, new char[]{' ', ','}, true);
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = 64;
            try {
                n = PortUtil.parseInt(stringArray[i]);
            }
            catch (Exception exception) {
                PortUtil.stderr.println("Lyric#setCosonantAdjustment; ex=" + exception);
            }
            nArray[i] = n;
        }
        this.setConsonantAdjustmentList(nArray);
    }

    public int[] getConsonantAdjustmentList() {
        if (this.m_consonant_adjustment == null) {
            if (this.m_phonetic_symbol == null) {
                this.m_consonant_adjustment = new int[0];
            } else {
                this.m_consonant_adjustment = new int[this.m_phonetic_symbol.length];
                for (int i = 0; i < this.m_phonetic_symbol.length; ++i) {
                    this.m_consonant_adjustment[i] = VsqPhoneticSymbol.isConsonant(this.m_phonetic_symbol[i]) ? 64 : 0;
                }
            }
        }
        return this.m_consonant_adjustment;
    }

    public void setConsonantAdjustmentList(int[] nArray) {
        if (nArray == null) {
            return;
        }
        this.m_consonant_adjustment = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.m_consonant_adjustment[i] = nArray[i];
        }
    }

    public Object clone() {
        int n;
        Lyric lyric = new Lyric();
        lyric.Phrase = this.Phrase;
        lyric.m_phonetic_symbol = new String[this.m_phonetic_symbol.length];
        for (n = 0; n < this.m_phonetic_symbol.length; ++n) {
            lyric.m_phonetic_symbol[n] = this.m_phonetic_symbol[n];
        }
        lyric.UnknownFloat = this.UnknownFloat;
        if (this.m_consonant_adjustment != null) {
            lyric.m_consonant_adjustment = new int[this.m_consonant_adjustment.length];
            for (n = 0; n < this.m_consonant_adjustment.length; ++n) {
                lyric.m_consonant_adjustment[n] = this.m_consonant_adjustment[n];
            }
        }
        lyric.PhoneticSymbolProtected = this.PhoneticSymbolProtected;
        return lyric;
    }

    public Lyric(String string, String string2) {
        this.Phrase = string;
        this.setPhoneticSymbol(string2);
        this.UnknownFloat = 0.0f;
    }

    public Lyric() {
    }

    public String getPhoneticSymbol() {
        String[] stringArray = this.getPhoneticSymbolList();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + (i == 0 ? "" : " ") + stringArray[i];
        }
        return string;
    }

    public void setPhoneticSymbol(String string) {
        String string2 = string.replace("  ", " ");
        this.m_phonetic_symbol = PortUtil.splitString(string2, new char[]{' '}, 16, true);
        for (int i = 0; i < this.m_phonetic_symbol.length; ++i) {
            this.m_phonetic_symbol[i] = this.m_phonetic_symbol[i].replace("\\\\", "\\");
        }
    }

    public String[] getPhoneticSymbolList() {
        String[] stringArray = new String[this.m_phonetic_symbol.length];
        for (int i = 0; i < this.m_phonetic_symbol.length; ++i) {
            stringArray[i] = this.m_phonetic_symbol[i];
        }
        return stringArray;
    }

    public Lyric(String string) {
        String[] stringArray = PortUtil.splitString(string, ',');
        int n = stringArray.length - 3;
        if (stringArray.length < 4) {
            this.Phrase = "a";
            this.setPhoneticSymbol("a");
            this.UnknownFloat = 0.0f;
            this.PhoneticSymbolProtected = false;
        } else {
            String string2;
            this.Phrase = stringArray[0];
            if (this.Phrase.startsWith("\"")) {
                this.Phrase = this.Phrase.substring(1);
            }
            if (this.Phrase.endsWith("\"")) {
                this.Phrase = this.Phrase.substring(0, PortUtil.getStringLength(this.Phrase) - 1);
            }
            if ((string2 = stringArray[1]).startsWith("\"")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("\"")) {
                string2 = string2.substring(0, PortUtil.getStringLength(string2) - 1);
            }
            this.setPhoneticSymbol(string2);
            this.UnknownFloat = PortUtil.parseFloat(stringArray[2]);
            this.PhoneticSymbolProtected = !stringArray[stringArray.length - 1].equals("0");
        }
    }

    public String toString(boolean bl) {
        int n;
        String string = bl ? "\"" : "";
        String string2 = string + this.Phrase + string + ",";
        String[] stringArray = this.getPhoneticSymbolList();
        String string3 = this.getPhoneticSymbol();
        if (!bl && (string3 == null || string3 != null && string3.equals(""))) {
            string3 = "u:";
        }
        string2 = string2 + string + string3 + string + "," + PortUtil.formatDecimal("0.000000", this.UnknownFloat);
        string2 = string2.replace("\\\\", "\\");
        if (this.m_consonant_adjustment == null) {
            this.m_consonant_adjustment = new int[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                this.m_consonant_adjustment[n] = VsqPhoneticSymbol.isConsonant(stringArray[n]) ? 64 : 0;
            }
        }
        for (n = 0; n < this.m_consonant_adjustment.length; ++n) {
            string2 = string2 + "," + this.m_consonant_adjustment[n];
        }
        string2 = this.PhoneticSymbolProtected ? string2 + ",1" : string2 + ",0";
        return string2;
    }
}

