/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiEvent
implements Comparable<MidiEvent> {
    public long clock;
    public byte firstByte;
    public byte[] data;

    private static void writeDeltaClock(RandomAccessFile randomAccessFile, long l) throws IOException {
        int n;
        int n2;
        boolean[] blArray = new boolean[64];
        long l2 = 1L;
        blArray[0] = (l & l2) == l2;
        for (n2 = 1; n2 < 64; ++n2) {
            blArray[n2] = (l & (l2 <<= 1)) == l2;
        }
        n2 = 0;
        for (n = 63; n >= 0; --n) {
            if (!blArray[n]) continue;
            n2 = n;
            break;
        }
        n = n2 / 7 + 1;
        for (int i = 1; i <= n; ++i) {
            long l3 = 0L;
            long l4 = 128L;
            for (int j = (n - i + 1) * 7 - 1; j >= (n - i + 1) * 7 - 6 - 1; --j) {
                l4 >>= 1;
                if (!blArray[j]) continue;
                l3 += l4;
            }
            if (i != n) {
                l3 += 128L;
            }
            randomAccessFile.write((byte)l3);
        }
    }

    private static long readDeltaClock(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        long l = 0L;
        while ((n = randomAccessFile.read()) >= 0) {
            byte by = (byte)n;
            l = l << 7 | (long)by & 0x7FL;
            if ((by & 0x80) != 0) continue;
            break;
        }
        return l;
    }

    public static MidiEvent read(RandomAccessFile randomAccessFile, ByRef<Long> byRef, ByRef<Byte> byRef2) throws IOException, Exception {
        long l = MidiEvent.readDeltaClock(randomAccessFile);
        ByRef<Long> byRef3 = byRef;
        byRef3.value = (Long)byRef3.value + l;
        byte by = (byte)randomAccessFile.read();
        if (by < 128) {
            long l2 = randomAccessFile.getFilePointer();
            randomAccessFile.seek(l2 - 1L);
            by = (Byte)byRef2.value;
        } else {
            byRef2.value = by;
        }
        byte by2 = (byte)(by & 0xFFFFFFF0);
        if (by2 == 128 || by2 == 144 || by2 == 160 || by2 == 176 || by2 == 224 || by == 242) {
            MidiEvent midiEvent = new MidiEvent();
            midiEvent.clock = (Long)byRef.value;
            midiEvent.firstByte = by;
            midiEvent.data = new byte[2];
            randomAccessFile.read(midiEvent.data, 0, 2);
            return midiEvent;
        }
        if (by2 == 192 || by2 == 208 || by == 241 || by == 242) {
            MidiEvent midiEvent = new MidiEvent();
            midiEvent.clock = (Long)byRef.value;
            midiEvent.firstByte = by;
            midiEvent.data = new byte[1];
            randomAccessFile.read(midiEvent.data, 0, 1);
            return midiEvent;
        }
        if (by == 246) {
            MidiEvent midiEvent = new MidiEvent();
            midiEvent.clock = (Long)byRef.value;
            midiEvent.firstByte = by;
            midiEvent.data = new byte[0];
            return midiEvent;
        }
        if (by == 255) {
            byte by3 = (byte)randomAccessFile.read();
            long l3 = MidiEvent.readDeltaClock(randomAccessFile);
            MidiEvent midiEvent = new MidiEvent();
            midiEvent.clock = (Long)byRef.value;
            midiEvent.firstByte = by;
            midiEvent.data = new byte[(int)l3 + 1];
            midiEvent.data[0] = by3;
            randomAccessFile.read(midiEvent.data, 1, (int)l3);
            return midiEvent;
        }
        if (by == 240) {
            MidiEvent midiEvent = new MidiEvent();
            midiEvent.clock = (Long)byRef.value;
            midiEvent.firstByte = by;
            long l4 = MidiEvent.readDeltaClock(randomAccessFile);
            midiEvent.data = new byte[(int)l4 + 1];
            randomAccessFile.read(midiEvent.data, 0, (int)(l4 + 1L));
            return midiEvent;
        }
        if (by == 247) {
            MidiEvent midiEvent = new MidiEvent();
            midiEvent.clock = (Long)byRef.value;
            midiEvent.firstByte = by;
            long l5 = MidiEvent.readDeltaClock(randomAccessFile);
            midiEvent.data = new byte[(int)l5];
            randomAccessFile.read(midiEvent.data, 0, (int)l5);
            return midiEvent;
        }
        throw new Exception("don't know how to process first_byte: 0x" + PortUtil.toHexString(by));
    }

    public void writeData(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.write(this.firstByte);
        if (this.firstByte == 255) {
            randomAccessFile.write(this.data[0]);
            MidiEvent.writeDeltaClock(randomAccessFile, this.data.length - 1);
            randomAccessFile.write(this.data, 1, this.data.length - 1);
        } else {
            randomAccessFile.write(this.data, 0, this.data.length);
        }
    }

    @Override
    public int compareTo(MidiEvent midiEvent) {
        if (this.clock != midiEvent.clock) {
            return (int)(this.clock - midiEvent.clock);
        }
        int n = this.firstByte & 0xF0;
        int n2 = midiEvent.firstByte & 0xF0;
        if (!(n != 128 && n != 144 || n2 != 128 && n2 != 144 || this.data == null || this.data.length < 2 || midiEvent.data == null || midiEvent.data.length < 2)) {
            if (n2 == 144 && midiEvent.data[1] == 0) {
                n2 = 128;
            }
            if (n == 144 && this.data[1] == 0) {
                n = 128;
            }
            if (this.data[0] == midiEvent.data[0]) {
                if (n == 144) {
                    if (n2 == 128) {
                        return 1;
                    }
                    return 0;
                }
                if (n2 == 128) {
                    return 0;
                }
                return -1;
            }
        }
        return (int)(this.clock - midiEvent.clock);
    }

    public static MidiEvent generateTimeSigEvent(int n, int n2, int n3) {
        MidiEvent midiEvent = new MidiEvent();
        midiEvent.clock = n;
        midiEvent.firstByte = (byte)-1;
        byte by = (byte)(Math.log(n3) / Math.log(2.0) + 0.1);
        midiEvent.data = new byte[]{88, (byte)n2, by, 24, 8};
        return midiEvent;
    }

    public static MidiEvent generateTempoChangeEvent(int n, int n2) {
        MidiEvent midiEvent = new MidiEvent();
        midiEvent.clock = n;
        midiEvent.firstByte = (byte)-1;
        byte by = (byte)(n2 & 0xFF);
        byte by2 = (byte)((n2 >>= 8) & 0xFF);
        byte by3 = (byte)((n2 >>= 8) & 0xFF);
        midiEvent.data = new byte[]{81, by3, by2, by};
        return midiEvent;
    }
}

