/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;
import org.kbinani.ValuePair;
import org.kbinani.vsq.SynthesizerType;
import org.kbinani.vsq.VocaloSysUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolTable
implements Cloneable {
    private TreeMap<String, String> m_dict;
    private String m_name;
    private boolean m_enabled;
    private static TreeMap<Integer, SymbolTable> s_table = new TreeMap();
    private static SymbolTable s_default_jp = null;
    private static SymbolTable s_default_en = null;
    private static boolean s_initialized = false;

    public static SymbolTable getSymbolTable(int n) {
        if (!s_initialized) {
            SymbolTable.loadDictionary();
        }
        if (0 <= n && n < s_table.size()) {
            return s_table.get(n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDictionary() {
        String string;
        int n;
        String[] stringArray;
        Object object;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        Vector<String[]> vector = new Vector<String[]>();
        BufferedReader bufferedReader = null;
        try {
            object4 = PortUtil.combinePath(PortUtil.combinePath(PortUtil.getApplicationStartupPath(), "resources"), "dict_ja.txt");
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((String)object4), "UTF-8"));
            object3 = "";
            while ((object3 = bufferedReader.readLine()) != null) {
                object2 = PortUtil.splitString((String)object3, '\t');
                if (((String[])object2).length < 2) continue;
                vector.add(new String[]{object2[0], object2[1]});
            }
        }
        catch (Exception exception) {
            PortUtil.stderr.println("SymbolTable#loadDictionary; ex=" + exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("SymbolTable#loadDictionary; ex2=" + exception);
                }
            }
        }
        s_default_jp = new SymbolTable("DEFAULT_JP", (String[][])vector.toArray((T[])new String[0][]), true);
        object4 = new Vector();
        object3 = null;
        try {
            object2 = PortUtil.combinePath(PortUtil.combinePath(PortUtil.getApplicationStartupPath(), "resources"), "dict_en.txt");
            object3 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((String)object2), "UTF-8"));
            string2 = "";
            while ((string2 = ((BufferedReader)object3).readLine()) != null) {
                object = PortUtil.splitString(string2, '\t');
                if (((String[])object).length < 2) continue;
                ((Vector)object4).add(new String[]{object[0], object[1]});
            }
        }
        catch (Exception exception) {
            PortUtil.stderr.println("SymbolTable#loadDictionary; ex=" + exception);
        }
        finally {
            if (object3 != null) {
                try {
                    ((BufferedReader)object3).close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("SymbolTable#loadDictionary; ex2=" + exception);
                }
            }
        }
        s_default_en = new SymbolTable("DEFAULT_EN", (String[][])((Vector)object4).toArray((T[])new String[0][]), true);
        s_table.clear();
        int n2 = 0;
        s_table.put(n2, s_default_en);
        s_table.put(++n2, s_default_jp);
        ++n2;
        string2 = VocaloSysUtil.getEditorPath(SynthesizerType.VOCALOID2);
        if (string2 != "") {
            object = PortUtil.combinePath(PortUtil.getDirectoryName(string2), "UDIC");
            if (!PortUtil.isDirectoryExists((String)object)) {
                return;
            }
            stringArray = PortUtil.listFiles((String)object, "*.udc");
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = PortUtil.getFileName(stringArray[n]);
                string = PortUtil.combinePath((String)object, stringArray[n]);
                s_table.put(n2, new SymbolTable(string, true, false));
                ++n2;
            }
        }
        if (PortUtil.isDirectoryExists((String)(object = PortUtil.combinePath(PortUtil.getApplicationStartupPath(), "udic")))) {
            stringArray = PortUtil.listFiles((String)object, "*.eudc");
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = PortUtil.getFileName(stringArray[n]);
                string = PortUtil.combinePath((String)object, stringArray[n]);
                s_table.put(n2, new SymbolTable(string, false, false));
                ++n2;
            }
        }
        s_initialized = true;
    }

    public static boolean attatch(String string, ByRef<String> byRef) {
        for (int n : s_table.keySet()) {
            SymbolTable symbolTable = s_table.get(n);
            if (!symbolTable.isEnabled() || !symbolTable.attatchImp(string, byRef)) continue;
            return true;
        }
        byRef.value = "a";
        return false;
    }

    public static int getCount() {
        if (!s_initialized) {
            SymbolTable.loadDictionary();
        }
        return s_table.size();
    }

    public static void changeOrder(Vector<ValuePair<String, Boolean>> vector) {
        TreeMap<Integer, SymbolTable> treeMap = new TreeMap<Integer, SymbolTable>();
        for (int n2 : s_table.keySet()) {
            treeMap.put(n2, (SymbolTable)s_table.get(n2).clone());
        }
        s_table.clear();
        int n = vector.size();
        block1: for (int n2 = 0; n2 < n; ++n2) {
            ValuePair<String, Boolean> valuePair = vector.get(n2);
            Iterator iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                SymbolTable symbolTable = (SymbolTable)treeMap.get(n3);
                if (!symbolTable.getName().equals(valuePair.getKey())) continue;
                symbolTable.setEnabled(valuePair.getValue());
                s_table.put(n2, symbolTable);
                continue block1;
            }
        }
    }

    public Object clone() {
        SymbolTable symbolTable = new SymbolTable();
        symbolTable.m_dict = new TreeMap();
        for (String string : this.m_dict.keySet()) {
            symbolTable.m_dict.put(string, this.m_dict.get(string));
        }
        symbolTable.m_name = this.m_name;
        symbolTable.m_enabled = this.m_enabled;
        return symbolTable;
    }

    private SymbolTable() {
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymbolTable(String string, boolean bl, boolean bl2) {
        this.m_dict = new TreeMap();
        this.m_enabled = bl2;
        if (!PortUtil.isFileExists(string)) {
            return;
        }
        this.m_name = PortUtil.getFileName(string);
        BufferedReader bufferedReader = null;
        try {
            if (bl ? (bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "Shift_JIS"))) == null : (bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF8"))) == null) {
                return;
            }
            while (bufferedReader.ready()) {
                String[] stringArray;
                String string2 = bufferedReader.readLine();
                if (string2.startsWith("//") || (stringArray = PortUtil.splitString(string2, new String[]{"\t"}, 2, true)).length < 2) continue;
                String string3 = stringArray[0].toLowerCase();
                if (this.m_dict.containsKey(string3)) {
                    PortUtil.println("SymbolTable..ctor");
                    PortUtil.println("    dictionary already contains key: " + string3);
                    continue;
                }
                this.m_dict.put(string3, stringArray[1]);
            }
        }
        catch (Exception exception) {
            PortUtil.stderr.println("SymbolTable#.ctor; ex=" + exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("SymbolTable#.ctor; ex=" + exception);
                }
            }
        }
    }

    private boolean attatchImp(String string, ByRef<String> byRef) {
        String string2 = string.toLowerCase();
        if (this.m_dict.containsKey(string2)) {
            byRef.value = this.m_dict.get(string2);
            return true;
        }
        byRef.value = "a";
        return false;
    }

    private SymbolTable(String string, String[][] stringArray, boolean bl) {
        this.m_enabled = bl;
        this.m_name = string;
        this.m_dict = new TreeMap();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i][0].toLowerCase();
            if (this.m_dict.containsKey(string2)) continue;
            this.m_dict.put(string2, stringArray[i][1]);
        }
    }
}

