/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.util.Arrays;
import org.kbinani.PortUtil;
import org.kbinani.vsq.ITextWriter;

public class TextStream
implements ITextWriter {
    static final int INIT_BUFLEN = 512;
    private char[] array = new char[512];
    private int length = 0;
    private int position = -1;

    public int getPointer() {
        return this.position;
    }

    public void setPointer(int n) {
        this.position = n;
    }

    public char get() {
        ++this.position;
        return this.array[this.position];
    }

    public String readLine() {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        ++this.position;
        while (this.position < this.length && (c = this.array[this.position]) != '\n') {
            stringBuilder.append(c);
            ++this.position;
        }
        return stringBuilder.toString();
    }

    public boolean ready() {
        return 0 <= this.position + 1 && this.position + 1 < this.length;
    }

    private void ensureCapacity(int n) {
        if (n > this.array.length) {
            int n2 = n;
            if (this.length <= 0) {
                n2 = n * 3 >> 1;
            } else {
                int n3 = n / this.array.length;
                if (n3 <= 1) {
                    n3 = 2;
                }
                n2 = this.array.length * n3;
            }
            this.array = Arrays.copyOf(this.array, n2);
        }
    }

    public void write(String string) {
        int n = PortUtil.getStringLength(string);
        int n2 = this.length + n;
        int n3 = this.length;
        this.ensureCapacity(n2);
        for (int i = 0; i < n; ++i) {
            this.array[n3 + i] = string.charAt(i);
        }
        this.length = n2;
    }

    public void writeLine(String string) {
        int n = PortUtil.getStringLength(string);
        int n2 = this.length + n + 1;
        int n3 = this.length;
        this.ensureCapacity(n2);
        for (int i = 0; i < n; ++i) {
            this.array[n3 + i] = string.charAt(i);
        }
        this.array[n3 + n] = 10;
        this.length = n2;
    }

    public void close() {
        this.array = null;
        this.length = 0;
    }
}

