/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import org.kbinani.PortUtil;
import org.kbinani.vsq.UstEnvelope;
import org.kbinani.vsq.UstPortamento;
import org.kbinani.vsq.UstVibrato;

public class UstEvent
implements Cloneable,
Serializable {
    public String Tag;
    public int Length = 0;
    public String Lyric = "";
    public int Note = -1;
    public int Intensity = -1;
    public int PBType = -1;
    public float[] Pitches = null;
    public float Tempo = -1.0f;
    public UstVibrato Vibrato = null;
    public UstPortamento Portamento = null;
    public float PreUtterance = 0.0f;
    public float VoiceOverlap = 0.0f;
    public UstEnvelope Envelope = null;
    public String Flags = "";
    public int Moduration = 100;
    public int Index;

    public int getLength() {
        return this.Length;
    }

    public void setLength(int n) {
        this.Length = n;
    }

    public Object clone() {
        UstEvent ustEvent = new UstEvent();
        ustEvent.setLength(this.Length);
        ustEvent.Lyric = this.Lyric;
        ustEvent.Note = this.Note;
        ustEvent.Intensity = this.Intensity;
        ustEvent.PBType = this.PBType;
        if (this.Pitches != null) {
            ustEvent.Pitches = new float[this.Pitches.length];
            for (int i = 0; i < this.Pitches.length; ++i) {
                ustEvent.Pitches[i] = this.Pitches[i];
            }
        }
        ustEvent.Tempo = this.Tempo;
        if (this.Vibrato != null) {
            ustEvent.Vibrato = (UstVibrato)this.Vibrato.clone();
        }
        if (this.Portamento != null) {
            ustEvent.Portamento = (UstPortamento)this.Portamento.clone();
        }
        if (this.Envelope != null) {
            ustEvent.Envelope = (UstEnvelope)this.Envelope.clone();
        }
        ustEvent.PreUtterance = this.PreUtterance;
        ustEvent.VoiceOverlap = this.VoiceOverlap;
        ustEvent.Flags = this.Flags;
        ustEvent.Moduration = this.Moduration;
        ustEvent.Tag = this.Tag;
        return ustEvent;
    }

    public void print(BufferedWriter bufferedWriter) throws IOException {
        if (this.Index == Integer.MIN_VALUE) {
            bufferedWriter.write("[#PREV]");
            bufferedWriter.newLine();
        } else if (this.Index == Integer.MAX_VALUE) {
            bufferedWriter.write("[#NEXT]");
            bufferedWriter.newLine();
        } else {
            bufferedWriter.write("[#" + PortUtil.formatDecimal("0000", this.Index) + "]");
            bufferedWriter.newLine();
        }
        bufferedWriter.write("Length=" + this.Length);
        bufferedWriter.newLine();
        bufferedWriter.write("Lyric=" + this.Lyric);
        bufferedWriter.newLine();
        bufferedWriter.write("NoteNum=" + this.Note);
        bufferedWriter.newLine();
        if (this.Intensity >= 0) {
            bufferedWriter.write("Intensity=" + this.Intensity);
            bufferedWriter.newLine();
        }
        if (this.PBType >= 0 && this.Pitches != null) {
            bufferedWriter.write("PBType=" + this.PBType);
            bufferedWriter.newLine();
            bufferedWriter.write("Piches=");
            for (int i = 0; i < this.Pitches.length; ++i) {
                if (i == 0) {
                    bufferedWriter.write(this.Pitches[i] + "");
                    continue;
                }
                bufferedWriter.write("," + this.Pitches[i]);
            }
            bufferedWriter.newLine();
        }
        if (this.Tempo > 0.0f) {
            bufferedWriter.write("Tempo=" + this.Tempo);
            bufferedWriter.newLine();
        }
        if (this.Vibrato != null) {
            bufferedWriter.write(this.Vibrato.toString());
            bufferedWriter.newLine();
        }
        if (this.Portamento != null) {
            this.Portamento.print(bufferedWriter);
        }
        if (this.PreUtterance != 0.0f) {
            bufferedWriter.write("PreUtterance=" + this.PreUtterance);
            bufferedWriter.newLine();
        }
        if (this.VoiceOverlap != 0.0f) {
            bufferedWriter.write("VoiceOverlap=" + this.VoiceOverlap);
            bufferedWriter.newLine();
        }
        if (this.Envelope != null) {
            bufferedWriter.write(this.Envelope.toString());
            bufferedWriter.newLine();
        }
        if (this.Flags != "") {
            bufferedWriter.write("Flags=" + this.Flags);
            bufferedWriter.newLine();
        }
        if (this.Moduration >= 0) {
            bufferedWriter.write("Moduration=" + this.Moduration);
            bufferedWriter.newLine();
        }
    }
}

