/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;
import org.kbinani.vsq.ITextWriter;
import org.kbinani.vsq.IconDynamicsHandle;
import org.kbinani.vsq.IconHandle;
import org.kbinani.vsq.Lyric;
import org.kbinani.vsq.LyricHandle;
import org.kbinani.vsq.NoteHeadHandle;
import org.kbinani.vsq.TextStream;
import org.kbinani.vsq.VibratoBPList;
import org.kbinani.vsq.VibratoHandle;
import org.kbinani.vsq.VsqHandleType;
import org.kbinani.vsq.WrappedStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsqHandle
implements Serializable {
    public VsqHandleType m_type;
    public int Index;
    public String IconID = "";
    public String IDS = "";
    public Lyric L0;
    public Vector<Lyric> Trailing = new Vector();
    public int Original;
    public String Caption = "";
    public int Length;
    public int StartDepth;
    public VibratoBPList DepthBP;
    public int StartRate;
    public VibratoBPList RateBP;
    public int Language;
    public int Program;
    public int Duration;
    public int Depth;
    public int StartDyn;
    public int EndDyn;
    public VibratoBPList DynBP;
    public boolean addQuotationMark = true;

    public VsqHandle() {
    }

    public int getLength() {
        return this.Length;
    }

    public void setLength(int n) {
        this.Length = n;
    }

    public LyricHandle castToLyricHandle() {
        LyricHandle lyricHandle = new LyricHandle();
        lyricHandle.L0 = this.L0;
        lyricHandle.Index = this.Index;
        lyricHandle.Trailing = this.Trailing;
        return lyricHandle;
    }

    public VibratoHandle castToVibratoHandle() {
        VibratoHandle vibratoHandle = new VibratoHandle();
        vibratoHandle.Index = this.Index;
        vibratoHandle.setCaption(this.Caption);
        vibratoHandle.setDepthBP((VibratoBPList)this.DepthBP.clone());
        vibratoHandle.IconID = this.IconID;
        vibratoHandle.IDS = this.IDS;
        vibratoHandle.Index = this.Index;
        vibratoHandle.setLength(this.Length);
        vibratoHandle.Original = this.Original;
        vibratoHandle.setRateBP((VibratoBPList)this.RateBP.clone());
        vibratoHandle.setStartDepth(this.StartDepth);
        vibratoHandle.setStartRate(this.StartRate);
        return vibratoHandle;
    }

    public IconHandle castToIconHandle() {
        IconHandle iconHandle = new IconHandle();
        iconHandle.Index = this.Index;
        iconHandle.Caption = this.Caption;
        iconHandle.IconID = this.IconID;
        iconHandle.IDS = this.IDS;
        iconHandle.Index = this.Index;
        iconHandle.Language = this.Language;
        iconHandle.setLength(this.Length);
        iconHandle.Original = this.Original;
        iconHandle.Program = this.Program;
        return iconHandle;
    }

    public NoteHeadHandle castToNoteHeadHandle() {
        NoteHeadHandle noteHeadHandle = new NoteHeadHandle();
        noteHeadHandle.setCaption(this.Caption);
        noteHeadHandle.setDepth(this.Depth);
        noteHeadHandle.setDuration(this.Duration);
        noteHeadHandle.IconID = this.IconID;
        noteHeadHandle.IDS = this.IDS;
        noteHeadHandle.setLength(this.getLength());
        noteHeadHandle.Original = this.Original;
        return noteHeadHandle;
    }

    public IconDynamicsHandle castToIconDynamicsHandle() {
        IconDynamicsHandle iconDynamicsHandle = new IconDynamicsHandle();
        iconDynamicsHandle.IDS = this.IDS;
        iconDynamicsHandle.IconID = this.IconID;
        iconDynamicsHandle.Original = this.Original;
        iconDynamicsHandle.setCaption(this.Caption);
        iconDynamicsHandle.setDynBP(this.DynBP);
        iconDynamicsHandle.setEndDyn(this.EndDyn);
        iconDynamicsHandle.setLength(this.getLength());
        iconDynamicsHandle.setStartDyn(this.StartDyn);
        return iconDynamicsHandle;
    }

    public void write(ITextWriter iTextWriter) throws IOException {
        iTextWriter.writeLine(this.toString());
    }

    public void write(BufferedWriter bufferedWriter) throws IOException {
        this.write(new WrappedStreamWriter(bufferedWriter));
    }

    public VsqHandle(TextStream textStream, int n, ByRef<String> byRef) {
        this.Index = n;
        this.m_type = VsqHandleType.Vibrato;
        this.IconID = "";
        this.IDS = "normal";
        this.L0 = new Lyric("");
        this.Original = 0;
        this.Caption = "";
        this.Length = 0;
        this.StartDepth = 0;
        this.DepthBP = null;
        this.StartRate = 0;
        this.RateBP = null;
        this.Language = 0;
        this.Program = 0;
        this.Duration = 0;
        this.Depth = 64;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        byRef.value = textStream.readLine().toString();
        while (!((String)byRef.value).startsWith("[")) {
            ByRef<Integer> byRef2;
            String string10;
            String[] stringArray = PortUtil.splitString((String)byRef.value, '=');
            String string11 = stringArray[0];
            if (string11.equals("Language")) {
                this.m_type = VsqHandleType.Singer;
                this.Language = PortUtil.parseInt(stringArray[1]);
            } else if (string11.equals("Program")) {
                this.Program = PortUtil.parseInt(stringArray[1]);
            } else if (string11.equals("IconID")) {
                this.IconID = stringArray[1];
            } else if (string11.equals("IDS")) {
                this.IDS = stringArray[1];
            } else if (string11.equals("Original")) {
                this.Original = PortUtil.parseInt(stringArray[1]);
            } else if (string11.equals("Caption")) {
                this.Caption = stringArray[1];
                for (int i = 2; i < stringArray.length; ++i) {
                    this.Caption = this.Caption + "=" + stringArray[i];
                }
            } else if (string11.equals("Length")) {
                this.Length = PortUtil.parseInt(stringArray[1]);
            } else if (string11.equals("StartDepth")) {
                this.StartDepth = PortUtil.parseInt(stringArray[1]);
            } else if (string11.equals("DepthBPNum")) {
                string3 = stringArray[1];
            } else if (string11.equals("DepthBPX")) {
                string = stringArray[1];
            } else if (string11.equals("DepthBPY")) {
                string2 = stringArray[1];
            } else if (string11.equals("StartRate")) {
                this.m_type = VsqHandleType.Vibrato;
                this.StartRate = PortUtil.parseInt(stringArray[1]);
            } else if (string11.equals("RateBPNum")) {
                string6 = stringArray[1];
            } else if (string11.equals("RateBPX")) {
                string4 = stringArray[1];
            } else if (string11.equals("RateBPY")) {
                string5 = stringArray[1];
            } else if (string11.equals("Duration")) {
                this.m_type = VsqHandleType.NoteHeadHandle;
                this.Duration = PortUtil.parseInt(stringArray[1]);
            } else if (string11.equals("Depth")) {
                this.Duration = PortUtil.parseInt(stringArray[1]);
            } else if (string11.equals("StartDyn")) {
                this.m_type = VsqHandleType.DynamicsHandle;
                this.StartDyn = PortUtil.parseInt(stringArray[1]);
            } else if (string11.equals("EndDyn")) {
                this.m_type = VsqHandleType.DynamicsHandle;
                this.EndDyn = PortUtil.parseInt(stringArray[1]);
            } else if (string11.equals("DynBPNum")) {
                string9 = stringArray[1];
            } else if (string11.equals("DynBPX")) {
                string7 = stringArray[1];
            } else if (string11.equals("DynBPY")) {
                string8 = stringArray[1];
            } else if (string11.startsWith("L") && PortUtil.getStringLength(string11) >= 2 && PortUtil.tryParseInt(string10 = string11.substring(1), byRef2 = new ByRef<Integer>(0))) {
                Lyric lyric = new Lyric(stringArray[1]);
                this.m_type = VsqHandleType.Lyric;
                int n2 = (Integer)byRef2.value;
                if (n2 == 0) {
                    this.L0 = lyric;
                } else {
                    this.Trailing.set(n2 - 1, lyric);
                }
            }
            if (!textStream.ready()) break;
            byRef.value = textStream.readLine().toString();
        }
        if (this.m_type == VsqHandleType.Vibrato) {
            this.RateBP = !string6.equals("") ? new VibratoBPList(string6, string4, string5) : new VibratoBPList();
            this.DepthBP = !string3.equals("") ? new VibratoBPList(string3, string, string2) : new VibratoBPList();
        } else {
            this.DepthBP = new VibratoBPList();
            this.RateBP = new VibratoBPList();
        }
        this.DynBP = !string9.equals("") ? new VibratoBPList(string9, string7, string8) : new VibratoBPList();
    }

    public static int HandleIndexFromString(String string) {
        String[] stringArray = PortUtil.splitString(string, '#');
        return PortUtil.parseInt(stringArray[1]);
    }

    public void print(BufferedWriter bufferedWriter) throws IOException {
        String string = this.toString();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }

    private void print() {
        String string = this.toString();
        PortUtil.println(string);
    }

    public String toString() {
        String string = "";
        string = string + "[h#" + PortUtil.formatDecimal("0000", this.Index) + "]";
        if (this.m_type == VsqHandleType.Lyric) {
            string = string + "\nL0=" + this.L0.toString(this.addQuotationMark);
            int n = this.Trailing.size();
            for (int i = 0; i < n; ++i) {
                string = string + "\nL" + (i + 1) + this.Trailing.get(i).toString(this.addQuotationMark);
            }
        } else if (this.m_type == VsqHandleType.Vibrato) {
            int n;
            string = string + "\nIconID=" + this.IconID + "\n";
            string = string + "IDS=" + this.IDS + "\n";
            string = string + "Original=" + this.Original + "\n";
            string = string + "Caption=" + this.Caption + "\n";
            string = string + "Length=" + this.Length + "\n";
            string = string + "StartDepth=" + this.StartDepth + "\n";
            string = string + "DepthBPNum=" + this.DepthBP.getCount() + "\n";
            if (this.DepthBP.getCount() > 0) {
                string = string + "DepthBPX=" + PortUtil.formatDecimal("0.000000", this.DepthBP.getElement((int)0).X);
                for (n = 1; n < this.DepthBP.getCount(); ++n) {
                    string = string + "," + PortUtil.formatDecimal("0.000000", this.DepthBP.getElement((int)n).X);
                }
                string = string + "\nDepthBPY=" + this.DepthBP.getElement((int)0).Y;
                for (n = 1; n < this.DepthBP.getCount(); ++n) {
                    string = string + "," + this.DepthBP.getElement((int)n).Y;
                }
                string = string + "\n";
            }
            string = string + "StartRate=" + this.StartRate + "\n";
            string = string + "RateBPNum=" + this.RateBP.getCount();
            if (this.RateBP.getCount() > 0) {
                string = string + "\nRateBPX=" + PortUtil.formatDecimal("0.000000", this.RateBP.getElement((int)0).X);
                for (n = 1; n < this.RateBP.getCount(); ++n) {
                    string = string + "," + PortUtil.formatDecimal("0.000000", this.RateBP.getElement((int)n).X);
                }
                string = string + "\nRateBPY=" + this.RateBP.getElement((int)0).Y;
                for (n = 1; n < this.RateBP.getCount(); ++n) {
                    string = string + "," + this.RateBP.getElement((int)n).Y;
                }
            }
        } else if (this.m_type == VsqHandleType.Singer) {
            string = string + "\nIconID=" + this.IconID + "\n";
            string = string + "IDS=" + this.IDS + "\n";
            string = string + "Original=" + this.Original + "\n";
            string = string + "Caption=" + this.Caption + "\n";
            string = string + "Length=" + this.Length + "\n";
            string = string + "Language=" + this.Language + "\n";
            string = string + "Program=" + this.Program;
        } else if (this.m_type == VsqHandleType.NoteHeadHandle) {
            string = string + "\nIconID=" + this.IconID + "\n";
            string = string + "IDS=" + this.IDS + "\n";
            string = string + "Original=" + this.Original + "\n";
            string = string + "Caption=" + this.Caption + "\n";
            string = string + "Length=" + this.Length + "\n";
            string = string + "Duration=" + this.Duration + "\n";
            string = string + "Depth=" + this.Depth;
        } else if (this.m_type == VsqHandleType.DynamicsHandle) {
            string = string + "\nIconID=" + this.IconID + "\n";
            string = string + "IDS=" + this.IDS + "\n";
            string = string + "Original=" + this.Original + "\n";
            string = string + "Caption=" + this.Caption + "\n";
            string = string + "StartDyn=" + this.StartDyn + "\n";
            string = string + "EndDyn=" + this.EndDyn + "\n";
            string = string + "Length=" + this.Length + "\n";
            if (this.DynBP != null) {
                if (this.DynBP.getCount() <= 0) {
                    string = string + "DynBPNum=0";
                } else {
                    int n;
                    string = string + "DynBPX=" + PortUtil.formatDecimal("0.000000", this.DynBP.getElement((int)0).X);
                    int n2 = this.DynBP.getCount();
                    for (n = 1; n < n2; ++n) {
                        string = string + "," + PortUtil.formatDecimal("0.000000", this.DynBP.getElement((int)n).X);
                    }
                    string = string + "\nDynBPY=" + this.DynBP.getElement((int)0).Y;
                    for (n = 1; n < n2; ++n) {
                        string = string + "," + this.DynBP.getElement((int)n).Y;
                    }
                }
            } else {
                string = string + "DynBPNum=0";
            }
        }
        return string;
    }
}

