/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.Serializable;

public class VsqNote
implements Serializable {
    public int Value;
    private static final int[] ALTER = new int[]{0, 1, 0, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0};
    private static final boolean[] _KEY_TYPE = new boolean[]{true, false, true, false, true, true, false, true, false, true, false, true, true, false, true, false, true, true, false, true, false, true, false, true, true, false, true, false, true, true, false, true, false, true, false, true, true, false, true, false, true, true, false, true, false, true, false, true, true, false, true, false, true, true, false, true, false, true, false, true, true, false, true, false, true, true, false, true, false, true, false, true, true, false, true, false, true, true, false, true, false, true, false, true, true, false, true, false, true, true, false, true, false, true, false, true, true, false, true, false, true, true, false, true, false, true, false, true, true, false, true, false, true, true, false, true, false, true, false, true, true, false, true, false, true, true, false, true};

    public VsqNote(int n) {
        this.Value = n;
    }

    public boolean isWhiteKey() {
        return VsqNote.isNoteWhiteKey(this.Value);
    }

    public static boolean isNoteWhiteKey(int n) {
        if (0 <= n && n <= 127) {
            return _KEY_TYPE[n];
        }
        int n2 = n % 12;
        switch (n2) {
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    public static int getNoteAlter(int n) {
        return ALTER[n % 12];
    }

    public static int getNoteOctave(int n) {
        int n2 = n % 12;
        return (n - n2) / 12 - 2;
    }

    public static String getNoteStringBase(int n) {
        int n2 = n % 12;
        switch (n2) {
            case 0: 
            case 1: {
                return "C";
            }
            case 2: {
                return "D";
            }
            case 3: 
            case 4: {
                return "E";
            }
            case 5: 
            case 6: {
                return "F";
            }
            case 7: 
            case 8: {
                return "G";
            }
            case 9: {
                return "A";
            }
            case 10: 
            case 11: {
                return "B";
            }
        }
        return "";
    }

    public static String getNoteString(int n) {
        int n2 = n % 12;
        int n3 = (n - n2) / 12 - 2;
        switch (n2) {
            case 0: {
                return "C" + n3;
            }
            case 1: {
                return "C#" + n3;
            }
            case 2: {
                return "D" + n3;
            }
            case 3: {
                return "Eb" + n3;
            }
            case 4: {
                return "E" + n3;
            }
            case 5: {
                return "F" + n3;
            }
            case 6: {
                return "F#" + n3;
            }
            case 7: {
                return "G" + n3;
            }
            case 8: {
                return "G#" + n3;
            }
            case 9: {
                return "A" + n3;
            }
            case 10: {
                return "Bb" + n3;
            }
            case 11: {
                return "B" + n3;
            }
        }
        return "";
    }

    public String toString() {
        return VsqNote.getNoteString(this.Value);
    }
}

