/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.windows.forms;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import javax.swing.JLabel;

public class BLabel
extends JLabel {
    private static final long serialVersionUID = -6416404129933688215L;
    private int drawCount = 0;
    private GlyphVector gvtext;
    private boolean autoEllipsis = false;

    public BLabel() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                BLabel.this.drawCount = 0;
                BLabel.this.repaint();
            }
        });
    }

    private GlyphVector getWrappedGlyphVector(String string, float f, Font font, FontRenderContext fontRenderContext) {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        float f2 = (float)glyphVector.getLogicalBounds().getHeight();
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n = 0;
        for (int i = 0; i < glyphVector.getNumGlyphs(); ++i) {
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(i);
            f4 = glyphMetrics.getAdvance();
            if (f3 < f && f <= f3 + f4) {
                ++n;
                f3 = 0.0f;
            }
            ((Point2D)double_).setLocation(f3, f2 * (float)n);
            glyphVector.setGlyphPosition(i, double_);
            f3 += f4;
        }
        return glyphVector;
    }

    public void setAutoEllipsis(boolean bl) {
        this.autoEllipsis = bl;
    }

    public boolean getAutoEllipsis() {
        return this.autoEllipsis;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.autoEllipsis) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.drawCount == 0) {
                Insets insets = this.getInsets();
                int n = this.getWidth() - insets.left - insets.right;
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                this.gvtext = this.getWrappedGlyphVector(this.getText(), n, this.getFont(), fontRenderContext);
                this.drawCount = 1;
            }
            graphics2D.setPaint(this.getForeground());
            graphics2D.drawGlyphVector(this.gvtext, this.getInsets().left, this.getInsets().top + this.getFont().getSize());
        } else {
            super.paintComponent(graphics);
        }
    }
}

