/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.windows.forms;

import java.util.Vector;
import javax.swing.table.TableModel;

public class BListViewItem
implements Cloneable {
    private Vector<String> subItems = new Vector();
    private Object tag;
    protected TableModel tmodel = null;
    protected int row;
    private String name = "";

    public BListViewItem(String[] stringArray) {
        this.subItems.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            this.subItems.add(stringArray[i]);
        }
    }

    protected BListViewItem(TableModel tableModel, int n) {
        this.tmodel = tableModel;
        this.row = n;
        int n2 = tableModel.getColumnCount() - 1;
        this.subItems.clear();
        for (int i = 0; i < n2; ++i) {
            this.subItems.add(tableModel.getValueAt(n, i + 1) + "");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Object clone() {
        this.updateStatusFromTableModel();
        int n = this.subItems.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.subItems.get(i);
        }
        BListViewItem bListViewItem = new BListViewItem(stringArray);
        return bListViewItem;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object object) {
        this.tag = object;
    }

    public int getSubItemCount() {
        this.updateStatusFromTableModel();
        return this.subItems.size();
    }

    private void updateStatusFromTableModel() {
        if (this.tmodel == null) {
            return;
        }
        int n = this.tmodel.getColumnCount() - 1;
        if (this.subItems.size() != n) {
            this.subItems.clear();
            this.subItems.setSize(n);
        }
        for (int i = 0; i < n; ++i) {
            this.subItems.set(i, this.tmodel.getValueAt(this.row, i + 1) + "");
        }
    }

    public String getSubItemAt(int n) {
        this.updateStatusFromTableModel();
        return this.subItems.get(n);
    }

    public void setSubItemAt(int n, String string) {
        this.updateStatusFromTableModel();
        this.subItems.set(n, string);
    }
}

