/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.xml;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.kbinani.xml.XmlMember;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSerializer {
    private Document m_document;
    private Class m_class;
    private boolean m_static_mode = false;
    private boolean m_indent = true;
    private int m_indent_width = 2;

    public boolean isIndent() {
        return this.m_indent;
    }

    public void setIndent(boolean bl) {
        this.m_indent = bl;
    }

    public int getIndentWidth() {
        return this.m_indent_width;
    }

    public void setIndentWidth(int n) {
        this.m_indent_width = n < 0 ? 0 : n;
    }

    public XmlSerializer(Class clazz) {
        this.m_class = clazz;
    }

    public Object deserialize(InputStream inputStream) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Object object = this.parseNode(this.m_class, null, document.getDocumentElement());
            return object;
        }
        catch (Exception exception) {
            System.out.println("XmlSerializer.deserialize; ex=" + exception);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object parseNode(Class clazz, Class clazz2, Node node) {
        void var9_13;
        Object t;
        Object object;
        Object object2;
        Object object4;
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        String string = node.getTextContent() + "";
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return Integer.parseInt(string);
        }
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return Byte.parseByte(string);
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return Short.parseShort(string);
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return Double.parseDouble(string);
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return Boolean.parseBoolean(string);
        }
        if (clazz.equals(String.class)) {
            return string;
        }
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, string);
        }
        if (clazz.isArray() || clazz.equals(Vector.class)) {
            Object object3;
            int n2;
            object4 = null;
            if (clazz2 == null) {
                return null;
            }
            for (Method method : clazz2.getDeclaredMethods()) {
                if (!method.getName().equals("getGenericTypeName") || !Modifier.isStatic(n2 = method.getModifiers()) || !Modifier.isPublic(n2) || !method.getReturnType().equals(String.class) || ((Class<?>[])(object3 = method.getParameterTypes())).length != 1 || !object3[0].equals(String.class)) continue;
                object4 = method;
                break;
            }
            if (object4 == null) {
                return null;
            }
            try {
                String exception = (String)object4.invoke(null, node.getNodeName());
                object2 = Class.forName(exception);
                object = new Vector();
                String string2 = XmlSerializer.getCliTypeName((Class)object2);
                if (string2.equals("")) {
                    String string3 = ((Class)object2).getSimpleName();
                }
                for (n2 = 0; n2 < n; ++n2) {
                    void var12_21;
                    Element element;
                    object3 = nodeList.item(n2);
                    if (object3.getNodeType() != 1 || !(element = (Element)object3).getTagName().equals(var12_21)) continue;
                    ((Vector)object).add(this.parseNode((Class)object2, clazz, (Node)object3));
                }
                if (clazz.isArray()) {
                    n2 = ((Vector)object).size();
                    object3 = Array.newInstance(object2, n2);
                    for (int i = 0; i < n2; ++i) {
                        Array.set(object3, i, ((Vector)object).get(i));
                    }
                    return object3;
                }
                if (clazz.equals(Vector.class)) {
                    return object;
                }
            }
            catch (Exception i) {
                System.out.println("XmlSerializer.parseNode; ex=" + i);
                return null;
            }
        }
        try {
            t = clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        object4 = XmlMember.extractMembers(clazz);
        boolean bl = false;
        while (var9_13 < n) {
            object2 = nodeList.item((int)var9_13);
            if (object2.getNodeType() == 1) {
                object = (Element)object2;
                String string4 = object.getTagName();
                for (XmlMember xmlMember : object4) {
                    if (!object.getTagName().equals(xmlMember.getName())) continue;
                    xmlMember.set(t, this.parseNode(xmlMember.getType(), clazz, (Node)object2));
                    break;
                }
            }
            ++var9_13;
        }
        return t;
    }

    public void serialize(OutputStream outputStream, Object object) throws TransformerConfigurationException, ParserConfigurationException, TransformerException, IllegalAccessException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        this.m_document = dOMImplementation.createDocument(null, this.m_class.getSimpleName(), null);
        Element element = this.m_document.getDocumentElement();
        this.parseFieldAndProperty(this.m_class, object, element);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        if (this.m_indent) {
            transformer.setOutputProperty("indent", "yes");
        }
        transformer.setOutputProperty("method", "xml");
        if (this.m_indent) {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "" + this.m_indent_width);
        }
        transformer.transform(new DOMSource(this.m_document), new StreamResult(outputStream));
    }

    private void parseFieldAndProperty(Class clazz, Object object, Element element) throws IllegalAccessException {
        XmlMember[] xmlMemberArray;
        if (object == null) {
            return;
        }
        for (XmlMember xmlMember : xmlMemberArray = XmlMember.extractMembers(clazz)) {
            String string = xmlMember.getName();
            Element element2 = this.m_document.createElement(string);
            this.printItemRecurse(xmlMember.getType(), xmlMember.get(object), element2);
            element.appendChild(element2);
        }
    }

    private void printItemRecurse(Class clazz, Object object, Element element) throws IllegalAccessException {
        try {
            if (!this.tryWriteValueType(clazz, object, element)) {
                if (clazz.isArray() || clazz.equals(Vector.class)) {
                    Object[] objectArray = null;
                    if (clazz.isArray()) {
                        objectArray = (Object[])object;
                    } else if (clazz.equals(Vector.class)) {
                        objectArray = ((Vector)object).toArray();
                    }
                    if (objectArray != null) {
                        for (Object object2 : objectArray) {
                            if (object2 == null) continue;
                            String string = XmlSerializer.getCliTypeName(object2.getClass());
                            if (string.equals("")) {
                                string = object2.getClass().getSimpleName();
                            }
                            Element element2 = this.m_document.createElement(string);
                            this.printItemRecurse(object2.getClass(), object2, element2);
                            element.appendChild(element2);
                        }
                    }
                } else {
                    this.parseFieldAndProperty(clazz, object, element);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("printItemRecurse; ex=" + exception);
        }
    }

    private static String getCliTypeName(Class clazz) {
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return "bool";
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return "double";
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return "int";
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return "long";
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return "short";
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return "float";
        }
        if (clazz.equals(String.class)) {
            return "string";
        }
        return "";
    }

    private boolean tryWriteValueType(Class clazz, Object object, Element element) {
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            element.appendChild(this.m_document.createTextNode((Boolean)object + ""));
            return true;
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            element.appendChild(this.m_document.createTextNode((Double)object + ""));
            return true;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            element.appendChild(this.m_document.createTextNode((Integer)object + ""));
            return true;
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            element.appendChild(this.m_document.createTextNode((Long)object + ""));
            return true;
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            element.appendChild(this.m_document.createTextNode((Short)object + ""));
            return true;
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            element.appendChild(this.m_document.createTextNode((Float)object + ""));
            return true;
        }
        if (clazz.equals(String.class)) {
            if (object == null) {
                element.appendChild(this.m_document.createTextNode(""));
            } else {
                element.appendChild(this.m_document.createTextNode((String)object));
            }
            return true;
        }
        if (clazz.isEnum()) {
            if (object == null) {
                for (Field field : clazz.getDeclaredFields()) {
                    String string = field.getName();
                    if (string.startsWith("$")) continue;
                    element.appendChild(this.m_document.createTextNode(string));
                    break;
                }
            } else {
                element.appendChild(this.m_document.createTextNode(object + ""));
            }
            return true;
        }
        return false;
    }
}

