/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.geom.CubicCurve2D;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kbinani.ByRef;
import org.kbinani.InternalStdErr;
import org.kbinani.InternalStdOut;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortUtil
implements AWTEventListener {
    private static boolean s_ctrl = false;
    private static boolean s_shift = false;
    private static boolean s_alt = false;
    private static PortUtil s_instance = null;
    public static Color AliceBlue = new Color(240, 248, 255);
    public static Color AntiqueWhite = new Color(250, 235, 215);
    public static Color Aqua = new Color(0, 255, 255);
    public static Color Aquamarine = new Color(127, 255, 212);
    public static Color Azure = new Color(240, 255, 255);
    public static Color Beige = new Color(245, 245, 220);
    public static Color Bisque = new Color(255, 228, 196);
    public static Color Black = new Color(0, 0, 0);
    public static Color BlanchedAlmond = new Color(255, 235, 205);
    public static Color Blue = new Color(0, 0, 255);
    public static Color BlueViolet = new Color(138, 43, 226);
    public static Color Brown = new Color(165, 42, 42);
    public static Color BurlyWood = new Color(222, 184, 135);
    public static Color CadetBlue = new Color(95, 158, 160);
    public static Color Chartreuse = new Color(127, 255, 0);
    public static Color Chocolate = new Color(210, 105, 30);
    public static Color Coral = new Color(255, 127, 80);
    public static Color CornflowerBlue = new Color(100, 149, 237);
    public static Color Cornsilk = new Color(255, 248, 220);
    public static Color Crimson = new Color(220, 20, 60);
    public static Color Cyan = new Color(0, 255, 255);
    public static Color DarkBlue = new Color(0, 0, 139);
    public static Color DarkCyan = new Color(0, 139, 139);
    public static Color DarkGoldenrod = new Color(184, 134, 11);
    public static Color DarkGray = new Color(169, 169, 169);
    public static Color DarkGreen = new Color(0, 100, 0);
    public static Color DarkKhaki = new Color(189, 183, 107);
    public static Color DarkMagenta = new Color(139, 0, 139);
    public static Color DarkOliveGreen = new Color(85, 107, 47);
    public static Color DarkOrange = new Color(255, 140, 0);
    public static Color DarkOrchid = new Color(153, 50, 204);
    public static Color DarkRed = new Color(139, 0, 0);
    public static Color DarkSalmon = new Color(233, 150, 122);
    public static Color DarkSeaGreen = new Color(143, 188, 139);
    public static Color DarkSlateBlue = new Color(72, 61, 139);
    public static Color DarkSlateGray = new Color(47, 79, 79);
    public static Color DarkTurquoise = new Color(0, 206, 209);
    public static Color DarkViolet = new Color(148, 0, 211);
    public static Color DeepPink = new Color(255, 20, 147);
    public static Color DeepSkyBlue = new Color(0, 191, 255);
    public static Color DimGray = new Color(105, 105, 105);
    public static Color DodgerBlue = new Color(30, 144, 255);
    public static Color Firebrick = new Color(178, 34, 34);
    public static Color FloralWhite = new Color(255, 250, 240);
    public static Color ForestGreen = new Color(34, 139, 34);
    public static Color Fuchsia = new Color(255, 0, 255);
    public static Color Gainsboro = new Color(220, 220, 220);
    public static Color GhostWhite = new Color(248, 248, 255);
    public static Color Gold = new Color(255, 215, 0);
    public static Color Goldenrod = new Color(218, 165, 32);
    public static Color Gray = new Color(128, 128, 128);
    public static Color Green = new Color(0, 128, 0);
    public static Color GreenYellow = new Color(173, 255, 47);
    public static Color Honeydew = new Color(240, 255, 240);
    public static Color HotPink = new Color(255, 105, 180);
    public static Color IndianRed = new Color(205, 92, 92);
    public static Color Indigo = new Color(75, 0, 130);
    public static Color Ivory = new Color(255, 255, 240);
    public static Color Khaki = new Color(240, 230, 140);
    public static Color Lavender = new Color(230, 230, 250);
    public static Color LavenderBlush = new Color(255, 240, 245);
    public static Color LawnGreen = new Color(124, 252, 0);
    public static Color LemonChiffon = new Color(255, 250, 205);
    public static Color LightBlue = new Color(173, 216, 230);
    public static Color LightCoral = new Color(240, 128, 128);
    public static Color LightCyan = new Color(224, 255, 255);
    public static Color LightGoldenrodYellow = new Color(250, 250, 210);
    public static Color LightGreen = new Color(144, 238, 144);
    public static Color LightGray = new Color(211, 211, 211);
    public static Color LightPink = new Color(255, 182, 193);
    public static Color LightSalmon = new Color(255, 160, 122);
    public static Color LightSeaGreen = new Color(32, 178, 170);
    public static Color LightSkyBlue = new Color(135, 206, 250);
    public static Color LightSlateGray = new Color(119, 136, 153);
    public static Color LightSteelBlue = new Color(176, 196, 222);
    public static Color LightYellow = new Color(255, 255, 224);
    public static Color Lime = new Color(0, 255, 0);
    public static Color LimeGreen = new Color(50, 205, 50);
    public static Color Linen = new Color(250, 240, 230);
    public static Color Magenta = new Color(255, 0, 255);
    public static Color Maroon = new Color(128, 0, 0);
    public static Color MediumAquamarine = new Color(102, 205, 170);
    public static Color MediumBlue = new Color(0, 0, 205);
    public static Color MediumOrchid = new Color(186, 85, 211);
    public static Color MediumPurple = new Color(147, 112, 219);
    public static Color MediumSeaGreen = new Color(60, 179, 113);
    public static Color MediumSlateBlue = new Color(123, 104, 238);
    public static Color MediumSpringGreen = new Color(0, 250, 154);
    public static Color MediumTurquoise = new Color(72, 209, 204);
    public static Color MediumVioletRed = new Color(199, 21, 133);
    public static Color MidnightBlue = new Color(25, 25, 112);
    public static Color MintCream = new Color(245, 255, 250);
    public static Color MistyRose = new Color(255, 228, 225);
    public static Color Moccasin = new Color(255, 228, 181);
    public static Color NavajoWhite = new Color(255, 222, 173);
    public static Color Navy = new Color(0, 0, 128);
    public static Color OldLace = new Color(253, 245, 230);
    public static Color Olive = new Color(128, 128, 0);
    public static Color OliveDrab = new Color(107, 142, 35);
    public static Color Orange = new Color(255, 165, 0);
    public static Color OrangeRed = new Color(255, 69, 0);
    public static Color Orchid = new Color(218, 112, 214);
    public static Color PaleGoldenrod = new Color(238, 232, 170);
    public static Color PaleGreen = new Color(152, 251, 152);
    public static Color PaleTurquoise = new Color(175, 238, 238);
    public static Color PaleVioletRed = new Color(219, 112, 147);
    public static Color PapayaWhip = new Color(255, 239, 213);
    public static Color PeachPuff = new Color(255, 218, 185);
    public static Color Peru = new Color(205, 133, 63);
    public static Color Pink = new Color(255, 192, 203);
    public static Color Plum = new Color(221, 160, 221);
    public static Color PowderBlue = new Color(176, 224, 230);
    public static Color Purple = new Color(128, 0, 128);
    public static Color Red = new Color(255, 0, 0);
    public static Color RosyBrown = new Color(188, 143, 143);
    public static Color RoyalBlue = new Color(65, 105, 225);
    public static Color SaddleBrown = new Color(139, 69, 19);
    public static Color Salmon = new Color(250, 128, 114);
    public static Color SandyBrown = new Color(244, 164, 96);
    public static Color SeaGreen = new Color(46, 139, 87);
    public static Color SeaShell = new Color(255, 245, 238);
    public static Color Sienna = new Color(160, 82, 45);
    public static Color Silver = new Color(192, 192, 192);
    public static Color SkyBlue = new Color(135, 206, 235);
    public static Color SlateBlue = new Color(106, 90, 205);
    public static Color SlateGray = new Color(112, 128, 144);
    public static Color Snow = new Color(255, 250, 250);
    public static Color SpringGreen = new Color(0, 255, 127);
    public static Color SteelBlue = new Color(70, 130, 180);
    public static Color Tan = new Color(210, 180, 140);
    public static Color Teal = new Color(0, 128, 128);
    public static Color Thistle = new Color(216, 191, 216);
    public static Color Tomato = new Color(255, 99, 71);
    public static Color Turquoise = new Color(64, 224, 208);
    public static Color Violet = new Color(238, 130, 238);
    public static Color Wheat = new Color(245, 222, 179);
    public static Color White = new Color(255, 255, 255);
    public static Color WhiteSmoke = new Color(245, 245, 245);
    public static Color Yellow = new Color(255, 255, 0);
    public static Color YellowGreen = new Color(154, 205, 50);
    public static InternalStdOut stdout = new InternalStdOut();
    public static InternalStdErr stderr = new InternalStdErr();
    public static final int MSGBOX_DEFAULT_OPTION = -1;
    public static final int MSGBOX_YES_NO_OPTION = 0;
    public static final int MSGBOX_YES_NO_CANCEL_OPTION = 1;
    public static final int MSGBOX_OK_CANCEL_OPTION = 2;
    public static final int MSGBOX_ERROR_MESSAGE = 0;
    public static final int MSGBOX_INFORMATION_MESSAGE = 1;
    public static final int MSGBOX_WARNING_MESSAGE = 2;
    public static final int MSGBOX_QUESTION_MESSAGE = 3;
    public static final int MSGBOX_PLAIN_MESSAGE = -1;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int CLOSED_OPTION = -1;
    public static final int STRING_ALIGN_FAR = 1;
    public static final int STRING_ALIGN_NEAR = -1;
    public static final int STRING_ALIGN_CENTER = 0;

    private PortUtil() {
    }

    public static BDialogResult showMessageBox(String string, String string2, int n, int n2) {
        BDialogResult bDialogResult = BDialogResult.CANCEL;
        int n3 = JOptionPane.showConfirmDialog(null, string, string2, n, n2);
        if (n3 == 0) {
            bDialogResult = BDialogResult.YES;
        } else if (n3 == 1) {
            bDialogResult = BDialogResult.NO;
        } else if (n3 == 2) {
            bDialogResult = BDialogResult.CANCEL;
        } else if (n3 == 0) {
            bDialogResult = BDialogResult.OK;
        } else if (n3 == -1) {
            bDialogResult = BDialogResult.CANCEL;
        }
        return bDialogResult;
    }

    public static String getComponentName(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Component) {
            String string = ((Component)object).getName();
            if (string == null) {
                string = "";
            }
            return string;
        }
        return "";
    }

    public static String formatMessage(String string, Object ... objectArray) {
        return MessageFormat.format(string, objectArray);
    }

    public static double getCurrentTime() {
        return new Date().getTime();
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getID();
            if (n2 == 401) {
                if (n == 18) {
                    s_alt = true;
                } else if (n == 17) {
                    s_ctrl = true;
                } else if (n == 16) {
                    s_shift = true;
                }
            } else if (n2 == 402) {
                if (n == 18) {
                    s_alt = false;
                } else if (n == 17) {
                    s_ctrl = false;
                } else if (n == 16) {
                    s_shift = false;
                }
            }
        }
    }

    public static int getCurrentModifierKey() {
        int n = 0;
        if (s_ctrl) {
            n += 2;
        }
        if (s_alt) {
            n += 8;
        }
        if (s_shift) {
            ++n;
        }
        return n;
    }

    public static Rectangle getScreenBounds(Component component) {
        return component.getGraphicsConfiguration().getBounds();
    }

    public static void setClipboardText(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(string), null);
    }

    public static void clearClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(null), null);
    }

    public static boolean isClipboardContainsText() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        return transferable == null || !transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public static String getClipboardText() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        String string = null;
        if (transferable == null || !transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            string = null;
        } else {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                string = null;
            }
        }
        return string;
    }

    public static byte[] getbytes_int64_le(long l) {
        byte[] byArray = new byte[]{(byte)(l & 0xFFFFFFFFFFFFFFFFL), (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL), (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL), (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL), (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL), (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL), (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL), (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL)};
        return byArray;
    }

    public static byte[] getbytes_uint32_le(long l) {
        byte[] byArray = new byte[4];
        l = 0xFFFFFFFFFFFFFFFFL & l;
        byArray[0] = (byte)(l & 0xFFFFFFFFFFFFFFFFL);
        byArray[1] = (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL);
        byArray[2] = (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL);
        byArray[3] = (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL);
        return byArray;
    }

    public static byte[] getbytes_int32_le(int n) {
        long l = n;
        if (l < 0L) {
            l += 0x100000000L;
        }
        return PortUtil.getbytes_uint32_le(l);
    }

    public static byte[] getbytes_int32_be(int n) {
        long l = n;
        if (l < 0L) {
            l += 0x100000000L;
        }
        return PortUtil.getbytes_uint32_be(l);
    }

    public static byte[] getbytes_int64_be(long l) {
        byte[] byArray = new byte[8];
        byArray[7] = (byte)(l & 0xFFFFFFFFFFFFFFFFL);
        byArray[6] = (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL);
        byArray[5] = (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL);
        byArray[4] = (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL);
        byArray[3] = (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL);
        byArray[2] = (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL);
        byArray[1] = (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL);
        byArray[0] = (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL);
        return byArray;
    }

    public static byte[] getbytes_uint32_be(long l) {
        byte[] byArray = new byte[4];
        l = 0xFFFFFFFFFFFFFFFFL & l;
        byArray[3] = (byte)(l & 0xFFFFFFFFFFFFFFFFL);
        byArray[2] = (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL);
        byArray[1] = (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL);
        byArray[0] = (byte)((l >>>= 8) & 0xFFFFFFFFFFFFFFFFL);
        return byArray;
    }

    public static byte[] getbytes_int16_le(short n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 65536;
        }
        return PortUtil.getbytes_uint16_le(n2);
    }

    public static byte[] getbytes_uint16_le(int n) {
        byte[] byArray = new byte[2];
        byArray[0] = (byte)(n & 0xFFFFFFFF);
        n = (byte)(n >>> 8);
        byArray[1] = (byte)(n & 0xFFFFFFFF);
        return byArray;
    }

    public static byte[] getbytes_uint16_be(int n) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(n & 0xFFFFFFFF);
        n = (byte)(n >>> 8);
        byArray[0] = (byte)(n & 0xFFFFFFFF);
        return byArray;
    }

    public static long make_int64_le(byte[] byArray) {
        return ((((((long)((byArray[7] << 8 | byArray[6]) << 8) | (long)byArray[5]) << 8 | (long)byArray[4]) << 8 | (long)byArray[3]) << 8 | (long)byArray[2]) << 8 | (long)byArray[1]) << 8 | (long)byArray[0];
    }

    public static long make_int64_be(byte[] byArray) {
        return ((((((long)((byArray[0] << 8 | byArray[1]) << 8) | (long)byArray[2]) << 8 | (long)byArray[3]) << 8 | (long)byArray[4]) << 8 | (long)byArray[5]) << 8 | (long)byArray[6]) << 8 | (long)byArray[7];
    }

    public static long make_uint32_le(byte[] byArray) {
        return ((long)(byArray[3] << 8 | byArray[2]) << 8 | (long)byArray[1]) << 8 | (long)byArray[0];
    }

    public static long make_uint32_be(byte[] byArray) {
        return ((long)(byArray[0] << 8 | byArray[1]) << 8 | (long)byArray[2]) << 8 | (long)byArray[3];
    }

    public static int make_int32_le(byte[] byArray) {
        long l = PortUtil.make_uint32_le(byArray);
        if (l >= Integer.MAX_VALUE) {
            l -= 0x100000000L;
        }
        return (int)l;
    }

    public static int make_uint16_le(byte[] byArray) {
        return byArray[1] << 8 | byArray[0];
    }

    public static int make_uint16_be(byte[] byArray) {
        return byArray[0] << 8 | byArray[1];
    }

    public static short make_int16_le(byte[] byArray) {
        int n = PortUtil.make_uint16_le(byArray);
        if (n >= 32768) {
            n -= 65536;
        }
        return (short)n;
    }

    public static double make_double_le(byte[] byArray) {
        long l = 0L;
        for (int i = 7; i >= 0; --i) {
            l = l << 8 | (long)byArray[i] & 0xFFL;
        }
        return Double.longBitsToDouble(l);
    }

    public static double make_double_be(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i <= 7; ++i) {
            l = l << 8 | (long)byArray[i] & 0xFFL;
        }
        return Double.longBitsToDouble(l);
    }

    public static float make_float_le(byte[] byArray) {
        int n = 0;
        for (int i = 3; i >= 0; --i) {
            n = n << 8 | byArray[i] & 0xFF;
        }
        return Float.intBitsToFloat(n);
    }

    public static float make_float_be(byte[] byArray) {
        int n = 0;
        for (int i = 0; i <= 3; ++i) {
            n = n << 8 | byArray[i] & 0xFF;
        }
        return Float.intBitsToFloat(n);
    }

    public static byte[] getbytes_double_le(double d) {
        long l = Double.doubleToLongBits(d);
        return PortUtil.getbytes_int64_le(l);
    }

    public static byte[] getbytes_double_be(double d) {
        long l = Double.doubleToLongBits(d);
        return PortUtil.getbytes_int64_be(l);
    }

    public static byte[] getbytes_float_le(float f) {
        int n = Float.floatToIntBits(f);
        return PortUtil.getbytes_int32_le(n);
    }

    public static byte[] getbytes_float_be(float f) {
        int n = Float.floatToIntBits(f);
        return PortUtil.getbytes_int32_be(n);
    }

    public static KeyStroke getKeyStrokeFromBKeys(BKeys[] bKeysArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < bKeysArray.length; ++i) {
            if (bKeysArray[i] == BKeys.Alt) {
                n += 8;
                continue;
            }
            if (bKeysArray[i] == BKeys.Control) {
                n += 2;
                continue;
            }
            if (bKeysArray[i] == BKeys.Shift) {
                ++n;
                continue;
            }
            n2 = bKeysArray[i].getValue();
        }
        return KeyStroke.getKeyStroke(n2, n);
    }

    public static BKeys[] getBKeysFromKeyStroke(KeyStroke keyStroke) {
        Vector<BKeys> vector = new Vector<BKeys>();
        int n = keyStroke.getKeyCode();
        int n2 = keyStroke.getModifiers();
        vector.add(PortUtil.getBKeysFromKeyCode(n));
        if ((n2 & 8) == 8) {
            vector.add(BKeys.Alt);
        }
        if ((n2 & 2) == 2) {
            vector.add(BKeys.Control);
        }
        if ((n2 & 1) == 1) {
            vector.add(BKeys.Shift);
        }
        return vector.toArray(new BKeys[0]);
    }

    public static int getKeyCodeFromBKeys(BKeys bKeys) {
        return bKeys.getValue();
    }

    public static BKeys getBKeysFromKeyCode(int n) {
        switch (n) {
            case 0: {
                return BKeys.None;
            }
            case 1: {
                return BKeys.LButton;
            }
            case 2: {
                return BKeys.RButton;
            }
            case 3: {
                return BKeys.Cancel;
            }
            case 4: {
                return BKeys.MButton;
            }
            case 8: {
                return BKeys.Back;
            }
            case 9: {
                return BKeys.Tab;
            }
            case 10: {
                return BKeys.LineFeed;
            }
            case 12: {
                return BKeys.Clear;
            }
            case 16: {
                return BKeys.ShiftKey;
            }
            case 17: {
                return BKeys.ControlKey;
            }
            case 18: {
                return BKeys.Menu;
            }
            case 19: {
                return BKeys.Pause;
            }
            case 20: {
                return BKeys.CapsLock;
            }
            case 21: {
                return BKeys.KanaMode;
            }
            case 24: {
                return BKeys.FinalMode;
            }
            case 25: {
                return BKeys.KanjiMode;
            }
            case 27: {
                return BKeys.Escape;
            }
            case 28: {
                return BKeys.IMEConvert;
            }
            case 29: {
                return BKeys.IMENonconvert;
            }
            case 30: {
                return BKeys.IMEAccept;
            }
            case 31: {
                return BKeys.IMEModeChange;
            }
            case 32: {
                return BKeys.Space;
            }
            case 33: {
                return BKeys.PageUp;
            }
            case 34: {
                return BKeys.PageDown;
            }
            case 35: {
                return BKeys.End;
            }
            case 36: {
                return BKeys.Home;
            }
            case 37: {
                return BKeys.Left;
            }
            case 38: {
                return BKeys.Up;
            }
            case 39: {
                return BKeys.Right;
            }
            case 40: {
                return BKeys.Down;
            }
            case 48: {
                return BKeys.D0;
            }
            case 49: {
                return BKeys.D1;
            }
            case 50: {
                return BKeys.D2;
            }
            case 51: {
                return BKeys.D3;
            }
            case 52: {
                return BKeys.D4;
            }
            case 53: {
                return BKeys.D5;
            }
            case 54: {
                return BKeys.D6;
            }
            case 55: {
                return BKeys.D7;
            }
            case 56: {
                return BKeys.D8;
            }
            case 57: {
                return BKeys.D9;
            }
            case 65: {
                return BKeys.A;
            }
            case 66: {
                return BKeys.B;
            }
            case 67: {
                return BKeys.C;
            }
            case 68: {
                return BKeys.D;
            }
            case 69: {
                return BKeys.E;
            }
            case 70: {
                return BKeys.F;
            }
            case 71: {
                return BKeys.G;
            }
            case 72: {
                return BKeys.H;
            }
            case 73: {
                return BKeys.I;
            }
            case 74: {
                return BKeys.J;
            }
            case 75: {
                return BKeys.K;
            }
            case 76: {
                return BKeys.L;
            }
            case 77: {
                return BKeys.M;
            }
            case 78: {
                return BKeys.N;
            }
            case 79: {
                return BKeys.O;
            }
            case 80: {
                return BKeys.P;
            }
            case 81: {
                return BKeys.Q;
            }
            case 82: {
                return BKeys.R;
            }
            case 83: {
                return BKeys.S;
            }
            case 84: {
                return BKeys.T;
            }
            case 85: {
                return BKeys.U;
            }
            case 86: {
                return BKeys.V;
            }
            case 87: {
                return BKeys.W;
            }
            case 88: {
                return BKeys.X;
            }
            case 89: {
                return BKeys.Y;
            }
            case 90: {
                return BKeys.Z;
            }
            case 91: {
                return BKeys.LWin;
            }
            case 92: {
                return BKeys.RWin;
            }
            case 93: {
                return BKeys.Apps;
            }
            case 96: {
                return BKeys.NumPad0;
            }
            case 97: {
                return BKeys.NumPad1;
            }
            case 98: {
                return BKeys.NumPad2;
            }
            case 99: {
                return BKeys.NumPad3;
            }
            case 100: {
                return BKeys.NumPad4;
            }
            case 101: {
                return BKeys.NumPad5;
            }
            case 102: {
                return BKeys.NumPad6;
            }
            case 103: {
                return BKeys.NumPad7;
            }
            case 104: {
                return BKeys.NumPad8;
            }
            case 105: {
                return BKeys.NumPad9;
            }
            case 106: {
                return BKeys.Multiply;
            }
            case 107: {
                return BKeys.Add;
            }
            case 108: {
                return BKeys.Separator;
            }
            case 109: {
                return BKeys.Subtract;
            }
            case 110: {
                return BKeys.Decimal;
            }
            case 111: {
                return BKeys.Divide;
            }
            case 112: {
                return BKeys.F1;
            }
            case 113: {
                return BKeys.F2;
            }
            case 114: {
                return BKeys.F3;
            }
            case 115: {
                return BKeys.F4;
            }
            case 116: {
                return BKeys.F5;
            }
            case 117: {
                return BKeys.F6;
            }
            case 118: {
                return BKeys.F7;
            }
            case 119: {
                return BKeys.F8;
            }
            case 120: {
                return BKeys.F9;
            }
            case 121: {
                return BKeys.F10;
            }
            case 122: {
                return BKeys.F11;
            }
            case 123: {
                return BKeys.F12;
            }
            case 127: {
                return BKeys.F16;
            }
            case 128: {
                return BKeys.F17;
            }
            case 129: {
                return BKeys.F18;
            }
            case 130: {
                return BKeys.F19;
            }
            case 131: {
                return BKeys.F20;
            }
            case 132: {
                return BKeys.F21;
            }
            case 133: {
                return BKeys.F22;
            }
            case 134: {
                return BKeys.F23;
            }
            case 135: {
                return BKeys.F24;
            }
            case 144: {
                return BKeys.NumLock;
            }
            case 145: {
                return BKeys.Scroll;
            }
            case 160: {
                return BKeys.LShiftKey;
            }
            case 161: {
                return BKeys.RShiftKey;
            }
            case 162: {
                return BKeys.LControlKey;
            }
            case 192: {
                return BKeys.Oemtilde;
            }
            case 222: {
                return BKeys.OemQuotes;
            }
        }
        return BKeys.None;
    }

    public static void drawBezier(Graphics2D graphics2D, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        graphics2D.draw(new CubicCurve2D.Float(f, f2, f3, f4, f5, f6, f7, f8));
    }

    public static void drawStringEx(Graphics graphics, String string, Font font, Rectangle rectangle, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Dimension dimension = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
        float f = 0.0f;
        float f2 = 0.0f;
        f = n > 0 ? (float)(rectangle.x + rectangle.width - dimension.width) : (n < 0 ? (float)rectangle.x : (float)rectangle.x + (float)rectangle.width / 2.0f - (float)dimension.width / 2.0f);
        f2 = n2 > 0 ? (float)(rectangle.y + rectangle.height - dimension.height) : (n2 < 0 ? (float)rectangle.y : (float)rectangle.y + (float)rectangle.height / 2.0f - (float)dimension.height / 2.0f);
        graphics2D.drawString(string, f, f2);
    }

    public static double getFileLastModified(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.lastModified();
        }
        return 0.0;
    }

    public static long getFileLength(String string) {
        File file = new File(string);
        return file.length();
    }

    public static String getExtension(String string) {
        String string2 = new File(string).getName();
        int n = string2.lastIndexOf(46);
        if (n <= 0) {
            return "";
        }
        return string2.substring(n);
    }

    public static String getFileName(String string) {
        File file = new File(string);
        return file.getName();
    }

    public static String getDirectoryName(String string) {
        File file = new File(string);
        return file.getParent();
    }

    public static String getFileNameWithoutExtension(String string) {
        String string2 = PortUtil.getFileName(string);
        int n = string2.lastIndexOf(string2);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static String createTempFile() {
        String string = "";
        try {
            File.createTempFile("tmp", "").getAbsolutePath();
        }
        catch (Exception exception) {
            System.out.println("PortUtil#createTempFile; ex=" + exception);
        }
        return string;
    }

    public static String[] listFiles(String string, String string2) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            String string3;
            File file2 = fileArray[i];
            if (file2.isDirectory() || !(string3 = file2.getName()).endsWith(string2)) continue;
            vector.add(string3);
        }
        return vector.toArray(new String[0]);
    }

    public static void deleteFile(String string) {
        new File(string).delete();
    }

    public static void moveFile(String string, String string2) throws FileNotFoundException, IOException {
        PortUtil.copyFile(string, string2);
        PortUtil.deleteFile(string);
    }

    public static boolean isDirectoryExists(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.isFile();
        }
        return false;
    }

    public static boolean isFileExists(String string) {
        return new File(string).exists();
    }

    public static String combinePath(String string, String string2) {
        if (string != null && string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        if (string2 != null && string2.startsWith(File.separator)) {
            string2 = string2.substring(1);
        }
        return string + File.separator + string2;
    }

    public static String getTempPath() {
        String string = System.getProperty("java.io.tmpdir");
        if (string == null) {
            return "";
        }
        return string;
    }

    public static void createDirectory(String string) {
        File file = new File(string);
        file.mkdir();
    }

    public static void deleteDirectory(String string, boolean bl) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = new File(PortUtil.combinePath(string, fileArray[i].getName()));
            if (file2.isDirectory()) {
                PortUtil.deleteDirectory(file2.getPath(), true);
                continue;
            }
            file2.delete();
        }
    }

    public static void deleteDirectory(String string) {
        new File(string).delete();
    }

    public static void copyFile(String string, String string2) throws FileNotFoundException, IOException {
        FileChannel fileChannel = new FileInputStream(new File(string)).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(new File(string2)).getChannel();
        fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        fileChannel.close();
        fileChannel2.close();
    }

    public static boolean tryParseInt(String string, ByRef<Integer> byRef) {
        try {
            byRef.value = PortUtil.parseInt(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean tryParseFloat(String string, ByRef<Float> byRef) {
        try {
            byRef.value = Float.valueOf(PortUtil.parseFloat(string));
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static int parseInt(String string) {
        return Integer.parseInt(string);
    }

    public static float parseFloat(String string) {
        return Float.parseFloat(string);
    }

    public static double parseDouble(String string) {
        return Double.parseDouble(string);
    }

    public static String formatDecimal(String string, double d) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(d);
    }

    public static String formatDecimal(String string, long l) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(l);
    }

    public static String toHexString(long l, int n) {
        String string = PortUtil.toHexString(l);
        int n2 = n - PortUtil.getStringLength(string);
        for (int i = 0; i < n2; ++i) {
            string = "0" + string;
        }
        return string;
    }

    public static String toHexString(long l) {
        return Long.toHexString(l);
    }

    public static long fromHexString(String string) {
        return Long.parseLong(string, 16);
    }

    public static String[] splitString(String string, char ... cArray) {
        return PortUtil.splitStringCorB(string, cArray, Integer.MAX_VALUE, false);
    }

    public static String[] splitString(String string, char[] cArray, int n) {
        return PortUtil.splitStringCorB(string, cArray, n, false);
    }

    public static String[] splitString(String string, char[] cArray, boolean bl) {
        return PortUtil.splitStringCorB(string, cArray, Integer.MAX_VALUE, bl);
    }

    public static String[] splitString(String string, String[] stringArray, boolean bl) {
        return PortUtil.splitStringCorA(string, stringArray, Integer.MAX_VALUE, bl);
    }

    public static String[] splitString(String string, char[] cArray, int n, boolean bl) {
        return PortUtil.splitStringCorB(string, cArray, n, bl);
    }

    public static String[] splitString(String string, String[] stringArray, int n, boolean bl) {
        return PortUtil.splitStringCorA(string, stringArray, n, bl);
    }

    private static String[] splitStringCorB(String string, char[] cArray, int n, boolean bl) {
        int n2 = cArray.length;
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = cArray[i] + "";
        }
        return PortUtil.splitStringCorA(string, stringArray, n, false);
    }

    private static String[] splitStringCorA(String string, String[] stringArray, int n, boolean bl) {
        if (stringArray.length == 0) {
            return new String[]{string};
        }
        Vector<String> vector = new Vector<String>();
        String string2 = string;
        int n2 = stringArray.length;
        int n3 = string2.indexOf(stringArray[0]);
        int n4 = 1;
        while (n3 < 0 && n4 < stringArray.length) {
            n3 = string2.indexOf(stringArray[n4]);
        }
        int n5 = 0;
        while (n3 >= 0) {
            if (!bl || bl && n3 > 0) {
                if (n5 + 1 == n) break;
                vector.add(string2.substring(0, n3));
                ++n5;
            }
            string2 = string2.substring(n3 + n2);
            n3 = string2.indexOf(stringArray[0]);
            n4 = 1;
            while (n3 < 0 && n4 < stringArray.length) {
                n3 = string2.indexOf(stringArray[n4]);
            }
        }
        if (!bl || bl && string2.length() > 0) {
            vector.add(string2);
        }
        return vector.toArray(new String[0]);
    }

    public static int getStringLength(String string) {
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    public static int getEncodedByteCount(String string, String string2) {
        byte[] byArray = PortUtil.getEncodedByte(string, string2);
        return byArray.length;
    }

    public static byte[] getEncodedByte(String string, String string2) {
        Charset charset = Charset.forName(string);
        ByteBuffer byteBuffer = charset.encode(string2);
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static String getDecodedString(String string, byte[] byArray, int n, int n2) {
        Charset charset = Charset.forName(string);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.put(byArray, n, n2);
        return charset.decode(byteBuffer).toString();
    }

    public static String getDecodedString(String string, byte[] byArray) {
        return PortUtil.getDecodedString(string, byArray, 0, byArray.length);
    }

    public static void setMousePosition(Point point) {
    }

    public static Point getMousePosition() {
        return MouseInfo.getPointerInfo().getLocation();
    }

    public static boolean isPointInScreens(Point point) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i];
            Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
            if (rectangle.x > point.x || point.x > rectangle.x + rectangle.width || rectangle.y > point.y || point.y > rectangle.y + rectangle.height) continue;
            return true;
        }
        return false;
    }

    public static Rectangle getWorkingArea(Window window) {
        return window.getGraphicsConfiguration().getBounds();
    }

    public static String getMD5FromString(String string) {
        byte[] byArray;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            byArray = PortUtil.getEncodedByte("UTF-8", string);
            messageDigest.update(byArray, 0, byArray.length);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("PortUtil#getMD5FromString; ex2=" + noSuchAlgorithmException);
        }
        byArray = messageDigest.digest();
        String string2 = "";
        for (int i = 0; i < byArray.length; ++i) {
            string2 = string2 + String.format("%02x", byArray[i]);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(String string) throws FileNotFoundException, IOException {
        byte[] byArray;
        FileInputStream fileInputStream = new FileInputStream(string);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            byArray = new byte[4096];
            int n = 0;
            while ((n = ((InputStream)fileInputStream).read(byArray, 0, byArray.length)) >= 0) {
                messageDigest.update(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("PortUtil#getMD5; ex2=" + noSuchAlgorithmException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        byArray = messageDigest.digest();
        String string2 = "";
        for (int i = 0; i < byArray.length; ++i) {
            string2 = string2 + String.format("%02x", byArray[i]);
        }
        return string2;
    }

    public static Integer[] convertIntArray(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    public static Long[] convertLongArray(long[] lArray) {
        Long[] longArray = new Long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            longArray[i] = lArray[i];
        }
        return longArray;
    }

    public static Byte[] convertByteArray(byte[] byArray) {
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = byArray[i];
        }
        return byteArray;
    }

    public static Float[] convertFloatArray(float[] fArray) {
        Float[] floatArray = new Float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            floatArray[i] = Float.valueOf(fArray[i]);
        }
        return floatArray;
    }

    public static Character[] convertCharArray(char[] cArray) {
        Character[] characterArray = new Character[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            characterArray[i] = Character.valueOf(cArray[i]);
        }
        return characterArray;
    }

    public static int[] convertIntArray(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    public static long[] convertLongArray(Long[] longArray) {
        long[] lArray = new long[longArray.length];
        for (int i = 0; i < longArray.length; ++i) {
            lArray[i] = longArray[i];
        }
        return lArray;
    }

    public static byte[] convertByteArray(Byte[] byteArray) {
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        return byArray;
    }

    public static float[] convertFloatArray(Float[] floatArray) {
        float[] fArray = new float[floatArray.length];
        for (int i = 0; i < floatArray.length; ++i) {
            fArray[i] = floatArray[i].floatValue();
        }
        return fArray;
    }

    public static char[] convertFloatArray(Character[] characterArray) {
        char[] cArray = new char[characterArray.length];
        for (int i = 0; i < characterArray.length; ++i) {
            cArray[i] = characterArray[i].charValue();
        }
        return cArray;
    }

    public static String getApplicationStartupPath() {
        return System.getProperty("user.dir");
    }

    public static void println(String string) {
        System.out.println(string);
    }

    static {
        s_instance = new PortUtil();
        Toolkit.getDefaultToolkit().addAWTEventListener(s_instance, 8L);
    }

    class FileFilterImp
    implements FileFilter {
        private String m_extension;

        public FileFilterImp(String string) {
            this.m_extension = string;
        }

        public boolean accept(File file) {
            String string = file.getName();
            return string.endsWith(this.m_extension);
        }
    }
}

