/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.apputil;

import java.awt.Graphics2D;

public class PolylineDrawer {
    int length = 1024;
    int[] xPoints;
    int[] yPoints;
    int pos = 0;
    Graphics2D g;

    public PolylineDrawer(Graphics2D graphics2D, int n) {
        this.g = graphics2D;
        this.length = n;
        if (this.length < 2) {
            this.length = 1024;
        }
        this.xPoints = new int[this.length];
        this.yPoints = new int[this.length];
        this.pos = 0;
    }

    public void clear() {
        this.pos = 0;
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    public void append(int n, int n2) {
        this.xPoints[this.pos] = n;
        this.yPoints[this.pos] = n2;
        ++this.pos;
        if (this.length <= this.pos) {
            this.flush();
        }
    }

    public void flush() {
        if (this.pos <= 1) {
            return;
        }
        int n = this.xPoints[this.pos - 1];
        int n2 = this.yPoints[this.pos - 1];
        this.g.drawPolyline(this.xPoints, this.yPoints, this.pos);
        this.xPoints[0] = n;
        this.yPoints[0] = n2;
        this.pos = 1;
    }
}

