/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Color;
import java.util.Collections;
import java.util.Vector;
import org.kbinani.ByRef;
import org.kbinani.cadencii.BezierControlType;
import org.kbinani.cadencii.BezierPoint;
import org.kbinani.cadencii.PointD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BezierChain
implements Cloneable {
    public Vector<BezierPoint> points = new Vector();
    public double Default;
    public int id;
    private Color m_color;
    static final double EPSILON = 1.0E-9;

    public double getStart() {
        if (this.points.size() <= 0) {
            return Double.NaN;
        }
        return this.points.get(0).getBase().getX();
    }

    public double getEnd() {
        if (this.points.size() <= 0) {
            return Double.NaN;
        }
        return this.points.get(this.points.size() - 1).getBase().getX();
    }

    public static PointD[] cutUnitBezier(PointD pointD, PointD pointD2, PointD pointD3, PointD pointD4, double d) {
        if (pointD.getX() >= d || d >= pointD4.getX()) {
            return null;
        }
        PointD[] pointDArray = new PointD[7];
        for (int i = 0; i < 7; ++i) {
            pointDArray[i] = new PointD();
        }
        pointDArray[0].setX(pointD.getX());
        pointDArray[0].setY(pointD.getY());
        pointDArray[6].setX(pointD4.getX());
        pointDArray[6].setY(pointD4.getY());
        double d2 = pointD.getX();
        double d3 = pointD2.getX();
        double d4 = pointD3.getX();
        double d5 = pointD4.getX();
        double d6 = d5 - 3.0 * d4 + 3.0 * d3 - d2;
        double d7 = 3.0 * d4 - 6.0 * d3 + 3.0 * d2;
        double d8 = 3.0 * (d3 - d2);
        double d9 = d2;
        double d10 = BezierChain.solveCubicEquation(d6, d7, d8, d9, d);
        d2 = pointD.getY();
        d3 = pointD2.getY();
        d4 = pointD3.getY();
        d5 = pointD4.getY();
        d6 = d5 - 3.0 * d4 + 3.0 * d3 - d2;
        d7 = 3.0 * d4 - 6.0 * d3 + 3.0 * d2;
        d8 = 3.0 * (d3 - d2);
        d9 = d2;
        pointDArray[3].setX(d);
        pointDArray[3].setY(((d6 * d10 + d7) * d10 + d8) * d10 + d9);
        pointDArray[1] = BezierChain.getMidPoint(pointD, pointD2, d10);
        pointDArray[5] = BezierChain.getMidPoint(pointD3, pointD4, d10);
        PointD pointD5 = BezierChain.getMidPoint(pointD2, pointD3, d10);
        pointDArray[2] = BezierChain.getMidPoint(pointDArray[1], pointD5, d10);
        pointDArray[4] = BezierChain.getMidPoint(pointD5, pointDArray[5], d10);
        return pointDArray;
    }

    private static PointD getMidPoint(PointD pointD, PointD pointD2, double d) {
        double d2 = pointD.getX() + (pointD2.getX() - pointD.getX()) * d;
        double d3 = pointD.getY() + (pointD2.getY() - pointD.getY()) * d;
        return new PointD(d2, d3);
    }

    public BezierChain extractPartialBezier(double d, double d2) throws Exception {
        int n;
        if (this.size() <= 1) {
            throw new Exception("chain must has two or more bezier points");
        }
        double d3 = this.points.get(0).getBase().getX();
        double d4 = this.points.get(this.size() - 1).getBase().getX();
        if (d3 > d || d2 > d4) {
            throw new Exception("no bezier point appeared in the range of \"from\" to \"to\"");
        }
        boolean bl = false;
        BezierChain bezierChain = new BezierChain(this.m_color);
        int n2 = 0;
        for (n = 0; n < this.points.size() - 1; ++n) {
            BezierPoint bezierPoint;
            PointD[] pointDArray;
            PointD pointD;
            PointD pointD2;
            PointD pointD3;
            PointD pointD4;
            if (this.points.get(n).getBase().getX() < d && d < this.points.get(n + 1).getBase().getX()) {
                BezierPoint bezierPoint2;
                if (this.points.get(n).getBase().getX() < d2 && d2 < this.points.get(n + 1).getBase().getX()) {
                    pointD4 = this.points.get(n).getBase();
                    pointD3 = this.points.get(n + 1).getBase();
                    pointD2 = this.points.get(n).getControlRightType() == BezierControlType.None ? pointD4 : this.points.get(n).getControlRight();
                    pointD = this.points.get(n + 1).getControlLeftType() == BezierControlType.None ? pointD3 : this.points.get(n + 1).getControlLeft();
                    pointDArray = BezierChain.cutUnitBezier(pointD4, pointD2, pointD, pointD3, d);
                    pointD4 = pointDArray[3];
                    pointD2 = pointDArray[4];
                    pointD = pointDArray[5];
                    pointD3 = pointDArray[6];
                    pointDArray = BezierChain.cutUnitBezier(pointD4, pointD2, pointD, pointD3, d2);
                    bezierPoint = new BezierPoint(pointDArray[0]);
                    bezierPoint2 = new BezierPoint(pointDArray[3]);
                    bezierPoint.setControlRight(pointDArray[1]);
                    bezierPoint2.setControlLeft(pointDArray[2]);
                    bezierPoint.setControlRightType(this.points.get(n).getControlRightType());
                    bezierPoint2.setControlLeftType(this.points.get(n + 1).getControlLeftType());
                    bezierChain.add(bezierPoint);
                    bezierChain.add(bezierPoint2);
                    bl = true;
                    break;
                }
                pointD4 = this.points.get(n).getBase();
                pointD3 = this.points.get(n + 1).getBase();
                pointD2 = this.points.get(n).getControlRightType() == BezierControlType.None ? pointD4 : this.points.get(n).getControlRight();
                pointD = this.points.get(n + 1).getControlLeftType() == BezierControlType.None ? pointD3 : this.points.get(n + 1).getControlLeft();
                pointDArray = BezierChain.cutUnitBezier(pointD4, pointD2, pointD, pointD3, d);
                bezierPoint = new BezierPoint(pointDArray[3]);
                bezierPoint2 = new BezierPoint(pointDArray[6]);
                bezierPoint.setControlRight(pointDArray[4]);
                bezierPoint.setControlRightType(this.points.get(n).getControlRightType());
                bezierPoint2.setControlLeft(pointDArray[5]);
                bezierPoint2.setControlRight(this.points.get(n + 1).getControlRight());
                bezierPoint2.setControlRightType(this.points.get(n + 1).getControlRightType());
                bezierPoint2.setControlLeftType(this.points.get(n + 1).getControlLeftType());
                bezierChain.points.add(bezierPoint);
                ++n2;
                bezierChain.points.add(bezierPoint2);
                ++n2;
                bl = true;
            }
            if (d <= this.points.get(n).getBase().getX() && this.points.get(n).getBase().getX() <= d2) {
                if (!bl) {
                    bezierChain.points.add((BezierPoint)this.points.get(n).clone());
                    ++n2;
                } else {
                    bl = false;
                }
            }
            if (!(this.points.get(n).getBase().getX() < d2) || !(d2 < this.points.get(n + 1).getBase().getX())) continue;
            pointD4 = this.points.get(n).getBase();
            pointD3 = this.points.get(n + 1).getBase();
            pointD2 = this.points.get(n).getControlRightType() == BezierControlType.None ? pointD4 : this.points.get(n).getControlRight();
            pointD = this.points.get(n + 1).getControlLeftType() == BezierControlType.None ? pointD3 : this.points.get(n + 1).getControlLeft();
            pointDArray = BezierChain.cutUnitBezier(pointD4, pointD2, pointD, pointD3, d2);
            bezierChain.points.get(n2 - 1).setControlRight(pointDArray[1]);
            bezierPoint = new BezierPoint(pointDArray[3]);
            bezierPoint.setControlLeft(pointDArray[2]);
            bezierPoint.setControlLeftType(this.points.get(n + 1).getControlLeftType());
            bezierChain.add(bezierPoint);
            ++n2;
            break;
        }
        if (this.points.get(this.points.size() - 1).getBase().getX() == d2 && !bl) {
            bezierChain.add((BezierPoint)this.points.get(this.points.size() - 1).clone());
            ++n2;
        }
        for (n = 0; n < bezierChain.size(); ++n) {
            bezierChain.points.get(n).setID(n);
        }
        return bezierChain;
    }

    public void clear() {
        this.points.clear();
    }

    public static boolean isBezierImplicit(BezierChain bezierChain) {
        for (int i = 0; i < bezierChain.points.size() - 1; ++i) {
            double d;
            double d2 = bezierChain.points.get(i).getBase().getX();
            double d3 = bezierChain.points.get(i).getControlRightType() == BezierControlType.None ? d2 : bezierChain.points.get(i).getControlRight().getX();
            double d4 = bezierChain.points.get(i + 1).getBase().getX();
            double d5 = d = bezierChain.points.get(i + 1).getControlLeftType() == BezierControlType.None ? d4 : bezierChain.points.get(i + 1).getControlLeft().getX();
            if (BezierChain.isUnitBezierImplicit(d2, d3, d, d4)) continue;
            return false;
        }
        return true;
    }

    private static boolean isUnitBezierImplicit(double d, double d2, double d3, double d4) {
        double d5 = d4 - 3.0 * d3 + 3.0 * d2 - d;
        double d6 = 2.0 * d3 - 4.0 * d2 + 2.0 * d;
        double d7 = d2 - d;
        if (d5 == 0.0) {
            return d7 >= 0.0 && d6 + d7 >= 0.0;
        }
        if (d5 > 0.0) {
            if (-d6 / (2.0 * d5) <= 0.0) {
                return d7 >= 0.0;
            }
            if (1.0 <= -d6 / (2.0 * d5)) {
                return d5 + d6 + d7 >= 0.0;
            }
            return d7 - d6 * d6 / (4.0 * d5) >= 0.0;
        }
        if (-d6 / (2.0 * d5) <= 0.5) {
            return d5 + d6 + d7 >= 0.0;
        }
        return d7 >= 0.0;
    }

    public void Dispose() {
        if (this.points != null) {
            this.points.clear();
        }
    }

    public int getNextId() {
        if (this.points.size() > 0) {
            int n = this.points.get(0).getID();
            for (int i = 1; i < this.points.size(); ++i) {
                n = Math.max(n, this.points.get(i).getID());
            }
            return n + 1;
        }
        return 0;
    }

    public void getValueMinMax(ByRef<Double> byRef, ByRef<Double> byRef2) {
        byRef.value = this.Default;
        byRef2.value = this.Default;
        for (BezierPoint bezierPoint : this.points) {
            byRef.value = Math.min((Double)byRef.value, bezierPoint.getBase().getY());
            byRef2.value = Math.max((Double)byRef2.value, bezierPoint.getBase().getY());
        }
    }

    public void getKeyMinMax(ByRef<Double> byRef, ByRef<Double> byRef2) {
        byRef.value = this.Default;
        byRef2.value = this.Default;
        for (BezierPoint bezierPoint : this.points) {
            byRef.value = Math.min((Double)byRef.value, bezierPoint.getBase().getX());
            byRef2.value = Math.max((Double)byRef2.value, bezierPoint.getBase().getX());
        }
    }

    public Object clone() {
        BezierChain bezierChain = new BezierChain(this.m_color);
        for (BezierPoint bezierPoint : this.points) {
            bezierChain.points.add((BezierPoint)bezierPoint.clone());
        }
        bezierChain.Default = this.Default;
        bezierChain.id = this.id;
        return bezierChain;
    }

    public BezierChain(Color color) {
        this.m_color = color;
    }

    public BezierChain() {
        this.m_color = Color.black;
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public void add(BezierPoint bezierPoint) {
        if (this.points == null) {
            this.points = new Vector();
            this.m_color = Color.black;
        }
        this.points.add(bezierPoint);
        Collections.sort(this.points);
    }

    public void removeElementAt(int n) {
        for (int i = 0; i < this.points.size(); ++i) {
            if (this.points.get(i).getID() != n) continue;
            this.points.removeElementAt(i);
            break;
        }
    }

    public int size() {
        if (this.points == null) {
            return 0;
        }
        return this.points.size();
    }

    public double getValue(double d) {
        int n = this.points.size();
        for (int i = 0; i < n - 1; ++i) {
            BezierPoint bezierPoint = this.points.get(i);
            BezierPoint bezierPoint2 = this.points.get(i + 1);
            if (!(bezierPoint.getBase().getX() <= d) || !(d <= bezierPoint2.getBase().getX())) continue;
            double d2 = bezierPoint.getBase().getX();
            double d3 = bezierPoint2.getBase().getX();
            if (d2 == d) {
                return bezierPoint.getBase().getY();
            }
            if (d3 == d) {
                return bezierPoint2.getBase().getY();
            }
            double d4 = bezierPoint.getControlRight().getX();
            double d5 = bezierPoint2.getControlLeft().getX();
            double d6 = d3 - 3.0 * d5 + 3.0 * d4 - d2;
            double d7 = 3.0 * d5 - 6.0 * d4 + 3.0 * d2;
            double d8 = 3.0 * (d4 - d2);
            double d9 = d2;
            double d10 = BezierChain.solveCubicEquation(d6, d7, d8, d9, d);
            d2 = bezierPoint.getBase().getY();
            d4 = bezierPoint.getControlRight().getY();
            d5 = bezierPoint2.getControlLeft().getY();
            d3 = bezierPoint2.getBase().getY();
            d6 = d3 - 3.0 * d5 + 3.0 * d4 - d2;
            d7 = 3.0 * d5 - 6.0 * d4 + 3.0 * d2;
            d8 = 3.0 * (d4 - d2);
            d9 = d2;
            return ((d6 * d10 + d7) * d10 + d8) * d10 + d9;
        }
        return this.Default;
    }

    private static double solveCubicEquation(double d, double d2, double d3, double d4, double d5) {
        double d6 = 0.5;
        double d7 = d * 3.0;
        double d8 = d2 * 2.0;
        while ((d7 * d6 + d8) * d6 + d3 == 0.0) {
            d6 += 0.1;
        }
        double d9 = d6;
        double d10 = d6;
        for (int i = 0; i < 5000 && !(Math.abs((d10 = d9 - (((d * d9 + d2) * d9 + d3) * d9 + d4 - d5) / ((d7 * d9 + d8) * d9 + d3)) - d9) < 1.0E-9 * d10); ++i) {
            d9 = d10;
        }
        return d10;
    }
}

