/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JPanel;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.PortUtil;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.VSTiProxy;
import org.kbinani.cadencii.VsqFileEx;
import org.kbinani.componentmodel.BBackgroundWorker;
import org.kbinani.componentmodel.BDoWorkEventArgs;
import org.kbinani.componentmodel.BDoWorkEventHandler;
import org.kbinani.componentmodel.BRunWorkerCompletedEventArgs;
import org.kbinani.componentmodel.BRunWorkerCompletedEventHandler;
import org.kbinani.media.WaveReader;
import org.kbinani.media.WaveWriter;
import org.kbinani.vsq.VocaloSysUtil;
import org.kbinani.vsq.VsqFile;
import org.kbinani.vsq.VsqNrpn;
import org.kbinani.vsq.VsqTrack;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BFormClosingEventArgs;
import org.kbinani.windows.forms.BFormClosingEventHandler;
import org.kbinani.windows.forms.BLabel;
import org.kbinani.windows.forms.BProgressBar;
import org.kbinani.windows.forms.BTimer;

public class FormSynthesize
extends BDialog {
    private VsqFileEx m_vsq;
    private int m_presend = 500;
    private Integer[] m_tracks;
    private String[] m_files;
    private int[] m_clock_start;
    private int[] m_clock_end;
    private int m_finished = -1;
    private boolean m_rendering_started = false;
    private boolean m_reflect_amp_to_wave = false;
    private BTimer timer;
    private BBackgroundWorker bgWork;
    private boolean isPartialMode = false;
    private boolean isCancelRequired = false;
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private BLabel lblSynthesizing = null;
    private BLabel lblProgress = null;
    private BLabel lblTime = null;
    private BProgressBar progressWhole = null;
    private BProgressBar progressOne = null;
    private BButton btnCancel = null;

    public FormSynthesize(VsqFileEx vsqFileEx, int n, int n2, String string, int n3, int n4, boolean bl) {
        this(vsqFileEx, n, new Integer[]{n2}, new String[]{string}, new Integer[]{n3}, new Integer[]{n4}, bl);
        this.isPartialMode = true;
    }

    public FormSynthesize(VsqFileEx vsqFileEx, int n, Integer[] integerArray, String[] stringArray, Integer[] integerArray2, Integer[] integerArray3, boolean bl) {
        int n2;
        this.m_vsq = vsqFileEx;
        this.m_presend = n;
        this.m_tracks = integerArray;
        this.m_files = stringArray;
        this.initialize();
        this.timer = new BTimer();
        this.timer.setDelay(1000);
        this.registerEventHandlers();
        this.setResources();
        this.lblProgress.setText("0/" + this.m_tracks.length);
        int n3 = 0;
        int n4 = this.m_vsq.TotalClocks + 240;
        for (n2 = 0; n2 < integerArray2.length; ++n2) {
            int n5 = integerArray3[n2];
            if (n5 == Integer.MAX_VALUE) {
                n5 = n4;
            }
            n3 += n5 - integerArray2[n2];
        }
        this.progressWhole.setMaximum(n3);
        this.progressWhole.setMinimum(0);
        this.progressWhole.setValue(0);
        this.m_clock_start = new int[integerArray2.length];
        this.m_clock_end = new int[integerArray3.length];
        for (n2 = 0; n2 < integerArray2.length; ++n2) {
            this.m_clock_start[n2] = integerArray2[n2];
            this.m_clock_end[n2] = integerArray3[n2];
        }
        this.m_reflect_amp_to_wave = bl;
        this.applyLanguage();
        Util.applyFontRecurse(this, AppManager.editorConfig.getBaseFont());
    }

    public void applyLanguage() {
        this.setTitle(FormSynthesize._("Synthesize"));
        this.lblSynthesizing.setText(FormSynthesize._("now synthesizing..."));
        this.btnCancel.setText(FormSynthesize._("Cancel"));
    }

    public int getFinished() {
        return this.m_finished;
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private void Start() {
        if (VSTiProxy.CurrentUser.equals("")) {
            VSTiProxy.CurrentUser = AppManager.getID();
            this.timer.start();
            this.m_rendering_started = true;
            this.bgWork.runWorkerAsync();
        } else {
            this.m_rendering_started = false;
            this.setDialogResult(BDialogResult.CANCEL);
        }
    }

    private void UpdateProgress(Object object, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.m_clock_end[i];
            if (n3 == Integer.MAX_VALUE) {
                n3 = this.m_vsq.TotalClocks + 240;
            }
            n2 += n3 - this.m_clock_start[i];
        }
        this.progressWhole.setValue(n2);
        this.lblProgress.setText(n + "/" + this.m_tracks.length);
    }

    private static String getTimeSpanString(long l) {
        int n = 86400;
        int n2 = 3600;
        int n3 = 60;
        String string = "";
        boolean bl = false;
        int n4 = (int)(l / (long)n);
        if (n4 > 0) {
            string = string + n4 + FormSynthesize._("day") + " ";
            bl = true;
            l -= (long)(n4 * n);
        }
        n4 = (int)(l / (long)n2);
        if (bl || n4 > 0) {
            string = string + PortUtil.formatDecimal(bl ? "00" : "0", n4) + FormSynthesize._("hour") + " ";
            bl = true;
            l -= (long)(n4 * n2);
        }
        n4 = (int)(l / (long)n3);
        if (bl || n4 > 0) {
            string = string + PortUtil.formatDecimal(bl ? "00" : "0", n4) + FormSynthesize._("min") + " ";
            bl = true;
            l -= (long)(n4 * n3);
        }
        return string + PortUtil.formatDecimal(bl ? "00" : "0", l) + FormSynthesize._("sec");
    }

    private void registerEventHandlers() {
        this.loadEvent.add(new BEventHandler(this, "FormSynthesize_Load"));
        this.bgWork.doWorkEvent.add(new BDoWorkEventHandler(this, "bgWork_DoWork"));
        this.bgWork.runWorkerCompletedEvent.add(new BRunWorkerCompletedEventHandler(this, "bgWork_RunWorkerCompleted"));
        this.timer.tickEvent.add(new BEventHandler(this, "timer_Tick"));
        this.formClosingEvent.add(new BFormClosingEventHandler(this, "FormSynthesize_FormClosing"));
        this.btnCancel.clickEvent.add(new BEventHandler(this, "btnCancel_Click"));
    }

    private void setResources() {
    }

    public void FormSynthesize_Load(Object object, BEventArgs bEventArgs) {
        this.lblTime.setText("");
        this.Start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bgWork_DoWork(Object object, BDoWorkEventArgs bDoWorkEventArgs) {
        try {
            int n = AppManager.editorConfig.WaveFileOutputChannel == 1 ? 1 : 2;
            double d = VocaloSysUtil.getAmplifyCoeffFromFeder(this.m_vsq.Mixer.MasterFeder);
            double d2 = VocaloSysUtil.getAmplifyCoeffFromPanLeft(this.m_vsq.Mixer.MasterPanpot);
            double d3 = VocaloSysUtil.getAmplifyCoeffFromPanRight(this.m_vsq.Mixer.MasterPanpot);
            int n2 = this.m_vsq.Track.size();
            String string = AppManager.getTempWaveDir();
            this.m_finished = 0;
            for (int i = 0; i < this.m_tracks.length; ++i) {
                int n3;
                int n4 = this.m_tracks[i];
                this.UpdateProgress(this, 1);
                Vector<VsqNrpn> vector = new Vector<VsqNrpn>(Arrays.asList(VsqFile.generateNRPN(this.m_vsq, n4, this.m_presend)));
                int n5 = ((VsqTrack)this.m_vsq.Track.get(n4)).getEventCount();
                if (n5 <= 0) continue;
                double d4 = VocaloSysUtil.getAmplifyCoeffFromFeder(this.m_vsq.Mixer.Slave.get((int)(n4 - 1)).Feder);
                double d5 = VocaloSysUtil.getAmplifyCoeffFromPanLeft(this.m_vsq.Mixer.Slave.get((int)(n4 - 1)).Panpot);
                double d6 = VocaloSysUtil.getAmplifyCoeffFromPanRight(this.m_vsq.Mixer.Slave.get((int)(n4 - 1)).Panpot);
                double d7 = d * d4 * d2 * d5;
                double d8 = d * d4 * d3 * d6;
                int n6 = this.m_vsq.TotalClocks;
                double d9 = this.m_vsq.getSecFromClock(n6);
                WaveWriter waveWriter = null;
                Vector<WaveReader> vector2 = new Vector<WaveReader>();
                if (this.isPartialMode && AppManager.editorConfig.WaveFileOutputFromMasterTrack && n2 > 2) {
                    for (n3 = 1; n3 < n2; ++n3) {
                        if (n3 == n4) continue;
                        String string2 = PortUtil.combinePath(string, n3 + ".wav");
                        WaveReader waveReader = new WaveReader(string2);
                        waveReader.setTag(n3);
                        vector2.add(waveReader);
                    }
                }
                try {
                    waveWriter = new WaveWriter(this.m_files[i], n, 16, VSTiProxy.SAMPLE_RATE);
                    n3 = this.m_clock_end[i];
                    if (n3 == Integer.MAX_VALUE) {
                        n3 = this.m_vsq.TotalClocks + 240;
                    }
                    VSTiProxy.render(this.m_vsq, n4, waveWriter, this.m_vsq.getSecFromClock(this.m_clock_start[i]), this.m_vsq.getSecFromClock(n3), this.m_presend, false, vector2.toArray(new WaveReader[0]), 0.0, false, string, this.m_reflect_amp_to_wave);
                    if (this.isCancelRequired) break;
                    ++this.m_finished;
                    continue;
                }
                catch (Exception exception) {
                    AppManager.reportError(exception, "FormSynthesize#bgWork_DoWork", 0);
                    continue;
                }
                finally {
                    if (waveWriter != null) {
                        try {
                            waveWriter.close();
                        }
                        catch (Exception exception) {
                            PortUtil.stderr.println("FormSynthesize#bgWork_DoWork; ex2=" + exception);
                        }
                    }
                }
            }
            this.UpdateProgress(this, this.m_tracks.length);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("FormSynthesize#bgWork_DoWork; ex=" + exception);
        }
    }

    public void FormSynthesize_FormClosing(Object object, BFormClosingEventArgs bFormClosingEventArgs) {
        this.timer.stop();
        if (this.m_rendering_started) {
            VSTiProxy.CurrentUser = "";
        }
        if (this.bgWork.isBusy()) {
            VSTiProxy.abortRendering();
            this.isCancelRequired = true;
            while (this.bgWork.isBusy()) {
                try {
                    Thread.sleep(0L);
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            this.setDialogResult(BDialogResult.CANCEL);
        } else {
            this.setDialogResult(BDialogResult.OK);
        }
    }

    public void bgWork_RunWorkerCompleted(Object object, BRunWorkerCompletedEventArgs bRunWorkerCompletedEventArgs) {
        this.timer.stop();
        this.setDialogResult(BDialogResult.OK);
        this.close();
    }

    public void timer_Tick(Object object, BEventArgs bEventArgs) {
        double d = VSTiProxy.getProgress();
        long l = (long)VSTiProxy.getElapsedSeconds();
        long l2 = (long)VSTiProxy.computeRemainintSeconds();
        if (d >= 0.0 && (double)l2 >= 0.0) {
            this.lblTime.setText(FormSynthesize._("Remaining") + " " + FormSynthesize.getTimeSpanString(l2) + " (" + FormSynthesize.getTimeSpanString(l) + " " + FormSynthesize._("elapsed") + ")");
        } else {
            this.lblTime.setText(FormSynthesize._("Remaining") + " [unknown] (" + FormSynthesize.getTimeSpanString(l) + " " + FormSynthesize._("elapsed") + ")");
        }
        this.progressOne.setValue((int)d > 100 ? 100 : (int)d);
    }

    public void btnCancel_Click(Object object, BEventArgs bEventArgs) {
        this.isCancelRequired = true;
        VSTiProxy.abortRendering();
        this.setDialogResult(BDialogResult.CANCEL);
    }

    private void initialize() {
        this.setSize(new Dimension(376, 197));
        this.setContentPane(this.getJPanel());
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(12, 0, 12, 16);
            gridBagConstraints.gridy = 4;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.insets = new Insets(4, 12, 4, 12);
            gridBagConstraints2.gridy = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(4, 12, 4, 12);
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(4, 12, 4, 0);
            gridBagConstraints4.gridy = 1;
            this.lblTime = new BLabel();
            this.lblTime.setText("remaining 0s (elapsed 0s)");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.insets = new Insets(12, 0, 4, 12);
            gridBagConstraints5.gridy = 0;
            this.lblProgress = new BLabel();
            this.lblProgress.setText("1/1");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.insets = new Insets(12, 12, 4, 0);
            gridBagConstraints6.gridy = 0;
            this.lblSynthesizing = new BLabel();
            this.lblSynthesizing.setText("now synthesizing...");
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.lblSynthesizing, gridBagConstraints6);
            this.jPanel.add((Component)this.lblProgress, gridBagConstraints5);
            this.jPanel.add((Component)this.lblTime, gridBagConstraints4);
            this.jPanel.add((Component)this.getProgressWhole(), gridBagConstraints3);
            this.jPanel.add((Component)this.getProgressOne(), gridBagConstraints2);
            this.jPanel.add((Component)this.getBtnCancel(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private BProgressBar getProgressWhole() {
        if (this.progressWhole == null) {
            this.progressWhole = new BProgressBar();
        }
        return this.progressWhole;
    }

    private BProgressBar getProgressOne() {
        if (this.progressOne == null) {
            this.progressOne = new BProgressBar();
        }
        return this.progressOne;
    }

    private BButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new BButton();
            this.btnCancel.setText("Cancel");
        }
        return this.btnCancel;
    }
}

