/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JPanel;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.PortUtil;
import org.kbinani.ValuePair;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AppManager;
import org.kbinani.vsq.SymbolTable;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BLabel;
import org.kbinani.windows.forms.BListView;
import org.kbinani.windows.forms.BListViewItem;
import org.kbinani.windows.forms.BPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormWordDictionary
extends BDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private BLabel lblAvailableDictionaries = null;
    private BPanel jPanel2 = null;
    private BButton btnOK = null;
    private BButton btnCancel = null;
    private BPanel jPanel21 = null;
    private BButton btnUp = null;
    private BButton btnDown = null;
    private BListView listDictionaries = null;

    public FormWordDictionary() {
        this.initialize();
        this.registerEventHandlers();
        this.setResources();
        this.applyLanguage();
        Util.applyFontRecurse(this, AppManager.editorConfig.getBaseFont());
    }

    public void applyLanguage() {
        this.setTitle(FormWordDictionary._("User Dictionary Configuration"));
        this.lblAvailableDictionaries.setText(FormWordDictionary._("Available Dictionaries"));
        this.btnOK.setText(FormWordDictionary._("OK"));
        this.btnCancel.setText(FormWordDictionary._("Cancel"));
        this.btnUp.setText(FormWordDictionary._("Up"));
        this.btnDown.setText(FormWordDictionary._("Down"));
    }

    public Vector<ValuePair<String, Boolean>> getResult() {
        Vector<ValuePair<String, Boolean>> vector = new Vector<ValuePair<String, Boolean>>();
        int n = this.listDictionaries.getItemCount("");
        for (int i = 0; i < n; ++i) {
            BListViewItem bListViewItem = this.listDictionaries.getItemAt("", i);
            vector.add(new ValuePair<String, Boolean>(bListViewItem.getSubItemAt(0), this.listDictionaries.isItemCheckedAt("", i)));
        }
        return vector;
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private void registerEventHandlers() {
        this.loadEvent.add(new BEventHandler(this, "FormWordDictionary_Load"));
        this.btnOK.clickEvent.add(new BEventHandler(this, "btnOK_Click"));
        this.btnUp.clickEvent.add(new BEventHandler(this, "btnUp_Click"));
        this.btnDown.clickEvent.add(new BEventHandler(this, "btnDown_Click"));
        this.btnCancel.clickEvent.add(new BEventHandler(this, "btnCancel_Click"));
    }

    private void setResources() {
    }

    public void FormWordDictionary_Load(Object object, BEventArgs bEventArgs) {
        this.listDictionaries.clear();
        for (int i = 0; i < SymbolTable.getCount(); ++i) {
            String string = SymbolTable.getSymbolTable(i).getName();
            boolean bl = SymbolTable.getSymbolTable(i).isEnabled();
            BListViewItem bListViewItem = new BListViewItem(new String[]{string});
            this.listDictionaries.addItem("", bListViewItem, bl);
        }
        this.listDictionaries.setColumnWidth(0, this.listDictionaries.getWidth());
    }

    public void btnOK_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.OK);
    }

    public void btnUp_Click(Object object, BEventArgs bEventArgs) {
        int n = this.listDictionaries.getSelectedIndex("");
        if (n >= 1) {
            try {
                this.listDictionaries.clearSelection("");
                String string = this.listDictionaries.getItemAt("", n - 1).getSubItemAt(0);
                boolean bl = this.listDictionaries.isItemCheckedAt("", n - 1);
                String string2 = this.listDictionaries.getItemAt("", n).getSubItemAt(0);
                boolean bl2 = this.listDictionaries.isItemCheckedAt("", n);
                this.listDictionaries.getItemAt("", n - 1).setSubItemAt(0, string2);
                this.listDictionaries.setItemCheckedAt("", n - 1, bl2);
                this.listDictionaries.getItemAt("", n).setSubItemAt(0, string);
                this.listDictionaries.setItemCheckedAt("", n, bl);
                this.listDictionaries.setItemSelectedAt("", n - 1, true);
            }
            catch (Exception exception) {
                PortUtil.stderr.println("FormWordDictionary#btnUp_Click; ex=" + exception);
            }
        }
    }

    public void btnDown_Click(Object object, BEventArgs bEventArgs) {
        int n = this.listDictionaries.getSelectedIndex("");
        if (0 <= n && n + 1 < this.listDictionaries.getItemCount("")) {
            try {
                this.listDictionaries.clearSelection("");
                String string = this.listDictionaries.getItemAt("", n).getSubItemAt(0);
                boolean bl = this.listDictionaries.isItemCheckedAt("", n);
                String string2 = this.listDictionaries.getItemAt("", n + 1).getSubItemAt(0);
                boolean bl2 = this.listDictionaries.isItemCheckedAt("", n + 1);
                this.listDictionaries.getItemAt("", n + 1).setSubItemAt(0, string);
                this.listDictionaries.setItemCheckedAt("", n + 1, bl);
                this.listDictionaries.getItemAt("", n).setSubItemAt(0, string2);
                this.listDictionaries.setItemCheckedAt("", n, bl2);
                this.listDictionaries.setItemSelectedAt("", n + 1, true);
            }
            catch (Exception exception) {
                PortUtil.stderr.println("FormWordDictionary#btnDown_Click; ex=" + exception);
            }
        }
    }

    public void btnCancel_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.CANCEL);
    }

    private void initialize() {
        this.setSize(new Dimension(327, 404));
        this.setTitle("User Dictionary Configuration");
        this.setContentPane(this.getJPanel());
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(6, 0, 12, 16);
            gridBagConstraints.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(6, 0, 6, 12);
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.insets = new Insets(6, 12, 6, 12);
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(12, 12, 6, 0);
            gridBagConstraints4.gridy = 0;
            this.lblAvailableDictionaries = new BLabel();
            this.lblAvailableDictionaries.setText("Available Dictionaries");
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.lblAvailableDictionaries, gridBagConstraints4);
            this.jPanel.add((Component)this.getListDictionaries(), gridBagConstraints3);
            this.jPanel.add((Component)this.getJPanel21(), gridBagConstraints2);
            this.jPanel.add((Component)this.getJPanel2(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private BPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 16;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 16);
            this.jPanel2 = new BPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.add((Component)this.getBtnOK(), gridBagConstraints2);
            this.jPanel2.add((Component)this.getBtnCancel(), gridBagConstraints);
        }
        return this.jPanel2;
    }

    private BButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new BButton();
            this.btnOK.setText("OK");
        }
        return this.btnOK;
    }

    private BButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new BButton();
            this.btnCancel.setText("Cancel");
        }
        return this.btnCancel;
    }

    private BPanel getJPanel21() {
        if (this.jPanel21 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 16;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 16);
            this.jPanel21 = new BPanel();
            this.jPanel21.setLayout(new GridBagLayout());
            this.jPanel21.add((Component)this.getBtnUp(), gridBagConstraints2);
            this.jPanel21.add((Component)this.getBtnDown(), gridBagConstraints);
        }
        return this.jPanel21;
    }

    private BButton getBtnUp() {
        if (this.btnUp == null) {
            this.btnUp = new BButton();
            this.btnUp.setText("Up");
            this.btnUp.setPreferredSize(new Dimension(49, 23));
        }
        return this.btnUp;
    }

    private BButton getBtnDown() {
        if (this.btnDown == null) {
            this.btnDown = new BButton();
            this.btnDown.setText("Down");
            this.btnDown.setPreferredSize(new Dimension(66, 23));
        }
        return this.btnDown;
    }

    private BListView getListDictionaries() {
        if (this.listDictionaries == null) {
            this.listDictionaries = new BListView();
        }
        return this.listDictionaries;
    }
}

