/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Color;
import javax.swing.event.DocumentEvent;
import org.kbinani.PortUtil;
import org.kbinani.windows.forms.BTextBox;

public class NumberTextBox
extends BTextBox {
    private ValueType m_value_type = ValueType.Double;
    private Color m_textcolor_normal = Color.black;
    private Color m_textcolor_invalid = Color.white;
    private Color m_backcolor_normal = Color.white;
    private Color m_backcolor_invalid = new Color(240, 128, 128);

    public ValueType getType() {
        return this.m_value_type;
    }

    public void setType(ValueType valueType) {
        this.m_value_type = valueType;
    }

    public void update(DocumentEvent documentEvent) {
        super.updates(documentEvent);
        this.validateText();
    }

    private void validateText() {
        boolean bl = false;
        String string = this.getText();
        if (this.m_value_type == ValueType.Double) {
            try {
                double d = PortUtil.parseDouble(string);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        } else if (this.m_value_type == ValueType.Float) {
            try {
                float f = PortUtil.parseFloat(string);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        } else if (this.m_value_type == ValueType.Integer) {
            try {
                int n = PortUtil.parseInt(string);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (bl) {
            this.setForeground(this.m_textcolor_normal);
            this.setBackground(this.m_backcolor_normal);
        } else {
            this.setForeground(this.m_textcolor_invalid);
            this.setBackground(this.m_backcolor_invalid);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueType {
        Double,
        Float,
        Integer;

    }
}

